/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.installer.anttask.security;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.installer.InstallerPlugin;
import com.metamatrix.installer.anttask.adminapi.BaseAdminAPITask;
import org.apache.tools.ant.BuildException;

public class PrincipalImportTask
extends BaseAdminAPITask {
    private String fileName = null;

    public void setFilename(String filename) {
        this.fileName = filename;
    }

    public void execute() throws BuildException {
        if (this.fileName == null || this.fileName.trim().length() == 0) {
            String msg = InstallerPlugin.Util.getString("PrincipalImportTask.invalidfilename");
            this.getProject().log(msg, 0);
            throw new BuildException(msg);
        }
        FileUtil util = new FileUtil(this.fileName);
        char[] data = util.read().toCharArray();
        if (data == null || data.length == 0) {
            String msg = InstallerPlugin.Util.getString("PrincipalImportTask.fileisempty", (Object)this.fileName);
            this.getProject().log(msg, 0);
            throw new BuildException(msg);
        }
        try {
            this.getAPI().importPrincipals(data);
            String msg = InstallerPlugin.Util.getString("PrincipalImportTask.importprincipals_completed", (Object)this.fileName);
            this.getProject().log(msg, 2);
        }
        catch (AdminException mmae) {
            String msg = InstallerPlugin.Util.getString("PrincipalImportTask.error_importing_principals", (Object)this.fileName);
            this.getProject().log(msg, 0);
            throw new BuildException((Throwable)mmae);
        }
    }
}

