/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RuleChooseMergeJoins
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, MetaMatrixComponentException {
        List nodes = NodeEditor.findAllNodes((PlanNode)plan, (int)2);
        if (nodes.size() == 0) {
            return plan;
        }
        Iterator nodeIter = nodes.iterator();
        while (nodeIter.hasNext()) {
            PlanNode joinNode = (PlanNode)nodeIter.next();
            RuleChooseMergeJoins.convertNode(joinNode, metadata, capFinder);
        }
        return plan;
    }

    static boolean canMakeMerge(PlanNode joinNode, QueryMetadataInterface metadata) {
        JoinType jtype = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
        if (jtype.equals((Object)JoinType.JOIN_CROSS) || jtype.equals((Object)JoinType.JOIN_FULL_OUTER)) {
            return false;
        }
        List crits = (List)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        Iterator iter = crits.iterator();
        boolean hasFunction = false;
        while (iter.hasNext()) {
            Criteria theCrit = (Criteria)iter.next();
            if (!(theCrit instanceof CompareCriteria)) {
                return false;
            }
            CompareCriteria crit = (CompareCriteria)theCrit;
            if (crit.getOperator() != 1) {
                return false;
            }
            Collection leftGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit.getLeftExpression());
            Collection rightGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit.getRightExpression());
            if (leftGroups.size() > 1 || rightGroups.size() > 1 || leftGroups.size() == 0 && rightGroups.size() == 0) {
                return false;
            }
            if (hasFunction) continue;
            if (crit.getLeftExpression() instanceof Function) {
                hasFunction = true;
                continue;
            }
            if (!(crit.getRightExpression() instanceof Function)) continue;
            hasFunction = true;
        }
        if (hasFunction) {
            RuleChooseMergeJoins.validateFunction(joinNode);
        }
        return true;
    }

    static boolean validateFunction(PlanNode joinNode) {
        List foundNodes = NodeEditor.findAllNodes((PlanNode)joinNode, (int)6);
        boolean sourceIsPhysical = true;
        Iterator i = foundNodes.iterator();
        while (i.hasNext()) {
            PlanNode node = (PlanNode)i.next();
            if (node.getChildCount() <= 0) continue;
            sourceIsPhysical = false;
            break;
        }
        return sourceIsPhysical;
    }

    static void convertNode(PlanNode joinNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (!RuleChooseMergeJoins.canMakeMerge(joinNode, metadata)) {
            return;
        }
        PlanNode leftChild = joinNode.getFirstChild();
        while (leftChild.getFirstChild() != null && leftChild.getType() == 4) {
            leftChild = leftChild.getFirstChild();
        }
        PlanNode rightChild = joinNode.getLastChild();
        while (rightChild.getLastChild() != null && rightChild.getType() == 4) {
            rightChild = rightChild.getLastChild();
        }
        List crits = (List)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        ArrayList leftExpressions = new ArrayList();
        ArrayList rightExpressions = new ArrayList();
        RuleChooseMergeJoins.buildExpressionLists(crits, leftChild.getGroups(), rightChild.getGroups(), leftExpressions, rightExpressions);
        joinNode.setProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS, leftExpressions);
        joinNode.setProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS, rightExpressions);
        joinNode.setProperty((Object)NodeConstants.Info.JOIN_STRATEGY, (Object)JoinStrategyType.MERGE);
        Boolean sortInLeftAccess = RuleChooseMergeJoins.sortAllowedInAccessNode(joinNode.getFirstChild(), leftExpressions, metadata, capFinder);
        joinNode.setProperty((Object)NodeConstants.Info.SORT_IN_LEFT_ACCESS, (Object)sortInLeftAccess);
        Boolean sortInRightAccess = RuleChooseMergeJoins.sortAllowedInAccessNode(joinNode.getLastChild(), rightExpressions, metadata, capFinder);
        joinNode.setProperty((Object)NodeConstants.Info.SORT_IN_RIGHT_ACCESS, (Object)sortInRightAccess);
    }

    static void buildExpressionLists(List crits, Collection leftGroups, Collection rightGroups, List leftExpressions, List rightExpressions) {
        Iterator iter = crits.iterator();
        while (iter.hasNext()) {
            CompareCriteria crit = (CompareCriteria)iter.next();
            Expression leftExpr = crit.getLeftExpression();
            Expression rightExpr = crit.getRightExpression();
            Collection leftExprGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)leftExpr);
            Collection rightExprGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)rightExpr);
            if (leftExprGroups.size() >= 1) {
                if (leftGroups.containsAll(leftExprGroups)) {
                    leftExpressions.add(leftExpr);
                    rightExpressions.add(rightExpr);
                    continue;
                }
                leftExpressions.add(rightExpr);
                rightExpressions.add(leftExpr);
                continue;
            }
            if (rightGroups.containsAll(rightExprGroups)) {
                leftExpressions.add(leftExpr);
                rightExpressions.add(rightExpr);
                continue;
            }
            leftExpressions.add(rightExpr);
            rightExpressions.add(leftExpr);
        }
    }

    private static boolean sortAllowedInAccessNode(PlanNode accessNode, List joinExpressions, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        boolean canUseOrderBy;
        Object modelID = RuleChooseMergeJoins.findModelID(accessNode, metadata, capFinder);
        boolean bl = canUseOrderBy = modelID != null;
        if (canUseOrderBy) {
            if (modelID != null && CapabilitiesUtil.supportsOrderBy(modelID, metadata, capFinder)) {
                Iterator joinExprIter = joinExpressions.iterator();
                while (joinExprIter.hasNext()) {
                    Expression expr = (Expression)joinExprIter.next();
                    if (expr instanceof ElementSymbol) continue;
                    canUseOrderBy = false;
                }
            } else {
                canUseOrderBy = false;
            }
        }
        return canUseOrderBy;
    }

    private static Object findModelID(PlanNode root, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = null;
        List accessNodes = NodeEditor.findAllNodes((PlanNode)root, (int)0);
        Iterator i = accessNodes.iterator();
        while (i.hasNext()) {
            PlanNode accessNode = (PlanNode)i.next();
            Object tempID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
            if (modelID == null) {
                modelID = tempID;
                continue;
            }
            if (CapabilitiesUtil.isSameConnector(modelID, modelID, metadata, capFinder)) continue;
            modelID = null;
            break;
        }
        return modelID;
    }

    public String toString() {
        return "ChooseMergeJoins";
    }
}

