/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api.service;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.MembershipException;
import com.metamatrix.api.exception.security.MetaMatrixAuthenticationException;
import com.metamatrix.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.util.RemoteUtil;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalNames;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.IMembershipServiceProxy;
import com.metamatrix.platform.security.api.service.MembershipObjectEditor;
import com.metamatrix.platform.security.api.service.MembershipServiceInterface;
import com.metamatrix.platform.security.membership.spi.FailedAuthenticationToken;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotInitializedException;
import com.metamatrix.platform.service.proxy.ServiceProxy;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MembershipServiceProxy
extends ServiceProxy
implements IMembershipServiceProxy {
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$service$MembershipServiceInterface;

    public MembershipServiceProxy() {
        this.setLoggingContext("MEMBERSHIP");
    }

    public String getServiceType() {
        return "MembershipService";
    }

    protected String getServiceNameForProxy() {
        return "MembershipService";
    }

    protected MembershipServiceInterface getCurrentService() throws ServiceException {
        return (MembershipServiceInterface)RemoteUtil.narrow(this.getNextInstance(), class$com$metamatrix$platform$security$api$service$MembershipServiceInterface == null ? (class$com$metamatrix$platform$security$api$service$MembershipServiceInterface = MembershipServiceProxy.class$("com.metamatrix.platform.security.api.service.MembershipServiceInterface")) : class$com$metamatrix$platform$security$api$service$MembershipServiceInterface);
    }

    public Serializable authenticateUser(String username, Credentials credential, Serializable trustedPayload, String applicationName) throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.authenticateUser(username, credential, trustedPayload, applicationName);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return new FailedAuthenticationToken(null);
    }

    public String getPrincipalNameForTrustedToken(Serializable token) throws MetaMatrixAuthenticationException, MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPrincipalNameForTrustedToken(token);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public boolean hasPrincipalForUser(String username) throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.hasPrincipalForUser(username);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public boolean hasPrincipalForGroup(String name) throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.hasPrincipalForGroup(name);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public MetaMatrixPrincipal getPrincipalForUser(String username) throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPrincipalForUser(username);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public MetaMatrixPrincipal getPrincipalForGroup(String name) throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPrincipalForGroup(name);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public MetaMatrixPrincipalNames getEditablePrincipalNames() throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getEditablePrincipalNames();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public MetaMatrixPrincipalNames getReadonlyPrincipalNames() throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getReadonlyPrincipalNames();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Set getRootGroupNames() throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getRootGroupNames();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Set getUsersForExport() throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getUsersForExport();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return Collections.EMPTY_SET;
    }

    public Set getGroupsForUser(String username, boolean explicitMembershipOnly) throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getGroupsForUser(username, explicitMembershipOnly);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Set getGroupsForGroup(String groupName, boolean explicitMembershipOnly) throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getGroupsForGroup(groupName, explicitMembershipOnly);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Set getGroupMembersOfGroup(String groupName) throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getGroupMembersOfGroup(groupName);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Set getUserMembersOfGroup(String groupName) throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getUserMembersOfGroup(groupName);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public MembershipObjectEditor getObjectEditor(boolean createActions) throws MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getObjectEditor(createActions);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Map getUserPrincipalAttributes() throws MembershipException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getUserPrincipalAttributes();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Map getGroupPrincipalAttributes() throws MembershipException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getGroupPrincipalAttributes();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Set executeTransaction(SessionToken caller, List actions) throws MembershipException, AuthorizationException, MetaMatrixSecurityException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.executeTransaction(caller, actions);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0084");
            I18nLogManager.logError("PROXY", "ERR.014.107.0084", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public void importUsers(SessionToken caller, Collection users) throws MetaMatrixSecurityException, ServiceException {
        super.checkConnection();
        MembershipServiceInterface service = null;
        RemoteException re = null;
        while ((service = this.getCurrentService()) != null) {
            String msg;
            try {
                for (int i = 0; i != this.getRetryLimit(); ++i) {
                    try {
                        service.importUsers(caller, users);
                        return;
                    }
                    catch (RemoteException e) {
                        re = e;
                        if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                }
                if (re != null) {
                    String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0081");
                    I18nLogManager.logCritical("PROXY", "ERR.014.107.0081", (Throwable)re, msg2);
                }
                this.markInstanceAsBad(service);
            }
            catch (ServiceNotInitializedException e) {
                msg = PlatformPlugin.Util.getString("ERR.014.107.0082");
                I18nLogManager.logError("PROXY", "ERR.014.107.0082", (Throwable)e, msg);
            }
            catch (ServiceException e) {
                msg = PlatformPlugin.Util.getString("ERR.014.107.0083");
                I18nLogManager.logError("PROXY", "ERR.014.107.0083", (Throwable)e, msg);
                this.markInstanceAsBad(service);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

