/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.log;

import com.metamatrix.core.log.Logger;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.log.PlatformLog;
import com.metamatrix.internal.core.util.ArrayUtil;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PluginLogger
implements ArrayUtil.Constants,
Logger,
StringUtil.Constants {
    private static final String STATUS_METHOD = "getStatus";
    private String pluginID;
    private PlatformLog log;

    public PluginLogger(String pluginID, PlatformLog log) {
        this.pluginID = pluginID;
        this.log = log;
    }

    public void log(IStatus status) {
        this.log.logMessage(status, System.currentTimeMillis(), this.pluginID, Thread.currentThread().getName());
    }

    public void log(int severity, String message) {
        if (message == null) {
            message = "";
        }
        this.log(new Status(severity, this.pluginID, 0, message, null));
    }

    public void log(int severity, Throwable t, String message) {
        if (message == null) {
            message = t == null ? "" : t.getClass().getName();
        }
        this.log(new Status(severity, this.pluginID, 0, message, t));
    }

    public void log(Object obj) {
        Throwable t = null;
        if (obj == null) {
            return;
        }
        this.log(new Status(2, this.pluginID, 0, obj.toString(), t));
    }

    public void log(Throwable throwable) {
        String message = throwable.getLocalizedMessage();
        if (message == null) {
            message = throwable.getClass().getName();
        }
        int severity = 2;
        try {
            Method meth = throwable.getClass().getMethod(STATUS_METHOD, new Class[0]);
            IStatus status = (IStatus)meth.invoke((Object)throwable, ArrayUtil.Constants.EMPTY_ARRAY);
            if (status != null) {
                severity = status.getSeverity();
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.log(new Status(severity, this.pluginID, 0, message, throwable));
    }
}

