/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.datatype;

import com.metamatrix.dqp.DQPPlugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobImpl
implements Blob,
Serializable {
    public static final int DEFAULT_MAX_SIZE = 5000000;
    private byte[] data;

    public BlobImpl(Blob blob) throws SQLException {
        int length = (int)blob.length();
        this.data = blob.getBytes(1L, length);
    }

    public BlobImpl(byte[] originalData) {
        this.data = new byte[originalData.length];
        int originalDataStartPosition = 0;
        int dataStartPosition = 0;
        int bytesToCopy = originalData.length;
        System.arraycopy(originalData, originalDataStartPosition, this.data, dataStartPosition, bytesToCopy);
    }

    public BlobImpl(InputStream in, int length) throws SQLException {
        this.data = new byte[length];
        try {
            in.read(this.data, 0, length);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.data);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException(DQPPlugin.Util.getString("BlobImpl.Invalid_byte_position", new Long(pos)));
        }
        if (pos > (long)this.data.length) {
            return null;
        }
        if (length < 0) {
            throw new SQLException(DQPPlugin.Util.getString("BlobImpl.Invalid_bytes_length", new Long(length)));
        }
        if (length > this.data.length) {
            length = this.data.length;
        }
        byte[] dataCopy = new byte[length];
        int startingDataPosition = (int)pos - 1;
        int startingCopyPosition = 0;
        System.arraycopy(this.data, startingDataPosition, dataCopy, startingCopyPosition, length);
        return dataCopy;
    }

    public long length() throws SQLException {
        return this.data.length;
    }

    public long position(Blob pattern, long start) throws SQLException {
        if (pattern == null || start > (long)this.data.length) {
            return -1L;
        }
        int length = (int)pattern.length();
        byte[] patternBytes = pattern.getBytes(1L, length);
        return this.position(patternBytes, start);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        int position;
        if (start < 1L) {
            throw new SQLException(DQPPlugin.Util.getString("BlobImpl.Invalid_start_position", new Long(start)));
        }
        if (pattern == null || start > (long)this.data.length) {
            return -1L;
        }
        String byteString = new String(this.data);
        String patternString = new String(pattern);
        if ((position = byteString.indexOf(patternString, (int)(--start))) != -1) {
            ++position;
        }
        return position;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null || this.data == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BlobImpl)) {
                return false;
            }
            BlobImpl blob = (BlobImpl)obj;
            if (blob.length() != this.length()) {
                return false;
            }
            byte[] bytes = blob.getBytes(1L, (int)blob.length());
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == this.data[i]) continue;
                return false;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        int i;
        String pre = "{";
        String post = "";
        int lastByte = this.data.length - 1;
        int frontTruncate = 5;
        int endTruncate = lastByte - 5;
        if (lastByte < 10) {
            frontTruncate = lastByte;
            endTruncate = lastByte;
        }
        for (i = 0; i < frontTruncate; ++i) {
            pre = pre + Integer.toString(this.data[i], 16) + ",";
        }
        for (i = endTruncate; i < lastByte; ++i) {
            post = post + "," + Integer.toString(this.data[i], 16);
        }
        post = post + "}";
        return "Length:" + this.data.length + ":" + pre + "..." + post;
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

