/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.PasswordCryptoFactory;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class PasswordDisplayUtility {
    public static String ADMIN_PASSWORD_PROPERTY_KEY = "metamatrix.admin.password";
    private static String propertyFileName = "mmconfig.properties";
    private static String propertyDir = "config";

    public static boolean initCrypto(Properties props) throws Exception {
        Properties sysprops = (Properties)System.getProperties().clone();
        sysprops.putAll((Map<?, ?>)props);
        System.setProperties(sysprops);
        CurrentConfiguration.reset();
        boolean encryptEnabled = CryptoUtil.isEncryptionEnabled();
        if (encryptEnabled) {
            String keyPwd = props.getProperty("metamatrix.security.password.PasswordKeyStore");
            if (keyPwd == null) {
                System.out.println("Unable to initialize PasswordCryptoFactory: keystore password is null.");
                System.exit(1);
            }
            PasswordCryptoFactory.init(keyPwd.toCharArray());
        }
        return encryptEnabled;
    }

    private static void printUsage() {
        System.out.println("usage: PasswordDisplayUtility <instalation lib>");
        System.exit(-1);
    }

    public static void main(String[] args) {
        block7: {
            if (args.length == 1) {
                String libDirectory = args[0];
                String propertyFile = libDirectory + File.separator + propertyDir + File.separator + propertyFileName;
                Properties properties = null;
                try {
                    properties = PropertiesUtils.load(propertyFile);
                    System.out.println("<<<Current properties>>>");
                    System.out.println(PropertiesUtils.prettyPrint(properties));
                    System.out.println("<<<Current properties>>>");
                    if (PasswordDisplayUtility.initCrypto(properties)) {
                        Properties p = CryptoUtil.propertyDecrypt(ADMIN_PASSWORD_PROPERTY_KEY, properties);
                        System.out.println(ADMIN_PASSWORD_PROPERTY_KEY + "=" + p.get(ADMIN_PASSWORD_PROPERTY_KEY));
                        break block7;
                    }
                    System.exit(-1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (CryptoException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                PasswordDisplayUtility.printUsage();
            }
        }
        System.exit(0);
    }
}

