/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.common.util.PasswordMaskUtil;
import com.metamatrix.core.util.ArgCheck;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class PropertiesUtils {
    private static final String NEWLINE = "\n";
    private static final String APREFIX = "Property '";
    private static final String AEQUAL = "'='";
    private static final String ASUFFIX = "'";
    private static final String TAB = "\t";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static List filter(String pattern, Properties props) {
        boolean addAll = false;
        String searchStr = null;
        ArrayList<String> propNames = new ArrayList<String>();
        int globIndex = pattern.indexOf(42);
        if (globIndex == -1) {
            searchStr = pattern;
        } else if (globIndex == 0) {
            addAll = true;
        } else {
            searchStr = pattern.substring(0, globIndex);
        }
        Enumeration<?> propNameEnum = props.propertyNames();
        while (propNameEnum.hasMoreElements()) {
            String name = (String)propNameEnum.nextElement();
            if (!name.startsWith(searchStr) && !addAll) continue;
            propNames.add(name);
        }
        return propNames;
    }

    public static Properties getProperties(String filterPattern, Properties props) {
        Properties results = new Properties();
        boolean addAll = false;
        String searchStr = null;
        int globIndex = filterPattern.indexOf(42);
        if (globIndex == -1) {
            searchStr = filterPattern;
        } else if (globIndex == 0) {
            addAll = true;
        } else {
            searchStr = filterPattern.substring(0, globIndex);
        }
        Enumeration<?> propNameEnum = props.propertyNames();
        while (propNameEnum.hasMoreElements()) {
            String name = (String)propNameEnum.nextElement();
            if (!name.startsWith(searchStr) && !addAll) continue;
            results.put(name, props.get(name));
        }
        return results;
    }

    public static Properties clone(Properties props) {
        boolean makeUnmodifiable = false;
        if (props instanceof UnmodifiableProperties) {
            makeUnmodifiable = true;
        }
        return PropertiesUtils.clone(props, makeUnmodifiable);
    }

    public static Properties clone(Properties props, boolean makeUnmodifiable) {
        return PropertiesUtils.clone(props, null, false, makeUnmodifiable);
    }

    public static Properties clone(Properties props, Properties defaults, boolean deepClone) {
        boolean makeUnmodifiable = false;
        if (props instanceof UnmodifiableProperties) {
            makeUnmodifiable = true;
        }
        return PropertiesUtils.clone(props, defaults, deepClone, makeUnmodifiable);
    }

    public static Properties clone(Properties props, Properties defaults, boolean deepClone, boolean makeUnmodifiable) {
        Properties result = null;
        if (defaults != null) {
            if (deepClone) {
                defaults = defaults instanceof UnmodifiableProperties ? PropertiesUtils.clone(defaults, true) : PropertiesUtils.clone(defaults, false);
            }
            result = new Properties(defaults);
        } else {
            result = new Properties();
        }
        PropertiesUtils.putAll(result, props);
        if (makeUnmodifiable) {
            result = new UnmodifiableProperties(result);
        }
        return result;
    }

    public static int compare(Properties p1, Properties p2) {
        if (p1 != null) {
            if (p2 == null) {
                return 1;
            }
        } else {
            if (p2 != null) {
                return -1;
            }
            return 0;
        }
        int diff = p1.size() - p2.size();
        if (diff != 0) {
            return diff;
        }
        Map.Entry<Object, Object> entry = null;
        Object p1Value = null;
        Object p2Value = null;
        Iterator<Map.Entry<Object, Object>> iter = p1.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            p1Value = entry.getValue();
            p2Value = p2.get(entry.getKey());
            if (p1Value != null) {
                if (p2Value == null) {
                    return 1;
                }
                diff = p1Value instanceof Comparable ? ((Comparable)p1Value).compareTo(p2Value) : p1Value.toString().compareTo(p2Value.toString());
                if (diff == 0) continue;
                return diff;
            }
            if (p2Value == null) continue;
            return -1;
        }
        return 0;
    }

    public static void putAll(Properties addToThis, Properties withThese) {
        if (withThese != null && addToThis != null) {
            Enumeration<?> enumeration = withThese.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propName = (String)enumeration.nextElement();
                Object propValue = withThese.get(propName);
                if (propValue == null) {
                    propValue = withThese.getProperty(propName);
                }
                if (propValue == null) continue;
                addToThis.put(propName, propValue);
            }
        }
    }

    public static int getIntProperty(Properties props, String propName, int defaultValue) {
        int val = defaultValue;
        if (props.containsKey(propName)) {
            try {
                val = Integer.parseInt(props.getProperty(propName));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return val;
    }

    public static long getLongProperty(Properties props, String propName, long defaultValue) {
        long val = defaultValue;
        if (props.containsKey(propName)) {
            try {
                val = Long.parseLong(props.getProperty(propName));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return val;
    }

    public static float getFloatProperty(Properties props, String propName, float defaultValue) {
        float val = defaultValue;
        if (props.containsKey(propName)) {
            try {
                Float f = new Float(props.getProperty(propName));
                val = f.floatValue();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return val;
    }

    public static double getDoubleProperty(Properties props, String propName, double defaultValue) {
        double val = defaultValue;
        if (props.containsKey(propName)) {
            try {
                Double d = new Double(props.getProperty(propName));
                val = d;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return val;
    }

    public static boolean getBooleanProperty(Properties props, String propName, boolean defaultValue) {
        boolean val = defaultValue;
        if (props.containsKey(propName)) {
            try {
                val = Boolean.valueOf(props.getProperty(propName));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadHeader(String fileName) throws IOException {
        String string;
        FileReader fr;
        block5: {
            fr = null;
            BufferedReader br = null;
            try {
                fr = new FileReader(fileName);
                br = new BufferedReader(fr);
                String header = br.readLine();
                if (header.indexOf(35) == 0) {
                    header = header.substring(1);
                }
                string = header;
                Object var6_5 = null;
                if (br == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_6 = null;
                    if (br != null) {
                        br.close();
                    }
                    if (fr == null) break block6;
                    fr.close();
                }
                throw throwable;
            }
            br.close();
        }
        if (fr != null) {
            fr.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties load(String fileName) throws IOException {
        InputStream is = null;
        try {
            Properties props = new Properties();
            is = new FileInputStream(fileName);
            props.load(is);
            Properties properties = props;
            return properties;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadAsResource(Class clazz, String resourceName) throws Exception {
        InputStream is = null;
        Properties configProps = new Properties();
        try {
            is = clazz.getResourceAsStream(resourceName);
            ArgCheck.isNotNull(is);
            if (is != null) {
                configProps.load(is);
            }
            Object var6_4 = null;
            if (is == null) return configProps;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (Exception ce) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ce) {}
        is.close();
        return configProps;
    }

    public static Properties sort(Properties props) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            names.add(name);
        }
        Collections.sort(names);
        Properties newProps = new Properties();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String propValue = props.getProperty(name);
            if (propValue == null) continue;
            newProps.setProperty(name, propValue);
        }
        return newProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(String fileName, Properties props, String header) throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(fileName);
            props.store(stream, header);
            stream.flush();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(String fileName, Properties props) throws IOException {
        FileOutputStream stream = null;
        PrintStream writer = null;
        try {
            stream = new FileOutputStream(fileName);
            writer = new PrintStream(stream);
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                names.add(name);
            }
            Collections.sort(names);
            Iterator nIt = names.iterator();
            while (nIt.hasNext()) {
                String name = (String)nIt.next();
                String value = props.getProperty(name);
                StringBuffer sb = new StringBuffer();
                sb.append(name);
                sb.append("=");
                sb.append(value);
                writer.println(sb.toString());
            }
            writer.flush();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {}
    }

    public static void print(PrintStream stream, Properties props) {
        Collection sorted = PropertiesUtils.sortPropertiesForPrinting(props);
        Iterator it = sorted.iterator();
        while (it.hasNext()) {
            String value = (String)it.next();
            stream.println(value);
        }
    }

    public static String prettyPrint(Properties props) {
        Collection sorted = PropertiesUtils.sortPropertiesForPrinting(props);
        StringBuffer outBuf = new StringBuffer();
        Iterator it = sorted.iterator();
        while (it.hasNext()) {
            String value = (String)it.next();
            outBuf.append(value);
            outBuf.append(NEWLINE);
        }
        return outBuf.toString();
    }

    public static Collection sortPropertiesForPrinting(Properties props) {
        ArrayList<String> sortedProps = new ArrayList<String>(props.size());
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            names.add(name);
        }
        Collections.sort(names);
        Iterator nIt = names.iterator();
        while (nIt.hasNext()) {
            String name = (String)nIt.next();
            String value = null;
            if (PasswordMaskUtil.doesNameEndWithPasswordSuffix(name)) {
                value = "*****";
            } else {
                value = props.getProperty(name);
                value = PropertiesUtils.saveConvert(value, false);
            }
            name = PropertiesUtils.saveConvert(name, true);
            StringBuffer sb = new StringBuffer(APREFIX);
            sb.append(name);
            sb.append(TAB);
            sb.append(AEQUAL);
            sb.append(value);
            sb.append(ASUFFIX);
            sortedProps.add(sb.toString());
        }
        return sortedProps;
    }

    public static String saveConvert(String theString, boolean escapeSpace) {
        if (theString == null) {
            return "";
        }
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertiesUtils.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertiesUtils.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertiesUtils.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertiesUtils.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static final void copyProperty(Properties srcProperties, String srcPropName, Properties tgtProperties, String tgtPropName) {
        if (srcProperties == null || srcPropName == null || tgtProperties == null || tgtPropName == null) {
            return;
        }
        String value = srcProperties.getProperty(srcPropName);
        if (value != null) {
            tgtProperties.setProperty(tgtPropName, value);
        }
    }

    public static Properties resolveNestedProperties(Properties original) throws IOException {
        Properties modified = new Properties();
        Enumeration<Object> e = original.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = original.getProperty(key);
            if (value == null) {
                modified.put(key, original.get(key));
                continue;
            }
            boolean matched = true;
            while (matched) {
                int start;
                int end = start = value.indexOf("${");
                if (start != -1) {
                    end = value.indexOf(125, start);
                }
                boolean bl = matched = start != -1 && end != -1;
                if (!matched) break;
                String nestedkey = value.substring(start + 2, end);
                String nestedvalue = original.getProperty(nestedkey);
                if (nestedvalue == null) {
                    nestedvalue = System.getProperty(nestedkey);
                }
                if (nestedvalue == null) {
                    value = null;
                    break;
                }
                value = value.substring(0, start) + nestedvalue + value.substring(end + 1);
            }
            if (value != null) {
                modified.setProperty(key, value);
                continue;
            }
            modified.remove(key);
        }
        return modified;
    }
}

