/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.MessageLevel;
import com.metamatrix.common.util.VMNaming;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class LogMessage
implements Externalizable {
    public static String VM_NAME = VMNaming.getVMName();
    public static String HOST_NAME = VMNaming.getLogicalHostName();
    private static final String DEFAULT_VM_NAME = "";
    private static final String NULL_MSG_TEXT = "Null";
    private String msgID;
    private String context;
    private int level;
    private Object[] msgParts;
    private Throwable exception;
    private long timestamp;
    private String threadName;
    private String hostName;
    private String vmName;

    public LogMessage(String msgID, String context, int level) {
        this.msgID = msgID;
        this.context = context;
        this.level = level;
        this.msgParts = null;
        this.timestamp = System.currentTimeMillis();
        this.threadName = Thread.currentThread().getName();
        this.hostName = HOST_NAME;
        this.vmName = VM_NAME;
    }

    public LogMessage(String msgID, String context, int level, Throwable e) {
        this(msgID, context, level);
        this.exception = e;
    }

    public LogMessage(String msgID, String context, int level, Object[] msgParts) {
        this.msgID = msgID;
        this.context = context;
        this.level = level;
        this.msgParts = this.convertMsgParts(msgParts);
        this.timestamp = System.currentTimeMillis();
        this.threadName = Thread.currentThread().getName();
        this.hostName = HOST_NAME;
        this.vmName = VM_NAME;
    }

    public LogMessage(String msgID, String context, int level, Throwable e, Object[] msgParts) {
        this(msgID, context, level, msgParts);
        this.exception = e;
    }

    public LogMessage(String context, int level, Object[] msgParts) {
        this.msgID = null;
        this.context = context;
        this.level = level;
        this.msgParts = this.convertMsgParts(msgParts);
        this.timestamp = System.currentTimeMillis();
        this.threadName = Thread.currentThread().getName();
        this.hostName = HOST_NAME;
        this.vmName = VM_NAME;
    }

    public LogMessage(String context, int level, Throwable e, Object[] msgParts) {
        this(context, level, msgParts);
        this.exception = e;
    }

    public LogMessage(String context, int level, Throwable e, Object[] msgParts, String threadname) {
        this(context, level, msgParts);
        this.exception = e;
        this.threadName = threadname;
    }

    public String getContext() {
        return this.context;
    }

    public int getLevel() {
        return this.level;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getVMName() {
        return this.vmName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getText() {
        String msg = null;
        if (this.msgID != null) {
            msg = this.msgParts == null ? CommonPlugin.Util.getString(this.msgID) : CommonPlugin.Util.getString(this.msgID, this.msgParts);
        } else {
            StringBuffer text = null;
            if (this.msgParts != null) {
                text = new StringBuffer();
                for (int i = 0; i < this.msgParts.length; ++i) {
                    Object omsg;
                    if (i > 0) {
                        text.append(" ");
                    }
                    if ((omsg = this.msgParts[i]) == null) continue;
                    text.append(omsg.toString());
                }
            }
            msg = text == null ? NULL_MSG_TEXT : text.toString();
        }
        if (msg == null || msg.length() == 0) {
            msg = NULL_MSG_TEXT;
        }
        return msg;
    }

    public String getMessageType() {
        return MessageLevel.getLabelForLevel(this.level);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.context);
        out.writeInt(this.level);
        out.writeObject(this.msgParts);
        out.writeObject(this.exception);
        out.writeLong(this.timestamp);
        out.writeObject(this.threadName);
        out.writeObject(this.vmName);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.context = (String)in.readObject();
        this.level = in.readInt();
        this.msgParts = (Object[])in.readObject();
        this.exception = (Throwable)in.readObject();
        this.timestamp = in.readLong();
        this.threadName = (String)in.readObject();
        this.vmName = (String)in.readObject();
    }

    private Object[] convertMsgParts(Object[] oriMsgParts) {
        if (oriMsgParts == null || oriMsgParts.length == 0) {
            return oriMsgParts;
        }
        Object[] newMsgParts = new Object[oriMsgParts.length];
        for (int i = 0; i < oriMsgParts.length; ++i) {
            if (oriMsgParts[i] == null) continue;
            newMsgParts[i] = oriMsgParts[i].toString();
        }
        return newMsgParts;
    }

    static {
        if (VM_NAME == null || VM_NAME.trim().length() == 0) {
            VM_NAME = VMNaming.getVMIDString();
        }
        if (VM_NAME == null || VM_NAME.trim().length() == 0) {
            VM_NAME = DEFAULT_VM_NAME;
        }
    }
}

