/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.application.basic;

import com.metamatrix.common.application.Application;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.I18nMessages;
import com.metamatrix.common.application.basic.BasicEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public abstract class BasicApplication
implements Application {
    private ApplicationEnvironment environment;
    private ArrayList installedServices = new ArrayList();

    public void initialize(Properties props) throws ApplicationInitializationException {
        BasicEnvironment basicEnv = new BasicEnvironment();
        basicEnv.setApplicationProperties(props);
        this.environment = basicEnv;
    }

    public void installService(String type, ApplicationService service) throws ApplicationInitializationException {
        if (service == null) {
            return;
        }
        try {
            service.start(this.environment);
            this.environment.bindService(type, service);
            service.bind();
            this.installedServices.add(type);
        }
        catch (ApplicationLifecycleException e) {
            throw new ApplicationInitializationException((Throwable)e, I18nMessages.getString("BasicApplication.Failed_while_installing_service_of_type__1") + type);
        }
    }

    public ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    public void stop() throws ApplicationLifecycleException {
        Iterator i = this.installedServices.iterator();
        while (i.hasNext()) {
            String type = (String)i.next();
            ApplicationService service = this.environment.findService(type);
            service.unbind();
            this.environment.unbindService(type);
            service.stop();
            i.remove();
        }
    }
}

