/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.console.models.UserManager;
import com.metamatrix.console.ui.util.LazyBranchListener;
import com.metamatrix.console.ui.views.users.GroupsTreeNode;
import com.metamatrix.console.ui.views.users.NotifyOnSelectionChange;
import com.metamatrix.console.ui.views.users.UserNodesExpandingTree;
import com.metamatrix.console.ui.views.users.UsersTabTreeCellRenderer;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticTreeUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GroupsTree
extends UserNodesExpandingTree
implements TreeSelectionListener,
TreeExpansionListener {
    public static final String METAMATRIX_LABEL = "MetaMatrix Groups";
    public static final String ENTERPRISE_LABEL = "Enterprise Groups";
    private UserManager manager;
    private NotifyOnSelectionChange controller;
    private boolean showingMetaMatrix;
    private boolean showingEnterprise;
    private boolean allowingUserNodeSelection;
    private boolean ignoreValueChange = false;
    private boolean treeChangeSinceLastPaint = false;
    private LazyBranchListener lazyBranchListener = new LazyBranchListener();

    public GroupsTree(UserManager mgr, NotifyOnSelectionChange ctrlr, boolean showMetaMatrix, boolean showEnterprise, boolean showUserNodes, boolean allowUserNodeSelection) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        this.manager = mgr;
        this.controller = ctrlr;
        this.showingMetaMatrix = showMetaMatrix;
        this.showingEnterprise = showEnterprise;
        this.allowingUserNodeSelection = allowUserNodeSelection;
        this.init();
        this.getModel().addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent ev) {
                GroupsTree.this.treeChangeSinceLastPaint = true;
            }

            public void treeNodesInserted(TreeModelEvent ev) {
                GroupsTree.this.treeChangeSinceLastPaint = true;
            }

            public void treeNodesRemoved(TreeModelEvent ev) {
                GroupsTree.this.treeChangeSinceLastPaint = true;
            }

            public void treeStructureChanged(TreeModelEvent ev) {
                GroupsTree.this.treeChangeSinceLastPaint = true;
            }
        });
        int count = this.getRowCount();
        for (int row = 0; row < count; ++row) {
            this.expandRow(row);
        }
    }

    public boolean isShowingMetaMatrix() {
        return this.showingMetaMatrix;
    }

    public boolean isShowingEnterprise() {
        return this.showingEnterprise;
    }

    private void init() {
        GroupsTreeNode rootNode = new GroupsTreeNode(null, "root", this.manager, this.allowingUserNodeSelection, 0, false, this);
        rootNode.setRoot(true);
        rootNode.setSortType(3);
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
        this.setModel(treeModel);
        rootNode.setModel(treeModel);
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer((TreeCellRenderer)new UsersTabTreeCellRenderer());
        try {
            rootNode.populate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        this.lazyBranchListener = new LazyBranchListener();
        this.addTreeWillExpandListener((TreeWillExpandListener)this.lazyBranchListener);
    }

    public void valueChanged(TreeSelectionEvent ev) {
        if (this.selectionAllowed(ev)) {
            TreePath path = ev.getNewLeadSelectionPath();
            if (path != null) {
                GroupsTreeNode selectedNode = (GroupsTreeNode)ev.getNewLeadSelectionPath().getLastPathComponent();
                this.populateSelectedNode(selectedNode);
                if (!this.ignoreValueChange) {
                    this.controller.selectionChanged((Component)((Object)this), (Object)selectedNode);
                }
            }
        } else {
            this.setSelectionPath(ev.getOldLeadSelectionPath());
        }
    }

    public void refreshData() {
        GroupsTreeNode node = null;
        TreePath path = this.getSelectionPath();
        int[] selectedRows = this.getSelectionRows();
        if (path == null && (path = this.pathToFirstMetaMatrixGroup()) != null) {
            this.setSelectionPath(path);
        }
        if (path != null) {
            node = (GroupsTreeNode)path.getLastPathComponent();
        }
        GroupsTreeNode rootNode = (GroupsTreeNode)this.getModel().getRoot();
        rootNode.removeAllChildren();
        try {
            this.refreshNode(rootNode);
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage((String)"Groups refresh failed.", (Throwable)theException);
        }
        ((DefaultTreeModel)this.getModel()).reload();
        if (node == null) {
            this.selectFirstEditableGroup();
        } else {
            Object userObj = node.getUserObject();
            TreeNode selectedNode = this.findNode((DefaultMutableTreeNode)rootNode, userObj);
            if (selectedNode == null) {
                this.selectAppropriateRow(selectedRows[0]);
            } else {
                this.expandMetaMatrixBranch();
                this.expandEnterpriseBranch();
                ArrayList<TreeNode> pathNodes = new ArrayList<TreeNode>();
                pathNodes.add(selectedNode);
                for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selectedNode.getParent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
                    pathNodes.add(parent);
                }
                Collections.reverse(pathNodes);
                TreePath newPath = new TreePath(pathNodes.toArray());
                this.removeTreeWillExpandListener((TreeWillExpandListener)this.lazyBranchListener);
                this.setSelectionPath(newPath);
                if (!this.ignoreValueChange) {
                    this.controller.selectionChanged((Component)((Object)this), (Object)selectedNode);
                }
                this.scrollRowToVisible(this.getRowForPath(newPath));
                this.addTreeWillExpandListener((TreeWillExpandListener)this.lazyBranchListener);
            }
        }
    }

    private TreeNode findNode(DefaultMutableTreeNode theNode, Object theUserObject) {
        if (theNode.getUserObject().equals(theUserObject)) {
            return theNode;
        }
        int kids = theNode.getChildCount();
        for (int i = 0; i < kids; ++i) {
            DefaultMutableTreeNode kid = (DefaultMutableTreeNode)theNode.getChildAt(i);
            TreeNode node = this.findNode(kid, theUserObject);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private void refreshNode(GroupsTreeNode theNode) throws Exception {
        theNode.resetPopulated();
        theNode.populate();
        Enumeration kids = theNode.children();
        while (kids.hasMoreElements()) {
            GroupsTreeNode kid = (GroupsTreeNode)kids.nextElement();
            this.refreshNode(kid);
        }
    }

    private void selectAppropriateRow(int theRow) {
        this.expandMetaMatrixBranch();
        int row = -1;
        int count = this.getTopOfMetaMatrixBranch().getChildCount();
        if (theRow < count) {
            row = theRow;
        } else if (theRow >= count) {
            row = count;
        }
        this.setSelectionInterval(row, row);
        this.scrollRowToVisible(row);
    }

    private TreePath pathToFirstMetaMatrixGroup() {
        TreePath path = null;
        GroupsTreeNode root = (GroupsTreeNode)this.getModel().getRoot();
        GroupsTreeNode topOfMetaMatrixBranch = null;
        Enumeration enumeration = root.children();
        while (enumeration.hasMoreElements() && topOfMetaMatrixBranch == null) {
            GroupsTreeNode child = (GroupsTreeNode)enumeration.nextElement();
            if (!child.isTopOfMetaMatrixBranch()) continue;
            topOfMetaMatrixBranch = child;
        }
        if (topOfMetaMatrixBranch != null && topOfMetaMatrixBranch.getChildCount() > 0) {
            GroupsTreeNode firstMetaMatrixGroup = (GroupsTreeNode)topOfMetaMatrixBranch.getChildAt(0);
            int numRows = this.getRowCount();
            for (int row = 0; row < numRows && path == null; ++row) {
                Object lastNodeInPath;
                TreePath curPath = this.getPathForRow(row);
                if (!this.isVisible(curPath) || (lastNodeInPath = curPath.getLastPathComponent()) != firstMetaMatrixGroup) continue;
                path = curPath;
            }
        }
        return path;
    }

    private void expandMetaMatrixBranch() {
        GroupsTreeNode node = this.getTopOfMetaMatrixBranch();
        if (node.getChildCount() > 0) {
            TreeNode firstKid = node.getFirstChild();
            ArrayList<Object> pathNodes = new ArrayList<Object>();
            pathNodes.add(this.getModel().getRoot());
            pathNodes.add(node);
            pathNodes.add(firstKid);
            TreePath path = new TreePath(pathNodes.toArray());
            this.expandPath(path);
        }
    }

    private void expandEnterpriseBranch() {
        GroupsTreeNode node = this.getTopOfEnterpriseBranch();
        if (node.getChildCount() > 0) {
            TreeNode firstKid = node.getFirstChild();
            ArrayList<Object> pathNodes = new ArrayList<Object>();
            pathNodes.add(this.getModel().getRoot());
            pathNodes.add(node);
            pathNodes.add(firstKid);
            TreePath path = new TreePath(pathNodes.toArray());
            this.expandPath(path);
        }
    }

    private void selectFirstEditableGroup() {
        GroupsTreeNode topNode = this.getTopOfMetaMatrixBranch();
        if (topNode.getChildCount() > 0) {
            TreeNode firstKid = topNode.getFirstChild();
            ArrayList<Object> pathNodes = new ArrayList<Object>();
            pathNodes.add(this.getModel().getRoot());
            pathNodes.add(topNode);
            pathNodes.add(firstKid);
            TreePath path = new TreePath(pathNodes.toArray());
            this.expandPath(path);
            this.setSelectionPath(path);
            this.scrollRowToVisible(this.getRowForPath(path));
        }
    }

    public void treeCollapsed(TreeExpansionEvent ev) {
    }

    public void treeExpanded(TreeExpansionEvent ev) {
    }

    public void setIgnoreValueChange(boolean flag) {
        this.ignoreValueChange = flag;
    }

    public boolean isDisplayableNode(GroupsTreeNode node) {
        return !node.isRoot() && !node.isTopOfMetaMatrixBranch() && !node.isTopOfEnterpriseBranch();
    }

    public GroupsTreeNode getTopOfMetaMatrixBranch() {
        GroupsTreeNode topOfMetaMatrixBranch = null;
        GroupsTreeNode root = (GroupsTreeNode)this.getModel().getRoot();
        int childCount = root.getChildCount();
        int i = 0;
        while (i < childCount && topOfMetaMatrixBranch == null) {
            GroupsTreeNode curChild = (GroupsTreeNode)root.getChildAt(i);
            if (curChild.isTopOfMetaMatrixBranch()) {
                topOfMetaMatrixBranch = curChild;
                continue;
            }
            ++i;
        }
        return topOfMetaMatrixBranch;
    }

    public GroupsTreeNode getTopOfEnterpriseBranch() {
        GroupsTreeNode topOfEnterpriseBranch = null;
        GroupsTreeNode root = (GroupsTreeNode)this.getModel().getRoot();
        int childCount = root.getChildCount();
        int i = 0;
        while (i < childCount && topOfEnterpriseBranch == null) {
            GroupsTreeNode curChild = (GroupsTreeNode)root.getChildAt(i);
            if (curChild.isTopOfEnterpriseBranch()) {
                topOfEnterpriseBranch = curChild;
                continue;
            }
            ++i;
        }
        return topOfEnterpriseBranch;
    }

    public TreeSelectionListener getSelectionListener() {
        return this;
    }

    private boolean selectionAllowed(TreeSelectionEvent ev) {
        Object lastNode;
        GroupsTreeNode selectedNode;
        boolean allowed = true;
        TreePath path = ev.getNewLeadSelectionPath();
        if (path != null && (selectedNode = (GroupsTreeNode)(lastNode = path.getLastPathComponent())).getNodeType() == 1 && !this.allowingUserNodeSelection) {
            allowed = false;
        }
        return allowed;
    }

    private void populateSelectedNode(GroupsTreeNode selectedNode) {
        try {
            selectedNode.populate();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage((String)"Populate Selected Groups Tree Node", (Throwable)ex);
        }
    }

    public void paint(Graphics g) {
        if (this.treeChangeSinceLastPaint) {
            StaticTreeUtilities.userTabPaintProblemDuplicateNodeCheck((JTree)((Object)this));
            this.treeChangeSinceLastPaint = false;
        }
        super.paint(g);
    }
}

