/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.connections;

import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.api.exception.ComponentCommunicationException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.client.ServerAdminFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionHolder;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConsoleConnectionFactory;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConnectionInfo
implements SocketServerConnectionHolder {
    private String url;
    private String user;
    private char[] password;
    private String applicationName;
    private ServerConnection connection;
    private List hosts;
    private String connectedHost;
    private List ports;
    private String connectedPort;
    private MMURL mmurl;
    private static final long INIT_RETRY_DELAY_DEFAULT_VAL = 10000L;
    private static final long MAX_RETRY_DELAY_DEFAULT_VAL = 1000L;
    private static final int MAX_RETRY_DEFAULT_VAL = 240;
    private static long INIT_RETRY_DELAY_VAL = 10000L;
    private static long MAX_RETRY_DELAY_VAL = 1000L;
    private static int MAX_RETRY_VAL = 240;

    public ConnectionInfo(String serverURL, String user, char[] password, String applicationName) {
        this.url = serverURL;
        this.user = user;
        this.password = password;
        this.applicationName = applicationName;
        this.mmurl = new MMURL(serverURL);
        List infos = this.mmurl.getHostInfo();
        this.hosts = new ArrayList(infos.size());
        this.ports = new ArrayList(infos.size());
        Iterator it = infos.iterator();
        while (it.hasNext()) {
            HostInfo hi = (HostInfo)it.next();
            this.hosts.add(hi.getHostName().toUpperCase());
            this.ports.add(String.valueOf(hi.getPortNumber()));
        }
        this.connectedHost = (String)this.hosts.get(0);
        this.connectedPort = (String)this.ports.get(0);
    }

    public String getUser() {
        return this.user;
    }

    public String getURL() {
        return this.url;
    }

    public String getHost() {
        return this.connectedHost;
    }

    public List getHosts() {
        return this.hosts;
    }

    public String getPort() {
        return this.connectedPort;
    }

    public List getPorts() {
        return this.ports;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public boolean isConnectedHost(String hostName) {
        if (this.hosts.size() == 1) {
            return this.connectedHost.equalsIgnoreCase(hostName);
        }
        return false;
    }

    public boolean isConnectedHost(String hostName, String port) {
        if (this.isConnectedHost(hostName)) {
            return this.ports.contains(port);
        }
        return false;
    }

    public ServerConnection getServerConnection(boolean create) {
        if (!create) {
            return this.connection;
        }
        if (this.connection != null && this.isOpen()) {
            return this.connection;
        }
        try {
            this.connection = this.relogin(true);
            return this.connection;
        }
        catch (LogonException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    public MetaMatrixSessionID getSessionID() {
        SocketServerConnection asc = this.getServerConnection();
        return asc.getClientSideLogon().getSessionId();
    }

    private boolean isOpen() {
        if (this.connection == null) {
            return false;
        }
        try {
            this.connection.selectServerInstance(null);
            return true;
        }
        catch (CommunicationException e) {
            return false;
        }
    }

    public SocketServerConnection getServerConnection() {
        return (SocketServerConnection)this.getServerConnection(true);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode((int)hc, (Object)this.getURL());
        hc = HashCodeUtil.hashCode((int)hc, (Object)this.getUser());
        return hc;
    }

    public boolean equals(Object obj) {
        ConnectionInfo conn;
        boolean same = obj == null ? false : (obj == this ? true : (!(obj instanceof ConnectionInfo) ? false : this.url.equals((conn = (ConnectionInfo)obj).getURL()) && this.user.equals(conn.getUser())));
        return same;
    }

    public String toString() {
        String str = this.getURL() + '[' + this.getUser() + ']';
        return str;
    }

    public ServerConnection login() throws ConnectionException, CommunicationException {
        ConsoleConnectionFactory factory = ConsoleConnectionFactory.getInstance();
        this.connection = factory.createConnection(this.user, this.password, this.url, this.applicationName);
        return this.connection;
    }

    private ServerConnection relogin(boolean sleepFirst) throws LogonException, MetaMatrixComponentException {
        if (sleepFirst) {
            try {
                Thread.sleep(INIT_RETRY_DELAY_VAL);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        this.close();
        Exception e = null;
        this.connection = null;
        for (int i = 0; i < MAX_RETRY_VAL; ++i) {
            try {
                this.connection = this.login();
                boolean initSucceeded = ModelManager.init((ConnectionInfo)this);
                if (initSucceeded) {
                    return this.connection;
                }
            }
            catch (Exception ex) {
                e = ex;
            }
            if (!sleepFirst) continue;
            try {
                Thread.sleep(MAX_RETRY_DELAY_VAL);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        String msg = "Lost communication with Server.";
        ComponentCommunicationException cce = new ComponentCommunicationException((Throwable)e, msg);
        throw cce;
    }

    public ServerConnection relogin() throws LogonException, MetaMatrixComponentException {
        return this.relogin(true);
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.shutdown();
            }
            catch (CommunicationException communicationException) {
                // empty catch block
            }
        }
    }

    public synchronized ServerAdmin getServerAdmin() throws AdminException, LogonException {
        return ServerAdminFactory.getInstance().createAdmin(this.user, this.password, this.url, this.applicationName);
    }

    public void setServerConnection(SocketServerConnection connection) {
        this.connection = connection;
    }

    static {
        long initRetryMS = -1L;
        try {
            String initialRetryDelay = ConsolePlugin.Util.getString("ConnectionInfo.initialRetryDelayMS");
            initRetryMS = Long.parseLong(initialRetryDelay);
        }
        catch (NumberFormatException err) {
            err.printStackTrace();
        }
        if (initRetryMS > 0L) {
            INIT_RETRY_DELAY_VAL = initRetryMS;
        }
        long retryDelayMS = -1L;
        try {
            String retryDelayStr = ConsolePlugin.Util.getString("ConnectionInfo.retryDelayMS");
            retryDelayMS = Long.parseLong(retryDelayStr);
        }
        catch (NumberFormatException err) {
            err.printStackTrace();
        }
        if (retryDelayMS > 0L) {
            MAX_RETRY_DELAY_VAL = retryDelayMS;
        }
        int maxRetrys = -1;
        try {
            String maxRetryStr = ConsolePlugin.Util.getString("ConnectionInfo.maxRetrys");
            maxRetrys = Integer.parseInt(maxRetryStr);
        }
        catch (NumberFormatException err) {
            err.printStackTrace();
        }
        if (maxRetrys > 0) {
            MAX_RETRY_VAL = maxRetrys;
        }
    }
}

