/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;

public class GroupingChecker {
    HashMap bundles = new HashMap();

    private ArrayList getConstraints(ResolverExport constrained) {
        HashMap exports = (HashMap)this.bundles.get(constrained.getExporter());
        if (exports == null) {
            return null;
        }
        ArrayList constraints = (ArrayList)exports.get(constrained);
        if (constraints == null) {
            return null;
        }
        ArrayList results = new ArrayList(constraints.size());
        Iterator iter = constraints.iterator();
        while (iter.hasNext()) {
            ResolverExport impConstraint;
            Object constraint = iter.next();
            if (constraint instanceof ResolverExport && !results.contains(constraint)) {
                results.add(constraint);
                continue;
            }
            ResolverImport imp = (ResolverImport)constraint;
            if (imp.getMatchingExport() == null || (impConstraint = imp.getMatchingExport().getRoot()) == null || results.contains(impConstraint)) continue;
            results.add(impConstraint);
        }
        return results;
    }

    private ArrayList createConstraints(ResolverExport constrained) {
        ArrayList constraints;
        HashMap exports = (HashMap)this.bundles.get(constrained.getExporter());
        if (exports == null) {
            exports = new HashMap();
            this.bundles.put(constrained.getExporter(), exports);
        }
        if ((constraints = (ArrayList)exports.get(constrained)) == null) {
            constraints = new ArrayList();
            exports.put(constrained, constraints);
        }
        return constraints;
    }

    private void addConstraint(ResolverExport constrained, Object constraint) {
        ArrayList list = this.createConstraints(constrained);
        if (!list.contains(constraint)) {
            list.add(constraint);
        }
    }

    private void addConstraints(ResolverExport constrained, ArrayList newConstraints) {
        ArrayList list = this.createConstraints(constrained);
        for (int i = 0; i < newConstraints.size(); ++i) {
            Object constraint = newConstraints.get(i);
            if (list.contains(constraint)) continue;
            list.add(constraint);
        }
    }

    void removeAllExportConstraints(ResolverBundle bundle) {
        this.bundles.remove(bundle);
    }

    ResolverExport isConsistent(ResolverImport imp, ResolverExport exp) {
        int i;
        ResolverImport[] imports = imp.getBundle().getImportPackages();
        BundleConstraint[] requires = imp.getBundle().getRequires();
        for (i = 0; i < imports.length; ++i) {
            ResolverExport re;
            int j;
            ResolverExport wire = imports[i].getMatchingExport();
            if (wire == null) continue;
            ArrayList list = this.getConstraints(wire);
            if (list != null) {
                for (j = 0; j < list.size(); ++j) {
                    re = (ResolverExport)list.get(j);
                    if (re.isDropped() || !re.getExporter().isResolvable() || !exp.getName().equals(re.getName()) || ResolverExport.isOnRootPath(re.getExporter(), imp.getMatchingExport()) || imp.isOnRootPathSplit(imp.getMatchingExport().getExporter(), re.getExporter())) continue;
                    return wire;
                }
            }
            if ((list = this.getConstraints(exp)) == null) continue;
            for (j = 0; j < list.size(); ++j) {
                re = (ResolverExport)list.get(j);
                if (re.isDropped()) continue;
                if (re.getExporter().isResolvable() && wire.getName().equals(re.getName()) && !ResolverExport.isOnRootPath(re.getExporter(), imports[i].getMatchingExport()) && !imp.isOnRootPathSplit(imp.getMatchingExport().getExporter(), re.getExporter())) {
                    return wire;
                }
                for (int k = 0; k < requires.length; ++k) {
                    if (requires[k].getMatchingBundle() == null) continue;
                    ResolverExport[] exports = requires[k].getMatchingBundle().getExportPackages();
                    for (int m = 0; m < exports.length; ++m) {
                        if (!re.getExporter().isResolvable() || !exports[m].getName().equals(re.getName()) || ResolverExport.isOnRootPath(re.getExporter(), exports[m])) continue;
                        return re;
                    }
                }
            }
        }
        for (i = 0; i < requires.length; ++i) {
            if (requires[i].getMatchingBundle() == null) continue;
            ResolverExport[] exports = requires[i].getMatchingBundle().getExportPackages();
            for (int j = 0; j < exports.length; ++j) {
                ArrayList list = this.getConstraints(exports[j]);
                if (list == null) continue;
                for (int k = 0; k < list.size(); ++k) {
                    ResolverExport re = (ResolverExport)list.get(k);
                    if (!re.getExporter().isResolvable() || !exp.getName().equals(re.getName()) || ResolverExport.isOnRootPath(re.getExporter(), imp.getMatchingExport())) continue;
                    return re;
                }
            }
        }
        return null;
    }

    boolean checkRequiresConstraints(ResolverBundle bundle) {
        BundleConstraint[] requires = bundle.getRequires();
        if (requires == null) {
            return true;
        }
        for (int i = 0; i < requires.length; ++i) {
            ResolverBundle matchingBundle = requires[i].getMatchingBundle();
            if (matchingBundle == null) continue;
            ResolverExport[] exports = matchingBundle.getExportPackages();
            for (int j = 0; j < exports.length; ++j) {
                ArrayList list = this.getConstraints(exports[j]);
                if (list == null) continue;
                for (int k = 0; k < list.size(); ++k) {
                    ResolverExport constraint = (ResolverExport)list.get(k);
                    boolean foundPotential = false;
                    boolean found = false;
                    for (int m = 0; m < requires.length; ++m) {
                        if (requires[m].getMatchingBundle() == null) continue;
                        ResolverExport[] exps = requires[m].getMatchingBundle().getExportPackages();
                        for (int n = 0; n < exps.length; ++n) {
                            if (!constraint.getExporter().isResolvable() || !constraint.getName().equals(exps[n].getName())) continue;
                            foundPotential = true;
                            if (exps[n] != constraint && !ResolverExport.isOnRootPath(constraint.getExporter(), exps[n])) continue;
                            found = true;
                            break;
                        }
                        if (found) break;
                    }
                    if (!foundPotential || found) continue;
                    return false;
                }
            }
        }
        return true;
    }

    void addInitialGroupingConstraints(ResolverBundle[] initBundles) {
        for (int i = 0; i < initBundles.length; ++i) {
            if (this.bundles.containsKey(initBundles[i])) continue;
            ResolverExport[] exports = initBundles[i].getExportPackages();
            for (int j = 0; j < exports.length; ++j) {
                String[] uses = (String[])exports[j].getExportPackageDescription().getDirective("uses");
                if (uses == null) continue;
                for (int k = 0; k < uses.length; ++k) {
                    Object constraint = initBundles[i].getExport(uses[k]);
                    if (constraint != null) {
                        this.addConstraint(exports[j], constraint);
                        this.addTransitiveGroupingConstraints(exports[j], (ResolverExport)constraint);
                    }
                    if ((constraint = initBundles[i].getImport(uses[k])) == null) continue;
                    this.addConstraint(exports[j], constraint);
                }
            }
            if (this.bundles.get(initBundles[i]) != null) continue;
            this.bundles.put(initBundles[i], null);
        }
    }

    private void addTransitiveGroupingConstraints(ResolverExport export, ResolverExport constraint) {
        if (export == constraint) {
            return;
        }
        String[] uses = (String[])constraint.getExportPackageDescription().getDirective("uses");
        if (uses == null) {
            return;
        }
        for (int i = 0; i < uses.length; ++i) {
            ArrayList list;
            Object newConstraint = export.getExporter().getExport(uses[i]);
            if (newConstraint == null) {
                newConstraint = export.getExporter().getImport(uses[i]);
            }
            if (newConstraint == null || newConstraint == constraint || (list = this.getConstraints(export)) != null && list.contains(newConstraint)) continue;
            this.addConstraint(export, newConstraint);
            if (!(newConstraint instanceof ResolverExport)) continue;
            this.addTransitiveGroupingConstraints(export, (ResolverExport)newConstraint);
        }
    }

    void addReExportConstraints(ResolverBundle bundle) {
        ResolverExport[] exports = bundle.getExportPackages();
        for (int i = 0; i < exports.length; ++i) {
            ArrayList list;
            ResolverExport root;
            if (exports[i].getExportPackageDescription().isRoot() || (root = exports[i].getRoot()) == null || (list = this.getConstraints(root)) == null) continue;
            this.addConstraints(exports[i], list);
        }
    }

    void addRequireConstraints(ResolverExport[] exports, ResolverBundle bundle) {
        BundleConstraint[] requires = bundle.getRequires();
        for (int i = 0; i < exports.length; ++i) {
            if (exports[i].getExportPackageDescription().isRoot()) continue;
            for (int j = 0; j < requires.length; ++j) {
                if (requires[j].getMatchingBundle() == null || exports[i].getExporter() == requires[j].getMatchingBundle()) continue;
                ResolverExport[] requireExports = requires[j].getMatchingBundle().getExportPackages();
                for (int k = 0; k < requireExports.length; ++k) {
                    ArrayList list;
                    if (!exports[i].getName().equals(requireExports[k].getName()) || (list = this.getConstraints(requireExports[k])) == null) continue;
                    for (int m = 0; m < list.size(); ++m) {
                        this.addConstraint(exports[i], list.get(m));
                    }
                }
            }
        }
    }

    void addReprovideConstraints(ResolverExport re) {
        BundleConstraint[] requires = re.getExporter().getRequires();
        for (int i = 0; i < requires.length; ++i) {
            if (requires[i].getMatchingBundle() == null) {
                return;
            }
            ResolverExport[] requireExports = requires[i].getMatchingBundle().getExportPackages();
            for (int j = 0; j < requireExports.length; ++j) {
                ArrayList list;
                if (!re.getName().equals(requireExports[j].getName()) || (list = this.getConstraints(requireExports[j])) == null) continue;
                for (int k = 0; k < list.size(); ++k) {
                    this.addConstraint(re, list.get(k));
                }
            }
        }
    }
}

