/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.BundleException;

public class SystemBundleData
extends AbstractBundleData {
    public static final String OSGI_FRAMEWORK = "osgi.framework";

    public SystemBundleData(AbstractFrameworkAdaptor adaptor) throws BundleException {
        super(adaptor, 0L);
        File osgiBase = this.getOsgiBase();
        this.createBundleFile(osgiBase);
        this.manifest = this.createManifest(osgiBase);
        this.setMetaData();
        this.setLastModified(System.currentTimeMillis());
    }

    private File getOsgiBase() {
        String frameworkLocation = System.getProperty(OSGI_FRAMEWORK);
        if (frameworkLocation != null) {
            return new File(frameworkLocation.substring(5));
        }
        try {
            URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            return new File(url.getPath());
        }
        catch (Throwable throwable) {
            frameworkLocation = System.getProperty("user.dir");
            if (frameworkLocation != null) {
                return new File(frameworkLocation);
            }
            return null;
        }
    }

    private Headers createManifest(File osgiBase) throws BundleException {
        InputStream in = null;
        if (osgiBase != null && osgiBase.exists()) {
            try {
                BundleEntry entry = this.baseBundleFile.getEntry("META-INF/MANIFEST.MF");
                if (entry != null) {
                    in = entry.getInputStream();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (in == null) {
            in = this.getManifestAsResource();
        }
        if (Debug.DEBUG_GENERAL && in == null) {
            Debug.println("Unable to find system bundle manifest META-INF/MANIFEST.MF");
        }
        if (in == null) {
            throw new BundleException(AdaptorMsg.SYSTEMBUNDLE_MISSING_MANIFEST);
        }
        Headers systemManifest = Headers.parseManifest(in);
        String exportPackages = this.adaptor.getExportPackages();
        String exportServices = this.adaptor.getExportServices();
        String providePackages = this.adaptor.getProvidePackages();
        if (exportPackages != null) {
            this.appendManifestValue(systemManifest, "Export-Package", exportPackages);
        }
        if (exportServices != null) {
            this.appendManifestValue(systemManifest, "Export-Service", exportServices);
        }
        if (providePackages != null) {
            this.appendManifestValue(systemManifest, "Provide-Package", providePackages);
        }
        return systemManifest;
    }

    private InputStream getManifestAsResource() {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            Enumeration<URL> manifests;
            Enumeration<URL> enumeration = manifests = cl != null ? cl.getResources("META-INF/MANIFEST.MF") : ClassLoader.getSystemResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL url = manifests.nextElement();
                try {
                    Headers headers = Headers.parseManifest(url.openStream());
                    if (!"true".equals(headers.get("Eclipse-SystemBundle"))) continue;
                    return url.openStream();
                }
                catch (BundleException e) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void appendManifestValue(Headers systemManifest, String header, String append) {
        String newValue = (String)systemManifest.get(header);
        newValue = newValue == null ? append : newValue + "," + append;
        systemManifest.set(header, null);
        systemManifest.set(header, newValue);
    }

    private void createBundleFile(File osgiBase) {
        if (osgiBase != null) {
            try {
                this.baseBundleFile = this.adaptor.createBundleFile(osgiBase, this);
            }
            catch (IOException iOException) {}
        } else {
            this.baseBundleFile = new BundleFile(osgiBase){

                public File getFile(String path) {
                    return null;
                }

                public BundleEntry getEntry(String path) {
                    return null;
                }

                public Enumeration getEntryPaths(String path) {
                    return null;
                }

                public void close() {
                }

                public void open() {
                }

                public boolean containsDir(String dir) {
                    return false;
                }
            };
        }
    }

    private void setMetaData() throws BundleException {
        this.setLocation("System Bundle");
        this.loadFromManifest();
    }

    public BundleClassLoader createClassLoader(ClassLoaderDelegate delegate, BundleProtectionDomain domain, String[] bundleclasspath) {
        return null;
    }

    public File createGenerationDir() {
        return null;
    }

    public String findLibrary(String libname) {
        return null;
    }

    public void installNativeCode(String[] nativepaths) throws BundleException {
    }

    public File getDataFile(String path) {
        return null;
    }

    public int getStartLevel() {
        return 0;
    }

    public int getStatus() {
        return 0;
    }

    public void save() {
    }

    public String[] getBundleSigners() {
        return null;
    }
}

