/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import java.util.Collection;
import java.util.List;

public class CorrelatedReferenceCollectorVisitor
extends LanguageVisitor {
    private Collection groupSymbols;
    private List references;

    public CorrelatedReferenceCollectorVisitor(Collection groupSymbols, List correlatedReferences) {
        this.groupSymbols = groupSymbols;
        this.references = correlatedReferences;
    }

    public List getReferences() {
        return this.references;
    }

    public void visit(Reference obj) {
        ElementSymbol e;
        GroupSymbol g;
        Expression expr = obj.getExpression();
        if (expr instanceof ElementSymbol && this.groupSymbols.contains(g = (e = (ElementSymbol)expr).getGroupSymbol()) && e.isExternalReference()) {
            this.references.add(obj);
        }
    }

    public static final void collectReferences(LanguageObject obj, Collection groupSymbols, List correlatedReferences) {
        CorrelatedReferenceCollectorVisitor visitor = new CorrelatedReferenceCollectorVisitor(groupSymbols, correlatedReferences);
        DeepPreOrderNavigator.doVisit(obj, visitor);
    }
}

