/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.proc;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;

public class AssignmentStatement
extends Statement
implements SubqueryContainer {
    private ElementSymbol variable;
    private Command command;
    private Expression expression;

    public AssignmentStatement() {
    }

    public AssignmentStatement(ElementSymbol variable, Expression value) {
        this.variable = variable;
        this.expression = value;
    }

    public AssignmentStatement(ElementSymbol variable, Command value) {
        this.variable = variable;
        this.command = value;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean hasCommand() {
        return this.command != null;
    }

    public boolean hasExpression() {
        return this.expression != null;
    }

    public ElementSymbol getVariable() {
        return this.variable;
    }

    public void setVariable(ElementSymbol variable) {
        this.variable = variable;
    }

    public int getType() {
        return 5;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        AssignmentStatement clone = null;
        if (this.hasExpression()) {
            clone = new AssignmentStatement((ElementSymbol)this.variable.clone(), (Expression)this.expression.clone());
        } else if (this.hasCommand()) {
            clone = new AssignmentStatement((ElementSymbol)this.variable.clone(), (Command)this.command.clone());
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AssignmentStatement other = (AssignmentStatement)obj;
        return EquivalenceUtil.areEqual(this.getVariable(), other.getVariable()) && EquivalenceUtil.areEqual(this.getCommand(), other.getCommand()) && EquivalenceUtil.areEqual(this.getExpression(), other.getExpression());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.getVariable());
        myHash = HashCodeUtil.hashCode(myHash, this.getExpression());
        myHash = HashCodeUtil.hashCode(myHash, this.getCommand());
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

