/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.AbstractCompareCriteria;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.util.ValueIterator;
import com.metamatrix.query.sql.util.ValueIteratorProvider;

public class SubqueryCompareCriteria
extends AbstractCompareCriteria
implements SubqueryContainer,
ValueIteratorProvider {
    public static final int NO_QUANTIFIER = 1;
    public static final int SOME = 2;
    public static final int ANY = 3;
    public static final int ALL = 4;
    private int predicateQuantifier = 1;
    private Command command;
    private ValueIterator valueIterator;

    public SubqueryCompareCriteria() {
    }

    public SubqueryCompareCriteria(Expression leftExpression, Command subCommand, int operator, int predicateQuantifier) {
        this.setLeftExpression(leftExpression);
        this.setCommand(subCommand);
        this.setOperator(operator);
        this.setPredicateQuantifier(predicateQuantifier);
    }

    public int getPredicateQuantifier() {
        return this.predicateQuantifier;
    }

    public void setPredicateQuantifier(int predicateQuantifier) {
        this.predicateQuantifier = predicateQuantifier;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public ValueIterator getValueIterator() {
        if (this.valueIterator == null) {
            throw new MetaMatrixRuntimeException("ERR.015.010.0034", QueryPlugin.Util.getString("ERR.015.010.0034"));
        }
        this.valueIterator.reset();
        return this.valueIterator;
    }

    public void setValueIterator(ValueIterator valueIterator) {
        this.valueIterator = valueIterator;
    }

    public String getPredicateQuantifierAsString() {
        switch (this.predicateQuantifier) {
            case 1: {
                return "";
            }
            case 3: {
                return "ANY ";
            }
            case 2: {
                return "SOME ";
            }
            case 4: {
                return "ALL ";
            }
        }
        return "??";
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode(hc, this.getLeftExpression());
        hc = HashCodeUtil.hashCode(hc, this.getOperator());
        hc = HashCodeUtil.hashCode(hc, this.getPredicateQuantifier());
        hc = HashCodeUtil.hashCode(hc, this.getCommand());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        SubqueryCompareCriteria scc = (SubqueryCompareCriteria)obj;
        return this.getOperator() == scc.getOperator() && this.getPredicateQuantifier() == scc.getPredicateQuantifier() && EquivalenceUtil.areEqual(this.getLeftExpression(), scc.getLeftExpression()) && EquivalenceUtil.areEqual(this.getCommand(), scc.getCommand());
    }

    public Object clone() {
        Expression leftCopy = null;
        if (this.getLeftExpression() != null) {
            leftCopy = (Expression)this.getLeftExpression().clone();
        }
        Command copyCommand = null;
        if (this.getCommand() != null) {
            copyCommand = (Command)this.getCommand().clone();
        }
        return new SubqueryCompareCriteria(leftCopy, copyCommand, this.getOperator(), this.getPredicateQuantifier());
    }
}

