/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.symbol.Expression;

public class MatchCriteria
extends PredicateCriteria {
    public static final char WILDCARD_CHAR = '%';
    public static final char MATCH_CHAR = '_';
    private Expression leftExpression;
    private Expression rightExpression;
    public static final char NULL_ESCAPE_CHAR = '\u0000';
    private char escapeChar = '\u0000';
    private boolean negated = false;

    public MatchCriteria() {
    }

    public MatchCriteria(Expression leftExpression, Expression rightExpression) {
        this.setLeftExpression(leftExpression);
        this.setRightExpression(rightExpression);
    }

    public MatchCriteria(Expression leftExpression, Expression rightExpression, char escapeChar) {
        this(leftExpression, rightExpression);
        this.setEscapeChar(escapeChar);
    }

    public void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public void setRightExpression(Expression expression) {
        this.rightExpression = expression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setNegated(boolean negationFlag) {
        this.negated = negationFlag;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode(hc, this.getLeftExpression());
        hc = HashCodeUtil.hashCode(hc, this.getRightExpression());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        MatchCriteria mc = (MatchCriteria)obj;
        if (this.isNegated() ^ mc.isNegated()) {
            return false;
        }
        return this.getEscapeChar() == mc.getEscapeChar() && EquivalenceUtil.areEqual(this.getLeftExpression(), mc.getLeftExpression()) && EquivalenceUtil.areEqual(this.getRightExpression(), mc.getRightExpression());
    }

    public static String translateWildcard(String old, char wildcard, char escape) {
        StringBuffer trans = new StringBuffer();
        boolean sawEscape = false;
        for (int i = 0; i < old.length(); ++i) {
            char oldChar = old.charAt(i);
            if (sawEscape) {
                if (oldChar != '%' && escape != '\u0000') {
                    trans.append(escape);
                }
                trans.append(oldChar);
                sawEscape = false;
                continue;
            }
            if (oldChar == escape) {
                sawEscape = true;
                continue;
            }
            if (oldChar == '%') {
                trans.append(wildcard);
                continue;
            }
            if (oldChar == wildcard) {
                if (escape != '\u0000') {
                    trans.append(escape);
                }
                trans.append(wildcard);
                continue;
            }
            trans.append(oldChar);
        }
        return trans.toString();
    }

    public Object clone() {
        Expression leftCopy = null;
        if (this.getLeftExpression() != null) {
            leftCopy = (Expression)this.getLeftExpression().clone();
        }
        Expression rightCopy = null;
        if (this.getRightExpression() != null) {
            rightCopy = (Expression)this.getRightExpression().clone();
        }
        MatchCriteria criteriaCopy = new MatchCriteria(leftCopy, rightCopy, this.getEscapeChar());
        criteriaCopy.setNegated(this.isNegated());
        return criteriaCopy;
    }
}

