/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api.service;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.AuthorizationMgmtException;
import com.metamatrix.api.exception.security.InvalidMetaMatrixPrincipalException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.util.RemoteUtil;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeImpl;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.AuthorizationServiceInterface;
import com.metamatrix.platform.security.api.service.IAuthorizationServiceProxy;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotInitializedException;
import com.metamatrix.platform.service.proxy.ServiceProxy;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AuthorizationServiceProxy
extends ServiceProxy
implements IAuthorizationServiceProxy {
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$service$AuthorizationServiceInterface;

    public AuthorizationServiceProxy() {
        this.setLoggingContext("AUTHORIZATION");
    }

    public String getServiceType() {
        return "AuthorizationService";
    }

    public String printServiceState() throws ServiceException {
        return this.getCurrentService().toString();
    }

    protected String getServiceNameForProxy() {
        return "AuthorizationService";
    }

    protected AuthorizationServiceInterface getCurrentService() throws ServiceException {
        return (AuthorizationServiceInterface)RemoteUtil.narrow(this.getNextInstance(), class$com$metamatrix$platform$security$api$service$AuthorizationServiceInterface == null ? (class$com$metamatrix$platform$security$api$service$AuthorizationServiceInterface = AuthorizationServiceProxy.class$("com.metamatrix.platform.security.api.service.AuthorizationServiceInterface")) : class$com$metamatrix$platform$security$api$service$AuthorizationServiceInterface);
    }

    public boolean checkAccess(SessionToken sessionToken, String contextName, AuthorizationPermission request) throws InvalidSessionException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.checkAccess(sessionToken, contextName, request);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public boolean checkAccess(SessionToken sessionToken, String contextName, AuthorizationPermission request, boolean fetchDependants) throws InvalidSessionException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.checkAccess(sessionToken, contextName, request, fetchDependants);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public boolean checkAccess(SessionToken sessionToken, String contextName, Collection requests) throws InvalidSessionException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.checkAccess(sessionToken, contextName, requests);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public Collection getAccessibleResources(SessionToken sessionToken, String contextName, Collection requests) throws InvalidSessionException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getAccessibleResources(sessionToken, contextName, requests);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getInaccessibleResources(SessionToken sessionToken, String contextName, Collection requests) throws InvalidSessionException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getInaccessibleResources(sessionToken, contextName, requests);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public List getGroupEntitlements(AuthorizationRealm realm, String fullyQualifiedGroupName) throws AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getGroupEntitlements(realm, fullyQualifiedGroupName);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public List getGroupEntitlements(AuthorizationRealm realm, Collection groupNames) throws AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getGroupEntitlements(realm, groupNames);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public List getElementEntitlements(AuthorizationRealm realm, String fullyQualifiedElementName) throws AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getElementEntitlements(realm, fullyQualifiedElementName);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public List getElementEntitlements(AuthorizationRealm realm, Collection elementNames) throws AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getElementEntitlements(realm, elementNames);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Map getUserActionsForResources(SessionToken userToken, Collection resources) throws InvalidMetaMatrixPrincipalException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getUserActionsForResources(userToken, resources);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getRealmNames(SessionToken caller) throws InvalidSessionException, AuthorizationMgmtException, AuthorizationException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getRealmNames(caller);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public boolean containsPolicy(SessionToken caller, AuthorizationPolicyID id) throws InvalidSessionException, AuthorizationMgmtException, AuthorizationException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.containsPolicy(caller, id);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public Collection findAllPolicyIDs(SessionToken caller) throws InvalidSessionException, AuthorizationMgmtException, AuthorizationException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.findAllPolicyIDs(caller);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection findPolicyIDs(SessionToken caller, Collection principals) throws InvalidSessionException, AuthorizationMgmtException, AuthorizationException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.findPolicyIDs(caller, principals);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getPolicies(SessionToken caller, Collection policyIDs) throws InvalidSessionException, AuthorizationMgmtException, AuthorizationException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPolicies(caller, policyIDs);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public AuthorizationPolicy getPolicy(SessionToken caller, AuthorizationPolicyID policyID) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPolicy(caller, policyID);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("AuthorizationServiceProxy.No_auth_svc");
            this.logException(e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Set executeTransaction(SessionToken caller, List actions) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.executeTransaction(caller, actions);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public boolean isCallerInRole(SessionToken caller, String roleName) throws AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.isCallerInRole(caller, roleName);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public boolean isCallerInRole(SessionToken caller, Set roleNames) throws AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.isCallerInRole(caller, roleNames);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public Map getRoleDescriptions(SessionToken caller) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getRoleDescriptions(caller);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getPrincipalsForRole(SessionToken caller, String roleName) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPrincipalsForRole(caller, roleName);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getRoleNamesForPrincipal(SessionToken caller, MetaMatrixPrincipalName principal, boolean explicitOnly) throws InvalidSessionException, AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getRoleNamesForPrincipal(caller, principal, explicitOnly);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public boolean removePrincipalFromAllPolicies(SessionToken caller, MetaMatrixPrincipalName principal) throws AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.removePrincipalFromAllPolicies(caller, principal);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public Collection getPolicyIDsWithPermissionsInRealm(SessionToken caller, AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPolicyIDsWithPermissionsInRealm(caller, realm);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getPolicyIDsInRealm(SessionToken caller, AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPolicyIDsInRealm(caller, realm);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getPoliciesInRealm(SessionToken caller, AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPoliciesInRealm(caller, realm);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getPolicyIDsInPartialRealm(SessionToken caller, AuthorizationRealm realm) throws AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPolicyIDsInPartialRealm(caller, realm);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getPolicIDsForResourceInRealm(SessionToken caller, AuthorizationRealm realm, String resourceName) throws AuthorizationException, AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPolicIDsForResourceInRealm(caller, realm, resourceName);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public PermissionDataNodeImpl fillPermissionNodeTree(PermissionDataNodeImpl root, AuthorizationPolicyID policyID) throws AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        super.checkConnection();
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.fillPermissionNodeTree(root, policyID);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public void removePrincipalFromCache(String principal) throws ComponentNotFoundException, ServiceException {
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            service.removePrincipalFromCache(principal);
                            return;
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
    }

    public List getMetaBaseNodes(SessionToken callerToken) throws AuthorizationMgmtException, ComponentNotFoundException, ServiceException {
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getMetaBaseNodes(callerToken);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public void processRepositoryChanges(String targetPath, String targetUUID, String user, boolean isAdd) throws AuthorizationException, ComponentNotFoundException {
        AuthorizationServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            service.processRepositoryChanges(targetPath, targetUUID, user, isAdd);
                            return;
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0077");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0077", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0078");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0078", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0079");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0079", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0080");
            I18nLogManager.logError("PROXY", "ERR.014.107.0080", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

