/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import java.util.BitSet;

public class UriUtil {
    private static final char[] hexadecimal;
    private static BitSet alphanum;
    private static BitSet schemeReserved;
    private static BitSet authorityReserved;
    private static BitSet userinfoReserved;
    private static BitSet hostReserved;
    private static BitSet pathReserved;
    private static BitSet queryReserved;

    private UriUtil() {
    }

    public static BitSet alphanum() {
        return alphanum;
    }

    public static BitSet schemeReserved() {
        return schemeReserved;
    }

    public static BitSet authorityReserved() {
        return authorityReserved;
    }

    public static BitSet userinfoReserved() {
        return userinfoReserved;
    }

    public static BitSet hostReserved() {
        return hostReserved;
    }

    public static BitSet pathReserved() {
        return pathReserved;
    }

    public static BitSet queryReserved() {
        return queryReserved;
    }

    private static synchronized byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    public static String unescape(String str) {
        return str == null ? null : UriUtil.unescape(str.getBytes());
    }

    public static synchronized String unescape(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        int ix = 0;
        int ox = 0;
        while (ix < len) {
            int b;
            if ((b = bytes[ix++]) == 43) {
                b = 32;
            } else if (b == 37) {
                b = (byte)((UriUtil.convertHexDigit(bytes[ix++]) << 4) + UriUtil.convertHexDigit(bytes[ix++]));
            }
            bytes[ox++] = b;
        }
        return new String(bytes, 0, ox);
    }

    public static String escape(String str) {
        return UriUtil.escape(str, null);
    }

    public static String escape(String str, BitSet reserved) {
        return str == null ? null : UriUtil.escape(str.getBytes(), reserved);
    }

    public static synchronized String escape(byte[] bytes, BitSet reserved) {
        if (bytes == null) {
            return null;
        }
        StringBuffer rewrittenStr = new StringBuffer(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            char c = (char)bytes[i];
            if (alphanum.get(c)) {
                rewrittenStr.append(c);
                continue;
            }
            if (reserved != null && reserved.get(c)) {
                rewrittenStr.append(c);
                continue;
            }
            byte toEscape = bytes[i];
            rewrittenStr.append('%');
            int low = toEscape & 0xF;
            int high = (toEscape & 0xF0) >> 4;
            rewrittenStr.append(hexadecimal[high]);
            rewrittenStr.append(hexadecimal[low]);
        }
        return rewrittenStr.toString();
    }

    static {
        int i;
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        alphanum = new BitSet(128);
        for (i = 97; i <= 122; ++i) {
            alphanum.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            alphanum.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            alphanum.set(i);
        }
        schemeReserved = new BitSet(128);
        schemeReserved.set(43);
        schemeReserved.set(46);
        schemeReserved.set(45);
        authorityReserved = new BitSet(128);
        authorityReserved.set(59);
        authorityReserved.set(58);
        authorityReserved.set(64);
        authorityReserved.set(63);
        authorityReserved.set(47);
        userinfoReserved = new BitSet(128);
        userinfoReserved.set(59);
        userinfoReserved.set(58);
        userinfoReserved.set(38);
        userinfoReserved.set(61);
        userinfoReserved.set(43);
        userinfoReserved.set(36);
        userinfoReserved.set(44);
        hostReserved = new BitSet(128);
        hostReserved.set(46);
        hostReserved.set(45);
        pathReserved = new BitSet(128);
        pathReserved.set(47);
        pathReserved.set(59);
        pathReserved.set(61);
        pathReserved.set(63);
        queryReserved = new BitSet(128);
        queryReserved.set(59);
        queryReserved.set(47);
        queryReserved.set(63);
        queryReserved.set(58);
        queryReserved.set(64);
        queryReserved.set(38);
        queryReserved.set(61);
        queryReserved.set(43);
        queryReserved.set(44);
        queryReserved.set(36);
    }

    public static interface Constants {
        public static final char SEPARATOR_CHAR = '/';
        public static final char PROTOCOL_SEPARATOR_CHAR = '/';
        public static final char PORT_SEPARATOR_CHAR = ':';
        public static final String SEPARATOR = String.valueOf('/');
        public static final String PROTOCOL_SEPARATOR = String.valueOf('/');
        public static final String PORT_SEPARATOR = String.valueOf(':');
    }
}

