/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.CommonPlugin;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ByteArrayHelper {
    private static final String SEPARATOR = "-";
    private static final String ZERO_FILL = "0";
    public static final int CHUNK_SIZE = 32000;

    public static String toString(byte[] bytes) {
        if (bytes != null) {
            if (bytes.length == 0) {
                return "";
            }
            StringBuffer buf = new StringBuffer(bytes.length * 3 - 1);
            for (int i = 0; i < bytes.length; ++i) {
                String hexValue;
                if (i > 0) {
                    buf.append(SEPARATOR);
                }
                if ((hexValue = Integer.toHexString(bytes[i] & 0xFF)).length() == 1) {
                    buf.append(ZERO_FILL);
                }
                buf.append(hexValue.toUpperCase());
            }
            return buf.toString();
        }
        return null;
    }

    public static byte[] parse(String s) throws NumberFormatException {
        if (s != null) {
            ArrayList<Integer> byteArray = new ArrayList<Integer>(s.length() / 3 + 1);
            StringTokenizer tokenizer = new StringTokenizer(s, SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.trim().length() != 2) {
                    throw new NumberFormatException(CommonPlugin.Util.getString("ERR.003.030.0019", token));
                }
                byteArray.add(Integer.valueOf(token, 16));
            }
            byte[] bytes = new byte[byteArray.size()];
            for (int i = 0; i < byteArray.size(); ++i) {
                bytes[i] = ((Integer)byteArray.get(i)).byteValue();
            }
            return bytes;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] byArray = ByteArrayHelper.toByteArray(fis);
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        return ByteArrayHelper.toByteArray(stream, 32000);
    }

    public static byte[] toByteArray(InputStream stream, int chunkSize) throws IOException {
        byte[] data = null;
        ArrayList<byte[]> dataArrays = null;
        data = new byte[chunkSize];
        int pos = 0;
        int finalSize = 0;
        while (stream.available() > 0) {
            int n = stream.read(data, pos, data.length - pos);
            if (n >= 0) {
                pos += n;
            }
            if (data.length - pos != 0) continue;
            if (dataArrays == null) {
                dataArrays = new ArrayList<byte[]>();
            }
            dataArrays.add(data);
            data = new byte[chunkSize];
            pos = 0;
            finalSize += chunkSize;
        }
        byte[] result = new byte[finalSize += pos];
        int offSet = 0;
        if (dataArrays != null) {
            Iterator i = dataArrays.iterator();
            byte[] tempArray = null;
            while (i.hasNext()) {
                tempArray = (byte[])i.next();
                System.arraycopy(tempArray, 0, result, offSet, chunkSize);
                offSet += chunkSize;
            }
        }
        System.arraycopy(data, 0, result, offSet, pos);
        return result;
    }

    public static void toOutputStream(byte[] data, OutputStream outputStream) throws Exception {
        int bytesRead;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream isContent = new BufferedInputStream(bais);
        byte[] buff = new byte[2048];
        while (-1 != (bytesRead = ((InputStream)isContent).read(buff, 0, buff.length))) {
            outputStream.write(buff, 0, bytesRead);
        }
        outputStream.flush();
        outputStream.close();
    }

    public static InputStream toInputStream(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream isContent = new BufferedInputStream(bais);
        return isContent;
    }
}

