/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types;

import com.metamatrix.common.types.DataTypeManager;
import java.util.HashMap;
import java.util.Map;

public final class MMJDBCSQLTypeInfo {
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String TIME = "time";
    public static final String DATE = "date";
    public static final String TIMESTAMP = "timestamp";
    public static final String INTEGER = "integer";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String BIGDECIMAL = "bigdecimal";
    public static final String BIGINTEGER = "biginteger";
    public static final String BYTE = "byte";
    public static final String SHORT = "short";
    public static final String LONG = "long";
    public static final String CHAR = "char";
    public static final String OBJECT = "object";
    public static final String CLOB = "clob";
    public static final String BLOB = "blob";
    public static final String XML = "xml";
    public static final String NULL = "null";
    private static Map NAME_TO_TYPE_MAP = new HashMap();
    public static final String STRING_CLASS;
    public static final String BOOLEAN_CLASS;
    public static final String TIME_CLASS;
    public static final String DATE_CLASS;
    public static final String TIMESTAMP_CLASS;
    public static final String INTEGER_CLASS;
    public static final String FLOAT_CLASS;
    public static final String DOUBLE_CLASS;
    public static final String BIGDECIMAL_CLASS;
    public static final String BYTE_CLASS;
    public static final String SHORT_CLASS;
    public static final String LONG_CLASS;
    public static final String CHAR_CLASS;
    public static final String BIGINTEGER_CLASS;
    public static final String OBJECT_CLASS;
    public static final String CLOB_CLASS = "java.sql.Clob";
    public static final String BLOB_CLASS = "java.sql.Blob";
    private static Map CLASSNAME_TO_TYPE_MAP;

    private MMJDBCSQLTypeInfo() {
    }

    public static final int getSQLType(String typeName) {
        if (typeName == null) {
            return 0;
        }
        Integer sqlType = (Integer)NAME_TO_TYPE_MAP.get(typeName.toLowerCase());
        if (sqlType == null) {
            return 2000;
        }
        return sqlType;
    }

    public static final int getSQLTypeFromClass(String typeName) {
        if (typeName == null) {
            return 0;
        }
        Integer sqlType = (Integer)CLASSNAME_TO_TYPE_MAP.get(typeName.toLowerCase());
        if (sqlType == null) {
            return 2000;
        }
        return sqlType;
    }

    public static final int getSQLTypeFromRuntimeType(Class type) {
        String name = DataTypeManager.getDataTypeName(type);
        return MMJDBCSQLTypeInfo.getSQLType(name);
    }

    public static final String getJavaClassName(int jdbcSQLType) {
        String javaClassName;
        switch (jdbcSQLType) {
            case 12: {
                javaClassName = STRING_CLASS;
                break;
            }
            case -1: {
                javaClassName = STRING_CLASS;
                break;
            }
            case 1: {
                javaClassName = CHAR_CLASS;
                break;
            }
            case -7: {
                javaClassName = BOOLEAN_CLASS;
                break;
            }
            case 91: {
                javaClassName = DATE_CLASS;
                break;
            }
            case 92: {
                javaClassName = TIME_CLASS;
                break;
            }
            case 93: {
                javaClassName = TIMESTAMP_CLASS;
                break;
            }
            case 4: {
                javaClassName = INTEGER_CLASS;
                break;
            }
            case 7: {
                javaClassName = FLOAT_CLASS;
                break;
            }
            case 6: {
                javaClassName = DOUBLE_CLASS;
                break;
            }
            case 8: {
                javaClassName = DOUBLE_CLASS;
                break;
            }
            case 2: {
                javaClassName = BIGDECIMAL_CLASS;
                break;
            }
            case 3: {
                javaClassName = BIGDECIMAL_CLASS;
                break;
            }
            case -5: {
                javaClassName = LONG_CLASS;
                break;
            }
            case -6: {
                javaClassName = BYTE_CLASS;
                break;
            }
            case 5: {
                javaClassName = SHORT_CLASS;
                break;
            }
            case 2000: {
                javaClassName = OBJECT_CLASS;
                break;
            }
            case 2005: {
                javaClassName = CLOB_CLASS;
                break;
            }
            case 2004: {
                javaClassName = BLOB_CLASS;
                break;
            }
            default: {
                javaClassName = null;
            }
        }
        return javaClassName;
    }

    public static String[] getMMTypeNames() {
        return new String[]{STRING, BOOLEAN, TIME, DATE, TIMESTAMP, INTEGER, FLOAT, DOUBLE, BIGDECIMAL, BIGINTEGER, BYTE, SHORT, LONG, CHAR, OBJECT, CLOB, BLOB, XML};
    }

    static {
        NAME_TO_TYPE_MAP.put(STRING, new Integer(12));
        NAME_TO_TYPE_MAP.put(BOOLEAN, new Integer(-7));
        NAME_TO_TYPE_MAP.put(TIME, new Integer(92));
        NAME_TO_TYPE_MAP.put(DATE, new Integer(91));
        NAME_TO_TYPE_MAP.put(TIMESTAMP, new Integer(93));
        NAME_TO_TYPE_MAP.put(INTEGER, new Integer(4));
        NAME_TO_TYPE_MAP.put(FLOAT, new Integer(7));
        NAME_TO_TYPE_MAP.put(DOUBLE, new Integer(8));
        NAME_TO_TYPE_MAP.put(BIGDECIMAL, new Integer(2));
        NAME_TO_TYPE_MAP.put(BIGINTEGER, new Integer(2));
        NAME_TO_TYPE_MAP.put(BYTE, new Integer(-6));
        NAME_TO_TYPE_MAP.put(SHORT, new Integer(5));
        NAME_TO_TYPE_MAP.put(LONG, new Integer(-5));
        NAME_TO_TYPE_MAP.put(CHAR, new Integer(1));
        NAME_TO_TYPE_MAP.put(OBJECT, new Integer(2000));
        NAME_TO_TYPE_MAP.put(CLOB, new Integer(2005));
        NAME_TO_TYPE_MAP.put(BLOB, new Integer(2004));
        NAME_TO_TYPE_MAP.put(XML, new Integer(12));
        NAME_TO_TYPE_MAP.put(NULL, new Integer(0));
        STRING_CLASS = DataTypeManager.DefaultDataClasses.STRING.getName();
        BOOLEAN_CLASS = DataTypeManager.DefaultDataClasses.BOOLEAN.getName();
        TIME_CLASS = DataTypeManager.DefaultDataClasses.TIME.getName();
        DATE_CLASS = DataTypeManager.DefaultDataClasses.DATE.getName();
        TIMESTAMP_CLASS = DataTypeManager.DefaultDataClasses.TIMESTAMP.getName();
        INTEGER_CLASS = DataTypeManager.DefaultDataClasses.INTEGER.getName();
        FLOAT_CLASS = DataTypeManager.DefaultDataClasses.FLOAT.getName();
        DOUBLE_CLASS = DataTypeManager.DefaultDataClasses.DOUBLE.getName();
        BIGDECIMAL_CLASS = DataTypeManager.DefaultDataClasses.BIG_DECIMAL.getName();
        BYTE_CLASS = DataTypeManager.DefaultDataClasses.BYTE.getName();
        SHORT_CLASS = DataTypeManager.DefaultDataClasses.SHORT.getName();
        LONG_CLASS = DataTypeManager.DefaultDataClasses.LONG.getName();
        CHAR_CLASS = DataTypeManager.DefaultDataClasses.CHAR.getName();
        BIGINTEGER_CLASS = DataTypeManager.DefaultDataClasses.BIG_INTEGER.getName();
        OBJECT_CLASS = DataTypeManager.DefaultDataClasses.OBJECT.getName();
        CLASSNAME_TO_TYPE_MAP = new HashMap();
        CLASSNAME_TO_TYPE_MAP.put(STRING_CLASS.toLowerCase(), new Integer(12));
        CLASSNAME_TO_TYPE_MAP.put(BOOLEAN_CLASS.toLowerCase(), new Integer(-7));
        CLASSNAME_TO_TYPE_MAP.put(TIME_CLASS.toLowerCase(), new Integer(92));
        CLASSNAME_TO_TYPE_MAP.put(DATE_CLASS.toLowerCase(), new Integer(91));
        CLASSNAME_TO_TYPE_MAP.put(TIMESTAMP_CLASS.toLowerCase(), new Integer(93));
        CLASSNAME_TO_TYPE_MAP.put(INTEGER_CLASS.toLowerCase(), new Integer(4));
        CLASSNAME_TO_TYPE_MAP.put(FLOAT_CLASS.toLowerCase(), new Integer(7));
        CLASSNAME_TO_TYPE_MAP.put(DOUBLE_CLASS.toLowerCase(), new Integer(8));
        CLASSNAME_TO_TYPE_MAP.put(BIGDECIMAL_CLASS.toLowerCase(), new Integer(2));
        CLASSNAME_TO_TYPE_MAP.put(BIGINTEGER_CLASS.toLowerCase(), new Integer(2));
        CLASSNAME_TO_TYPE_MAP.put(BYTE_CLASS.toLowerCase(), new Integer(-6));
        CLASSNAME_TO_TYPE_MAP.put(SHORT_CLASS.toLowerCase(), new Integer(5));
        CLASSNAME_TO_TYPE_MAP.put(LONG_CLASS.toLowerCase(), new Integer(-5));
        CLASSNAME_TO_TYPE_MAP.put(CHAR_CLASS.toLowerCase(), new Integer(1));
        CLASSNAME_TO_TYPE_MAP.put(OBJECT_CLASS.toLowerCase(), new Integer(2000));
        CLASSNAME_TO_TYPE_MAP.put(CLOB_CLASS.toLowerCase(), new Integer(2005));
        CLASSNAME_TO_TYPE_MAP.put(BLOB_CLASS.toLowerCase(), new Integer(2004));
    }
}

