/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.types.BlobType;
import com.metamatrix.common.types.ClobType;
import com.metamatrix.common.types.NullType;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.XMLType;
import com.metamatrix.common.types.basic.BigDecimalToBigIntegerTransform;
import com.metamatrix.common.types.basic.BigDecimalToBooleanTransform;
import com.metamatrix.common.types.basic.BigDecimalToByteTransform;
import com.metamatrix.common.types.basic.BigDecimalToDoubleTransform;
import com.metamatrix.common.types.basic.BigDecimalToFloatTransform;
import com.metamatrix.common.types.basic.BigDecimalToIntegerTransform;
import com.metamatrix.common.types.basic.BigDecimalToLongTransform;
import com.metamatrix.common.types.basic.BigDecimalToShortTransform;
import com.metamatrix.common.types.basic.BigDecimalToStringTransform;
import com.metamatrix.common.types.basic.BigIntegerToBigDecimalTransform;
import com.metamatrix.common.types.basic.BigIntegerToBooleanTransform;
import com.metamatrix.common.types.basic.BigIntegerToByteTransform;
import com.metamatrix.common.types.basic.BigIntegerToDoubleTransform;
import com.metamatrix.common.types.basic.BigIntegerToFloatTransform;
import com.metamatrix.common.types.basic.BigIntegerToIntegerTransform;
import com.metamatrix.common.types.basic.BigIntegerToLongTransform;
import com.metamatrix.common.types.basic.BigIntegerToShortTransform;
import com.metamatrix.common.types.basic.BigIntegerToStringTransform;
import com.metamatrix.common.types.basic.BooleanToBigDecimalTransform;
import com.metamatrix.common.types.basic.BooleanToBigIntegerTransform;
import com.metamatrix.common.types.basic.BooleanToByteTransform;
import com.metamatrix.common.types.basic.BooleanToDoubleTransform;
import com.metamatrix.common.types.basic.BooleanToFloatTransform;
import com.metamatrix.common.types.basic.BooleanToIntegerTransform;
import com.metamatrix.common.types.basic.BooleanToLongTransform;
import com.metamatrix.common.types.basic.BooleanToShortTransform;
import com.metamatrix.common.types.basic.BooleanToStringTransform;
import com.metamatrix.common.types.basic.ByteToBigDecimalTransform;
import com.metamatrix.common.types.basic.ByteToBigIntegerTransform;
import com.metamatrix.common.types.basic.ByteToBooleanTransform;
import com.metamatrix.common.types.basic.ByteToDoubleTransform;
import com.metamatrix.common.types.basic.ByteToFloatTransform;
import com.metamatrix.common.types.basic.ByteToIntegerTransform;
import com.metamatrix.common.types.basic.ByteToLongTransform;
import com.metamatrix.common.types.basic.ByteToShortTransform;
import com.metamatrix.common.types.basic.ByteToStringTransform;
import com.metamatrix.common.types.basic.CharacterToStringTransform;
import com.metamatrix.common.types.basic.DateToStringTransform;
import com.metamatrix.common.types.basic.DateToTimestampTransform;
import com.metamatrix.common.types.basic.DoubleToBigDecimalTransform;
import com.metamatrix.common.types.basic.DoubleToBigIntegerTransform;
import com.metamatrix.common.types.basic.DoubleToBooleanTransform;
import com.metamatrix.common.types.basic.DoubleToByteTransform;
import com.metamatrix.common.types.basic.DoubleToFloatTransform;
import com.metamatrix.common.types.basic.DoubleToIntegerTransform;
import com.metamatrix.common.types.basic.DoubleToLongTransform;
import com.metamatrix.common.types.basic.DoubleToShortTransform;
import com.metamatrix.common.types.basic.DoubleToStringTransform;
import com.metamatrix.common.types.basic.FloatToBigDecimalTransform;
import com.metamatrix.common.types.basic.FloatToBigIntegerTransform;
import com.metamatrix.common.types.basic.FloatToBooleanTransform;
import com.metamatrix.common.types.basic.FloatToByteTransform;
import com.metamatrix.common.types.basic.FloatToDoubleTransform;
import com.metamatrix.common.types.basic.FloatToIntegerTransform;
import com.metamatrix.common.types.basic.FloatToLongTransform;
import com.metamatrix.common.types.basic.FloatToShortTransform;
import com.metamatrix.common.types.basic.FloatToStringTransform;
import com.metamatrix.common.types.basic.IntegerToBigDecimalTransform;
import com.metamatrix.common.types.basic.IntegerToBigIntegerTransform;
import com.metamatrix.common.types.basic.IntegerToBooleanTransform;
import com.metamatrix.common.types.basic.IntegerToByteTransform;
import com.metamatrix.common.types.basic.IntegerToDoubleTransform;
import com.metamatrix.common.types.basic.IntegerToFloatTransform;
import com.metamatrix.common.types.basic.IntegerToLongTransform;
import com.metamatrix.common.types.basic.IntegerToShortTransform;
import com.metamatrix.common.types.basic.IntegerToStringTransform;
import com.metamatrix.common.types.basic.LongToBigDecimalTransform;
import com.metamatrix.common.types.basic.LongToBigIntegerTransform;
import com.metamatrix.common.types.basic.LongToBooleanTransform;
import com.metamatrix.common.types.basic.LongToByteTransform;
import com.metamatrix.common.types.basic.LongToDoubleTransform;
import com.metamatrix.common.types.basic.LongToFloatTransform;
import com.metamatrix.common.types.basic.LongToIntegerTransform;
import com.metamatrix.common.types.basic.LongToShortTransform;
import com.metamatrix.common.types.basic.LongToStringTransform;
import com.metamatrix.common.types.basic.NullToBigDecimalTransform;
import com.metamatrix.common.types.basic.NullToBigIntegerTransform;
import com.metamatrix.common.types.basic.NullToBlobTransform;
import com.metamatrix.common.types.basic.NullToBooleanTransform;
import com.metamatrix.common.types.basic.NullToByteTransform;
import com.metamatrix.common.types.basic.NullToCharacterTransform;
import com.metamatrix.common.types.basic.NullToClobTransform;
import com.metamatrix.common.types.basic.NullToDateTransform;
import com.metamatrix.common.types.basic.NullToDoubleTransform;
import com.metamatrix.common.types.basic.NullToFloatTransform;
import com.metamatrix.common.types.basic.NullToIntegerTransform;
import com.metamatrix.common.types.basic.NullToLongTransform;
import com.metamatrix.common.types.basic.NullToObjectTransform;
import com.metamatrix.common.types.basic.NullToShortTransform;
import com.metamatrix.common.types.basic.NullToStringTransform;
import com.metamatrix.common.types.basic.NullToTimeTransform;
import com.metamatrix.common.types.basic.NullToTimestampTransform;
import com.metamatrix.common.types.basic.ShortToBigDecimalTransform;
import com.metamatrix.common.types.basic.ShortToBigIntegerTransform;
import com.metamatrix.common.types.basic.ShortToBooleanTransform;
import com.metamatrix.common.types.basic.ShortToByteTransform;
import com.metamatrix.common.types.basic.ShortToDoubleTransform;
import com.metamatrix.common.types.basic.ShortToFloatTransform;
import com.metamatrix.common.types.basic.ShortToIntegerTransform;
import com.metamatrix.common.types.basic.ShortToLongTransform;
import com.metamatrix.common.types.basic.ShortToStringTransform;
import com.metamatrix.common.types.basic.StringToBigDecimalTransform;
import com.metamatrix.common.types.basic.StringToBigIntegerTransform;
import com.metamatrix.common.types.basic.StringToBooleanTransform;
import com.metamatrix.common.types.basic.StringToByteTransform;
import com.metamatrix.common.types.basic.StringToCharacterTransform;
import com.metamatrix.common.types.basic.StringToDateTransform;
import com.metamatrix.common.types.basic.StringToDoubleTransform;
import com.metamatrix.common.types.basic.StringToFloatTransform;
import com.metamatrix.common.types.basic.StringToIntegerTransform;
import com.metamatrix.common.types.basic.StringToLongTransform;
import com.metamatrix.common.types.basic.StringToShortTransform;
import com.metamatrix.common.types.basic.StringToTimeTransform;
import com.metamatrix.common.types.basic.StringToTimestampTransform;
import com.metamatrix.common.types.basic.StringToXMLTransform;
import com.metamatrix.common.types.basic.TimeToStringTransform;
import com.metamatrix.common.types.basic.TimeToTimestampTransform;
import com.metamatrix.common.types.basic.TimestampToDateTransform;
import com.metamatrix.common.types.basic.TimestampToStringTransform;
import com.metamatrix.common.types.basic.TimestampToTimeTransform;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataTypeManager {
    private static Map transforms = new HashMap();
    private static Map dataTypeNames = new HashMap();
    private static Map dataTypeClasses = new HashMap();
    private static Map implicitConversions = new HashMap();
    private static Map explicitConversions = new HashMap();

    private static Object getTransformFromMaps(String srcType, String targetType) {
        Transform transform = null;
        Map innerMap = (Map)transforms.get(srcType);
        if (innerMap != null) {
            transform = (Transform)innerMap.get(targetType);
        }
        return transform;
    }

    private DataTypeManager() {
    }

    static void addDataType(String typeName, Class dataType) {
        dataTypeNames.put(typeName, dataType);
        dataTypeClasses.put(dataType, typeName);
    }

    public static Set getAllDataTypes() {
        return dataTypeNames.keySet();
    }

    public static Class getDataTypeClass(String name) {
        if (name == null) {
            return DefaultDataClasses.NULL;
        }
        Class dataTypeClass = (Class)dataTypeNames.get(name);
        if (dataTypeClass == null) {
            dataTypeClass = (Class)dataTypeNames.get(name.toLowerCase());
        }
        return dataTypeClass;
    }

    public static String getDataTypeName(Class typeClass) {
        if (typeClass == null) {
            return "null";
        }
        return (String)dataTypeClasses.get(typeClass);
    }

    public static Class determineDataTypeClass(Object value) {
        if (value == null) {
            return DefaultDataClasses.NULL;
        }
        Class<?> valueClass = value.getClass();
        if (dataTypeClasses.containsKey(valueClass)) {
            return valueClass;
        }
        if (value instanceof Blob) {
            return DefaultDataClasses.BLOB;
        }
        if (value instanceof Clob) {
            return DefaultDataClasses.CLOB;
        }
        return DefaultDataClasses.OBJECT;
    }

    public static Transform getTransform(Class sourceType, Class targetType) {
        if (sourceType == null || targetType == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.029.0002", sourceType, targetType));
        }
        return (Transform)DataTypeManager.getTransformFromMaps(DataTypeManager.getDataTypeName(sourceType), DataTypeManager.getDataTypeName(targetType));
    }

    public static Transform getTransform(String sourceTypeName, String targetTypeName) {
        if (sourceTypeName == null || targetTypeName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.029.0003", sourceTypeName, targetTypeName));
        }
        return (Transform)DataTypeManager.getTransformFromMaps(sourceTypeName, targetTypeName);
    }

    public static Transform getPreferredTransform(Class firstType, Class secondType) {
        if (firstType == null || secondType == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.029.0002", firstType, secondType));
        }
        String firstName = DataTypeManager.getDataTypeName(firstType);
        String secondName = DataTypeManager.getDataTypeName(secondType);
        return DataTypeManager.getPreferredTransformHelper(firstName, secondName);
    }

    public static Transform getPreferredTransform(String firstTypeName, String secondTypeName) {
        if (firstTypeName == null || secondTypeName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.029.0003", firstTypeName, secondTypeName));
        }
        return DataTypeManager.getPreferredTransformHelper(firstTypeName, secondTypeName);
    }

    private static Transform getPreferredTransformHelper(String firstTypeName, String secondTypeName) {
        if (firstTypeName.equals(secondTypeName)) {
            return null;
        }
        Transform t1 = (Transform)DataTypeManager.getTransformFromMaps(firstTypeName, secondTypeName);
        Transform t2 = (Transform)DataTypeManager.getTransformFromMaps(secondTypeName, firstTypeName);
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return null;
        }
        if (firstTypeName.equals(DefaultDataClasses.STRING.getName())) {
            return t1;
        }
        if (secondTypeName.equals(DefaultDataClasses.STRING.getName())) {
            return t2;
        }
        if (!t1.isNarrowing() && t2.isNarrowing()) {
            return t1;
        }
        if (t1.isNarrowing() && !t2.isNarrowing()) {
            return t2;
        }
        if (firstTypeName.equals("time") || firstTypeName.equals("date")) {
            return t2;
        }
        if (secondTypeName.equals("time") || secondTypeName.equals("date")) {
            return t1;
        }
        return t1;
    }

    private static Collection getAllTransforms() {
        throw new UnsupportedOperationException();
    }

    public static boolean isTransformable(Class sourceType, Class targetType) {
        if (sourceType == null || targetType == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.029.0002", sourceType, targetType));
        }
        return DataTypeManager.getTransformFromMaps(DataTypeManager.getDataTypeName(sourceType), DataTypeManager.getDataTypeName(targetType)) != null;
    }

    public static boolean isTransformable(String sourceTypeName, String targetTypeName) {
        if (sourceTypeName == null || targetTypeName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.029.0003", sourceTypeName, targetTypeName));
        }
        return DataTypeManager.getTransformFromMaps(sourceTypeName, targetTypeName) != null;
    }

    public static void addTransform(Transform transform) {
        if (transform == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.029.0004"));
        }
        String sourceName = transform.getSourceTypeName();
        String targetName = transform.getTargetTypeName();
        if (sourceName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.029.0005", transform));
        }
        if (targetName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.029.0006", transform));
        }
        HashMap<String, Transform> innerMap = (HashMap<String, Transform>)transforms.get(sourceName);
        if (innerMap == null) {
            innerMap = new HashMap<String, Transform>();
            transforms.put(sourceName, innerMap);
        }
        innerMap.put(targetName, transform);
    }

    public static void setImplicitConversions(String type, List conversions) {
        implicitConversions.put(type, conversions);
    }

    public static List getImplicitConversions(String type) {
        return (List)implicitConversions.get(type);
    }

    public static boolean isImplicitConversion(String srcType, String tgtType) {
        List conversions = (List)implicitConversions.get(srcType);
        if (conversions != null) {
            return conversions.contains(tgtType);
        }
        return false;
    }

    public static void setExplicitConversions(String type, List conversions) {
        explicitConversions.put(type, conversions);
    }

    public static List getExplicitConversions(String type) {
        return (List)explicitConversions.get(type);
    }

    public static boolean isExplicitConversion(String srcType, String tgtType) {
        List conversions = (List)explicitConversions.get(srcType);
        if (conversions != null) {
            return conversions.contains(tgtType);
        }
        return false;
    }

    public static Comparator getComparator(Class type) {
        return null;
    }

    public static Comparator getComparator(String typeName) {
        return null;
    }

    static void loadDataTypes() {
        DataTypeManager.addDataType("string", DefaultDataClasses.STRING);
        DataTypeManager.addDataType("boolean", DefaultDataClasses.BOOLEAN);
        DataTypeManager.addDataType("byte", DefaultDataClasses.BYTE);
        DataTypeManager.addDataType("short", DefaultDataClasses.SHORT);
        DataTypeManager.addDataType("char", DefaultDataClasses.CHAR);
        DataTypeManager.addDataType("integer", DefaultDataClasses.INTEGER);
        DataTypeManager.addDataType("long", DefaultDataClasses.LONG);
        DataTypeManager.addDataType("biginteger", DefaultDataClasses.BIG_INTEGER);
        DataTypeManager.addDataType("float", DefaultDataClasses.FLOAT);
        DataTypeManager.addDataType("double", DefaultDataClasses.DOUBLE);
        DataTypeManager.addDataType("bigdecimal", DefaultDataClasses.BIG_DECIMAL);
        DataTypeManager.addDataType("date", DefaultDataClasses.DATE);
        DataTypeManager.addDataType("time", DefaultDataClasses.TIME);
        DataTypeManager.addDataType("timestamp", DefaultDataClasses.TIMESTAMP);
        DataTypeManager.addDataType("object", DefaultDataClasses.OBJECT);
        DataTypeManager.addDataType("null", DefaultDataClasses.NULL);
        DataTypeManager.addDataType("blob", DefaultDataClasses.BLOB);
        DataTypeManager.addDataType("clob", DefaultDataClasses.CLOB);
        DataTypeManager.addDataType("xml", DefaultDataClasses.XML);
    }

    static void loadBasicTransforms() {
        DataTypeManager.addTransform(new BigDecimalToBigIntegerTransform());
        DataTypeManager.addTransform(new BigDecimalToBooleanTransform());
        DataTypeManager.addTransform(new BigDecimalToByteTransform());
        DataTypeManager.addTransform(new BigDecimalToDoubleTransform());
        DataTypeManager.addTransform(new BigDecimalToFloatTransform());
        DataTypeManager.addTransform(new BigDecimalToIntegerTransform());
        DataTypeManager.addTransform(new BigDecimalToLongTransform());
        DataTypeManager.addTransform(new BigDecimalToShortTransform());
        DataTypeManager.addTransform(new BigDecimalToStringTransform());
        DataTypeManager.addTransform(new BigIntegerToBigDecimalTransform());
        DataTypeManager.addTransform(new BigIntegerToBooleanTransform());
        DataTypeManager.addTransform(new BigIntegerToByteTransform());
        DataTypeManager.addTransform(new BigIntegerToDoubleTransform());
        DataTypeManager.addTransform(new BigIntegerToFloatTransform());
        DataTypeManager.addTransform(new BigIntegerToIntegerTransform());
        DataTypeManager.addTransform(new BigIntegerToLongTransform());
        DataTypeManager.addTransform(new BigIntegerToShortTransform());
        DataTypeManager.addTransform(new BigIntegerToStringTransform());
        DataTypeManager.addTransform(new BooleanToBigDecimalTransform());
        DataTypeManager.addTransform(new BooleanToBigIntegerTransform());
        DataTypeManager.addTransform(new BooleanToByteTransform());
        DataTypeManager.addTransform(new BooleanToDoubleTransform());
        DataTypeManager.addTransform(new BooleanToFloatTransform());
        DataTypeManager.addTransform(new BooleanToIntegerTransform());
        DataTypeManager.addTransform(new BooleanToLongTransform());
        DataTypeManager.addTransform(new BooleanToShortTransform());
        DataTypeManager.addTransform(new BooleanToStringTransform());
        DataTypeManager.addTransform(new ByteToBigDecimalTransform());
        DataTypeManager.addTransform(new ByteToBigIntegerTransform());
        DataTypeManager.addTransform(new ByteToBooleanTransform());
        DataTypeManager.addTransform(new ByteToDoubleTransform());
        DataTypeManager.addTransform(new ByteToFloatTransform());
        DataTypeManager.addTransform(new ByteToIntegerTransform());
        DataTypeManager.addTransform(new ByteToLongTransform());
        DataTypeManager.addTransform(new ByteToShortTransform());
        DataTypeManager.addTransform(new ByteToStringTransform());
        DataTypeManager.addTransform(new CharacterToStringTransform());
        DataTypeManager.addTransform(new DateToStringTransform());
        DataTypeManager.addTransform(new DateToTimestampTransform());
        DataTypeManager.addTransform(new DoubleToBigDecimalTransform());
        DataTypeManager.addTransform(new DoubleToBigIntegerTransform());
        DataTypeManager.addTransform(new DoubleToBooleanTransform());
        DataTypeManager.addTransform(new DoubleToByteTransform());
        DataTypeManager.addTransform(new DoubleToFloatTransform());
        DataTypeManager.addTransform(new DoubleToIntegerTransform());
        DataTypeManager.addTransform(new DoubleToLongTransform());
        DataTypeManager.addTransform(new DoubleToShortTransform());
        DataTypeManager.addTransform(new DoubleToStringTransform());
        DataTypeManager.addTransform(new FloatToBigDecimalTransform());
        DataTypeManager.addTransform(new FloatToBigIntegerTransform());
        DataTypeManager.addTransform(new FloatToBooleanTransform());
        DataTypeManager.addTransform(new FloatToByteTransform());
        DataTypeManager.addTransform(new FloatToDoubleTransform());
        DataTypeManager.addTransform(new FloatToIntegerTransform());
        DataTypeManager.addTransform(new FloatToLongTransform());
        DataTypeManager.addTransform(new FloatToShortTransform());
        DataTypeManager.addTransform(new FloatToStringTransform());
        DataTypeManager.addTransform(new IntegerToBigDecimalTransform());
        DataTypeManager.addTransform(new IntegerToBigIntegerTransform());
        DataTypeManager.addTransform(new IntegerToBooleanTransform());
        DataTypeManager.addTransform(new IntegerToByteTransform());
        DataTypeManager.addTransform(new IntegerToDoubleTransform());
        DataTypeManager.addTransform(new IntegerToFloatTransform());
        DataTypeManager.addTransform(new IntegerToLongTransform());
        DataTypeManager.addTransform(new IntegerToShortTransform());
        DataTypeManager.addTransform(new IntegerToStringTransform());
        DataTypeManager.addTransform(new LongToBigDecimalTransform());
        DataTypeManager.addTransform(new LongToBigIntegerTransform());
        DataTypeManager.addTransform(new LongToBooleanTransform());
        DataTypeManager.addTransform(new LongToByteTransform());
        DataTypeManager.addTransform(new LongToDoubleTransform());
        DataTypeManager.addTransform(new LongToIntegerTransform());
        DataTypeManager.addTransform(new LongToFloatTransform());
        DataTypeManager.addTransform(new LongToShortTransform());
        DataTypeManager.addTransform(new LongToStringTransform());
        DataTypeManager.addTransform(new NullToBigDecimalTransform());
        DataTypeManager.addTransform(new NullToBigIntegerTransform());
        DataTypeManager.addTransform(new NullToBlobTransform());
        DataTypeManager.addTransform(new NullToBooleanTransform());
        DataTypeManager.addTransform(new NullToByteTransform());
        DataTypeManager.addTransform(new NullToCharacterTransform());
        DataTypeManager.addTransform(new NullToClobTransform());
        DataTypeManager.addTransform(new NullToDateTransform());
        DataTypeManager.addTransform(new NullToDoubleTransform());
        DataTypeManager.addTransform(new NullToFloatTransform());
        DataTypeManager.addTransform(new NullToIntegerTransform());
        DataTypeManager.addTransform(new NullToLongTransform());
        DataTypeManager.addTransform(new NullToObjectTransform());
        DataTypeManager.addTransform(new NullToShortTransform());
        DataTypeManager.addTransform(new NullToStringTransform());
        DataTypeManager.addTransform(new NullToTimestampTransform());
        DataTypeManager.addTransform(new NullToTimeTransform());
        DataTypeManager.addTransform(new ShortToBigDecimalTransform());
        DataTypeManager.addTransform(new ShortToBigIntegerTransform());
        DataTypeManager.addTransform(new ShortToByteTransform());
        DataTypeManager.addTransform(new ShortToBooleanTransform());
        DataTypeManager.addTransform(new ShortToDoubleTransform());
        DataTypeManager.addTransform(new ShortToFloatTransform());
        DataTypeManager.addTransform(new ShortToIntegerTransform());
        DataTypeManager.addTransform(new ShortToLongTransform());
        DataTypeManager.addTransform(new ShortToStringTransform());
        DataTypeManager.addTransform(new StringToBigDecimalTransform());
        DataTypeManager.addTransform(new StringToBigIntegerTransform());
        DataTypeManager.addTransform(new StringToBooleanTransform());
        DataTypeManager.addTransform(new StringToByteTransform());
        DataTypeManager.addTransform(new StringToCharacterTransform());
        DataTypeManager.addTransform(new StringToDateTransform());
        DataTypeManager.addTransform(new StringToDoubleTransform());
        DataTypeManager.addTransform(new StringToFloatTransform());
        DataTypeManager.addTransform(new StringToIntegerTransform());
        DataTypeManager.addTransform(new StringToLongTransform());
        DataTypeManager.addTransform(new StringToShortTransform());
        DataTypeManager.addTransform(new StringToTimestampTransform());
        DataTypeManager.addTransform(new StringToTimeTransform());
        DataTypeManager.addTransform(new TimestampToDateTransform());
        DataTypeManager.addTransform(new TimestampToStringTransform());
        DataTypeManager.addTransform(new TimestampToTimeTransform());
        DataTypeManager.addTransform(new TimeToTimestampTransform());
        DataTypeManager.addTransform(new TimeToStringTransform());
        DataTypeManager.addTransform(new StringToXMLTransform());
    }

    static void loadImplicitConversions() {
        DataTypeManager.setImplicitConversions("string", Arrays.asList(new String[0]));
        DataTypeManager.setImplicitConversions("char", Arrays.asList("string"));
        DataTypeManager.setImplicitConversions("boolean", Arrays.asList("string"));
        DataTypeManager.setImplicitConversions("byte", Arrays.asList("string", "boolean", "short", "integer", "long", "biginteger", "float", "double", "bigdecimal"));
        DataTypeManager.setImplicitConversions("short", Arrays.asList("string", "boolean", "integer", "long", "biginteger", "float", "double", "bigdecimal"));
        DataTypeManager.setImplicitConversions("integer", Arrays.asList("string", "boolean", "long", "biginteger", "float", "double", "bigdecimal"));
        DataTypeManager.setImplicitConversions("long", Arrays.asList("string", "boolean", "biginteger", "float", "double", "bigdecimal"));
        DataTypeManager.setImplicitConversions("biginteger", Arrays.asList("string", "float", "double", "bigdecimal"));
        DataTypeManager.setImplicitConversions("float", Arrays.asList("string", "double", "bigdecimal"));
        DataTypeManager.setImplicitConversions("double", Arrays.asList("string", "bigdecimal"));
        DataTypeManager.setImplicitConversions("bigdecimal", Arrays.asList("string"));
        DataTypeManager.setImplicitConversions("date", Arrays.asList("string", "timestamp"));
        DataTypeManager.setImplicitConversions("time", Arrays.asList("string"));
        DataTypeManager.setImplicitConversions("timestamp", Arrays.asList("string"));
        DataTypeManager.setImplicitConversions("object", Arrays.asList(new String[0]));
        DataTypeManager.setImplicitConversions("null", Arrays.asList("string", "char", "boolean", "byte", "short", "integer", "long", "biginteger", "float", "double", "bigdecimal", "date", "time", "timestamp", "object", "blob", "clob", "xml"));
        DataTypeManager.setImplicitConversions("blob", Arrays.asList(new String[0]));
        DataTypeManager.setImplicitConversions("clob", Arrays.asList(new String[0]));
        DataTypeManager.setImplicitConversions("xml", Arrays.asList(new String[0]));
    }

    static void loadExplicitConversions() {
        DataTypeManager.setExplicitConversions("string", Arrays.asList("char", "boolean", "byte", "short", "integer", "long", "biginteger", "float", "double", "bigdecimal", "date", "time", "timestamp"));
        DataTypeManager.setExplicitConversions("char", Arrays.asList(new String[0]));
        DataTypeManager.setExplicitConversions("boolean", Arrays.asList("byte", "short", "integer", "long", "biginteger", "float", "double", "bigdecimal"));
        DataTypeManager.setExplicitConversions("byte", Arrays.asList(new String[0]));
        DataTypeManager.setExplicitConversions("short", Arrays.asList("byte"));
        DataTypeManager.setExplicitConversions("integer", Arrays.asList("byte", "short"));
        DataTypeManager.setExplicitConversions("long", Arrays.asList("byte", "short", "integer"));
        DataTypeManager.setExplicitConversions("biginteger", Arrays.asList("boolean", "byte", "short", "integer", "long"));
        DataTypeManager.setExplicitConversions("float", Arrays.asList("boolean", "byte", "short", "integer", "long", "biginteger"));
        DataTypeManager.setExplicitConversions("double", Arrays.asList("boolean", "byte", "short", "integer", "long", "biginteger", "float"));
        DataTypeManager.setExplicitConversions("bigdecimal", Arrays.asList("boolean", "byte", "short", "integer", "long", "biginteger", "float", "double"));
        DataTypeManager.setExplicitConversions("date", Arrays.asList(new String[0]));
        DataTypeManager.setExplicitConversions("time", Arrays.asList("timestamp"));
        DataTypeManager.setExplicitConversions("timestamp", Arrays.asList("date", "time"));
        DataTypeManager.setExplicitConversions("object", Arrays.asList(new String[0]));
        DataTypeManager.setExplicitConversions("null", Arrays.asList(new String[0]));
        DataTypeManager.setExplicitConversions("blob", Arrays.asList(new String[0]));
        DataTypeManager.setExplicitConversions("clob", Arrays.asList(new String[0]));
        DataTypeManager.setExplicitConversions("xml", Arrays.asList(new String[0]));
    }

    public static void main(String[] arg) {
        System.out.println("Known data types:\n");
        Collection all = DataTypeManager.getAllDataTypes();
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            String type = (String)iter.next();
            Class c = DataTypeManager.getDataTypeClass(type);
            System.out.println("\t" + type + "\t" + c.getName());
        }
        System.out.println("\nKnown data transforms:\n");
        all = DataTypeManager.getAllTransforms();
        iter = all.iterator();
        while (iter.hasNext()) {
            Transform t = (Transform)iter.next();
            System.out.println("\t" + t.getDisplayName() + "\t\tnarrowing=" + t.isNarrowing());
        }
        System.out.println("# transforms = " + all.size());
        System.out.println("\nSource\t\t\tTarget\t\tisTransformable\tpreferred\n");
        Set types = DataTypeManager.getAllDataTypes();
        Iterator outerIter = types.iterator();
        while (outerIter.hasNext()) {
            Class outerType = DataTypeManager.getDataTypeClass((String)outerIter.next());
            String outerTypeName = DataTypeManager.getDataTypeName(outerType);
            Iterator innerIter = types.iterator();
            while (innerIter.hasNext()) {
                Class innerType = DataTypeManager.getDataTypeClass((String)innerIter.next());
                String innerTypeName = DataTypeManager.getDataTypeName(innerType);
                System.out.println(outerTypeName + "\t" + innerTypeName + "\t\t" + DataTypeManager.isTransformable(outerType, innerType) + "\t\t" + DataTypeManager.getPreferredTransform(outerType, innerType));
                boolean b1 = DataTypeManager.isTransformable(outerType, innerType);
                boolean b2 = DataTypeManager.isTransformable(outerTypeName, innerTypeName);
                Transform t1 = DataTypeManager.getTransform(outerType, innerType);
                Transform t2 = DataTypeManager.getTransform(outerTypeName, innerTypeName);
                if (b1 != b2) {
                    System.out.println("!!!! Mismatch in isTransformable methods: " + outerTypeName + ", " + innerTypeName);
                }
                if (!(t1 == null && t2 != null || t2 == null && t1 != null) && (t1 == null || t1.equals(t2))) continue;
                System.out.println("!!!! Mismatch in transform results: " + outerTypeName + ", " + innerTypeName);
            }
        }
    }

    static {
        DataTypeManager.loadDataTypes();
        DataTypeManager.loadBasicTransforms();
        DataTypeManager.loadImplicitConversions();
        DataTypeManager.loadExplicitConversions();
    }

    public static final class DefaultDataClasses {
        public static final Class STRING = "".getClass();
        public static final Class BOOLEAN = Boolean.TRUE.getClass();
        public static final Class BYTE = new Byte(0).getClass();
        public static final Class SHORT = new Short(0).getClass();
        public static final Class CHAR = new Character('a').getClass();
        public static final Class INTEGER = new Integer(0).getClass();
        public static final Class LONG = new Long(0L).getClass();
        public static final Class BIG_INTEGER = new BigInteger("0").getClass();
        public static final Class FLOAT = new Float(0.0f).getClass();
        public static final Class DOUBLE = new Double(0.0).getClass();
        public static final Class BIG_DECIMAL = new BigDecimal("0").getClass();
        public static final Class DATE = new Date(System.currentTimeMillis()).getClass();
        public static final Class TIME = new Time(System.currentTimeMillis()).getClass();
        public static final Class TIMESTAMP = new Timestamp(System.currentTimeMillis()).getClass();
        public static final Class OBJECT = new Object().getClass();
        public static final Class NULL = new NullType().getClass();
        public static final Class BLOB = new BlobType().getClass();
        public static final Class CLOB = new ClobType().getClass();
        public static final Class XML = new XMLType().getClass();
    }

    public static final class DefaultDataTypes {
        public static final String STRING = "string";
        public static final String BOOLEAN = "boolean";
        public static final String BYTE = "byte";
        public static final String SHORT = "short";
        public static final String CHAR = "char";
        public static final String INTEGER = "integer";
        public static final String LONG = "long";
        public static final String BIG_INTEGER = "biginteger";
        public static final String FLOAT = "float";
        public static final String DOUBLE = "double";
        public static final String BIG_DECIMAL = "bigdecimal";
        public static final String DATE = "date";
        public static final String TIME = "time";
        public static final String TIMESTAMP = "timestamp";
        public static final String OBJECT = "object";
        public static final String NULL = "null";
        public static final String BLOB = "blob";
        public static final String CLOB = "clob";
        public static final String XML = "xml";
    }
}

