/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.impl.local;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.util.PropertiesUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LocalClientConnection
implements ClientConnection {
    protected Map waitingResponses = new HashMap();
    protected Map properties = null;
    boolean shutdown = false;

    public LocalClientConnection() {
        this(new Properties());
    }

    public LocalClientConnection(Properties props) {
        this.properties = PropertiesUtils.clone(props);
    }

    protected void addProperty(String propName, Object propValue) {
        this.properties.put(propName, propValue);
    }

    public Object getConnectionProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void addWaitingKey(String key, MessageListener listener) {
        this.waitingResponses.put(key, listener);
    }

    public void send(Message message, String messageKey) throws CommunicationException {
        MessageListener listener = (MessageListener)this.waitingResponses.remove(messageKey);
        if (listener != null) {
            listener.deliverMessage(message, messageKey);
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }
}

