/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFixedFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDWhiteSpace;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.impl.XSDFixedFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDWhiteSpaceFacetImpl
extends XSDFixedFacetImpl
implements XSDWhiteSpaceFacet {
    protected static final XSDWhiteSpace VALUE_EDEFAULT = XSDWhiteSpace.PRESERVE_LITERAL;
    protected XSDWhiteSpace value = VALUE_EDEFAULT;

    public static XSDWhiteSpaceFacet createWhiteSpaceFacet(Node node) {
        if (XSDConstants.nodeType(node) == 41) {
            XSDWhiteSpaceFacet xsdWhiteSpaceFacet = XSDFactory.eINSTANCE.createXSDWhiteSpaceFacet();
            xsdWhiteSpaceFacet.setElement((Element)node);
            return xsdWhiteSpaceFacet;
        }
        return null;
    }

    protected XSDWhiteSpaceFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDWhiteSpaceFacet();
    }

    public XSDWhiteSpace getValue() {
        return this.value;
    }

    public void setValue(XSDWhiteSpace newValue) {
        XSDWhiteSpace oldValue = this.value;
        XSDWhiteSpace xSDWhiteSpace = this.value = newValue == null ? VALUE_EDEFAULT : newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldValue, (Object)this.value));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove((Object)otherEnd, msgs);
                }
                case 8: {
                    return this.basicSetAnnotation(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getLexicalValue();
            }
            case 6: {
                return this.getFacetName();
            }
            case 7: {
                return this.getEffectiveValue();
            }
            case 8: {
                return this.getAnnotation();
            }
            case 9: {
                return this.getSimpleTypeDefinition();
            }
            case 10: {
                return this.isFixed() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.getValue();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 10: {
                this.setFixed((Boolean)newValue);
                return;
            }
            case 11: {
                this.setValue((XSDWhiteSpace)((Object)newValue));
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 8: {
                this.setAnnotation(null);
                return;
            }
            case 10: {
                this.unsetFixed();
                return;
            }
            case 11: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 6: {
                return FACET_NAME_EDEFAULT == null ? this.getFacetName() != null : !FACET_NAME_EDEFAULT.equals(this.getFacetName());
            }
            case 7: {
                return EFFECTIVE_VALUE_EDEFAULT == null ? this.getEffectiveValue() != null : !EFFECTIVE_VALUE_EDEFAULT.equals(this.getEffectiveValue());
            }
            case 8: {
                return this.annotation != null;
            }
            case 9: {
                return this.getSimpleTypeDefinition() != null;
            }
            case 10: {
                return this.isSetFixed();
            }
            case 11: {
                return this.value != VALUE_EDEFAULT;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append((Object)this.value);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(41);
        this.setElement(newElement);
        return newElement;
    }

    protected void validateRestriction(XSDFixedFacet xsdFixedFacet) {
        if (this.getValue().getValue() < ((XSDWhiteSpaceFacet)xsdFixedFacet).getValue().getValue()) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "whiteSpace-valid-restriction", this.getElement(), "value", new Object[]{this.getLexicalValue(), xsdFixedFacet.getLexicalValue(), xsdFixedFacet.getSimpleTypeDefinition().getURI()});
            xsdDiagnostic.getComponents().add((Object)xsdFixedFacet);
        }
    }

    protected void validateValue() {
        XSDSimpleTypeDefinition whiteSpaceEnumeration = ((XSDAttributeUse)((XSDComplexTypeDefinition)this.getSimpleTypeDefinition().getSchema().getSchemaForSchema().resolveElementDeclaration("whiteSpace").getTypeDefinition()).getAttributeContents().get(0)).getAttributeDeclaration().getTypeDefinition();
        this.checkSimpleTypeConstraint(whiteSpaceEnumeration, this.getLexicalValue(), "http://www.w3.org/TR/xmlschema-2/", "element-whiteSpace", this.getElement(), "value", true);
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.eINSTANCE.getXSDFacet_LexicalValue()) {
            String newValue = this.getLexicalValue();
            XSDWhiteSpace literal = XSDWhiteSpace.get(newValue);
            if (literal == null) {
                if (this.getValue() != XSDWhiteSpace.PRESERVE_LITERAL) {
                    this.setValue(XSDWhiteSpace.PRESERVE_LITERAL);
                }
            } else if (literal != this.getValue()) {
                this.setValue(literal);
            }
        }
    }

    public String getNormalizedLiteral(String literal) {
        switch (this.getValue().getValue()) {
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                boolean holdWhitespace = false;
                int length = literal.length();
                for (int i = 0; i < length; ++i) {
                    char character = literal.charAt(i);
                    if (Character.isWhitespace(character)) {
                        holdWhitespace = true;
                        continue;
                    }
                    if (stringBuffer.length() == 0) {
                        holdWhitespace = false;
                    }
                    if (holdWhitespace) {
                        holdWhitespace = false;
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(character);
                }
                return stringBuffer.toString();
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer(literal);
                int length = literal.length();
                for (int i = 0; i < length; ++i) {
                    char character = literal.charAt(i);
                    if (!Character.isWhitespace(character)) continue;
                    stringBuffer.setCharAt(i, Character.isWhitespace(character) ? (char)' ' : (char)character);
                }
                return stringBuffer.toString();
            }
        }
        return literal;
    }

    public Object getEffectiveValue() {
        return this.getValue();
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDWhiteSpaceFacetImpl clonedWhiteSpaceFacet = (XSDWhiteSpaceFacetImpl)this.getXSDFactory().createXSDWhiteSpaceFacet();
        clonedWhiteSpaceFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedWhiteSpaceFacet.setLexicalValue(this.getLexicalValue());
        }
        if (this.isSetFixed()) {
            clonedWhiteSpaceFacet.setFixed(this.isFixed());
        }
        if (deep && this.getAnnotation() != null) {
            clonedWhiteSpaceFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedWhiteSpaceFacet.setElement(this.getElement());
        }
        clonedWhiteSpaceFacet.isReconciling = shareDOM;
        return clonedWhiteSpaceFacet;
    }
}

