/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.ui.editors;

import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.metamodels.transformation.InputSet;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.notification.util.NotificationUtilities;
import com.metamatrix.modeler.core.transaction.SourcedNotification;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import com.metamatrix.modeler.diagram.ui.actions.DiagramActionService;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditor;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.SqlTransformationStatusChangeEvent;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationSqlHelper;
import com.metamatrix.modeler.internal.ui.actions.TextActionsAdapter;
import com.metamatrix.modeler.internal.ui.editors.ModelEditor;
import com.metamatrix.modeler.internal.ui.editors.MultiPageModelEditor;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.transformation.ui.UiConstants;
import com.metamatrix.modeler.transformation.ui.UiPlugin;
import com.metamatrix.modeler.transformation.ui.actions.ITransformationDiagramActionConstants;
import com.metamatrix.modeler.transformation.ui.actions.ReconcileTransformationAction;
import com.metamatrix.modeler.transformation.ui.editors.QueryEditorStatusEvent;
import com.metamatrix.modeler.transformation.ui.editors.SqlPanelDropTargetListener;
import com.metamatrix.modeler.transformation.ui.util.BuilderTreeProvider;
import com.metamatrix.modeler.transformation.ui.util.TransformationUiResourceHelper;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.modeler.ui.actions.ModelerActionBarIdManager;
import com.metamatrix.modeler.ui.editors.ModelEditorPage;
import com.metamatrix.modeler.ui.editors.ModelObjectEditorPage;
import com.metamatrix.modeler.ui.viewsupport.StatusBarUpdater;
import com.metamatrix.query.internal.ui.builder.criteria.QueryCriteriaStrategy;
import com.metamatrix.query.internal.ui.builder.util.ElementViewerFactory;
import com.metamatrix.query.internal.ui.builder.util.ICriteriaStrategy;
import com.metamatrix.query.internal.ui.sqleditor.actions.ToggleOptimizer;
import com.metamatrix.query.resolver.util.QueryValidator;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.ui.sqleditor.SqlEditorEvent;
import com.metamatrix.query.ui.sqleditor.SqlEditorPanel;
import com.metamatrix.query.ui.sqleditor.SqlEditorPanelWrapper;
import com.metamatrix.ui.internal.util.WidgetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchWindow;

public class TransformationObjectEditorPage
implements ModelObjectEditorPage,
UiConstants,
ITransformationDiagramActionConstants,
IAdaptable,
EventObjectListener,
INotifyChangedListener,
FocusListener,
SelectionListener,
MouseListener {
    private static final String SQL_UPDATE_TXN_DESCRIPTION = TransformationObjectEditorPage.getString("sqlUpdateTxnDescription");
    private static final String BLANK = "";
    private static final String SPACE = " ";
    private static final String COMMA_SPACE = ", ";
    private static final String RIGHT_PARENTH = ")";
    private static final String NAME = TransformationObjectEditorPage.getString("name");
    private static final String TITLE_TEXT = "title.text";
    private static final String TITLE_TOOLTIP = "title.toolTip";
    private static final String SELECT_TAB_TEXT = TransformationObjectEditorPage.getString("selectTab.text");
    private static final String SELECT_TAB_TOOLTIP = TransformationObjectEditorPage.getString("selectTab.toolTip");
    private static final String UPDATE_TAB_TEXT = TransformationObjectEditorPage.getString("updateTab.text");
    private static final String UPDATE_TAB_TOOLTIP = TransformationObjectEditorPage.getString("updateTab.toolTip");
    private static final String UPDATE_CHECKBOX_TEXT = TransformationObjectEditorPage.getString("updateCheckbox.text");
    private static final String UPDATE_CHECKBOX_TOOLTIP = TransformationObjectEditorPage.getString("updateCheckbox.toolTip");
    private static final String SELECT_SQL_MSG = TransformationObjectEditorPage.getString("selectSqlMsg.text");
    private static final String INSERT_SQL_MSG = TransformationObjectEditorPage.getString("insertSqlMsg.text");
    private static final String UPDATE_SQL_MSG = TransformationObjectEditorPage.getString("updateSqlMsg.text");
    private static final String DELETE_SQL_MSG = TransformationObjectEditorPage.getString("deleteSqlMsg.text");
    private static final String IS_VALID_MSG = TransformationObjectEditorPage.getString("isValidMsg.text");
    private static final String INSERT_TAB_TEXT = TransformationObjectEditorPage.getString("insertTab.text");
    private static final String INSERT_TAB_TOOLTIP = TransformationObjectEditorPage.getString("insertTab.toolTip");
    private static final String INSERT_CHECKBOX_TEXT = TransformationObjectEditorPage.getString("insertCheckbox.text");
    private static final String INSERT_CHECKBOX_TOOLTIP = TransformationObjectEditorPage.getString("insertCheckbox.toolTip");
    private static final String DELETE_TAB_TEXT = TransformationObjectEditorPage.getString("deleteTab.text");
    private static final String DELETE_TAB_TOOLTIP = TransformationObjectEditorPage.getString("deleteTab.toolTip");
    private static final String DELETE_CHECKBOX_TEXT = TransformationObjectEditorPage.getString("deleteCheckbox.text");
    private static final String DELETE_CHECKBOX_TOOLTIP = TransformationObjectEditorPage.getString("deleteCheckbox.toolTip");
    private static final String SAVE_PENDING_TITLE = TransformationObjectEditorPage.getString("savePendingChanges.title");
    private static final String SAVE_PENDING_MSG = TransformationObjectEditorPage.getString("savePendingChanges.msg");
    private static final String SQL_CHANGES_PENDING_MSG = TransformationObjectEditorPage.getString("sqlChangesPending.msg");
    private static final String USE_DEFAULT_CHECKBOX_TEXT = TransformationObjectEditorPage.getString("useDefaultCheckbox.text");
    private static final String USE_DEFAULT_CHECKBOX_TOOLTIP = TransformationObjectEditorPage.getString("useDefaultCheckbox.toolTip");
    private static final String UPDATE_SQL_TYPE = TransformationObjectEditorPage.getString("update.sqlType");
    private static final String INSERT_SQL_TYPE = TransformationObjectEditorPage.getString("insert.sqlType");
    private static final String DELETE_SQL_TYPE = TransformationObjectEditorPage.getString("delete.sqlType");
    private static final String LOST_SQL_TITLE = TransformationObjectEditorPage.getString("lostSql.title");
    private static final String LOST_SQL_TEXT = TransformationObjectEditorPage.getString("lostSqlText.text");
    private static final String LOST_SQL_MESSAGE = TransformationObjectEditorPage.getString("lostSqlMessage.text");
    private static final String COULDNT_GENERATE_INSERT_PROC = TransformationObjectEditorPage.getString("couldntGenerateInsertProc");
    private static final String COULDNT_GENERATE_UPDATE_PROC = TransformationObjectEditorPage.getString("couldntGenerateUpdateProc");
    private static final String COULDNT_GENERATE_DELETE_PROC = TransformationObjectEditorPage.getString("couldntGenerateDeleteProc");
    private static final String COULDNT_GENERATE_PROC_REASONS = TransformationObjectEditorPage.getString("couldntGenerateProcReasons");
    private static final String IS_VALID_AND_RECONCILABLE = TransformationObjectEditorPage.getString("isValidAndReconcilableMsg");
    private static final String IS_VALID_NOT_RECONCILABLE = TransformationObjectEditorPage.getString("isValidNotReconcilableMsg");
    private static final String QUERY_SIZE_MISMATCH_MSG = TransformationObjectEditorPage.getString("querySizeMismatchMsg");
    private static final String QUERY_SIZE_MISMATCH_NO_PROJECTED_SYMBOLS_MSG = TransformationObjectEditorPage.getString("querySizeMismatchNoProjectedSymbolsMsg");
    private static final String QUERY_NAME_MISMATCH_MSG = TransformationObjectEditorPage.getString("queryNameMismatchMsg");
    private static final String QUERY_TYPE_MISMATCH_MSG = TransformationObjectEditorPage.getString("queryTypeMismatchMsg");
    private static final String COMMAND_HAS_REFERENCES_MSG = TransformationObjectEditorPage.getString("commandHasReferencesMsg");
    private static final String NUMBER_REFERENCES_MSG = TransformationObjectEditorPage.getString("numberReferencesMsg");
    private static final String TRANSFORMATION_AUTO_ADJUSTED_MSG = TransformationObjectEditorPage.getString("transformationAutoAdjusted");
    private static final String SUPPORTS_UPDATE_TEXT = TransformationObjectEditorPage.getString("supportsUpdatesCheckBox.text");
    private static final String CURSOR_AT_TEXT = TransformationObjectEditorPage.getString("cursorAt.text");
    public static final String TRANSACTIONS = "modelerTransactions";
    public static final String THIS_CLASS = "TransformationObjectEditorPage";
    private SqlEditorPanelWrapper sqlEditorPanelWrapper;
    private QueryValidator validator;
    private Composite parent;
    private CTabFolder tabFolderWithUpdateTabs;
    private Composite objEditorParent;
    private StackLayout objEditorParentLayout;
    private Composite sqlSelectPanelForUpdate;
    private Composite sqlSelectPanelForNoUpdate;
    private Composite sqlOuterUpdatePanel;
    private Composite sqlOuterInsertPanel;
    private Composite sqlOuterDeletePanel;
    private Object currentItem;
    private CTabItem selectTabForUpdate;
    private CTabItem insertTab;
    private CTabItem updateTab;
    private CTabItem deleteTab;
    private SqlEditorPanel currentSqlEditor;
    private SqlEditorPanel sqlSelectEditorForUpdate;
    private SqlEditorPanel sqlSelectEditorForNoUpdate;
    private SqlEditorPanel sqlInsertEditor;
    private SqlEditorPanel sqlUpdateEditor;
    private SqlEditorPanel sqlDeleteEditor;
    private SqlPanelDropTargetListener seSelectUpdateDropListener;
    private SqlPanelDropTargetListener seSelectNoUpdateDropListener;
    private Button chkInsertEnabled;
    private Button chkUpdateEnabled;
    private Button chkDeleteEnabled;
    private Button chkUseDefaultForInsert;
    private Button chkUseDefaultForUpdate;
    private Button chkUseDefaultForDelete;
    private boolean bUseDefaultForInsert;
    private boolean bUseDefaultForUpdate;
    private boolean bUseDefaultForDelete;
    private boolean targetAllowsUpdates = false;
    private SqlTransformationMappingRoot currentMappingRoot;
    private boolean bHasFocus;
    private boolean isDirty = false;
    private ModelObjectEditorPage override;
    private int CHECKBOX_INDENT = SqlEditorPanel.getVerticalRulerWidth();
    private List eventListeners;
    private EventListenerList propListeners = new EventListenerList();
    private ArrayList arylTextActionsAdapters;
    private CheckBoxContribution chkSupportsUpdatesContribution;
    private CLabel cursorPositionLabel;
    private LabelContribution lblCursorPositionContribution;
    private ToggleOptimizer toggleOptimizerAction;
    private SelectionListener checkBoxListener = new /* Unavailable Anonymous Inner Class!! */;
    static /* synthetic */ Class class$org$eclipse$ui$IPropertyListener;
    static /* synthetic */ Class class$org$eclipse$jface$text$IFindReplaceTarget;
    static /* synthetic */ Class class$org$eclipse$swt$custom$StyledText;

    private static String getString(String key) {
        return UiConstants.Util.getString("TransformationObjectEditorPage." + key);
    }

    private static String getString(String key, String parameter) {
        return UiConstants.Util.getString("TransformationObjectEditorPage." + key, (Object)parameter);
    }

    public boolean canClose() {
        return true;
    }

    public void createControl(Composite parent) {
        this.parent = parent;
        this.objEditorParent = new Composite(parent, 0);
        this.objEditorParentLayout = new StackLayout();
        this.objEditorParent.setLayout((Layout)this.objEditorParentLayout);
        GridData gridData0 = new GridData(1808);
        this.objEditorParent.setLayoutData((Object)gridData0);
        this.createCTabFolderWithUpdateTabs(this.objEditorParent);
        this.createSqlControl(this.objEditorParent);
        GridData gridData2 = new GridData(1808);
        this.tabFolderWithUpdateTabs.setLayoutData((Object)gridData2);
        this.objEditorParentLayout.topControl = this.sqlSelectPanelForNoUpdate;
        this.registerListeners();
    }

    private Object getTopControl() {
        return this.objEditorParentLayout.topControl;
    }

    private void createSqlControl(Composite parent) {
        this.createSelectControlForNoUpdate(parent);
        this.setCurrentSqlEditor(this.sqlSelectEditorForNoUpdate);
    }

    private void createCTabFolderWithUpdateTabs(Composite parent) {
        this.tabFolderWithUpdateTabs = new CTabFolder(parent, 1024);
        this.createSelectTabForUpdate(this.tabFolderWithUpdateTabs);
        this.createUpdateTab(this.tabFolderWithUpdateTabs);
        this.createInsertTab(this.tabFolderWithUpdateTabs);
        this.createDeleteTab(this.tabFolderWithUpdateTabs);
        this.tabFolderWithUpdateTabs.setSelection(this.selectTabForUpdate);
        this.tabFolderWithUpdateTabs.setLayoutData((Object)this.createTextViewGridData());
        this.setCurrentSqlEditor(this.sqlSelectEditorForUpdate);
        this.addCheckBoxListeners(this.selectTabForUpdate);
    }

    private void createSelectTabForUpdate(CTabFolder tabFolder) {
        GridLayout glOuterGridLayout = new GridLayout();
        this.sqlSelectPanelForUpdate = new Composite((Composite)tabFolder, 0);
        this.sqlSelectPanelForUpdate.setLayout((Layout)glOuterGridLayout);
        this.sqlSelectPanelForUpdate.setLayoutData((Object)this.createTextViewGridData());
        this.sqlSelectEditorForUpdate = this.createEditorPanel(this.sqlSelectPanelForUpdate, 0);
        this.sqlSelectEditorForUpdate.setEditable(true);
        this.selectTabForUpdate = new CTabItem(tabFolder, 0);
        this.selectTabForUpdate.setControl((Control)this.sqlSelectPanelForUpdate);
        this.selectTabForUpdate.setText(SELECT_TAB_TEXT);
        this.selectTabForUpdate.setToolTipText(SELECT_TAB_TOOLTIP);
        this.seSelectUpdateDropListener = new SqlPanelDropTargetListener(this.sqlSelectEditorForUpdate, this.currentMappingRoot, (Object)this);
        if (this.seSelectUpdateDropListener != null) {
            DropTarget dropTarget = new DropTarget((Control)this.sqlSelectEditorForUpdate.getTextViewer().getTextWidget(), 3);
            dropTarget.setTransfer(this.seSelectUpdateDropListener.getTransfers());
            dropTarget.addDropListener((DropTargetListener)this.seSelectUpdateDropListener);
        }
    }

    private void createSelectControlForNoUpdate(Composite parent) {
        GridLayout glOuterGridLayout = new GridLayout();
        this.sqlSelectPanelForNoUpdate = new Composite(parent, 0);
        this.sqlSelectPanelForNoUpdate.setLayout((Layout)glOuterGridLayout);
        this.sqlSelectPanelForNoUpdate.setLayoutData((Object)this.createTextViewGridData());
        this.sqlSelectEditorForNoUpdate = this.createSelectEditorForNoUpdate(this.sqlSelectPanelForNoUpdate);
        this.sqlSelectEditorForNoUpdate.setEditable(true);
        this.seSelectNoUpdateDropListener = new SqlPanelDropTargetListener(this.sqlSelectEditorForNoUpdate, this.currentMappingRoot, (Object)this);
        if (this.seSelectNoUpdateDropListener != null) {
            DropTarget dropTarget = new DropTarget((Control)this.sqlSelectEditorForNoUpdate.getTextViewer().getTextWidget(), 3);
            dropTarget.setTransfer(this.seSelectNoUpdateDropListener.getTransfers());
            dropTarget.addDropListener((DropTargetListener)this.seSelectNoUpdateDropListener);
        }
    }

    protected SqlEditorPanel createSelectEditorForNoUpdate(Composite parent) {
        return this.createEditorPanel(parent, 0);
    }

    private void createUpdateTab(CTabFolder tabFolder) {
        GridLayout glEditorGridLayout = new GridLayout();
        glEditorGridLayout.numColumns = 1;
        this.sqlOuterUpdatePanel = new Composite((Composite)tabFolder, 0);
        this.sqlOuterUpdatePanel.setLayout((Layout)glEditorGridLayout);
        this.sqlOuterUpdatePanel.setLayoutData((Object)this.createTextViewGridData());
        this.createUpdateControlPanel(this.sqlOuterUpdatePanel);
        this.sqlUpdateEditor = this.createEditorPanel(this.sqlOuterUpdatePanel, 2);
        this.updateTab = new CTabItem(tabFolder, 0);
        this.updateTab.setControl((Control)this.sqlOuterUpdatePanel);
        if (TransformationHelper.isUpdateAllowed((Object)this.currentMappingRoot)) {
            this.updateTab.getControl().setEnabled(true);
            this.sqlUpdateEditor.setEditable(true);
            this.sqlUpdateEditor.getTextViewer().getTextWidget().setEnabled(true);
            new DropTarget((Control)this.sqlUpdateEditor.getTextViewer().getTextWidget(), 0);
        }
        this.updateTab.setText(UPDATE_TAB_TEXT);
        this.updateTab.setToolTipText(UPDATE_TAB_TOOLTIP);
    }

    private void createInsertTab(CTabFolder tabFolder) {
        GridLayout glEditorGridLayout = new GridLayout();
        glEditorGridLayout.numColumns = 1;
        this.sqlOuterInsertPanel = new Composite((Composite)tabFolder, 0);
        this.sqlOuterInsertPanel.setLayout((Layout)glEditorGridLayout);
        this.sqlOuterInsertPanel.setLayoutData((Object)this.createTextViewGridData());
        this.createInsertControlPanel(this.sqlOuterInsertPanel);
        this.sqlInsertEditor = this.createEditorPanel(this.sqlOuterInsertPanel, 1);
        this.insertTab = new CTabItem(tabFolder, 0);
        this.insertTab.setControl((Control)this.sqlOuterInsertPanel);
        if (TransformationHelper.isInsertAllowed((Object)this.currentMappingRoot)) {
            this.insertTab.getControl().setEnabled(true);
            this.sqlInsertEditor.setEditable(true);
            this.sqlInsertEditor.getTextViewer().getTextWidget().setEnabled(true);
            new DropTarget((Control)this.sqlInsertEditor.getTextViewer().getTextWidget(), 0);
        }
        this.insertTab.setText(INSERT_TAB_TEXT);
        this.insertTab.setToolTipText(INSERT_TAB_TOOLTIP);
    }

    private void createDeleteTab(CTabFolder tabFolder) {
        GridLayout glEditorGridLayout = new GridLayout();
        glEditorGridLayout.numColumns = 1;
        this.sqlOuterDeletePanel = new Composite((Composite)tabFolder, 0);
        this.sqlOuterDeletePanel.setLayout((Layout)glEditorGridLayout);
        this.sqlOuterDeletePanel.setLayoutData((Object)this.createTextViewGridData());
        this.createDeleteControlPanel(this.sqlOuterDeletePanel);
        this.sqlDeleteEditor = this.createEditorPanel(this.sqlOuterDeletePanel, 3);
        this.deleteTab = new CTabItem(tabFolder, 0);
        this.deleteTab.setControl((Control)this.sqlOuterDeletePanel);
        if (TransformationHelper.isDeleteAllowed((Object)this.currentMappingRoot)) {
            this.deleteTab.getControl().setEnabled(true);
            this.sqlDeleteEditor.getTextViewer().setEditable(true);
            this.sqlDeleteEditor.setEditable(true);
            this.sqlDeleteEditor.getTextViewer().getTextWidget().setEnabled(true);
            new DropTarget((Control)this.sqlDeleteEditor.getTextViewer().getTextWidget(), 0);
        }
        this.deleteTab.setText(DELETE_TAB_TEXT);
        this.deleteTab.setToolTipText(DELETE_TAB_TOOLTIP);
    }

    private Composite createUpdateControlPanel(Composite cmpParent) {
        Composite cmpControlPanel = new Composite(cmpParent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        cmpControlPanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalIndent = this.CHECKBOX_INDENT;
        cmpControlPanel.setLayoutData((Object)gridData);
        this.chkUpdateEnabled = WidgetFactory.createCheckBox((Composite)cmpControlPanel, (String)UPDATE_CHECKBOX_TEXT, (boolean)true);
        this.chkUpdateEnabled.setToolTipText(UPDATE_CHECKBOX_TOOLTIP);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        gridData.grabExcessVerticalSpace = false;
        this.chkUpdateEnabled.setLayoutData((Object)gridData);
        this.chkUseDefaultForUpdate = WidgetFactory.createCheckBox((Composite)cmpControlPanel, (String)USE_DEFAULT_CHECKBOX_TEXT, (boolean)true);
        this.chkUseDefaultForUpdate.setToolTipText(USE_DEFAULT_CHECKBOX_TOOLTIP);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        this.chkUseDefaultForUpdate.setLayoutData((Object)gridData);
        return cmpControlPanel;
    }

    private Composite createInsertControlPanel(Composite cmpParent) {
        Composite cmpControlPanel = new Composite(cmpParent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        cmpControlPanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalIndent = this.CHECKBOX_INDENT;
        cmpControlPanel.setLayoutData((Object)gridData);
        this.chkInsertEnabled = WidgetFactory.createCheckBox((Composite)cmpControlPanel, (String)INSERT_CHECKBOX_TEXT, (boolean)true);
        this.chkInsertEnabled.setToolTipText(INSERT_CHECKBOX_TOOLTIP);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        gridData.grabExcessVerticalSpace = false;
        this.chkInsertEnabled.setLayoutData((Object)gridData);
        this.chkUseDefaultForInsert = WidgetFactory.createCheckBox((Composite)cmpControlPanel, (String)USE_DEFAULT_CHECKBOX_TEXT, (boolean)true);
        this.chkUseDefaultForInsert.setToolTipText(USE_DEFAULT_CHECKBOX_TOOLTIP);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        this.chkUseDefaultForInsert.setLayoutData((Object)gridData);
        return cmpControlPanel;
    }

    private Composite createDeleteControlPanel(Composite cmpParent) {
        Composite cmpControlPanel = new Composite(cmpParent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        cmpControlPanel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 1;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalIndent = this.CHECKBOX_INDENT;
        cmpControlPanel.setLayoutData((Object)gridData);
        this.chkDeleteEnabled = WidgetFactory.createCheckBox((Composite)cmpControlPanel, (String)DELETE_CHECKBOX_TEXT, (boolean)true);
        this.chkDeleteEnabled.setToolTipText(DELETE_CHECKBOX_TOOLTIP);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        gridData.grabExcessVerticalSpace = false;
        this.chkDeleteEnabled.setLayoutData((Object)gridData);
        this.chkUseDefaultForDelete = WidgetFactory.createCheckBox((Composite)cmpControlPanel, (String)USE_DEFAULT_CHECKBOX_TEXT, (boolean)true);
        this.chkUseDefaultForDelete.setToolTipText(USE_DEFAULT_CHECKBOX_TOOLTIP);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        this.chkUseDefaultForDelete.setLayoutData((Object)gridData);
        return cmpControlPanel;
    }

    protected SqlEditorPanel createEditorPanel(Composite cmpSqlPanel, int queryType) {
        SqlEditorPanel sepNewSqlEditor = new SqlEditorPanel(cmpSqlPanel, this.validator, queryType);
        sepNewSqlEditor.setLayoutData((Object)this.createTextViewGridData());
        sepNewSqlEditor.addEventListener((EventObjectListener)this);
        sepNewSqlEditor.getTextViewer().getTextWidget().addFocusListener((FocusListener)this);
        sepNewSqlEditor.getTextViewer().getTextWidget().addMouseListener((MouseListener)this);
        TextActionsAdapter taa = new TextActionsAdapter(sepNewSqlEditor.getTextViewer().getTextWidget());
        this.getTextActionsAdapterArray().add(taa);
        TextActionsAdapter taaMessageArea = new TextActionsAdapter(sepNewSqlEditor.getMessageArea());
        this.getTextActionsAdapterArray().add(taaMessageArea);
        return sepNewSqlEditor;
    }

    private ArrayList getTextActionsAdapterArray() {
        if (this.arylTextActionsAdapters == null) {
            this.arylTextActionsAdapters = new ArrayList();
        }
        return this.arylTextActionsAdapters;
    }

    private GridData createTextViewGridData() {
        GridData gridData = new GridData(1808);
        return gridData;
    }

    private void registerListeners() {
        ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this);
        SqlMappingRootCache.addEventListener((EventObjectListener)this);
        this.tabFolderWithUpdateTabs.addSelectionListener((SelectionListener)this);
    }

    private void removeCheckBoxListeners(Object item) {
        if (item == this.insertTab) {
            if (!this.chkInsertEnabled.isDisposed()) {
                this.chkInsertEnabled.removeSelectionListener(this.checkBoxListener);
            }
            if (!this.chkUseDefaultForInsert.isDisposed()) {
                this.chkUseDefaultForInsert.removeSelectionListener(this.checkBoxListener);
            }
        } else if (item == this.updateTab) {
            if (!this.chkUpdateEnabled.isDisposed()) {
                this.chkUpdateEnabled.removeSelectionListener(this.checkBoxListener);
            }
            if (!this.chkUseDefaultForUpdate.isDisposed()) {
                this.chkUseDefaultForUpdate.removeSelectionListener(this.checkBoxListener);
            }
        } else if (item == this.deleteTab) {
            if (!this.chkDeleteEnabled.isDisposed()) {
                this.chkDeleteEnabled.removeSelectionListener(this.checkBoxListener);
            }
            if (!this.chkUseDefaultForDelete.isDisposed()) {
                this.chkUseDefaultForDelete.removeSelectionListener(this.checkBoxListener);
            }
        }
    }

    private void addCheckBoxListeners(Object item) {
        if (item == this.insertTab) {
            if (!this.chkInsertEnabled.isDisposed()) {
                this.chkInsertEnabled.addSelectionListener(this.checkBoxListener);
            }
            if (!this.chkUseDefaultForInsert.isDisposed()) {
                this.chkUseDefaultForInsert.addSelectionListener(this.checkBoxListener);
            }
        } else if (item == this.updateTab) {
            if (!this.chkUpdateEnabled.isDisposed()) {
                this.chkUpdateEnabled.addSelectionListener(this.checkBoxListener);
            }
            if (!this.chkUseDefaultForUpdate.isDisposed()) {
                this.chkUseDefaultForUpdate.addSelectionListener(this.checkBoxListener);
            }
        } else if (item == this.deleteTab) {
            if (!this.chkDeleteEnabled.isDisposed()) {
                this.chkDeleteEnabled.addSelectionListener(this.checkBoxListener);
            }
            if (!this.chkUseDefaultForDelete.isDisposed()) {
                this.chkUseDefaultForDelete.addSelectionListener(this.checkBoxListener);
            }
        }
    }

    private SqlEditorPanelWrapper getSqlEditorPanelWrapper() {
        Display display;
        if (this.sqlEditorPanelWrapper == null) {
            this.sqlEditorPanelWrapper = new SqlEditorPanelWrapper(this.parent, null);
            this.sqlEditorPanelWrapper.setCurrentSqlEditorPanel(this.getCurrentSqlEditor());
        }
        if ((display = this.getControl().getDisplay()) != null) {
            display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.sqlEditorPanelWrapper;
    }

    private void setCurrentSqlEditor(SqlEditorPanel sep) {
        this.currentSqlEditor = sep;
        this.getSqlEditorPanelWrapper().setCurrentSqlEditorPanel(this.currentSqlEditor);
    }

    public SqlEditorPanel getCurrentSqlEditor() {
        return this.currentSqlEditor;
    }

    public boolean isCurrentTabSelect() {
        Object selectedItem = this.getSelectedItem();
        return selectedItem == this.sqlSelectPanelForNoUpdate || selectedItem == this.selectTabForUpdate;
    }

    public boolean hasPendingChanges() {
        boolean result = false;
        SqlEditorPanel currentEditor = this.getCurrentSqlEditor();
        if (currentEditor != null && currentEditor.hasPendingChanges()) {
            result = true;
        }
        return result;
    }

    public StyledText getTextWidget() {
        return this.currentSqlEditor.getTextViewer().getTextWidget();
    }

    public Control getControl() {
        return this.objEditorParent;
    }

    public String getTitle() {
        return TransformationObjectEditorPage.getString(TITLE_TEXT, this.getTransformationName());
    }

    public String getTitleToolTip() {
        return TransformationObjectEditorPage.getString(TITLE_TOOLTIP, this.getTransformationName());
    }

    protected String getTransformationName() {
        return NAME;
    }

    public Image getTitleImage() {
        return null;
    }

    public boolean canEdit(Object modelObject, IEditorPart editor) {
        if (this.override != null && this.override.canEdit(modelObject, editor)) {
            return false;
        }
        if (modelObject instanceof InputSet || !(editor instanceof DiagramEditor)) {
            return false;
        }
        if (modelObject != null && TransformationHelper.isSqlTransformationMappingRoot((Object)modelObject)) {
            return true;
        }
        return modelObject != null && (TransformationHelper.isVirtualSqlTable((Object)modelObject) || TransformationHelper.isSqlVirtualProcedure((Object)modelObject)) && TransformationHelper.isValidSqlTransformationTarget((Object)modelObject) && TransformationHelper.getMappingRoot((EObject)((EObject)modelObject)) != null;
    }

    public void edit(Object rootOrVirtualSqlTable) {
        SqlTransformationMappingRoot workingMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)rootOrVirtualSqlTable)) {
            workingMappingRoot = (SqlTransformationMappingRoot)rootOrVirtualSqlTable;
        } else if ((TransformationHelper.isVirtualSqlTable((Object)rootOrVirtualSqlTable) || TransformationHelper.isSqlVirtualProcedure((Object)rootOrVirtualSqlTable)) && TransformationHelper.isValidSqlTransformationTarget((Object)rootOrVirtualSqlTable)) {
            workingMappingRoot = (SqlTransformationMappingRoot)TransformationHelper.getMappingRoot((EObject)((EObject)rootOrVirtualSqlTable));
        }
        if (workingMappingRoot != null) {
            ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this);
            SqlMappingRootCache.addEventListener((EventObjectListener)this);
            this.currentMappingRoot = workingMappingRoot;
            this.validator = new TransformationValidator(this.currentMappingRoot, false);
            new BuilderTreeProvider();
            ElementViewerFactory.setCriteriaStrategy((ICriteriaStrategy)new QueryCriteriaStrategy());
            this.setUseDefaultStates(this.currentMappingRoot);
            this.refreshTabs();
            this.setEditorContent(this.currentItem, true, this, true, false);
            this.objEditorParent.layout();
            this.setEditorFocus(this.currentSqlEditor);
        } else {
            this.currentMappingRoot = null;
            this.validator = null;
            this.clearSqlEditors();
        }
    }

    private void refreshTabs() {
        if (!this.isEditorValid()) {
            return;
        }
        this.targetAllowsUpdates = this.getTargetAllowsUpdates();
        if (this.targetAllowsUpdates) {
            Object selectedItem = this.getSelectedItem();
            this.objEditorParentLayout.topControl = this.tabFolderWithUpdateTabs;
            if (selectedItem == this.selectTabForUpdate) {
                this.setCurrentSqlEditor(this.sqlSelectEditorForUpdate);
                this.tabFolderWithUpdateTabs.setSelection(this.selectTabForUpdate);
            } else if (selectedItem == this.insertTab) {
                this.setCurrentSqlEditor(this.sqlInsertEditor);
                this.tabFolderWithUpdateTabs.setSelection(this.insertTab);
            } else if (selectedItem == this.updateTab) {
                this.setCurrentSqlEditor(this.sqlUpdateEditor);
                this.tabFolderWithUpdateTabs.setSelection(this.updateTab);
            } else if (selectedItem == this.deleteTab) {
                this.setCurrentSqlEditor(this.sqlDeleteEditor);
                this.tabFolderWithUpdateTabs.setSelection(this.deleteTab);
            } else {
                this.setCurrentSqlEditor(this.sqlSelectEditorForUpdate);
                this.tabFolderWithUpdateTabs.setSelection(this.selectTabForUpdate);
            }
            if (this.seSelectUpdateDropListener != null) {
                this.seSelectUpdateDropListener.setTransformation(this.currentMappingRoot);
            }
        } else {
            this.objEditorParentLayout.topControl = this.sqlSelectPanelForNoUpdate;
            this.setCurrentSqlEditor(this.sqlSelectEditorForNoUpdate);
            if (this.seSelectNoUpdateDropListener != null) {
                this.seSelectNoUpdateDropListener.setTransformation(this.currentMappingRoot);
            }
        }
        this.currentItem = this.getSelectedItem();
    }

    private void setEditorFocus(final SqlEditorPanel editor) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                boolean gotFocus;
                StyledText st;
                TextViewer tv;
                if (editor != null && (tv = editor.getTextViewer()) != null && (st = tv.getTextWidget()) != null && !st.isDisposed() && (gotFocus = st.setFocus())) {
                    editor.setCaretOffset(0);
                    TransformationObjectEditorPage.this.handleCursorPositionChanged();
                }
            }
        });
    }

    public void refreshEditorContent() {
        this.setEditorContent(this.getSelectedItem(), false, this, true, false);
    }

    public void setEditorContent(Object item, boolean reconcileTarget, Object txnSource, boolean overwriteDirty, boolean sourceIsEvent) {
        int cmdType = this.getCommandTypeForItem(item);
        boolean showMessage = false;
        if (this.isResourceValid() && this.getControl() != null && !this.getControl().isDisposed()) {
            Command newCommand;
            String sqlString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)cmdType);
            boolean isValid = TransformationHelper.isValid((Object)this.currentMappingRoot, (int)cmdType);
            String uuidString = TransformationHelper.getUUIDSqlString((Object)this.currentMappingRoot, (int)cmdType);
            if (uuidString == null && isValid) {
                showMessage = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sqlString, (int)cmdType, (boolean)false, (Object)txnSource);
            }
            if (TransformationHelper.isResolvable((Object)this.currentMappingRoot, (int)cmdType) && (newCommand = TransformationHelper.getCommand((Object)this.currentMappingRoot, (int)cmdType)) instanceof SetQuery) {
                this.updateEditorSetQueryStates((SetQuery)newCommand);
            }
            Collection externalGroups = this.getExternalBuilderGroups(this.currentMappingRoot);
            this.currentSqlEditor.setExternalBuilderGroups(externalGroups);
            SqlEditorPanel editor = this.getSqlEditorForItem(item);
            editor.setQueryValidator(this.validator);
            if (overwriteDirty || !editor.hasPendingChanges()) {
                editor.setText(sqlString, (Object)this);
                this.setEditorMessage(item, sqlString);
            }
            this.setCheckBoxStates(this.currentMappingRoot, item);
            this.setEditableStatus(item);
            EObject targetGroup = TransformationHelper.getTransformationTarget((Object)this.currentMappingRoot);
            boolean isSelectCached = SqlMappingRootCache.containsStatus((EObject)this.currentMappingRoot, (int)0);
            boolean allowsUpdates = TransformationHelper.tableSupportsUpdate((EObject)targetGroup);
            if (!ModelObjectUtilities.isReadOnly((EObject)this.currentMappingRoot) && !(txnSource instanceof ReconcileTransformationAction)) {
                SqlEditorPanelWrapper sepw;
                int changeCode;
                if (reconcileTarget && (changeCode = TransformationMappingHelper.reconcileTargetAttributes((EObject)this.currentMappingRoot, (Object)this).getCode()) == 10 && !(sepw = this.getSqlEditorPanelWrapper()).isMessageAreaVisible()) {
                    sepw.setMessage(TRANSFORMATION_AUTO_ADJUSTED_MSG);
                    sepw.showMessageArea(true);
                }
                if (allowsUpdates) {
                    SqlEditorPanelWrapper sepw2;
                    if (!sourceIsEvent || !isSelectCached) {
                        String sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)1);
                        boolean change_1 = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)1, (boolean)false, (Object)txnSource);
                        sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)2);
                        boolean change_2 = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)2, (boolean)false, (Object)txnSource);
                        sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)3);
                        boolean change_3 = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)3, (boolean)false, (Object)txnSource);
                        if (change_1 || change_2 || change_3) {
                            showMessage = true;
                        }
                    } else {
                        if (!SqlMappingRootCache.containsStatus((EObject)this.currentMappingRoot, (int)1)) {
                            String sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)1);
                            showMessage = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)1, (boolean)false, (Object)txnSource);
                        }
                        if (!SqlMappingRootCache.containsStatus((EObject)this.currentMappingRoot, (int)2)) {
                            String sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)2);
                            boolean show = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)2, (boolean)false, (Object)txnSource);
                            if (!showMessage && show) {
                                showMessage = true;
                            }
                        }
                        if (!SqlMappingRootCache.containsStatus((EObject)this.currentMappingRoot, (int)3)) {
                            String sString = TransformationHelper.getSqlString((Object)this.currentMappingRoot, (int)3);
                            boolean show = TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sString, (int)3, (boolean)false, (Object)txnSource);
                            if (!showMessage && show) {
                                showMessage = true;
                            }
                        }
                    }
                    if (showMessage && !(sepw2 = this.getSqlEditorPanelWrapper()).isMessageAreaVisible()) {
                        sepw2.setMessage(TRANSFORMATION_AUTO_ADJUSTED_MSG);
                        sepw2.showMessageArea(true);
                    }
                }
            }
            if (isValid) {
                this.notifyEventListeners((EventObject)new QueryEditorStatusEvent((Object)this, 2));
            } else if (TransformationHelper.isResolvable((Object)this.currentMappingRoot, (int)cmdType)) {
                this.notifyEventListeners((EventObject)new QueryEditorStatusEvent((Object)this, 1));
            } else if (TransformationHelper.isParsable((Object)this.currentMappingRoot, (int)cmdType)) {
                this.notifyEventListeners((EventObject)new QueryEditorStatusEvent((Object)this, 0));
            } else {
                this.notifyEventListeners((EventObject)new QueryEditorStatusEvent((Object)this, 3));
            }
            this.setDirty(editor.hasPendingChanges());
            this.updateReadOnlyState();
        }
    }

    private void setEditableStatus(Object item) {
        boolean isReadOnly = false;
        if (this.currentMappingRoot != null && ModelObjectUtilities.isReadOnly((EObject)this.currentMappingRoot)) {
            isReadOnly = true;
        }
        if (isReadOnly) {
            this.getSqlEditorForItem(item).setEditable(false);
        } else if (item == this.selectTabForUpdate || item == this.sqlSelectPanelForNoUpdate) {
            this.getSqlEditorForItem(item).setEditable(true);
        } else if (item == this.insertTab || item == this.updateTab || item == this.deleteTab) {
            boolean allowed = this.isEnableSelected(item);
            boolean useDefault = this.isUseDefaultSelected(item);
            if (allowed && !useDefault) {
                this.getSqlEditorForItem(item).setEditable(true);
            } else {
                this.getSqlEditorForItem(item).setEditable(false);
            }
        }
    }

    private void setEditorMessage(Object item, String sqlString) {
        int cmdType = this.getCommandTypeForItem(item);
        boolean isTargetValid = TransformationHelper.isTargetValid((Object)this.currentMappingRoot, (int)cmdType);
        boolean isValid = TransformationHelper.isValid((Object)this.currentMappingRoot, (int)cmdType);
        if (this.isInsUpdDelTab(item) && this.isUseDefaultSelected(item) && sqlString == null) {
            this.setMessageDisplayCouldNotGenerate(item, (EObject)this.currentMappingRoot);
            this.currentSqlEditor.showMessageArea(true);
        } else if (isValid && isTargetValid) {
            this.setMessageDisplayForValidSQL();
        } else if (!isTargetValid) {
            IStatus status = TransformationHelper.getTargetValidStatus((Object)this.currentMappingRoot, (int)cmdType);
            if (status != null) {
                String message = status.getMessage();
                this.currentSqlEditor.setMessage(message);
                this.currentSqlEditor.showMessageArea(true);
            }
        } else if (!isValid) {
            this.currentSqlEditor.showMessageArea(true);
        }
    }

    private void setMessageDisplayCouldNotGenerate(Object item, EObject mappingRoot) {
        String couldntGenerateReasonsMsg = COULDNT_GENERATE_PROC_REASONS;
        String errorMsg = null;
        if (this.currentMappingRoot != null) {
            errorMsg = TransformationHelper.getProcedureGenerationErrorMsg((Object)mappingRoot);
        }
        if (errorMsg != null) {
            couldntGenerateReasonsMsg = errorMsg;
        }
        String messg = BLANK;
        if (item == this.insertTab) {
            messg = COULDNT_GENERATE_INSERT_PROC + couldntGenerateReasonsMsg;
        } else if (item == this.updateTab) {
            messg = COULDNT_GENERATE_UPDATE_PROC + couldntGenerateReasonsMsg;
        } else if (item == this.deleteTab) {
            messg = COULDNT_GENERATE_DELETE_PROC + couldntGenerateReasonsMsg;
        }
        this.currentSqlEditor.setMessage(messg);
        this.currentSqlEditor.showMessageArea(true);
    }

    private boolean isInsUpdDelTab(Object item) {
        return item == this.insertTab || item == this.updateTab || item == this.deleteTab;
    }

    private Collection getExternalBuilderGroups(Object transMappingRoot) {
        ArrayList<Object> externalGroups = null;
        if (transMappingRoot != null && TransformationHelper.isSqlTransformationMappingRoot((Object)transMappingRoot)) {
            List inParams;
            EObject targetGroup = TransformationHelper.getTransformationLinkTarget((EObject)((EObject)transMappingRoot));
            if (targetGroup instanceof MappingClass) {
                externalGroups = new ArrayList<Object>(1);
                InputSet inputSet = ((MappingClass)targetGroup).getInputSet();
                externalGroups.add(inputSet);
            } else if (TransformationHelper.isSqlProcedure((Object)targetGroup) && !(inParams = TransformationHelper.getInAndInoutParameters((EObject)targetGroup)).isEmpty()) {
                externalGroups = new ArrayList(1);
                externalGroups.add(targetGroup);
            }
        }
        if (externalGroups == null) {
            externalGroups = Collections.EMPTY_LIST;
        }
        return externalGroups;
    }

    private int getCommandTypeForItem(Object item) {
        int type = 0;
        if (item == this.insertTab) {
            type = 1;
        } else if (item == this.updateTab) {
            type = 2;
        } else if (item == this.deleteTab) {
            type = 3;
        }
        return type;
    }

    private SqlEditorPanel getSqlEditorForItem(Object item) {
        SqlEditorPanel editor = null;
        if (item == this.sqlSelectPanelForNoUpdate) {
            editor = this.sqlSelectEditorForNoUpdate;
        } else if (item == this.selectTabForUpdate) {
            editor = this.sqlSelectEditorForUpdate;
        } else if (item == this.insertTab) {
            editor = this.sqlInsertEditor;
        } else if (item == this.updateTab) {
            editor = this.sqlUpdateEditor;
        } else if (item == this.deleteTab) {
            editor = this.sqlDeleteEditor;
        }
        return editor;
    }

    public String getObjectText() {
        String result = null;
        if (this.currentMappingRoot != null) {
            result = StatusBarUpdater.formatEObjectMessage((EObject)this.currentMappingRoot);
        }
        return result;
    }

    private boolean isEditorValid() {
        return this.getControl() != null && !this.getControl().isDisposed();
    }

    public boolean deactivate() {
        try {
            this.doSave(true);
        }
        catch (Exception err) {
            UiConstants.Util.log((Throwable)err);
        }
        ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this);
        SqlMappingRootCache.removeEventListener((EventObjectListener)this);
        Iterator it = this.getTextActionsAdapterArray().iterator();
        while (it.hasNext()) {
            TextActionsAdapter taa = (TextActionsAdapter)it.next();
            taa.reinit();
        }
        this.edit(null);
        return true;
    }

    private void clearSqlEditors() {
        if (!this.parent.isDisposed()) {
            if (this.sqlSelectEditorForNoUpdate != null) {
                this.sqlSelectEditorForNoUpdate.setText(null, (Object)this);
            }
            if (this.sqlSelectEditorForUpdate != null) {
                this.sqlSelectEditorForUpdate.setText(null, (Object)this);
            }
            if (this.sqlInsertEditor != null) {
                this.sqlInsertEditor.setText(null, (Object)this);
            }
            if (this.sqlUpdateEditor != null) {
                this.sqlUpdateEditor.setText(null, (Object)this);
            }
            if (this.sqlDeleteEditor != null) {
                this.sqlDeleteEditor.setText(null, (Object)this);
            }
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.propListeners.addListener(class$org$eclipse$ui$IPropertyListener == null ? (class$org$eclipse$ui$IPropertyListener = TransformationObjectEditorPage.class$("org.eclipse.ui.IPropertyListener")) : class$org$eclipse$ui$IPropertyListener, (Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.propListeners.removeListener(class$org$eclipse$ui$IPropertyListener == null ? (class$org$eclipse$ui$IPropertyListener = TransformationObjectEditorPage.class$("org.eclipse.ui.IPropertyListener")) : class$org$eclipse$ui$IPropertyListener, (Object)listener);
    }

    private void handleTransformationStatusChangeEvent(boolean reconcileTarget, Object txnSource, boolean overwriteDirty) {
        if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
            String debugStr = "TransformationObjectEditorPage.handleTransformationStatusChangeEvent()";
            System.out.println(debugStr);
        }
        if (txnSource != this) {
            if (this.validator != null) {
                if (this.objEditorParentLayout.topControl == this.tabFolderWithUpdateTabs) {
                    this.sqlSelectEditorForNoUpdate.setQueryValidator(this.validator);
                    this.sqlSelectEditorForNoUpdate.setText(this.sqlSelectEditorForUpdate.getText(), txnSource);
                } else {
                    this.sqlSelectEditorForUpdate.setQueryValidator(this.validator);
                    this.sqlSelectEditorForUpdate.setText(this.sqlSelectEditorForNoUpdate.getText(), txnSource);
                }
                this.refreshTabs();
                this.setEditorContent(this.getSelectedItem(), reconcileTarget, txnSource, overwriteDirty, true);
                this.objEditorParent.layout();
            }
        } else {
            String theSQL = this.getCurrentSqlEditor().getText();
            this.setEditorMessage(this.getSelectedItem(), theSQL);
        }
    }

    public void notifyChanged(Notification notification) {
        if (!this.isEditorValid()) {
            return;
        }
        if (notification instanceof SourcedNotification) {
            Object source = ((SourcedNotification)notification).getSource();
            Collection notifications = ((SourcedNotification)notification).getNotifications();
            this.handleNotifications(notifications, source);
        } else {
            ArrayList<Notification> notifications = new ArrayList<Notification>(1);
            notifications.add(notification);
            this.handleNotifications(notifications, null);
        }
    }

    public void handleNotifications(Collection notifications, Object txnSource) {
        Collection validNotifications = this.getValidNotifications(notifications);
        if (!validNotifications.isEmpty() && !(txnSource instanceof TransformationObjectEditorPage)) {
            this.handleTransformationStatusChangeEvent(true, txnSource, true);
        }
    }

    private Collection getValidNotifications(Collection notifications) {
        ArrayList<Notification> validNotifications = new ArrayList<Notification>(notifications.size());
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            boolean targetSupportsUpdateState;
            Object changedObject;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || (changedObject = ModelerCore.getModelEditor().getChangedObject(notification)) == null || !(changedObject instanceof EObject)) continue;
            if (changedObject instanceof SqlTransformation) {
                validNotifications.add(notification);
                continue;
            }
            if (!this.isCurrentTransformationLinkTarget((EObject)changedObject) || (targetSupportsUpdateState = TransformationHelper.tableSupportsUpdate((EObject)((EObject)changedObject))) == this.targetAllowsUpdates) continue;
            validNotifications.add(notification);
        }
        return validNotifications;
    }

    private boolean isCurrentTransformationLinkTarget(EObject eObj) {
        EObject linkTarget;
        boolean result = false;
        if (this.currentMappingRoot != null && (linkTarget = TransformationHelper.getTransformationLinkTarget((EObject)this.currentMappingRoot)) != null && linkTarget.equals(eObj)) {
            result = true;
        }
        return result;
    }

    private String getSourceDesc(Object source) {
        int index;
        String sourceStr = "NULL";
        if (source != null && (index = (sourceStr = source.getClass().getName()).lastIndexOf(46)) != -1) {
            sourceStr = sourceStr.substring(index + 1);
        }
        return sourceStr;
    }

    private Object getSelectedItem() {
        Object item = this.getTopControl();
        if (item instanceof CTabFolder) {
            CTabFolder folder = (CTabFolder)item;
            CTabItem ti = folder.getSelection();
            if (ti != null) {
                return ti;
            }
            return folder.getItem(0);
        }
        return item;
    }

    private boolean getTargetAllowsUpdates() {
        boolean allowsUpdates = false;
        EObject targetEObj = TransformationHelper.getTransformationTarget((Object)this.currentMappingRoot);
        if (targetEObj != null) {
            allowsUpdates = TransformationHelper.tableSupportsUpdate((EObject)targetEObj);
        }
        return allowsUpdates;
    }

    private void setTargetAllowsUpdates(boolean allowsUpdates) {
        EObject targetEObj = TransformationHelper.getTransformationTarget((Object)this.currentMappingRoot);
        if (targetEObj != null) {
            TransformationHelper.setTableSupportsUpdate((EObject)targetEObj, (boolean)allowsUpdates);
        }
    }

    public void contributeExportedActions(IMenuManager theMenuMgr) {
        ModelEditorPage editorPage;
        String actionKey;
        IEditorPart editorPart;
        IAction action = null;
        IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        DiagramActionService service = (DiagramActionService)DiagramUiPlugin.getDefault().getActionService(window.getActivePage());
        try {
            editorPart = window.getActivePage().getActiveEditor();
            if (editorPart instanceof ModelEditor && service.isRegistered(actionKey = DiagramActionService.constructKey((String)ITransformationDiagramActionConstants.DiagramActions.ADD_TO_SQL_FROM, (ModelEditorPage)(editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage())))) {
                action = service.getAction(actionKey);
            }
        }
        catch (CoreException err) {
            UiConstants.Util.log((Throwable)err);
        }
        if (action != null) {
            if (theMenuMgr.find(ModelerActionBarIdManager.getMenuAdditionsMarkerId()) == null) {
                theMenuMgr.add(action);
            } else {
                theMenuMgr.appendToGroup(ModelerActionBarIdManager.getMenuAdditionsMarkerId(), action);
            }
        }
        try {
            editorPart = window.getActivePage().getActiveEditor();
            if (editorPart instanceof ModelEditor && service.isRegistered(actionKey = DiagramActionService.constructKey((String)ITransformationDiagramActionConstants.DiagramActions.ADD_TO_SQL_SELECT, (ModelEditorPage)(editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage())))) {
                action = service.getAction(actionKey);
            }
        }
        catch (CoreException err) {
            UiConstants.Util.log((Throwable)err);
        }
        if (action != null) {
            if (theMenuMgr.find(ModelerActionBarIdManager.getMenuAdditionsMarkerId()) == null) {
                theMenuMgr.add(action);
            } else {
                theMenuMgr.insertBefore(ModelerActionBarIdManager.getMenuAdditionsMarkerId(), action);
            }
        }
        try {
            editorPart = window.getActivePage().getActiveEditor();
            if (editorPart instanceof ModelEditor && service.isRegistered(actionKey = DiagramActionService.constructKey((String)ITransformationDiagramActionConstants.DiagramActions.ADD_JOIN_EXPRESSION, (ModelEditorPage)(editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage())))) {
                action = service.getAction(actionKey);
            }
        }
        catch (CoreException err) {
            UiConstants.Util.log((Throwable)err);
        }
        if (action != null) {
            if (theMenuMgr.find(ModelerActionBarIdManager.getMenuAdditionsMarkerId()) == null) {
                theMenuMgr.add(action);
            } else {
                theMenuMgr.insertBefore(ModelerActionBarIdManager.getMenuAdditionsMarkerId(), action);
            }
        }
    }

    public void contributeToolbarActions(ToolBarManager toolBarMgr) {
        if (toolBarMgr == null) {
            return;
        }
        toolBarMgr.add((IContributionItem)this.getLabelContributionForCursorPosition());
        toolBarMgr.add((IContributionItem)new Separator());
        if (!(this.currentMappingRoot == null || TransformationHelper.isMappingClass((Object)this.currentMappingRoot.getTarget()) || TransformationHelper.isStagingTable((Object)this.currentMappingRoot.getTarget()) || TransformationHelper.isOperation((Object)this.currentMappingRoot.getTarget()) || TransformationHelper.isSqlProcedure((Object)this.currentMappingRoot.getTarget()))) {
            toolBarMgr.add((IContributionItem)this.getCheckBoxContributionForSupportsUpdates());
            toolBarMgr.add((IContributionItem)new Separator());
        }
        List separatorLocs = this.getSeparatorLocations();
        int iAction = 0;
        IAction reconcileAction = this.contributeReconcileAction();
        if (reconcileAction != null) {
            toolBarMgr.add(reconcileAction);
            ++iAction;
        }
        List sqlActions = this.getSqlEditorPanelWrapper().getActions();
        Iterator iter = sqlActions.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof ToggleOptimizer) {
                this.toggleOptimizerAction = (ToggleOptimizer)obj;
            }
            toolBarMgr.add((IAction)((Action)obj));
            if (!separatorLocs.contains(new Integer(++iAction))) continue;
            toolBarMgr.add((IContributionItem)new Separator());
        }
    }

    protected IAction contributeReconcileAction() {
        IAction reconcileAction = null;
        IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        DiagramActionService service = (DiagramActionService)DiagramUiPlugin.getDefault().getActionService(window.getActivePage());
        try {
            ModelEditorPage editorPage;
            String actionKey;
            IEditorPart editorPart = window.getActivePage().getActiveEditor();
            if (editorPart instanceof ModelEditor && (reconcileAction = service.getAction(actionKey = DiagramActionService.constructKey((String)ITransformationDiagramActionConstants.DiagramActions.RECONCILE_TRANSFORMATION, (ModelEditorPage)(editorPage = (ModelEditorPage)((ModelEditor)editorPart).getCurrentPage())))) instanceof ReconcileTransformationAction) {
                ((ReconcileTransformationAction)reconcileAction).setTransObjectEditorPage(this);
            }
        }
        catch (CoreException err) {
            UiConstants.Util.log((Throwable)err);
        }
        return reconcileAction;
    }

    private CheckBoxContribution getCheckBoxContributionForSupportsUpdates() {
        if (this.chkSupportsUpdatesContribution == null) {
            this.chkSupportsUpdatesContribution = new CheckBoxContribution(SUPPORTS_UPDATE_TEXT);
        }
        return this.chkSupportsUpdatesContribution;
    }

    private void handleSupportsUpdatesCheckBoxChanged() {
        this.doSave(false);
        this.setTargetAllowsUpdates(this.getCheckBoxContributionForSupportsUpdates().getSelection());
        this.getCheckBoxContributionForSupportsUpdates().getControl().update();
    }

    private LabelContribution getLabelContributionForCursorPosition() {
        if (this.lblCursorPositionContribution == null) {
            this.lblCursorPositionContribution = new LabelContribution("Cursor at (1000, 1000)");
        }
        return this.lblCursorPositionContribution;
    }

    private String getCurrentCursorPosition() {
        String sPosition = CURSOR_AT_TEXT;
        int column = 0;
        int row = 0;
        if (this.currentSqlEditor != null) {
            column = 1 + this.currentSqlEditor.getCaretXPosition();
            row = 1 + this.currentSqlEditor.getCaretYPosition();
        }
        sPosition = sPosition + row + COMMA_SPACE + column + RIGHT_PARENTH;
        return sPosition;
    }

    private void handleCursorPositionChanged() {
        this.getLabelContributionForCursorPosition().setText(this.getCurrentCursorPosition());
    }

    private List getSeparatorLocations() {
        ArrayList<Integer> separatorLocs = new ArrayList<Integer>(6);
        separatorLocs.add(new Integer(2));
        separatorLocs.add(new Integer(4));
        separatorLocs.add(new Integer(5));
        separatorLocs.add(new Integer(7));
        separatorLocs.add(new Integer(9));
        return separatorLocs;
    }

    public void doSave(boolean isClosing) {
        if (this.parent.isDisposed()) {
            return;
        }
        boolean saveChanges = true;
        SqlEditorPanel theEditor = this.getCurrentSqlEditor();
        if (theEditor.hasPendingChanges()) {
            if (isClosing) {
                saveChanges = MessageDialog.openQuestion(null, (String)SAVE_PENDING_TITLE, (String)SAVE_PENDING_MSG);
            }
            if (saveChanges) {
                theEditor.setQueryValidator(this.validator);
                theEditor.setText(theEditor.getText());
            } else {
                this.setDirty(false);
            }
        }
    }

    public Object getAdapter(Class key) {
        Object oResult = null;
        if (key.equals(class$org$eclipse$jface$text$IFindReplaceTarget == null ? (class$org$eclipse$jface$text$IFindReplaceTarget = TransformationObjectEditorPage.class$("org.eclipse.jface.text.IFindReplaceTarget")) : class$org$eclipse$jface$text$IFindReplaceTarget) && this.currentSqlEditor != null) {
            oResult = this.currentSqlEditor.getTextViewer().getFindReplaceTarget();
        }
        if ((class$org$eclipse$swt$custom$StyledText == null ? (class$org$eclipse$swt$custom$StyledText = TransformationObjectEditorPage.class$("org.eclipse.swt.custom.StyledText")) : class$org$eclipse$swt$custom$StyledText).equals(key)) {
            ArrayList<StyledText> aryl = new ArrayList<StyledText>(4);
            if (this.sqlSelectEditorForNoUpdate != null) {
                aryl.add(this.sqlSelectEditorForNoUpdate.getTextViewer().getTextWidget());
            }
            if (this.sqlSelectEditorForUpdate != null) {
                aryl.add(this.sqlSelectEditorForUpdate.getTextViewer().getTextWidget());
            }
            if (this.sqlInsertEditor != null) {
                aryl.add(this.sqlInsertEditor.getTextViewer().getTextWidget());
            }
            if (this.sqlUpdateEditor != null) {
                aryl.add(this.sqlUpdateEditor.getTextViewer().getTextWidget());
            }
            if (this.sqlDeleteEditor != null) {
                aryl.add(this.sqlDeleteEditor.getTextViewer().getTextWidget());
            }
            oResult = aryl;
        }
        return oResult;
    }

    public void widgetSelected(SelectionEvent e) {
        Object eventSource = e.getSource();
        if (eventSource == this.getTopControl()) {
            this.handleTabSelectionChanged();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    private void handleTabSelectionChanged() {
        Object previousItem = this.currentItem;
        Object selectedItem = this.getSelectedItem();
        if (selectedItem != previousItem) {
            int cmdType;
            String previousSql;
            if (this.currentSqlEditor.hasPendingChanges() && TransformationHelper.isUserSqlDifferent((String)(previousSql = this.currentSqlEditor.getText()), (Object)this.currentMappingRoot, (int)(cmdType = this.getCommandTypeForItem(previousItem)))) {
                TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)previousSql, (int)cmdType, (boolean)true, (Object)this);
            }
            if (!this.targetAllowsUpdates) {
                selectedItem = this.sqlSelectPanelForNoUpdate;
                this.setCurrentSqlEditor(this.sqlSelectEditorForNoUpdate);
            } else if (selectedItem == this.selectTabForUpdate) {
                this.setCurrentSqlEditor(this.sqlSelectEditorForUpdate);
            } else if (selectedItem == this.insertTab) {
                this.setCurrentSqlEditor(this.sqlInsertEditor);
            } else if (selectedItem == this.updateTab) {
                this.setCurrentSqlEditor(this.sqlUpdateEditor);
            } else if (selectedItem == this.deleteTab) {
                this.setCurrentSqlEditor(this.sqlDeleteEditor);
            }
            this.currentItem = selectedItem;
            this.setEditorContent(this.currentItem, true, this, true, false);
            this.currentSqlEditor.getTextViewer().getTextWidget().setSelection(0);
            this.currentSqlEditor.getTextViewer().getTextWidget().setFocus();
            this.handleCursorPositionChanged();
        }
    }

    private void handleCheckBoxStateChanged(SelectionEvent e) {
        Object eventSource = e.getSource();
        Object selectedItem = this.getSelectedItem();
        boolean allowed = this.isEnableSelected(selectedItem);
        boolean useDefault = this.isUseDefaultSelected(selectedItem);
        if (selectedItem == this.insertTab) {
            this.bUseDefaultForInsert = useDefault;
        } else if (selectedItem == this.updateTab) {
            this.bUseDefaultForUpdate = useDefault;
        } else if (selectedItem == this.deleteTab) {
            this.bUseDefaultForDelete = useDefault;
        }
        this.setCheckBoxEnabledStates(selectedItem);
        if (eventSource == this.chkInsertEnabled || eventSource == this.chkUpdateEnabled || eventSource == this.chkDeleteEnabled) {
            this.handleEnabledCheckBoxChanged(eventSource, allowed);
        } else if (eventSource == this.chkUseDefaultForInsert || eventSource == this.chkUseDefaultForUpdate || eventSource == this.chkUseDefaultForDelete) {
            this.handleUseDefaultCheckBoxChanged(eventSource, useDefault, allowed);
        }
        this.setEditableStatus(selectedItem);
    }

    private void handleEnabledCheckBoxChanged(Object eventSource, boolean isAllowed) {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem == this.insertTab && eventSource == this.chkInsertEnabled) {
            TransformationHelper.setSupportsInsert((Object)this.currentMappingRoot, (boolean)isAllowed, (boolean)false, (Object)this);
        } else if (selectedItem == this.updateTab && eventSource == this.chkUpdateEnabled) {
            TransformationHelper.setSupportsUpdate((Object)this.currentMappingRoot, (boolean)isAllowed, (boolean)false, (Object)this);
        } else if (selectedItem == this.deleteTab && eventSource == this.chkDeleteEnabled) {
            TransformationHelper.setSupportsDelete((Object)this.currentMappingRoot, (boolean)isAllowed, (boolean)false, (Object)this);
        }
    }

    private boolean handleUseDefaultCheckBoxChanged(Object eventSource, boolean useDefault, boolean isAllowed) {
        Object selectedItem = this.getSelectedItem();
        boolean abortUseDefault = false;
        if (selectedItem == this.insertTab && eventSource == this.chkUseDefaultForInsert || selectedItem == this.updateTab && eventSource == this.chkUseDefaultForUpdate || selectedItem == this.deleteTab && eventSource == this.chkUseDefaultForDelete) {
            String typeStr = BLANK;
            int cmdType = 0;
            if (selectedItem == this.insertTab) {
                typeStr = INSERT_SQL_TYPE;
                cmdType = 1;
            } else if (selectedItem == this.updateTab) {
                typeStr = UPDATE_SQL_TYPE;
                cmdType = 2;
            } else if (selectedItem == this.deleteTab) {
                typeStr = DELETE_SQL_TYPE;
                cmdType = 3;
            }
            if (useDefault) {
                boolean shouldReplace = this.shouldReplaceSqlText(typeStr);
                if (shouldReplace) {
                    if (cmdType == 1) {
                        TransformationHelper.setInsertSqlDefault((Object)this.currentMappingRoot, (boolean)true, (boolean)false, (Object)this);
                    } else if (cmdType == 2) {
                        TransformationHelper.setUpdateSqlDefault((Object)this.currentMappingRoot, (boolean)true, (boolean)false, (Object)this);
                    } else if (cmdType == 3) {
                        TransformationHelper.setDeleteSqlDefault((Object)this.currentMappingRoot, (boolean)true, (boolean)false, (Object)this);
                    }
                    String generatedProc = TransformationHelper.getGeneratedProcedureStr((Object)this.currentMappingRoot, (int)cmdType);
                    if (TransformationHelper.isUserSqlDifferent((String)generatedProc, (Object)this.currentMappingRoot, (int)cmdType)) {
                        TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)generatedProc, (int)cmdType, (boolean)false, (Object)this);
                    }
                    this.setEditorContent(selectedItem, true, this, true, false);
                } else {
                    abortUseDefault = true;
                    this.removeCheckBoxListeners(selectedItem);
                    if (selectedItem == this.insertTab) {
                        this.chkUseDefaultForInsert.setSelection(false);
                    } else if (selectedItem == this.updateTab) {
                        this.chkUseDefaultForUpdate.setSelection(false);
                    } else if (selectedItem == this.deleteTab) {
                        this.chkUseDefaultForDelete.setSelection(false);
                    }
                    this.addCheckBoxListeners(selectedItem);
                }
            } else if (!useDefault) {
                if (cmdType == 1) {
                    TransformationHelper.setInsertSqlDefault((Object)this.currentMappingRoot, (boolean)false, (boolean)false, (Object)this);
                } else if (cmdType == 2) {
                    TransformationHelper.setUpdateSqlDefault((Object)this.currentMappingRoot, (boolean)false, (boolean)false, (Object)this);
                } else if (cmdType == 3) {
                    TransformationHelper.setDeleteSqlDefault((Object)this.currentMappingRoot, (boolean)false, (boolean)false, (Object)this);
                }
                String sql = this.currentSqlEditor.getText();
                TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sql, (int)cmdType, (boolean)false, (Object)this);
            }
        }
        return abortUseDefault;
    }

    private void updateEditorSetQueryStates(SetQuery unionQuery) {
        List queries = unionQuery.getQueries();
        int nQueries = queries.size();
        ArrayList<Boolean> reconciledList = new ArrayList<Boolean>(nQueries);
        for (int i = 0; i < nQueries; ++i) {
            QueryCommand qCommand = (QueryCommand)queries.get(i);
            boolean nameMatchReqd = false;
            if (i == 0) {
                nameMatchReqd = true;
            }
            boolean isReconciled = TransformationMappingHelper.targetAndCommandReconcile((EObject)this.currentMappingRoot, (Command)qCommand, (boolean)nameMatchReqd);
            reconciledList.add(new Boolean(isReconciled));
        }
        this.getCurrentSqlEditor().setSetQueryReconciledStates(reconciledList);
    }

    private void setUseDefaultStates(SqlTransformationMappingRoot transMappingRoot) {
        if (transMappingRoot != null) {
            this.bUseDefaultForInsert = TransformationHelper.isInsertSqlDefault((EObject)transMappingRoot);
            this.bUseDefaultForUpdate = TransformationHelper.isUpdateSqlDefault((EObject)transMappingRoot);
            this.bUseDefaultForDelete = TransformationHelper.isDeleteSqlDefault((EObject)transMappingRoot);
        }
    }

    private void setCheckBoxStates(Object transMappingRoot, Object item) {
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)transMappingRoot)) {
            this.removeCheckBoxListeners(item);
            int cmdType = this.getCommandTypeForItem(item);
            boolean isAllowed = TransformationHelper.isAllowed((Object)transMappingRoot, (int)cmdType);
            if (cmdType == 1 && !this.chkInsertEnabled.isDisposed()) {
                this.chkInsertEnabled.setSelection(isAllowed);
            } else if (cmdType == 2 && !this.chkUpdateEnabled.isDisposed()) {
                this.chkUpdateEnabled.setSelection(isAllowed);
            } else if (cmdType == 3 && !this.chkDeleteEnabled.isDisposed()) {
                this.chkDeleteEnabled.setSelection(isAllowed);
            }
            if (cmdType == 1) {
                this.bUseDefaultForInsert = TransformationHelper.isInsertSqlDefault((EObject)((EObject)transMappingRoot));
                if (!this.chkUseDefaultForInsert.isDisposed()) {
                    this.chkUseDefaultForInsert.setSelection(this.bUseDefaultForInsert);
                }
            } else if (cmdType == 2) {
                this.bUseDefaultForUpdate = TransformationHelper.isUpdateSqlDefault((EObject)((EObject)transMappingRoot));
                if (!this.chkUseDefaultForUpdate.isDisposed()) {
                    this.chkUseDefaultForUpdate.setSelection(this.bUseDefaultForUpdate);
                }
            } else if (cmdType == 3) {
                this.bUseDefaultForDelete = TransformationHelper.isDeleteSqlDefault((EObject)((EObject)transMappingRoot));
                if (!this.chkUseDefaultForDelete.isDisposed()) {
                    this.chkUseDefaultForDelete.setSelection(this.bUseDefaultForDelete);
                }
            }
            this.setCheckBoxEnabledStates(item);
            this.addCheckBoxListeners(item);
            this.setSupportsUpdatesCheckBoxState();
        }
    }

    private void setSupportsUpdatesCheckBoxState() {
        this.getCheckBoxContributionForSupportsUpdates().setEnabled(true);
        this.getCheckBoxContributionForSupportsUpdates().setSelection(this.getTargetAllowsUpdates());
    }

    private void setCheckBoxEnabledStates(Object item) {
        boolean enableState = this.isEnableSelected(item);
        if (item == this.insertTab && !this.chkUseDefaultForInsert.isDisposed()) {
            this.chkUseDefaultForInsert.setEnabled(enableState);
        } else if (item == this.updateTab && !this.chkUseDefaultForUpdate.isDisposed()) {
            this.chkUseDefaultForUpdate.setEnabled(enableState);
        } else if (item == this.deleteTab && !this.chkUseDefaultForDelete.isDisposed()) {
            this.chkUseDefaultForDelete.setEnabled(enableState);
        }
    }

    private boolean isEnableSelected(Object item) {
        boolean result = false;
        if (item == this.insertTab) {
            result = this.chkInsertEnabled.getSelection();
        } else if (item == this.updateTab) {
            result = this.chkUpdateEnabled.getSelection();
        } else if (item == this.deleteTab) {
            result = this.chkDeleteEnabled.getSelection();
        }
        return result;
    }

    private boolean isUseDefaultSelected(Object item) {
        boolean result = false;
        if (item == this.insertTab) {
            result = this.chkUseDefaultForInsert.getSelection();
        } else if (item == this.updateTab) {
            result = this.chkUseDefaultForUpdate.getSelection();
        } else if (item == this.deleteTab) {
            result = this.chkUseDefaultForDelete.getSelection();
        }
        return result;
    }

    private boolean shouldReplaceSqlText(String typeStr) {
        MessageBox box = new MessageBox(this.parent.getShell(), 65728);
        box.setMessage(LOST_SQL_TEXT + SPACE + typeStr + ". " + LOST_SQL_MESSAGE);
        box.setText(LOST_SQL_TITLE);
        Boolean bShouldDropSqlText = new Boolean(box.open() == 64);
        return bShouldDropSqlText;
    }

    public void processEvent(EventObject e) {
        if (!this.isEditorValid()) {
            return;
        }
        if (this.isEditorValid()) {
            SqlTransformationStatusChangeEvent stsce;
            EObject eventMappingRoot;
            if (e instanceof SqlEditorEvent && this.currentMappingRoot != null) {
                this.handleSqlEditorEvent((SqlEditorEvent)e);
            } else if (e instanceof SqlTransformationStatusChangeEvent && (eventMappingRoot = (stsce = (SqlTransformationStatusChangeEvent)e).getMappingRoot()) != null && ModelerCore.getModelEditor().equals(eventMappingRoot, (EObject)this.currentMappingRoot)) {
                this.handleTransformationStatusChangeEvent(false, e.getSource(), stsce.isOverwriteDirty());
            }
        }
    }

    private void handleSqlEditorEvent(SqlEditorEvent sqlEvent) {
        Object eventSource = sqlEvent.getSource();
        if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
            String debugStr = "TransformationObjectEditorPage.handleSqlEditorEvent(), source = " + this.getSourceDesc(eventSource);
            System.out.println(debugStr);
        }
        if (eventSource instanceof SqlEditorPanel) {
            int eventType = sqlEvent.getType();
            if (eventType == 5) {
                this.handleCursorPositionChanged();
            } else if (eventType == 0) {
                this.handleSqlEditorChangesPending();
            } else if (eventType == 4 || eventType == 3 || eventType == 2) {
                this.handleSqlEditorCommandEvent(sqlEvent.getCommand(), eventType, eventSource);
            } else if (eventType == 1) {
                this.handleSqlEditorChanged(sqlEvent.getSQLString(), eventSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSqlEditorCommandEvent(Command command, int eventType, Object eventSource) {
        Command newCommand;
        if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
            StringBuffer buff = new StringBuffer("TransformationObjectEditorPage.handleSqlEditorCommandEvent()");
            switch (eventType) {
                case 4: {
                    buff.append(", valid command");
                    break;
                }
                case 3: {
                    buff.append(", resolvable command");
                    break;
                }
                case 2: {
                    buff.append(", parsable command");
                    break;
                }
            }
            System.out.println(buff.toString() + " <set SQL and reconcile mappings>");
        }
        Object selectedItem = this.getSelectedItem();
        int cmdType = this.getCommandTypeForItem(selectedItem);
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)SQL_UPDATE_TXN_DESCRIPTION, (Object)this);
        boolean succeeded = false;
        try {
            TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)command.toString(), (int)cmdType, (boolean)false, (Object)this);
            TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)this.currentMappingRoot, (Object)this);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        if (TransformationHelper.isResolvable((Object)this.currentMappingRoot, (int)cmdType) && (newCommand = TransformationHelper.getCommand((Object)this.currentMappingRoot, (int)cmdType)) instanceof SetQuery) {
            this.updateEditorSetQueryStates((SetQuery)newCommand);
        }
        this.setEditorMessage(selectedItem, command.toString());
        this.setDirty(false);
        if (eventType == 4) {
            this.notifyEventListeners((EventObject)new QueryEditorStatusEvent((Object)this, 2));
        } else if (eventType == 3) {
            this.notifyEventListeners((EventObject)new QueryEditorStatusEvent((Object)this, 1));
        } else if (eventType == 2) {
            this.notifyEventListeners((EventObject)new QueryEditorStatusEvent((Object)this, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSqlEditorChanged(String sqlString, Object eventSource) {
        int cmdType;
        if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
            String debugStr = "TransformationObjectEditorPage.handleSqlEditorChanged() <set SQL>";
            System.out.println(debugStr);
        }
        if (TransformationHelper.isUserSqlDifferent((String)sqlString, (Object)this.currentMappingRoot, (int)(cmdType = this.getCommandTypeForItem(this.getSelectedItem())))) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (String)SQL_UPDATE_TXN_DESCRIPTION, (Object)this);
            boolean succeeded = false;
            try {
                TransformationHelper.setSqlString((Object)this.currentMappingRoot, (String)sqlString, (int)cmdType, (boolean)false, (Object)this);
                TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)this.currentMappingRoot, (Object)this);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        this.getSqlEditorPanelWrapper().showMessageArea(true);
        this.setDirty(false);
        this.notifyEventListeners((EventObject)new QueryEditorStatusEvent((Object)this, 3));
    }

    private void handleSqlEditorChangesPending() {
        if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
            String debugStr = "TransformationObjectEditorPage.handleSqlEditorChangesPending() <change editor message>";
            System.out.println(debugStr);
        }
        this.getSqlEditorPanelWrapper().setMessage(SQL_CHANGES_PENDING_MSG);
        this.getSqlEditorPanelWrapper().showMessageArea(true);
        this.setDirty(true);
        this.notifyEventListeners((EventObject)new QueryEditorStatusEvent((Object)this, 4));
    }

    public void addEventListener(EventObjectListener listener) {
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList();
        }
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    public void removeEventListener(EventObjectListener listener) {
        if (this.eventListeners != null) {
            this.eventListeners.remove(listener);
        }
    }

    private void notifyEventListeners(EventObject event) {
        EObject target = this.currentMappingRoot.getTarget();
        if (this.toggleOptimizerAction != null) {
            if (TransformationHelper.isSqlVirtualProcedure((Object)target)) {
                this.toggleOptimizerAction.setAllowOptimization(false);
            } else {
                this.toggleOptimizerAction.setAllowOptimization(true);
            }
        }
        if (this.eventListeners != null) {
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                EventObjectListener listener = (EventObjectListener)iterator.next();
                if (listener == null) continue;
                listener.processEvent(event);
            }
        }
    }

    private void setMessageDisplayForValidSQL() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem == this.insertTab) {
            this.getSqlEditorPanelWrapper().setMessage(INSERT_SQL_MSG + SPACE + IS_VALID_MSG);
            this.getSqlEditorPanelWrapper().showMessageArea(false);
        } else if (selectedItem == this.updateTab) {
            this.getSqlEditorPanelWrapper().setMessage(UPDATE_SQL_MSG + SPACE + IS_VALID_MSG);
            this.getSqlEditorPanelWrapper().showMessageArea(false);
        } else if (selectedItem == this.deleteTab) {
            this.getSqlEditorPanelWrapper().setMessage(DELETE_SQL_MSG + SPACE + IS_VALID_MSG);
            this.getSqlEditorPanelWrapper().showMessageArea(false);
        } else {
            String sqlTypeMsg = SELECT_SQL_MSG;
            int cmdType = this.getCommandTypeForItem(selectedItem);
            boolean[] statusArray = TransformationMappingHelper.compareQueryTargetAndSQLOutput((EObject)this.currentMappingRoot, (int)cmdType);
            boolean targetAndSQLOutSizesOK = statusArray[0];
            boolean targetAndSQLOutNamesOK = statusArray[1];
            boolean targetAndSQLOutTypesOK = statusArray[2];
            int refCount = TransformationSqlHelper.getReferenceCount((Object)this.currentMappingRoot, (int)cmdType);
            if (targetAndSQLOutSizesOK && targetAndSQLOutNamesOK && targetAndSQLOutTypesOK && refCount == 0) {
                this.getSqlEditorPanelWrapper().setMessage(sqlTypeMsg + SPACE + IS_VALID_AND_RECONCILABLE);
                this.getSqlEditorPanelWrapper().showMessageArea(false);
            } else {
                StringBuffer buff = new StringBuffer(sqlTypeMsg + SPACE + IS_VALID_NOT_RECONCILABLE);
                if (!targetAndSQLOutSizesOK) {
                    if (cmdType == 0) {
                        Command cmd = TransformationHelper.getCommand((Object)this.currentMappingRoot, (int)cmdType);
                        if (cmd.getProjectedSymbols().size() == 0) {
                            buff.append("\n" + QUERY_SIZE_MISMATCH_NO_PROJECTED_SYMBOLS_MSG);
                        } else {
                            buff.append("\n" + QUERY_SIZE_MISMATCH_MSG);
                        }
                    } else {
                        buff.append("\n" + QUERY_SIZE_MISMATCH_MSG);
                    }
                } else if (!targetAndSQLOutNamesOK) {
                    buff.append("\n" + QUERY_NAME_MISMATCH_MSG);
                } else if (!targetAndSQLOutTypesOK) {
                    buff.append("\n" + QUERY_TYPE_MISMATCH_MSG);
                }
                if (refCount > 0) {
                    buff.append("\n" + COMMAND_HAS_REFERENCES_MSG);
                    buff.append("\n" + NUMBER_REFERENCES_MSG + refCount);
                }
                this.getSqlEditorPanelWrapper().setMessage(buff.toString());
                this.getSqlEditorPanelWrapper().showMessageArea(true);
            }
        }
    }

    public boolean hasFocus() {
        return this.bHasFocus;
    }

    public void focusLost(FocusEvent fe) {
        this.bHasFocus = false;
    }

    public void focusGained(FocusEvent fe) {
        this.bHasFocus = true;
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void updateReadOnlyState() {
        if (this.currentMappingRoot != null) {
            boolean isReadOnly = ModelObjectUtilities.isReadOnly((EObject)this.currentMappingRoot);
            if (this.getCurrentSqlEditor() != null) {
                this.getSqlEditorPanelWrapper().updateReadOnlyState(isReadOnly);
                this.setEditableStatus(this.currentItem);
            }
            this.getCheckBoxContributionForSupportsUpdates().setEnabled(!isReadOnly);
            this.updateReadOnlyStateOfCheckBoxes(isReadOnly);
            this.notifyEventListeners((EventObject)new SqlTransformationStatusChangeEvent((EObject)this.currentMappingRoot, (Object)this));
        }
    }

    private void updateReadOnlyStateOfCheckBoxes(boolean isReadOnly) {
        if (this.chkInsertEnabled != null) {
            this.chkInsertEnabled.setEnabled(!isReadOnly);
        }
        if (this.chkUpdateEnabled != null) {
            this.chkUpdateEnabled.setEnabled(!isReadOnly);
        }
        if (this.chkDeleteEnabled != null) {
            this.chkDeleteEnabled.setEnabled(!isReadOnly);
        }
        if (this.chkUseDefaultForInsert != null) {
            this.chkUseDefaultForInsert.setEnabled(!isReadOnly);
        }
        if (this.chkUseDefaultForUpdate != null) {
            this.chkUseDefaultForUpdate.setEnabled(!isReadOnly);
        }
        if (this.chkUseDefaultForDelete != null) {
            this.chkUseDefaultForDelete.setEnabled(!isReadOnly);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        Iterator listeners = this.propListeners.getListeners(class$org$eclipse$ui$IPropertyListener == null ? (class$org$eclipse$ui$IPropertyListener = TransformationObjectEditorPage.class$("org.eclipse.ui.IPropertyListener")) : class$org$eclipse$ui$IPropertyListener);
        while (listeners.hasNext()) {
            ((IPropertyListener)listeners.next()).propertyChanged((Object)this, 257);
        }
    }

    public boolean isEditingObject(Object modelObject) {
        if (this.currentMappingRoot != null && modelObject != null) {
            SqlTransformationMappingRoot workingMappingRoot;
            if (modelObject instanceof InputSet) {
                return false;
            }
            if (TransformationHelper.isSqlTransformationMappingRoot((Object)modelObject) ? modelObject.equals(this.currentMappingRoot) : (TransformationHelper.isVirtualSqlTable((Object)modelObject) || TransformationHelper.isSqlVirtualProcedure((Object)modelObject)) && !TransformationHelper.isXmlDocument((Object)modelObject) && (workingMappingRoot = (SqlTransformationMappingRoot)TransformationHelper.getMappingRoot((EObject)((EObject)modelObject))) != null && workingMappingRoot.equals(this.currentMappingRoot)) {
                return true;
            }
        }
        return false;
    }

    public Object getEditableObject(Object modelObject) {
        SqlTransformationMappingRoot workingMappingRoot = null;
        EObject targetObject = null;
        targetObject = modelObject instanceof Diagram ? ((Diagram)modelObject).getTarget() : (EObject)modelObject;
        if (targetObject != null && targetObject.eResource() != null && TransformationUiResourceHelper.isSqlTransformationResource((Object)targetObject)) {
            if (TransformationHelper.isSqlTransformationMappingRoot((Object)targetObject)) {
                workingMappingRoot = (SqlTransformationMappingRoot)targetObject;
            } else if ((TransformationHelper.isVirtualSqlTable((Object)targetObject) || TransformationHelper.isSqlVirtualProcedure((Object)targetObject)) && TransformationHelper.isValidSqlTransformationTarget((Object)targetObject)) {
                workingMappingRoot = (SqlTransformationMappingRoot)TransformationHelper.getMappingRoot((EObject)targetObject);
            }
            if (workingMappingRoot != null) {
                return workingMappingRoot;
            }
        }
        return null;
    }

    public boolean isResourceValid() {
        ModelResource mr;
        return this.currentMappingRoot != null && this.currentMappingRoot.eResource() != null && (mr = ModelUtilities.getModelResourceForModelObject((EObject)this.currentMappingRoot)) != null;
    }

    protected SqlTransformationMappingRoot getCurrentMappingRoot() {
        return this.currentMappingRoot;
    }

    public void initialize(MultiPageModelEditor editor) {
    }

    public void setOverride(ModelObjectEditorPage editor) {
        this.override = editor;
    }

    static /* synthetic */ void access$000(TransformationObjectEditorPage x0, SelectionEvent x1) {
        x0.handleCheckBoxStateChanged(x1);
    }

    static /* synthetic */ SqlEditorPanelWrapper access$100(TransformationObjectEditorPage x0) {
        return x0.sqlEditorPanelWrapper;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$500(TransformationObjectEditorPage x0) {
        x0.handleSupportsUpdatesCheckBoxChanged();
    }

    static /* synthetic */ CheckBoxContribution access$602(TransformationObjectEditorPage x0, CheckBoxContribution x1) {
        x0.chkSupportsUpdatesContribution = x1;
        return x0.chkSupportsUpdatesContribution;
    }

    class LabelContribution
    extends ControlContribution {
        private static final int LABEL_GRID_STYLE = 32;
        Combo cbx = null;
        String sText;

        public LabelContribution(String sText) {
            super("myId");
            this.sText = sText;
        }

        protected Control createControl(Composite parent) {
            TransformationObjectEditorPage.this.cursorPositionLabel = (CLabel)WidgetFactory.createLabel((Composite)parent, (int)32, (String)this.sText);
            return TransformationObjectEditorPage.this.cursorPositionLabel;
        }

        public void setText(String text) {
            TransformationObjectEditorPage.this.cursorPositionLabel.setText(text);
        }
    }

    class CheckBoxContribution
    extends ControlContribution {
        private Button chkSupportsUpdates;
        private static final int BUTTON_GRID_STYLE = 320;
        Combo cbx = null;

        public CheckBoxContribution(String id) {
            super(id);
        }

        protected Control createControl(Composite parent) {
            this.chkSupportsUpdates = WidgetFactory.createCheckBox((Composite)parent, (String)SUPPORTS_UPDATE_TEXT, (int)320);
            this.chkSupportsUpdates.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ CheckBoxContribution this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent event) {
                    TransformationObjectEditorPage.access$500(CheckBoxContribution.access$400(this.this$1));
                }
            });
            this.chkSupportsUpdates.addDisposeListener(new DisposeListener(this){
                private final /* synthetic */ CheckBoxContribution this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetDisposed(DisposeEvent e) {
                    TransformationObjectEditorPage.access$602(CheckBoxContribution.access$400(this.this$1), null);
                }
            });
            this.chkSupportsUpdates.setEnabled(true);
            this.chkSupportsUpdates.setSelection(TransformationObjectEditorPage.this.getTargetAllowsUpdates());
            return this.chkSupportsUpdates;
        }

        public Control getControl() {
            return this.chkSupportsUpdates;
        }

        public void setSelection(boolean b) {
            if (this.chkSupportsUpdates != null) {
                this.chkSupportsUpdates.setSelection(b);
            }
        }

        public boolean getSelection() {
            if (this.chkSupportsUpdates != null) {
                return this.chkSupportsUpdates.getSelection();
            }
            return true;
        }

        public void setEnabled(boolean enabled) {
            if (this.chkSupportsUpdates != null) {
                this.chkSupportsUpdates.setEnabled(enabled);
            }
        }

        static /* synthetic */ TransformationObjectEditorPage access$400(CheckBoxContribution x0) {
            return x0.TransformationObjectEditorPage.this;
        }
    }
}

