/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.odbc;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.odbc.MetaMatrixODBCIP;
import com.metamatrix.odbc.MetaMatrixODBCIPException;
import com.metamatrix.odbc.MetaMatrixODBCIP_stmt;
import com.metamatrix.odbc.ODBCPlugin;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import oajava.sql.sqlip;
import oajava.sql.sqlip_stmt;
import oajava.sql.xo_col_attribute;
import oajava.sql.xo_int;

public class MetaMatrixODBCIP_stmt
implements sqlip_stmt {
    private Connection connection;
    private Throwable lastError;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;
    private ResultSetMetaData metadata;
    private int fetchSize = 0;
    private int nextFetchSize = -1;
    private int queryTimeout = -1;
    private int maxRows = 0;
    private int currentRowInResultSet = 0;
    private boolean isCurrentBatchRetrieved = false;
    private boolean callNext = true;
    private int numParametersInCurrentCommand = -1;
    private String sql;
    private String databaseURL;
    private String userName;
    private TimeZone timeZone;
    private boolean useODBCFetchSize;
    private Object[] logParams = null;
    private boolean isQuery = false;
    private boolean statementExecuted = false;
    private static final String MAX_ROWS = "mrows";
    private static final String QUERY_TIMEOUT = "qt";
    private static final String FETCH_SIZE = "FETCH_BLOCK_SIZE";
    private static final Short SHORT_TRUE = new Short(1);
    private static final Short SHORT_FALSE = new Short(0);
    private Calendar cal;
    private ColumnMetadata[] metadataCache;
    private int[] dataTypesCache;
    private int columnCount;
    private static final BufferAppender STRING_APPENDER = new StringAppender();
    private static final BufferAppender INT_APPENDER = new IntAppender();
    private static final BufferAppender FLOAT_APPENDER = new FloatAppender();
    private static final BufferAppender DOUBLE_APPENDER = new DoubleAppender();
    private static final BufferAppender TIMESTAMP_APPENDER = new TimestampAppender();
    private static final BufferAppender DATE_APPENDER = new DateAppender();
    private static final BufferAppender TIME_APPENDER = new TimeAppender();
    private static final BufferAppender SHORT_APPENDER = new ShortAppender();
    private static final BufferAppender BLOB_APPENDER = new BlobAppender();
    private static final BufferAppender CLOB_APPENDER = new ClobAppender();
    private static final BufferAppender BYTE_ARRAY_APPENDER = new ByteArrayAppender();
    private static final BufferAppender DEFAULT_APPENDER = new DefaultAppender();
    private BufferAppender[] appenders;

    public MetaMatrixODBCIP_stmt(sqlip mmODBCIP, int callbackObject, int memoryTree) {
        LogManager.logTrace((String)"ODBC_STATEMENT", (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP_stmt.statement_create"));
        MetaMatrixODBCIP MyIPObj = (MetaMatrixODBCIP)mmODBCIP;
        this.connection = MyIPObj.getConnectionObj();
        this.databaseURL = MyIPObj.getDatabaseURL();
        this.userName = MyIPObj.getUserName();
        this.timeZone = MyIPObj.getTimeZone();
        this.useODBCFetchSize = MyIPObj.useODBCFetchSize();
        this.cal = Calendar.getInstance(this.timeZone);
    }

    public int sqlipCloseCursor() {
        try {
            LogManager.logTrace((String)"ODBC_STATEMENT", (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP_stmt.cursor_close"));
            if (this.resultSet != null) {
                this.resultSet.close();
                this.resultSet = null;
            }
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP_stmt.error_resultset_close", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    public int sqlipCloseStmt() {
        try {
            LogManager.logTrace((String)"ODBC_STATEMENT", (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP_stmt.statement_close"));
            this.preparedStatement.close();
            this.clearStmtOptions();
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP_stmt.error_statement_close", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    public int sqlipDeclareCursor(String cursorName) {
        return 0;
    }

    public int sqlipError(StringBuffer state, xo_int nativeErrorCode, StringBuffer errorMessage) {
        try {
            int returnCode = MetaMatrixODBCIP.getError((StringBuffer)state, (xo_int)nativeErrorCode, (StringBuffer)errorMessage, (Throwable)this.lastError, (String)"ODBC_STATEMENT");
            this.lastError = null;
            return returnCode;
        }
        catch (Throwable e) {
            LogManager.logError((String)"ODBC_STATEMENT", (Throwable)e, (String)e.getMessage());
            return -1;
        }
    }

    public int sqlipFetchRow() {
        int returnCode = 0;
        try {
            if (this.resultSet == null) {
                return this.handleException("MetaMatrixODBCIP_stmt.sqlipFetchRow", this.logParams, null);
            }
            if (this.isCurrentBatchRetrieved) {
                returnCode = 2;
                this.isCurrentBatchRetrieved = false;
            } else if (this.isMaximumRowsFetched(this.currentRowInResultSet)) {
                returnCode = 1;
            } else if (!this.resultSet.next()) {
                returnCode = 1;
            } else {
                ++this.currentRowInResultSet;
                if (this.fetchSize > 0 && this.currentRowInResultSet % this.fetchSize == 0) {
                    this.isCurrentBatchRetrieved = true;
                }
            }
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP_stmt.error_sqlipFetchRow", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return returnCode;
    }

    private boolean isMaximumRowsFetched(int rowsFetched) {
        return this.maxRows != 0 && this.maxRows == rowsFetched;
    }

    public int sqlipGetColspec(int columnIndex, xo_int atiDataTypeCode, xo_int isNullable, StringBuffer columnName, xo_int columnLength, xo_int columnPrecision, xo_int columnScale, xo_col_attribute oleColumnAttributes, xo_int oleColumnFlags) {
        ++columnIndex;
        try {
            if (this.statementExecuted && !this.isQuery) {
                Object[] params = new Object[]{new Integer(columnIndex), this.sql};
                return this.handleException("MetaMatrixODBCIP_stmt.sqlipGetColSpec_on_update", params, null);
            }
            ColumnMetadata md = this.metadataCache[columnIndex];
            if (md == null) {
                md = new ColumnMetadata();
                ResultSetMetaData sqlMetadata = this.getQueryMetadata();
                md.atiType = this.getATIColumnType(columnIndex);
                md.nullable = sqlMetadata.isNullable(columnIndex);
                md.nullable = md.nullable == 1 ? 1 : (md.nullable == 0 ? 0 : 2);
                md.colName = sqlMetadata.getColumnName(columnIndex);
                md.length = sqlMetadata.getColumnDisplaySize(columnIndex);
                md.precision = sqlMetadata.getPrecision(columnIndex);
                md.scale = sqlMetadata.getScale(columnIndex);
                this.metadataCache[columnIndex] = md;
            }
            atiDataTypeCode.setVal(md.atiType);
            isNullable.setVal(md.nullable);
            columnName.append(md.colName);
            columnLength.setVal(md.length);
            columnPrecision.setVal(md.precision);
            columnScale.setVal(md.scale);
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColSpec", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sqlipGetColval(int columnIndex, xo_int atiDataTypeCode, xo_int isValueNull, xo_int errorFlag) {
        int returnCode = 0;
        Object columnValue = null;
        try {
            if (this.resultSet == null) {
                returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColVal_null_resultset", this.logParams, null);
                if (isValueNull != null) {
                    isValueNull.setVal(-1);
                }
                Object var7_7 = null;
                return var7_7;
            }
            int iATIDataTypeCode = this.getATIColumnType(++columnIndex);
            atiDataTypeCode.setVal(iATIDataTypeCode);
            switch (iATIDataTypeCode) {
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 2: 
                case 12: {
                    columnValue = MetaMatrixODBCIP_stmt.getString(this.resultSet, columnIndex);
                    break;
                }
                case 4: {
                    columnValue = this.resultSet.getObject(columnIndex);
                    if (columnValue instanceof Integer) break;
                    columnValue = new Integer(this.resultSet.getInt(columnIndex));
                    break;
                }
                case 7: {
                    columnValue = this.resultSet.getObject(columnIndex);
                    break;
                }
                case 6: 
                case 8: {
                    columnValue = this.resultSet.getObject(columnIndex);
                    break;
                }
                case 11: {
                    Timestamp timestamp = this.resultSet.getTimestamp(columnIndex);
                    if (timestamp == null) break;
                    this.cal.setTime(timestamp);
                    int[] timestampArray = new int[10];
                    timestampArray[5] = this.cal.get(1);
                    timestampArray[4] = this.cal.get(2);
                    timestampArray[3] = this.cal.get(5);
                    timestampArray[2] = this.cal.get(11);
                    timestampArray[1] = this.cal.get(12);
                    timestampArray[0] = this.cal.get(13);
                    timestampArray[9] = timestamp.getNanos();
                    columnValue = timestampArray;
                    break;
                }
                case 9: {
                    Date date = this.resultSet.getDate(columnIndex);
                    if (date == null) break;
                    this.cal.setTime(date);
                    int[] dateArray = new int[10];
                    dateArray[5] = this.cal.get(1);
                    dateArray[4] = this.cal.get(2);
                    dateArray[3] = this.cal.get(5);
                    columnValue = dateArray;
                    break;
                }
                case 10: {
                    Time time = this.resultSet.getTime(columnIndex);
                    if (time == null) break;
                    this.cal.setTime(time);
                    int[] timeArray = new int[10];
                    timeArray[2] = this.cal.get(11);
                    timeArray[1] = this.cal.get(12);
                    timeArray[0] = this.cal.get(13);
                    columnValue = timeArray;
                    break;
                }
                case 5: {
                    Object value = this.resultSet.getObject(columnIndex);
                    if (value instanceof Boolean) {
                        Boolean booleanValue = (Boolean)value;
                        if (booleanValue == null) {
                            columnValue = null;
                            break;
                        }
                        if (booleanValue.equals(Boolean.TRUE)) {
                            columnValue = SHORT_TRUE;
                            break;
                        }
                        columnValue = SHORT_FALSE;
                        break;
                    }
                    if (value instanceof Short) {
                        columnValue = value;
                        break;
                    }
                    columnValue = new Short(this.resultSet.getShort(columnIndex));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    columnValue = this.resultSet.getBytes(columnIndex);
                    break;
                }
                default: {
                    Object value = this.resultSet.getObject(columnIndex);
                    Object[] params = new Object[]{new Integer(iATIDataTypeCode), new Integer(columnIndex), value};
                    String message = ODBCPlugin.Util.getString("MetaMatrixODBCIP_stmt.unknown_type", params);
                    LogManager.logWarning((String)"ODBC_STATEMENT", (String)message);
                    columnValue = value == null ? null : value.toString();
                }
            }
            if (isValueNull != null) {
                if (columnValue == null || this.resultSet.wasNull()) {
                    isValueNull.setVal(-1);
                } else {
                    isValueNull.setVal(0);
                }
            }
        }
        catch (SQLException se) {
            returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColVal", this.logParams, se);
        }
        catch (Throwable e) {
            returnCode = this.handleException(e);
        }
        finally {
            if (errorFlag != null) {
                errorFlag.setVal(returnCode);
            }
        }
        return columnValue;
    }

    private static String getString(ResultSet resultSet, int columnIndex) throws SQLException {
        String columnValue = resultSet.getString(columnIndex);
        if (columnValue != null && columnValue.indexOf(0) != -1) {
            MMSQLException exception = MMSQLException.create(null, (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP_stmt.error_string_contains_null", new Object[]{new Integer(columnIndex)}));
            throw exception;
        }
        return columnValue;
    }

    public int sqlipGetInfo(int informationType, StringBuffer informationValue) {
        informationValue.append("0");
        return 0;
    }

    public int sqlipGetNumcols(xo_int columnCount) {
        try {
            if (this.statementExecuted && !this.isQuery) {
                columnCount.setVal(0);
                return 0;
            }
            ResultSetMetaData sqlMetadata = this.getQueryMetadata();
            if (sqlMetadata != null) {
                columnCount.setVal(sqlMetadata.getColumnCount());
            } else {
                columnCount.setVal(0);
            }
            LogManager.logTrace((String)"ODBC_STATEMENT", (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP_stmt.columns", columnCount.getVal()));
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetNumcols", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    public int sqlipGetNumparams(xo_int parameterCount) {
        try {
            parameterCount.setVal(this.getNumberOfParametersInCurrentCommand());
        }
        catch (SQLException e) {
            return this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetNumparams", this.logParams, e);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    public int sqlipInitParam(int parameterIndex, int isNull, String parameterValue, byte[] blobData, int atiDataTypeCode) {
        try {
            LogManager.logTrace((String)"ODBC_STATEMENT", (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP_stmt.set_param", (Object)new Integer(++parameterIndex), (Object)parameterValue));
            if (isNull != -1) {
                if (atiDataTypeCode == -2 || atiDataTypeCode == -3 || atiDataTypeCode == -4) {
                    this.preparedStatement.setBytes(parameterIndex, blobData);
                } else {
                    this.preparedStatement.setObject(parameterIndex, parameterValue);
                }
            } else {
                this.preparedStatement.setObject(parameterIndex, null);
            }
        }
        catch (SQLException se) {
            Object[] params = new Object[]{new Integer(parameterIndex), parameterValue, this.sql, this.databaseURL, this.userName};
            return this.handleException("MetaMatrixODBCIP_stmt.error_sqlipInitParam", params, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    public int sqlipIsCursorOpen(xo_int isOpen) {
        try {
            if (this.resultSet != null) {
                isOpen.setVal(1);
            } else {
                isOpen.setVal(0);
            }
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sqlipOpenCursor(xo_int rowCount) {
        try {
            this.isQuery = this.preparedStatement.execute();
            this.statementExecuted = true;
            if (this.isQuery) {
                this.resultSet = this.preparedStatement.getResultSet();
                if (this.resultSet == null) return this.handleException("MetaMatrixODBCIP_stmt.error_sqlipOpenCursor_null_resultset", this.logParams, null);
                this.fetchSize = this.resultSet.getFetchSize();
                ResultSetMetaData rsmd = this.getQueryMetadata();
                this.columnCount = rsmd.getColumnCount();
                rowCount.setVal(-1);
                return 0;
            } else {
                rowCount.setVal(this.preparedStatement.getUpdateCount());
            }
            return 0;
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP_stmt.error_sqlipOpenCursor", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
    }

    public int sqlipOpenNextCursor(xo_int rowCount) {
        int returnCode = 0;
        try {
            if (this.preparedStatement.getMoreResults()) {
                this.resultSet = this.preparedStatement.getResultSet();
                if (this.resultSet != null) {
                    rowCount.setVal(0);
                } else {
                    returnCode = -1;
                    rowCount.setVal(0);
                }
            } else {
                int iRowCount = this.preparedStatement.getUpdateCount();
                rowCount.setVal(iRowCount);
                if (iRowCount == -1) {
                    returnCode = 1;
                }
            }
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP_stmt.error_sqlipOpenNextCursor", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return returnCode;
    }

    public int sqlipOpenOutputCursor(xo_int rowCount) {
        return 0;
    }

    public int sqlipPrepareStmt(String sqlString) {
        this.logParams = null;
        try {
            this.clearLocalState();
            LogManager.logTrace((String)"ODBC_STATEMENT", (String)("ODBC_SQL=" + sqlString));
            this.logParams = new Object[]{sqlString, this.databaseURL, this.userName};
            LogManager.logTrace((String)"ODBC_STATEMENT", (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP_stmt.prepared_statement_create"));
            this.sql = sqlString;
            this.preparedStatement = this.connection.prepareStatement(sqlString);
            this.preparedStatement.setMaxRows(this.maxRows);
            if (this.useODBCFetchSize && this.nextFetchSize != -1) {
                this.preparedStatement.setFetchSize(this.nextFetchSize);
            }
            if (this.queryTimeout != -1) {
                this.preparedStatement.setQueryTimeout(this.queryTimeout);
            }
        }
        catch (SQLException se) {
            return this.handleException("MetaMatrixODBCIP_stmt.error_sqlipPrepareStmt", this.logParams, se);
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    public int sqlipSetInfo(String arguments) {
        String props = arguments;
        int start = arguments.indexOf(39);
        int end = arguments.indexOf(39, start + 1);
        if (start != -1 && end != -1) {
            props = arguments.substring(start + 1, end);
        }
        StringTokenizer st = new StringTokenizer(props, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf(61);
            if (index == -1) continue;
            String key = token.substring(0, index).trim();
            String value = token.substring(index + 1).trim();
            try {
                int intValue = Integer.parseInt(value);
                if (intValue == 0) continue;
                if (MAX_ROWS.equals(key)) {
                    this.maxRows = intValue;
                    continue;
                }
                if (FETCH_SIZE.equals(key) && this.useODBCFetchSize) {
                    this.nextFetchSize = intValue;
                    continue;
                }
                if (!QUERY_TIMEOUT.equals(key)) continue;
                this.queryTimeout = intValue;
            }
            catch (NumberFormatException e) {
                LogManager.logTrace((String)"ODBC_STATEMENT", (String)ODBCPlugin.Util.getString("MetaMatrixODBCIP_stmt.setInfo", (Object)e));
                return -1;
            }
        }
        return 0;
    }

    public int sqlipGetParamSpec(int parameterIndex, xo_int atiDataTypeCode, xo_int isNullableCode, xo_int length, xo_int precision, xo_int scale, xo_int parameterDirection, xo_int errorFlag) {
        try {
            if (atiDataTypeCode != null) {
                atiDataTypeCode.setVal(12);
            }
            if (isNullableCode != null) {
                isNullableCode.setVal(2);
            }
            if (length != null) {
                length.setVal(255);
            }
            if (precision != null) {
                precision.setVal(255);
            }
            if (scale != null) {
                scale.setVal(0);
            }
        }
        catch (Throwable e) {
            return this.handleException(e);
        }
        return 0;
    }

    private static int mapJdbcTypeToATIType(int jdbcDataTypeCode) {
        switch (jdbcDataTypeCode) {
            case -5: {
                return 1;
            }
            case -2: {
                return -2;
            }
            case -7: 
            case -6: 
            case 5: {
                return 5;
            }
            case -4: 
            case 2004: {
                return -4;
            }
            case 1: {
                return 1;
            }
            case -1: 
            case 2005: {
                return -1;
            }
            case 91: {
                return 9;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 6;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return 7;
            }
            case 92: {
                return 10;
            }
            case 93: {
                return 11;
            }
            case -3: {
                return -3;
            }
        }
        return 12;
    }

    private int getATIColumnType(int columnIndex) throws SQLException {
        if (this.dataTypesCache == null) {
            ResultSetMetaData rsMetadata = this.getQueryMetadata();
            this.dataTypesCache = new int[rsMetadata.getColumnCount() + 1];
            for (int col = 1; col < this.dataTypesCache.length; ++col) {
                this.dataTypesCache[col] = MetaMatrixODBCIP_stmt.mapJdbcTypeToATIType(rsMetadata.getColumnType(col));
                if (this.dataTypesCache[col] != 0) continue;
                Object[] params = new Object[]{new Integer(columnIndex)};
                String message = ODBCPlugin.Util.getString("MetaMatrixODBCIP_stmt.error_getATIColumnType", params);
                LogManager.logError((String)"ODBC_STATEMENT", (String)message);
                throw new SQLException(message);
            }
        }
        return this.dataTypesCache[columnIndex];
    }

    private ResultSetMetaData getQueryMetadata() throws SQLException {
        if (this.metadata == null && this.preparedStatement != null) {
            this.metadata = this.preparedStatement.getMetaData();
            if (this.metadata != null) {
                this.metadataCache = new ColumnMetadata[this.metadata.getColumnCount() + 1];
                this.numParametersInCurrentCommand = ((com.metamatrix.jdbc.api.ResultSetMetaData)this.metadata).getParameterCount();
            } else {
                this.numParametersInCurrentCommand = 0;
            }
        }
        return this.metadata;
    }

    private int getNumberOfParametersInCurrentCommand() throws SQLException {
        if (this.numParametersInCurrentCommand < 0) {
            this.getQueryMetadata();
        }
        return this.numParametersInCurrentCommand;
    }

    private void clearLocalState() {
        this.metadata = null;
        this.metadataCache = null;
        this.dataTypesCache = null;
        this.userName = null;
        this.databaseURL = null;
        this.resultSet = null;
        this.currentRowInResultSet = 0;
        this.numParametersInCurrentCommand = -1;
        this.statementExecuted = false;
        this.fetchSize = 0;
        this.columnCount = -1;
        this.appenders = null;
        this.callNext = true;
        this.isCurrentBatchRetrieved = false;
    }

    private void clearStmtOptions() {
        this.maxRows = 0;
        this.nextFetchSize = -1;
        this.queryTimeout = -1;
    }

    public int sqlipBestRowIdentifier(String arg0, String arg1, String arg2, int arg3, boolean arg4) {
        return -1;
    }

    public int sqlipCatalogs() {
        return -1;
    }

    public int sqlipColumns(String arg0, String arg1, String arg2, String arg3) {
        return -1;
    }

    public int sqlipForeignKeys(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) {
        return -1;
    }

    public int sqlipIndexInfo(String arg0, String arg1, String arg2, boolean arg3, boolean arg4) {
        return -1;
    }

    public int sqlipMapToXoType(int arg0) {
        return arg0;
    }

    public int sqlipPrimaryKeys(String arg0, String arg1, String arg2) {
        return -1;
    }

    public int sqlipProcedureColumns(String arg0, String arg1, String arg2, String arg3) {
        return -1;
    }

    public int sqlipProcedures(String arg0, String arg1, String arg2) {
        return -1;
    }

    public int sqlipSchemas() {
        return -1;
    }

    public int sqlipTables(String arg0, String arg1, String arg2, String arg3) {
        return -1;
    }

    public int sqlipTableTypes() {
        return -1;
    }

    public int sqlipTypeInfo(int arg0) {
        return -1;
    }

    public int sqlipVersionColumns(String arg0, String arg1, String arg2) {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sqlipGetColType(int iColNum, xo_int errorFlag) {
        int returnCode = 0;
        int type = 0;
        try {
            type = this.getATIColumnType(iColNum + 1);
        }
        catch (SQLException e) {
            returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_getATIColumnType", new Object[]{new Integer(iColNum + 1)}, e);
        }
        catch (Throwable e) {
            returnCode = this.handleException(e);
        }
        finally {
            if (errorFlag != null) {
                errorFlag.setVal(returnCode);
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short sqlipGetShortColval(int columnIndex, xo_int isValueNull, xo_int errorFlag) {
        int returnCode = 0;
        short value = 0;
        try {
            if (this.resultSet == null) {
                returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColVal_null_resultset", this.logParams, null);
                if (isValueNull != null) {
                    isValueNull.setVal(-1);
                }
                short s = 0;
                return s;
            }
            value = this.resultSet.getShort(columnIndex + 1);
            if (this.resultSet.wasNull()) {
                isValueNull.setVal(-1);
            } else {
                isValueNull.setVal(0);
            }
        }
        catch (SQLException se) {
            returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColVal", this.logParams, se);
        }
        catch (Throwable e) {
            returnCode = this.handleException(e);
        }
        finally {
            if (errorFlag != null) {
                errorFlag.setVal(returnCode);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sqlipGetIntColval(int columnIndex, xo_int isValueNull, xo_int errorFlag) {
        int returnCode = 0;
        int value = 0;
        try {
            if (this.resultSet == null) {
                returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColVal_null_resultset", this.logParams, null);
                if (isValueNull != null) {
                    isValueNull.setVal(-1);
                }
                int n = 0;
                return n;
            }
            value = this.resultSet.getInt(columnIndex + 1);
            if (this.resultSet.wasNull()) {
                isValueNull.setVal(-1);
            } else {
                isValueNull.setVal(0);
            }
        }
        catch (SQLException se) {
            returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColVal", this.logParams, se);
        }
        catch (Throwable e) {
            returnCode = this.handleException(e);
        }
        finally {
            if (errorFlag != null) {
                errorFlag.setVal(returnCode);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float sqlipGetFloatColval(int columnIndex, xo_int isValueNull, xo_int errorFlag) {
        int returnCode = 0;
        float value = 0.0f;
        try {
            if (this.resultSet == null) {
                returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColVal_null_resultset", this.logParams, null);
                if (isValueNull != null) {
                    isValueNull.setVal(-1);
                }
                float f = 0.0f;
                return f;
            }
            value = this.resultSet.getFloat(columnIndex + 1);
            if (this.resultSet.wasNull()) {
                isValueNull.setVal(-1);
            } else {
                isValueNull.setVal(0);
            }
        }
        catch (SQLException se) {
            returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColVal", this.logParams, se);
        }
        catch (Throwable e) {
            returnCode = this.handleException(e);
        }
        finally {
            if (errorFlag != null) {
                errorFlag.setVal(returnCode);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sqlipGetDoubleColval(int columnIndex, xo_int isValueNull, xo_int errorFlag) {
        int returnCode = 0;
        double value = 0.0;
        try {
            if (this.resultSet == null) {
                returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColVal_null_resultset", this.logParams, null);
                if (isValueNull != null) {
                    isValueNull.setVal(-1);
                }
                double d = 0.0;
                return d;
            }
            value = this.resultSet.getDouble(columnIndex + 1);
            if (this.resultSet.wasNull()) {
                isValueNull.setVal(-1);
            } else {
                isValueNull.setVal(0);
            }
        }
        catch (SQLException se) {
            returnCode = this.handleException("MetaMatrixODBCIP_stmt.error_sqlipGetColVal", this.logParams, se);
        }
        catch (Throwable e) {
            returnCode = this.handleException(e);
        }
        finally {
            if (errorFlag != null) {
                errorFlag.setVal(returnCode);
            }
        }
        return value;
    }

    private BufferAppender getAppender(int column) throws SQLException {
        if (this.appenders == null) {
            this.appenders = new BufferAppender[this.columnCount + 1];
            block13: for (int i = 1; i <= this.columnCount; ++i) {
                switch (this.getATIColumnType(i)) {
                    case -9: 
                    case -8: 
                    case 1: 
                    case 2: 
                    case 12: {
                        this.appenders[i] = STRING_APPENDER;
                        continue block13;
                    }
                    case 4: {
                        this.appenders[i] = INT_APPENDER;
                        continue block13;
                    }
                    case 7: {
                        this.appenders[i] = FLOAT_APPENDER;
                        continue block13;
                    }
                    case 6: 
                    case 8: {
                        this.appenders[i] = DOUBLE_APPENDER;
                        continue block13;
                    }
                    case 11: {
                        this.appenders[i] = TIMESTAMP_APPENDER;
                        continue block13;
                    }
                    case 9: {
                        this.appenders[i] = DATE_APPENDER;
                        continue block13;
                    }
                    case 10: {
                        this.appenders[i] = TIME_APPENDER;
                        continue block13;
                    }
                    case 5: {
                        this.appenders[i] = SHORT_APPENDER;
                        continue block13;
                    }
                    case -10: 
                    case -1: {
                        this.appenders[i] = CLOB_APPENDER;
                        continue block13;
                    }
                    case -4: {
                        this.appenders[i] = BLOB_APPENDER;
                        continue block13;
                    }
                    case -3: 
                    case -2: {
                        this.appenders[i] = BYTE_ARRAY_APPENDER;
                        continue block13;
                    }
                    default: {
                        this.appenders[i] = DEFAULT_APPENDER;
                    }
                }
            }
        }
        return this.appenders[column];
    }

    /*
     * Exception decompiling
     */
    public Object[] sqlipFetchRowsInBuffer(ByteBuffer byteBuffer, char[] charBuffer, xo_int numRows, xo_int charBufferLength, xo_int status) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int handleException(String key, Object[] params, Exception e) {
        String msg = null;
        msg = params != null ? ODBCPlugin.Util.getString(key, params) : ODBCPlugin.Util.getString(key);
        if (e == null) {
            e = new MetaMatrixODBCIPException(msg);
        }
        LogManager.logError((String)"ODBC_STATEMENT", (Throwable)e, (String)msg);
        this.lastError = e;
        return -1;
    }

    private int handleException(Throwable e) {
        LogManager.logError((String)"ODBC_STATEMENT", (Throwable)e, (String)e.getMessage());
        this.lastError = e;
        return -1;
    }

    static final class CharBuffer {
        private char[] buffer;
        private int length = 0;

        CharBuffer(char[] buffer) {
            this.buffer = buffer;
        }

        void put(String s) {
            int strLength = s.length();
            int remaining = this.buffer.length - this.length - 1;
            boolean overflow = false;
            if (remaining < strLength) {
                overflow = true;
                strLength = remaining;
            }
            for (int i = 0; i < strLength; ++i) {
                this.buffer[this.length++] = s.charAt(i);
            }
            if (overflow) {
                throw new BufferOverflowException();
            }
        }

        static /* synthetic */ int access$1400(CharBuffer x0) {
            return x0.length;
        }
    }

    private static final class DefaultAppender
    implements BufferAppender {
        private DefaultAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            Object value = resultSet.getObject(column);
            if (value == null) {
                byteBuffer.put((byte)-1);
            } else {
                byteBuffer.put((byte)0);
                charBuffer.put(value.toString());
            }
        }
    }

    private static final class ByteArrayAppender
    implements BufferAppender {
        private ByteArrayAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            byte[] bytes = resultSet.getBytes(column);
            if (resultSet.wasNull()) {
                byteBuffer.put((byte)-1);
            } else {
                byteBuffer.put((byte)0);
                byteBuffer.putInt(bytes.length);
                byteBuffer.put(bytes);
            }
        }
    }

    private static final class ClobAppender
    implements BufferAppender {
        private ClobAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            String val = MetaMatrixODBCIP_stmt.getString(resultSet, column);
            if (resultSet.wasNull()) {
                byteBuffer.put((byte)-1);
            } else {
                byteBuffer.put((byte)0);
                byteBuffer.putInt(val.length());
                lobArrays.add(val.toCharArray());
            }
        }
    }

    private static final class BlobAppender
    implements BufferAppender {
        private BlobAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            byte[] bytes = resultSet.getBytes(column);
            if (resultSet.wasNull()) {
                byteBuffer.put((byte)-1);
            } else {
                byteBuffer.put((byte)0);
                byteBuffer.putInt(bytes.length);
                lobArrays.add(bytes);
            }
        }
    }

    private static final class TimeAppender
    implements BufferAppender {
        private TimeAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            Time time = resultSet.getTime(column);
            if (time != null) {
                byteBuffer.put((byte)0);
                cal.setTime(time);
                byteBuffer.put((byte)cal.get(11));
                byteBuffer.put((byte)cal.get(12));
                byteBuffer.put((byte)cal.get(13));
            } else {
                byteBuffer.put((byte)-1);
            }
        }
    }

    private static final class DateAppender
    implements BufferAppender {
        private DateAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            Date date = resultSet.getDate(column);
            if (date != null) {
                byteBuffer.put((byte)0);
                cal.setTime(date);
                byteBuffer.putShort((short)cal.get(1));
                byteBuffer.put((byte)cal.get(2));
                byteBuffer.put((byte)cal.get(5));
            } else {
                byteBuffer.put((byte)-1);
            }
        }
    }

    private static final class TimestampAppender
    implements BufferAppender {
        private TimestampAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            Timestamp timestamp = resultSet.getTimestamp(column);
            if (timestamp != null) {
                byteBuffer.put((byte)0);
                cal.setTime(timestamp);
                byteBuffer.putShort((short)cal.get(1));
                byteBuffer.put((byte)cal.get(2));
                byteBuffer.put((byte)cal.get(5));
                byteBuffer.put((byte)cal.get(11));
                byteBuffer.put((byte)cal.get(12));
                byteBuffer.put((byte)cal.get(13));
                byteBuffer.putInt(timestamp.getNanos());
            } else {
                byteBuffer.put((byte)-1);
            }
        }
    }

    private static final class ShortAppender
    implements BufferAppender {
        private ShortAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            short val = resultSet.getShort(column);
            if (resultSet.wasNull()) {
                byteBuffer.put((byte)-1);
            } else {
                byteBuffer.put((byte)0);
                byteBuffer.putShort(val);
            }
        }
    }

    private static final class DoubleAppender
    implements BufferAppender {
        private DoubleAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            double val = resultSet.getDouble(column);
            if (resultSet.wasNull()) {
                byteBuffer.put((byte)-1);
            } else {
                byteBuffer.put((byte)0);
                byteBuffer.putDouble(val);
            }
        }
    }

    private static final class FloatAppender
    implements BufferAppender {
        private FloatAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            float val = resultSet.getFloat(column);
            if (resultSet.wasNull()) {
                byteBuffer.put((byte)-1);
            } else {
                byteBuffer.put((byte)0);
                byteBuffer.putFloat(val);
            }
        }
    }

    private static final class StringAppender
    implements BufferAppender {
        private StringAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            String val = MetaMatrixODBCIP_stmt.getString(resultSet, column);
            if (val == null) {
                byteBuffer.put((byte)-1);
            } else {
                byteBuffer.put((byte)0);
                byteBuffer.putInt(val.length());
                if (val.length() > 0) {
                    charBuffer.put(val);
                }
            }
        }
    }

    private static final class IntAppender
    implements BufferAppender {
        private IntAppender() {
        }

        public void appendToBuffer(ByteBuffer byteBuffer, CharBuffer charBuffer, List lobArrays, Calendar cal, ResultSet resultSet, int column) throws SQLException {
            int val = resultSet.getInt(column);
            if (resultSet.wasNull()) {
                byteBuffer.put((byte)-1);
            } else {
                byteBuffer.put((byte)0);
                byteBuffer.putInt(val);
            }
        }
    }

    private static class ColumnMetadata {
        public int atiType;
        public int nullable;
        public String colName;
        public int length;
        public int precision;
        public int scale;

        private ColumnMetadata() {
        }
    }
}

