/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.console.models.UserManager;
import com.metamatrix.console.ui.views.users.UserTabTreeNode;
import com.metamatrix.console.ui.views.users.UsersTree;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.console.util.StaticUtilities;
import java.awt.Component;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UsersTreeNode
extends UserTabTreeNode {
    public static final String METAMATRIX_LABEL = "MetaMatrix Users";
    public static final String ENTERPRISE_LABEL = "Enterprise Users";
    public static final int LARGE_MODEL = 200;
    private UsersTree displayTree;

    public UsersTreeNode(DefaultTreeModel treeModel, String name, UserManager mgr, boolean isMetaMatrix, UsersTree dispTree) {
        super(treeModel, name, mgr, isMetaMatrix);
        this.displayTree = dispTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate() throws Exception {
        boolean alreadyWaiting = StaticUtilities.isShowingWaitCursor();
        try {
            if (!alreadyWaiting) {
                StaticUtilities.startWait((Component)((Object)this.displayTree));
            }
            if (!this.isPopulated()) {
                this.populated = true;
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (!UsersTreeNode.this.displayTree.isDisplayable()) {
                            SwingUtilities.invokeLater(this);
                            return;
                        }
                        TreePath tp = StaticTreeUtilities.treePathToNode((JTree)((Object)UsersTreeNode.this.displayTree), (Object)((Object)UsersTreeNode.this));
                        UsersTreeNode.this.displayTree.expandPath(tp);
                    }
                };
                if (this.isRoot()) {
                    if (this.displayTree.isShowingMetaMatrix()) {
                        UsersTreeNode topOfMetaMatrixBranch = new UsersTreeNode(this.getModel(), METAMATRIX_LABEL, this.getManager(), true, this.displayTree);
                        topOfMetaMatrixBranch.setTopOfMetaMatrixBranch(true);
                        this.add((MutableTreeNode)((Object)topOfMetaMatrixBranch));
                    }
                    if (this.displayTree.isShowingEnterprise()) {
                        UsersTreeNode topOfEnterpriseBranch = new UsersTreeNode(this.getModel(), ENTERPRISE_LABEL, this.getManager(), false, this.displayTree);
                        topOfEnterpriseBranch.setTopOfEnterpriseBranch(true);
                        this.add((MutableTreeNode)((Object)topOfEnterpriseBranch));
                    }
                } else if (this.isTopOfMetaMatrixBranch()) {
                    boolean isAlpha;
                    List metaMatrixNames = this.getManager().getAllMetaMatrixUserNames();
                    boolean isLarge = metaMatrixNames.size() > 200;
                    boolean bl = isAlpha = this.getSortType() == 2;
                    if (isAlpha) {
                        Collections.sort(metaMatrixNames);
                        this.setSortType(3);
                    }
                    Iterator it = metaMatrixNames.iterator();
                    while (it.hasNext()) {
                        String userName = (String)it.next();
                        UsersTreeNode newNode = new UsersTreeNode(this.getModel(), userName, this.getManager(), true, this.displayTree);
                        this.add((MutableTreeNode)((Object)newNode));
                    }
                    if (!isLarge) {
                        SwingUtilities.invokeLater(runnable);
                    }
                    if (isAlpha) {
                        this.setSortType(2);
                    }
                } else if (this.isTopOfEnterpriseBranch()) {
                    boolean isAlpha;
                    List enterpriseNames = this.getManager().getAllEnterpriseUserNames();
                    boolean isLarge = enterpriseNames.size() > 200;
                    boolean bl = isAlpha = this.getSortType() == 2;
                    if (isAlpha) {
                        Collections.sort(enterpriseNames);
                        this.setSortType(3);
                    }
                    Iterator it = enterpriseNames.iterator();
                    while (it.hasNext()) {
                        String userName = (String)it.next();
                        UsersTreeNode newNode = new UsersTreeNode(this.getModel(), userName, this.getManager(), false, this.displayTree);
                        this.add((MutableTreeNode)((Object)newNode));
                    }
                    if (!isLarge) {
                        SwingUtilities.invokeLater(runnable);
                    }
                    if (isAlpha) {
                        this.setSortType(2);
                    }
                }
            }
            this.displayTree.setTreeChanged();
            this.getModel().nodeStructureChanged((TreeNode)((Object)this));
        }
        finally {
            if (!alreadyWaiting) {
                StaticUtilities.endWait((Component)((Object)this.displayTree));
            }
        }
    }

    public int getTypeOfNode() {
        int nodeType = -1;
        if (!(this.isRoot() || this.isTopOfMetaMatrixBranch() || this.isTopOfEnterpriseBranch())) {
            nodeType = 1;
        }
        return nodeType;
    }
}

