/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.console.models.UserManager;
import com.metamatrix.console.ui.util.LazyBranchListener;
import com.metamatrix.console.ui.views.users.NotifyOnSelectionChange;
import com.metamatrix.console.ui.views.users.UserNodesExpandingTree;
import com.metamatrix.console.ui.views.users.UsersTabTreeCellRenderer;
import com.metamatrix.console.ui.views.users.UsersTreeNode;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticTreeUtilities;
import com.metamatrix.console.util.StaticUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UsersTree
extends UserNodesExpandingTree
implements TreeSelectionListener {
    public static final String METAMATRIX_LABEL = "MetaMatrix Users";
    public static final String ENTERPRISE_LABEL = "Enterprise Users";
    private UserManager manager;
    private NotifyOnSelectionChange controller;
    private boolean showingMetaMatrix;
    private boolean showingEnterprise;
    private boolean ignoreValueChange = false;
    private boolean treeChangeSinceLastPaint = false;
    private LazyBranchListener lazyBranchListener = new LazyBranchListener();

    public UsersTree(UserManager mgr, NotifyOnSelectionChange ctrlr, boolean showMetaMatrix, boolean showEnterprise) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        this.manager = mgr;
        this.controller = ctrlr;
        this.showingMetaMatrix = showMetaMatrix;
        this.showingEnterprise = showEnterprise;
        this.init();
        this.getModel().addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent ev) {
                UsersTree.this.treeChangeSinceLastPaint = true;
            }

            public void treeNodesInserted(TreeModelEvent ev) {
                UsersTree.this.treeChangeSinceLastPaint = true;
            }

            public void treeNodesRemoved(TreeModelEvent ev) {
                UsersTree.this.treeChangeSinceLastPaint = true;
            }

            public void treeStructureChanged(TreeModelEvent ev) {
                UsersTree.this.treeChangeSinceLastPaint = true;
            }
        });
    }

    private void init() {
        UsersTreeNode rootNode = new UsersTreeNode(null, "root", this.manager, false, this);
        rootNode.setRoot(true);
        rootNode.setSortType(3);
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)((Object)rootNode));
        this.setModel(treeModel);
        rootNode.setModel(treeModel);
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer((TreeCellRenderer)new UsersTabTreeCellRenderer());
        try {
            rootNode.populate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addTreeSelectionListener(this);
        this.lazyBranchListener = new LazyBranchListener();
        this.addTreeWillExpandListener((TreeWillExpandListener)this.lazyBranchListener);
        this.setLargeModel(true);
    }

    public boolean isShowingMetaMatrix() {
        return this.showingMetaMatrix;
    }

    public boolean isShowingEnterprise() {
        return this.showingEnterprise;
    }

    public void setIgnoreValueChange(boolean flag) {
        this.ignoreValueChange = flag;
    }

    public void valueChanged(TreeSelectionEvent ev) {
        TreePath tp = ev.getNewLeadSelectionPath();
        UsersTreeNode selectedNode = null;
        if (tp != null) {
            Object obj = tp.getLastPathComponent();
            selectedNode = (UsersTreeNode)((Object)obj);
            this.populateSelectedNode(selectedNode);
        }
        if (!this.ignoreValueChange) {
            this.controller.selectionChanged((Component)((Object)this), (Object)selectedNode);
        }
    }

    private TreeNode findNode(DefaultMutableTreeNode theNode, Object theUserObject) {
        if (theNode.getUserObject().equals(theUserObject)) {
            return theNode;
        }
        int kids = theNode.getChildCount();
        for (int i = 0; i < kids; ++i) {
            DefaultMutableTreeNode kid = (DefaultMutableTreeNode)theNode.getChildAt(i);
            TreeNode node = this.findNode(kid, theUserObject);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private void refreshNode(UsersTreeNode theNode) throws Exception {
        theNode.resetPopulated();
        theNode.populate();
        Enumeration kids = theNode.children();
        while (kids.hasMoreElements()) {
            UsersTreeNode kid = (UsersTreeNode)((Object)kids.nextElement());
            this.refreshNode(kid);
        }
    }

    private UsersTreeNode findTopOfMetaMatrixBranch() {
        UsersTreeNode rootNode = (UsersTreeNode)((Object)this.getModel().getRoot());
        UsersTreeNode node = null;
        int kids = rootNode.getChildCount();
        for (int i = 0; i < kids && !(node = (UsersTreeNode)((Object)rootNode.getChildAt(i))).isTopOfMetaMatrixBranch(); ++i) {
        }
        return node;
    }

    private void expandMetaMatrixBranch() {
        UsersTreeNode node = this.findTopOfMetaMatrixBranch();
        if (((DefaultMutableTreeNode)((Object)node)).getChildCount() > 0) {
            TreeNode firstKid = ((DefaultMutableTreeNode)((Object)node)).getFirstChild();
            ArrayList<Object> pathNodes = new ArrayList<Object>();
            pathNodes.add(this.getModel().getRoot());
            pathNodes.add((Object)node);
            pathNodes.add(firstKid);
            TreePath path = new TreePath(pathNodes.toArray());
            this.expandPath(path);
        }
    }

    private void selectFirstEditableUser() {
        UsersTreeNode topNode = this.findTopOfMetaMatrixBranch();
        if (((DefaultMutableTreeNode)((Object)topNode)).getChildCount() > 0) {
            TreeNode firstKid = ((DefaultMutableTreeNode)((Object)topNode)).getFirstChild();
            ArrayList<Object> pathNodes = new ArrayList<Object>();
            pathNodes.add(this.getModel().getRoot());
            pathNodes.add((Object)topNode);
            pathNodes.add(firstKid);
            TreePath path = new TreePath(pathNodes.toArray());
            this.expandPath(path);
            this.setSelectionPath(path);
            this.scrollRowToVisible(this.getRowForPath(path));
        }
    }

    private void selectAppropriateRow(int theRow) {
        this.expandMetaMatrixBranch();
        int row = -1;
        int count = this.findTopOfMetaMatrixBranch().getChildCount();
        if (theRow < count) {
            row = theRow;
        } else if (theRow >= count) {
            row = count;
        }
        this.setSelectionInterval(row, row);
        this.scrollRowToVisible(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshData() {
        TreePath path = this.getSelectionPath();
        UsersTreeNode node = null;
        int[] selectedRows = this.getSelectionRows();
        if (path != null) {
            node = (UsersTreeNode)((Object)path.getLastPathComponent());
        }
        UsersTreeNode rootNode = (UsersTreeNode)((Object)this.getModel().getRoot());
        boolean alreadyWaiting = StaticUtilities.isShowingWaitCursor();
        try {
            if (!alreadyWaiting) {
                StaticUtilities.startWait((Component)((Object)this));
            }
            rootNode.removeAllChildren();
            this.refreshNode(rootNode);
            ((DefaultTreeModel)this.getModel()).reload();
            if (node == null) {
                this.selectFirstEditableUser();
            } else {
                Object userObj = node.getUserObject();
                TreeNode selectedNode = this.findNode((DefaultMutableTreeNode)((Object)rootNode), userObj);
                if (selectedNode == null) {
                    this.selectAppropriateRow(selectedRows[0]);
                } else {
                    ArrayList<TreeNode> pathNodes = new ArrayList<TreeNode>();
                    pathNodes.add(selectedNode);
                    for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selectedNode.getParent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
                        pathNodes.add(parent);
                    }
                    Collections.reverse(pathNodes);
                    TreePath newPath = new TreePath(pathNodes.toArray());
                    this.removeTreeWillExpandListener((TreeWillExpandListener)this.lazyBranchListener);
                    this.setSelectionPath(newPath);
                    this.controller.selectionChanged((Component)((Object)this), (Object)selectedNode);
                    this.scrollRowToVisible(this.getRowForPath(newPath));
                    this.addTreeWillExpandListener((TreeWillExpandListener)this.lazyBranchListener);
                }
            }
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage((String)"Users refresh failed.", (Throwable)theException);
        }
        finally {
            if (!alreadyWaiting) {
                StaticUtilities.endWait((Component)((Object)this));
            }
        }
    }

    public boolean isDisplayableNode(UsersTreeNode node) {
        return !node.isRoot() && !node.isTopOfMetaMatrixBranch() && !node.isTopOfEnterpriseBranch();
    }

    public TreeSelectionListener getSelectionListener() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSelectedNode(UsersTreeNode selectedNode) {
        boolean alreadyWaiting = StaticUtilities.isShowingWaitCursor();
        try {
            if (!alreadyWaiting) {
                StaticUtilities.startWait((Component)((Object)this));
            }
            selectedNode.populate();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage((String)"Populate Selected Groups Tree Node", (Throwable)ex);
        }
        finally {
            if (!alreadyWaiting) {
                StaticUtilities.endWait((Component)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        boolean alreadyWaiting = StaticUtilities.isShowingWaitCursor();
        try {
            if (!alreadyWaiting) {
                StaticUtilities.startWait((Component)((Object)this));
            }
            if (this.treeChangeSinceLastPaint) {
                StaticTreeUtilities.userTabPaintProblemDuplicateNodeCheck((JTree)((Object)this));
                this.treeChangeSinceLastPaint = false;
            }
            super.paint(g);
        }
        finally {
            if (!alreadyWaiting) {
                StaticUtilities.endWait((Component)((Object)this));
            }
        }
    }
}

