/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.UserManager;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.util.ConsoleCellRenderer;
import com.metamatrix.console.ui.util.IconLabel;
import com.metamatrix.console.ui.util.RepaintController;
import com.metamatrix.console.ui.views.users.AddByPrincipalTypeAndSubtypeDialog;
import com.metamatrix.console.ui.views.users.Entity;
import com.metamatrix.console.ui.views.users.IsAssignedToListerPanel;
import com.metamatrix.console.ui.views.users.ItemsListerPanel;
import com.metamatrix.console.ui.views.users.MembershipController;
import com.metamatrix.console.ui.views.users.MembershipPanel;
import com.metamatrix.console.ui.views.users.PairedEntities;
import com.metamatrix.console.ui.views.users.RoleDisplay;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticPrincipalUtilities;
import com.metamatrix.console.util.StaticQuickSorter;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.MessagePanel;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class RoleDetail
extends BasePanel
implements MembershipController {
    private RoleDisplay roleDisplay;
    private Entity thisEntity;
    private UserManager manager;
    private boolean enterprise;
    private MembershipPanel rolePanel;
    private RepaintController repaintController;
    private ConnectionInfo connection;

    public RoleDetail(RoleDisplay rd, UserManager mgr, boolean rOnly, RepaintController rc, ConnectionInfo conn) throws Exception {
        this.roleDisplay = rd;
        this.manager = mgr;
        this.enterprise = rOnly;
        this.repaintController = rc;
        this.connection = conn;
        this.thisEntity = new Entity(this.roleDisplay.getDisplayName(), 2);
        this.init();
        this.repaintController.repaintNeeded();
    }

    private void init() throws Exception {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        String headerText = "Role: " + this.roleDisplay.getDisplayName();
        IconLabel header = new IconLabel((Icon)ConsoleCellRenderer.ROLE_ICON, headerText);
        this.add((Component)header);
        layout.setConstraints((Component)header, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        JTextArea descriptionArea = new JTextArea();
        descriptionArea.setColumns(30);
        descriptionArea.setRows(4);
        descriptionArea.setPreferredSize(new Dimension(150, 68));
        descriptionArea.setLineWrap(true);
        descriptionArea.setText(this.roleDisplay.getDescription());
        descriptionArea.setBorder((Border)new TitledBorder(""));
        descriptionArea.setBackground(new JPanel().getBackground());
        JScrollPane descriptionJSP = new JScrollPane(descriptionArea);
        this.add(descriptionJSP);
        layout.setConstraints(descriptionJSP, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.2, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.rolePanel = new MembershipPanel(this.thisEntity, true, (ItemsListerPanel)new IsAssignedToListerPanel(this.manager, this.roleDisplay, this.enterprise, this.repaintController, this.connection), (MembershipController)this, this.enterprise);
        this.rolePanel.setAddButtonText("Assign...");
        this.add((Component)this.rolePanel);
        layout.setConstraints((Component)this.rolePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.8, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void removeConfirmed(Component caller, PairedEntities[] removalItems) {
        this.removeRoleFromPrincipals(removalItems);
    }

    public void addPressed(Component caller) {
        this.showAssignRoleToDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRoleFromPrincipals(PairedEntities[] removalItems) {
        try {
            StaticUtilities.startWait((Component)((Object)this));
            ArrayList<MetaMatrixPrincipalName> principalNames = new ArrayList<MetaMatrixPrincipalName>();
            for (int i = 0; i < removalItems.length; ++i) {
                String name = removalItems[i].getSecond().getName();
                int unconvertedType = removalItems[i].getSecond().getType();
                int convertedType = -1;
                if (unconvertedType == 1) {
                    convertedType = 0;
                } else if (unconvertedType == 0) {
                    convertedType = 1;
                }
                MetaMatrixPrincipalName mmName = new MetaMatrixPrincipalName(name, convertedType);
                principalNames.add(mmName);
            }
            this.manager.removePrincipalsFromRole(principalNames, this.roleDisplay.getName());
            this.rolePanel.getListPanel().repopulatePanel(null);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Remove Role From Principals", (Throwable)e);
        }
        finally {
            StaticUtilities.endWait((Component)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAssignRoleToDialog() {
        try {
            StaticUtilities.startWait((Component)((Object)this));
            Collection principalsHavingRole = this.manager.getPrincipalsForRole(this.roleDisplay.getName());
            List metaMatrixUsers = this.manager.getAllMetaMatrixUserNames();
            List enterpriseUsers = this.manager.getAllEnterpriseUserNames();
            Collection metaMatrixGroups = this.manager.getAllMetaMatrixGroupNames();
            Collection enterpriseGroups = this.manager.getAllEnterpriseGroupNames();
            ArrayList<String> usersHavingRole = new ArrayList<String>();
            ArrayList<String> groupsHavingRole = new ArrayList<String>();
            Iterator it = principalsHavingRole.iterator();
            while (it.hasNext()) {
                MetaMatrixPrincipalName name = (MetaMatrixPrincipalName)it.next();
                if (name.getType() == 0) {
                    usersHavingRole.add(name.getName());
                    continue;
                }
                if (name.getType() != 1) continue;
                groupsHavingRole.add(name.getName());
            }
            metaMatrixUsers.removeAll(usersHavingRole);
            enterpriseUsers.removeAll(usersHavingRole);
            String loggedInUser = StaticPrincipalUtilities.getLoggedInUser((ConnectionInfo)this.connection).getName();
            metaMatrixUsers.remove(loggedInUser);
            enterpriseUsers.remove(loggedInUser);
            String[] metaMatrixUserNames = new String[metaMatrixUsers.size()];
            it = metaMatrixUsers.iterator();
            int loc = 0;
            while (it.hasNext()) {
                metaMatrixUserNames[loc] = (String)it.next();
                ++loc;
            }
            String[] sortedMetaMatrixUserNames = StaticQuickSorter.quickStringSort((String[])metaMatrixUserNames);
            String[] enterpriseUserNames = new String[enterpriseUsers.size()];
            it = enterpriseUsers.iterator();
            loc = 0;
            while (it.hasNext()) {
                enterpriseUserNames[loc] = (String)it.next();
                ++loc;
            }
            String[] sortedenterpriseUserNames = StaticQuickSorter.quickStringSort((String[])enterpriseUserNames);
            metaMatrixGroups.removeAll(groupsHavingRole);
            enterpriseGroups.removeAll(groupsHavingRole);
            String[] metaMatrixGroupNames = new String[metaMatrixGroups.size()];
            it = metaMatrixGroups.iterator();
            loc = 0;
            while (it.hasNext()) {
                metaMatrixGroupNames[loc] = (String)it.next();
                ++loc;
            }
            String[] sortedMetaMatrixGroupNames = StaticQuickSorter.quickStringSort((String[])metaMatrixGroupNames);
            String[] enterpriseGroupNames = new String[enterpriseGroups.size()];
            it = enterpriseGroups.iterator();
            loc = 0;
            while (it.hasNext()) {
                enterpriseGroupNames[loc] = (String)it.next();
                ++loc;
            }
            String[] sortedenterpriseGroupNames = StaticQuickSorter.quickStringSort((String[])enterpriseGroupNames);
            if (sortedMetaMatrixUserNames.length == 0 && sortedMetaMatrixGroupNames.length == 0 && sortedenterpriseUserNames.length == 0 && sortedenterpriseGroupNames.length == 0) {
                MessagePanel panel = new MessagePanel("notification", "All users have been assigned the role " + this.roleDisplay.getDisplayName());
                DialogWindow.show((Component)ViewManager.getMainFrame(), (String)"", (Component)panel);
            } else {
                AddByPrincipalTypeAndSubtypeDialog dialog = new AddByPrincipalTypeAndSubtypeDialog("Assign Role " + this.roleDisplay.getDisplayName() + " to:", sortedMetaMatrixUserNames, sortedenterpriseUserNames, sortedMetaMatrixGroupNames, sortedenterpriseGroupNames);
                StaticUtilities.endWait((Component)((Object)this));
                dialog.show();
                Collection checkedMetaMatrixUsers = dialog.getCheckedMetaMatrixUsers();
                Collection checkedEnterpriseUsers = dialog.getCheckedEnterpriseUsers();
                Collection checkedMetaMatrixGroups = dialog.getCheckedMetaMatrixGroups();
                Collection checkedEnterpriseGroups = dialog.getCheckedEnterpriseGroups();
                if (checkedMetaMatrixUsers.size() + checkedEnterpriseUsers.size() + checkedMetaMatrixGroups.size() + checkedEnterpriseGroups.size() > 0) {
                    ArrayList allChecked = new ArrayList(checkedMetaMatrixUsers);
                    allChecked.addAll(checkedEnterpriseUsers);
                    allChecked.addAll(checkedMetaMatrixGroups);
                    allChecked.addAll(checkedEnterpriseGroups);
                    this.manager.addPrincipalsToRole(allChecked, this.roleDisplay.getName());
                    this.rolePanel.getListPanel().repopulatePanel(null);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Assign Role to Principals", (Throwable)e);
        }
        finally {
            StaticUtilities.endWait((Component)((Object)this));
        }
    }
}

