/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.views.users;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.properties.MultiValuedProperties;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.UserManager;
import com.metamatrix.console.ui.layout.BasePanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.util.ConsoleCellRenderer;
import com.metamatrix.console.ui.util.IconLabel;
import com.metamatrix.console.ui.util.RepaintController;
import com.metamatrix.console.ui.views.users.AddByPrincipalTypeDialog;
import com.metamatrix.console.ui.views.users.AddDialog;
import com.metamatrix.console.ui.views.users.ContainsMembersListerPanel;
import com.metamatrix.console.ui.views.users.Entity;
import com.metamatrix.console.ui.views.users.HasRolesListerPanel;
import com.metamatrix.console.ui.views.users.IsMemberOfListerPanel;
import com.metamatrix.console.ui.views.users.ItemsListerPanel;
import com.metamatrix.console.ui.views.users.MembershipController;
import com.metamatrix.console.ui.views.users.MembershipPanel;
import com.metamatrix.console.ui.views.users.NotifyOnMembersOfGroupChange;
import com.metamatrix.console.ui.views.users.NotifyOnPrincipalMembershipsChange;
import com.metamatrix.console.ui.views.users.NotifyOnPrincipalPropertiesChanged;
import com.metamatrix.console.ui.views.users.PairedEntities;
import com.metamatrix.console.ui.views.users.PrincipalPropertiesDialog;
import com.metamatrix.console.ui.views.users.PrincipalPropertyInfo;
import com.metamatrix.console.ui.views.users.ResetPasswordDialog;
import com.metamatrix.console.ui.views.users.RoleDisplay;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticPrincipalUtilities;
import com.metamatrix.console.util.StaticQuickSorter;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.ScrollWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class PrincipalDetail
extends BasePanel
implements MembershipController,
NotifyOnPrincipalPropertiesChanged {
    private NotifyOnPrincipalMembershipsChange isMemberOfDisplayController;
    private NotifyOnMembersOfGroupChange hasMembersDisplayController;
    private UserManager manager;
    private ConnectionInfo connection;
    private MetaMatrixPrincipal principal;
    private boolean enterprisePrincipal;
    private boolean canViewPrincipals;
    private boolean canEditPrincipals;
    private boolean canViewRoles;
    private boolean canEditRoles;
    private boolean canResetPassword;
    private RepaintController repaintController;
    private PrincipalPropertyInfo[] initialPropValues;
    private JPanel propsPanel;
    private GridBagLayout layout;
    private Entity thisEntity;
    private Map mapPropNames;
    private JSplitPane splitter;
    private ButtonWidget resetPasswordButton;
    private JPanel assignmentsPanel = new JPanel();
    private MembershipPanel isMemberOf = null;
    private MembershipPanel containsMembers = null;
    private MembershipPanel hasRoles = null;

    public PrincipalDetail(NotifyOnPrincipalMembershipsChange isMemDispCtrlr, NotifyOnMembersOfGroupChange hasMemDispCtrlr, UserManager mgr, MetaMatrixPrincipal pcpl, boolean entrprs, boolean viewPr, boolean editPr, boolean viewRol, boolean editRol, boolean resetPW, RepaintController rc, ConnectionInfo conn) throws AuthorizationException, ExternalException, ComponentNotFoundException, MetaMatrixSecurityException {
        this.isMemberOfDisplayController = isMemDispCtrlr;
        this.hasMembersDisplayController = hasMemDispCtrlr;
        this.manager = mgr;
        this.principal = pcpl;
        this.enterprisePrincipal = entrprs;
        this.canViewPrincipals = viewPr;
        this.canEditPrincipals = editPr && !this.enterprisePrincipal;
        this.canViewRoles = viewRol;
        this.canEditRoles = editRol;
        this.canResetPassword = resetPW && !this.enterprisePrincipal;
        this.repaintController = rc;
        this.connection = conn;
        this.createEntity();
        if (!this.enterprisePrincipal) {
            this.mapPropNames = this.thisEntity.getType() == 1 ? this.manager.getMetaMatrixPropNamesForUsers() : this.manager.getMetaMatrixPropNamesForGroups();
        }
        this.setInitialPropValues();
        this.init();
        rc.repaintNeeded();
    }

    public MetaMatrixPrincipal getPrincipal() {
        return this.principal;
    }

    public Entity getThisEntity() {
        return this.thisEntity;
    }

    private void setInitialPropValues() {
        ArrayList<PrincipalPropertyInfo> pi = new ArrayList<PrincipalPropertyInfo>();
        MultiValuedProperties prop = this.principal.getProperties();
        Set names = prop.getPropertyNames();
        if (this.enterprisePrincipal) {
            this.mapPropNames = new HashMap();
        }
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Collection values = prop.getPropertyValues(name);
            if (values.size() != 1) continue;
            String value = (String)values.iterator().next();
            if (this.enterprisePrincipal) {
                pi.add(new PrincipalPropertyInfo(name, name, value));
                this.mapPropNames.put(name, name);
                continue;
            }
            pi.add(new PrincipalPropertyInfo(name, (String)this.mapPropNames.get(name), value));
        }
        Collection piOrder = new ArrayList();
        boolean reordering = this.shouldBeReordered(pi);
        if (reordering) {
            piOrder = this.reorderArrayList(pi);
        }
        this.initialPropValues = new PrincipalPropertyInfo[pi.size()];
        int loc = 0;
        it = reordering ? piOrder.iterator() : pi.iterator();
        while (it.hasNext()) {
            this.initialPropValues[loc] = (PrincipalPropertyInfo)it.next();
            ++loc;
        }
    }

    private boolean shouldBeReordered(List pi) {
        boolean reorder = false;
        if (!this.enterprisePrincipal && this.thisEntity.getType() == 1 && pi.size() == UserManager.PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_USERS.length) {
            boolean unmatchedItemFound = false;
            int i = 0;
            while (!unmatchedItemFound && i < UserManager.PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_USERS.length) {
                boolean itemMatched = false;
                int j = 0;
                while (!itemMatched && j < UserManager.PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_USERS.length) {
                    PrincipalPropertyInfo info = (PrincipalPropertyInfo)pi.get(j);
                    String name = info.getDisplayName();
                    if (name.equals(UserManager.PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_USERS[i][1])) {
                        itemMatched = true;
                        continue;
                    }
                    ++j;
                }
                if (!itemMatched) {
                    unmatchedItemFound = true;
                    continue;
                }
                ++i;
            }
            if (!unmatchedItemFound) {
                reorder = true;
            }
        }
        return reorder;
    }

    private Collection reorderArrayList(ArrayList p) {
        ArrayList orderPi = new ArrayList();
        block0: for (int i = 0; i < UserManager.PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_USERS.length; ++i) {
            String labelName = UserManager.PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_USERS[i][1];
            for (int j = 0; j < p.size(); ++j) {
                String name = ((PrincipalPropertyInfo)p.get(j)).getDisplayName();
                if (!name.equals(labelName)) continue;
                orderPi.add(p.get(j));
                continue block0;
            }
        }
        return orderPi;
    }

    private void init() throws AuthorizationException, ExternalException, ComponentNotFoundException, MetaMatrixSecurityException {
        JComponent overallPanel;
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        IconLabel header = this.thisEntity.getType() == 1 ? new IconLabel((Icon)ConsoleCellRenderer.USER_ICON, "User: " + this.thisEntity.getName()) : new IconLabel((Icon)ConsoleCellRenderer.USER_GROUP_ICON, "Group: " + this.thisEntity.getName());
        this.add((Component)header);
        this.layout.setConstraints((Component)header, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.canViewPrincipals) {
            PrincipalPropertyInfo[] initPropValues = new PrincipalPropertyInfo[this.initialPropValues.length];
            for (int i = 0; i < this.initialPropValues.length; ++i) {
                String name = this.initialPropValues[i].getName();
                initPropValues[i] = new PrincipalPropertyInfo(name, (String)this.mapPropNames.get(name), this.initialPropValues[i].getValue());
            }
            if (this.canResetPassword && this.thisEntity.getType() == 1) {
                this.resetPasswordButton = new ButtonWidget("Reset Password...");
                this.resetPasswordButton.setName("PrincipalDetail.resetPasswordButton");
                this.resetPasswordButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.propsPanel = this.buildPropsPanel(initPropValues);
        }
        TitledBorder tBorder = new TitledBorder("Properties");
        this.propsPanel.setBorder((Border)tBorder);
        if (this.thisEntity.getType() == 1) {
            this.setUpUserPanels();
        } else {
            this.setUpGroupPanels();
        }
        if (this.canViewPrincipals) {
            this.splitter = new /* Unavailable Anonymous Inner Class!! */;
            overallPanel = this.splitter;
        } else {
            overallPanel = this.assignmentsPanel;
        }
        this.add(overallPanel);
        this.layout.setConstraints(overallPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void setUpUserPanels() throws ExternalException, AuthorizationException, ComponentNotFoundException, MetaMatrixSecurityException {
        int numItems = 0;
        if (this.canViewPrincipals) {
            ++numItems;
        }
        if (this.canViewRoles) {
            ++numItems;
        }
        this.assignmentsPanel.setLayout(new GridLayout(1, numItems));
        if (this.canViewPrincipals) {
            this.isMemberOf = new MembershipPanel(this.thisEntity, true, (ItemsListerPanel)new IsMemberOfListerPanel(this.manager, this.principal, !this.canEditPrincipals, this.repaintController), (MembershipController)this, !this.canEditPrincipals);
            this.assignmentsPanel.add((Component)this.isMemberOf);
        }
        if (this.canViewRoles) {
            this.hasRoles = new MembershipPanel(this.thisEntity, false, (ItemsListerPanel)new HasRolesListerPanel(this.manager, this.principal, !this.canEditRoles, this.repaintController), (MembershipController)this, !this.canEditRoles);
            this.hasRoles.enableAddButton(!StaticPrincipalUtilities.hasAllRoles((MetaMatrixPrincipalName)this.thisEntity.toPrincipalName(), (ConnectionInfo)this.connection));
            this.assignmentsPanel.add((Component)this.hasRoles);
        }
    }

    private void setUpGroupPanels() throws ExternalException, AuthorizationException, ComponentNotFoundException, MetaMatrixSecurityException {
        int numItems = 0;
        if (this.canViewPrincipals) {
            numItems += 2;
        }
        if (this.canViewRoles) {
            ++numItems;
        }
        this.assignmentsPanel.setLayout(new GridLayout(1, numItems));
        if (this.canViewPrincipals) {
            this.isMemberOf = new MembershipPanel(this.thisEntity, true, (ItemsListerPanel)new IsMemberOfListerPanel(this.manager, this.principal, !this.canEditPrincipals, this.repaintController), (MembershipController)this, !this.canEditPrincipals);
            this.containsMembers = new MembershipPanel(this.thisEntity, false, (ItemsListerPanel)new ContainsMembersListerPanel(this.manager, this.principal, !this.canEditPrincipals, this.repaintController), (MembershipController)this, !this.canEditPrincipals);
            this.assignmentsPanel.add((Component)this.isMemberOf);
            this.assignmentsPanel.add((Component)this.containsMembers);
        }
        if (this.canViewRoles) {
            this.hasRoles = new MembershipPanel(this.thisEntity, false, (ItemsListerPanel)new HasRolesListerPanel(this.manager, this.principal, !this.canEditRoles, this.repaintController), (MembershipController)this, !this.canEditRoles);
            this.hasRoles.enableAddButton(!StaticPrincipalUtilities.hasAllRoles((MetaMatrixPrincipalName)this.thisEntity.toPrincipalName(), (ConnectionInfo)this.connection));
            this.assignmentsPanel.add((Component)this.hasRoles);
        }
    }

    private JPanel buildPropsPanel(PrincipalPropertyInfo[] principalProptyInfo) {
        JPanel result = new JPanel();
        this.populatePropsPanel(result, principalProptyInfo);
        return result;
    }

    private void populatePropsPanel(JPanel principalPropPanel, PrincipalPropertyInfo[] principalProptyInfo) {
        GridBagLayout propLayout = new GridBagLayout();
        principalPropPanel.setLayout(propLayout);
        LabelWidget propetyName = new LabelWidget("Property Name");
        LabelWidget PropertyValue = new LabelWidget("Property Value");
        JPanel labelPanel = new JPanel(new GridLayout(1, 2));
        JPanel labelPanelPNOuter = new JPanel();
        JPanel labelPanelPVOuter = new JPanel();
        labelPanelPNOuter.add((Component)propetyName);
        labelPanelPVOuter.add((Component)PropertyValue);
        labelPanel.add(labelPanelPNOuter);
        labelPanel.add(labelPanelPVOuter);
        labelPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        TextFieldWidget[] propTFW = new TextFieldWidget[principalProptyInfo.length];
        TextFieldWidget[] propValeTFW = new TextFieldWidget[principalProptyInfo.length];
        JPanel propPanel = new JPanel(new GridLayout(principalProptyInfo.length, 2));
        for (int i = 0; i < principalProptyInfo.length; ++i) {
            propTFW[i] = new TextFieldWidget(principalProptyInfo[i].getDisplayName());
            propTFW[i].setContextMenuEnabled(false);
            propTFW[i].setEnabled(false);
            propPanel.add((Component)propTFW[i]);
            propValeTFW[i] = new TextFieldWidget(principalProptyInfo[i].getValue());
            propValeTFW[i].setContextMenuEnabled(false);
            propValeTFW[i].setEnabled(false);
            propPanel.add((Component)propValeTFW[i]);
        }
        JPanel propPanelOuter = new JPanel(new BorderLayout());
        propPanelOuter.add((Component)propPanel, "North");
        ScrollWidget propSW = new ScrollWidget((Component)propPanelOuter);
        ButtonWidget editBW = new ButtonWidget("         Edit...         ");
        editBW.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel buttonPanel = new JPanel();
        if (this.resetPasswordButton != null) {
            buttonPanel.setLayout(new GridLayout(1, 2));
            JPanel buttonPanelPNOuter = new JPanel();
            JPanel buttonPanelPVOuter = new JPanel();
            buttonPanelPNOuter.add((Component)this.resetPasswordButton);
            buttonPanelPVOuter.add((Component)editBW);
            buttonPanel.add(buttonPanelPNOuter);
            buttonPanel.add(buttonPanelPVOuter);
            buttonPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        } else {
            buttonPanel.setLayout(new BorderLayout());
            buttonPanel.add((Component)editBW, "West");
        }
        propLayout.setConstraints(labelPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 5, 3, 5), 0, 0));
        propLayout.setConstraints((Component)propSW, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 17, 1, new Insets(3, 5, 3, 5), 0, 0));
        propLayout.setConstraints(buttonPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 5, 3, 5), 0, 0));
        if (principalProptyInfo.length >= 2) {
            principalPropPanel.add(labelPanel);
        }
        principalPropPanel.add((Component)propSW);
        if (this.canEditPrincipals) {
            principalPropPanel.add(buttonPanel);
        }
    }

    private void createEntity() {
        int type = this.principal.getType() == 0 ? 1 : 0;
        String name = this.principal.getName();
        this.thisEntity = new Entity(name, type);
    }

    private void refreshPrincipalFromEntity() throws AuthorizationException, ComponentNotFoundException, ExternalException {
        this.principal = this.thisEntity.getType() == 1 ? this.manager.refreshPrincipalCache(this.thisEntity.getName()) : this.manager.refreshGroupPrincipalCache(this.thisEntity.getName());
    }

    private void setPrincipalFromEntity() throws AuthorizationException, ComponentNotFoundException, ExternalException {
        this.principal = this.thisEntity.getType() == 1 ? this.manager.getUserPrincipal(this.thisEntity.getName()) : this.manager.getGroupPrincipal(this.thisEntity.getName());
    }

    private void editButtonPressed() {
        String[] initValues = this.propertiesInitialValues();
        PrincipalPropertiesDialog dlg = new PrincipalPropertiesDialog(this.manager, (NotifyOnPrincipalPropertiesChanged)this, this.thisEntity, initValues);
        dlg.show();
    }

    public void propertiesChanged(Properties prop) {
        this.refreshForPropertiesChange();
    }

    private String[] propertiesInitialValues() {
        String[][] propList = this.thisEntity.getType() == 1 ? UserManager.PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_USERS : UserManager.PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_GROUPS;
        String[] initValues = new String[propList.length];
        for (int i = 0; i < initValues.length; ++i) {
            int index = this.initialPropValuesIndex(propList[i][0]);
            initValues[i] = index >= 0 ? this.initialPropValues[index].getValue() : "";
        }
        return initValues;
    }

    private int initialPropValuesIndex(String name) {
        int index = -1;
        int i = 0;
        while (i < this.initialPropValues.length && index < 0) {
            if (name.equals(this.initialPropValues[i].getName())) {
                index = i;
                continue;
            }
            ++i;
        }
        return index;
    }

    private void resetPasswordButtonPressed() {
        ResetPasswordDialog dialog = new ResetPasswordDialog(this.manager, this.thisEntity.getName());
        dialog.show();
    }

    private void refreshForPropertiesChange() {
        try {
            this.refreshPrincipalFromEntity();
            this.setInitialPropValues();
            this.propsPanel.removeAll();
            this.populatePropsPanel(this.propsPanel, this.initialPropValues);
            this.propsPanel.revalidate();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Get Properties for Principal", (Throwable)e);
        }
    }

    public void removeConfirmed(Component caller, PairedEntities[] removalItems) {
        if (caller == this.isMemberOf) {
            this.removeThisPrincipalFromGroups(removalItems);
        } else if (caller == this.containsMembers) {
            this.removePrincipalsFromThisGroup(removalItems);
        } else if (caller == this.hasRoles) {
            this.removeRolesFromThisPrincipal(removalItems);
        }
    }

    public void addPressed(Component caller) {
        if (caller == this.isMemberOf) {
            this.showAddPrincipalAsMemberOf();
        } else if (caller == this.containsMembers) {
            this.showAddAsMembersOfPrincipal();
        } else if (caller == this.hasRoles) {
            this.showAddRolesToPrincipal();
        }
    }

    public void redisplayRoles() {
        try {
            HasRolesListerPanel hrlp = (HasRolesListerPanel)this.hasRoles.getListPanel();
            hrlp.repopulatePanel(this.getPrincipal());
        }
        catch (Exception ex) {
            LogManager.logError((String)"USERS", (Throwable)ex, (String)"Error attempting to repopulate principal detail.");
            ExceptionUtility.showMessage((String)"Attempt to re-populate principal detail", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAddPrincipalAsMemberOf() {
        try {
            StaticUtilities.startWait((Component)((Object)this));
            Collection list = this.manager.getAllMetaMatrixGroupNames();
            list.remove(this.thisEntity.getName());
            String[] descendantGroups = StaticPrincipalUtilities.descendantMetaMatrixGroups((MetaMatrixPrincipal)this.principal, (ConnectionInfo)this.connection);
            for (int i = 0; i < descendantGroups.length; ++i) {
                list.remove(descendantGroups[i]);
            }
            Set thisPrincipalIsMemberOf = this.principal.getGroupNames();
            Iterator iter = thisPrincipalIsMemberOf.iterator();
            while (iter.hasNext()) {
                String groupName = (String)iter.next();
                list.remove(groupName);
            }
            String[] array = new String[list.size()];
            if (array.length == 0) {
                StaticUtilities.displayModalDialogWithOK((String)"No Eligible Groups", (String)("There are no MetaMatrix Groups to which " + this.thisEntity.entityTypeToDisplayString() + " \"" + this.thisEntity.getName() + "\" can be added."));
            } else {
                Iterator it = list.iterator();
                int loc = 0;
                while (it.hasNext()) {
                    array[loc] = (String)it.next();
                    ++loc;
                }
                String[] sortedArray = StaticQuickSorter.quickStringSort((String[])array);
                String title = "Add " + this.thisEntity.entityTypeToDisplayString() + " \"" + this.thisEntity.getName() + "\" as member of:";
                AddDialog dialog = new AddDialog(title, sortedArray);
                dialog.show();
                Collection checkedItems = dialog.getCheckedItems();
                if (checkedItems.size() > 0) {
                    if (this.thisEntity.getType() == 1) {
                        this.manager.addUserMemberToGroups(this.thisEntity.getName(), checkedItems);
                    } else {
                        this.manager.addGroupMemberToGroups(this.thisEntity.getName(), checkedItems);
                    }
                    this.setPrincipalFromEntity();
                    this.isMemberOf.getListPanel().repopulatePanel(this.principal);
                    this.hasRoles.getListPanel().repopulatePanel(this.principal);
                    this.isMemberOfDisplayController.addedAsMemberOf(this.thisEntity, checkedItems);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Add Principal to Groups", (Throwable)e);
        }
        finally {
            StaticUtilities.endWait((Component)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAddAsMembersOfPrincipal() {
        try {
            Collection checkedGroups;
            StaticUtilities.startWait((Component)((Object)this));
            List userList = this.manager.getAllMetaMatrixUserNames();
            Collection userMembers = this.manager.getUserMembersOfGroup(this.thisEntity.getName());
            Iterator it = userMembers.iterator();
            while (it.hasNext()) {
                String member = (String)it.next();
                userList.remove(member);
            }
            Collection groupList = this.manager.getAllMetaMatrixGroupNames();
            groupList.remove(this.thisEntity.getName());
            Collection groupMembers = this.manager.getGroupMembersOfGroup(this.thisEntity.getName());
            it = groupMembers.iterator();
            while (it.hasNext()) {
                String member = (String)it.next();
                groupList.remove(member);
            }
            Set explicitMemberships = this.principal.getGroupNames();
            it = explicitMemberships.iterator();
            while (it.hasNext()) {
                String explicitMemberOf = (String)it.next();
                groupList.remove(explicitMemberOf);
            }
            String[][] implicitMemberships = this.manager.getImplicitGroupMemberships(this.principal);
            for (int i = 0; i < implicitMemberships.length; ++i) {
                groupList.remove(implicitMemberships[i][0]);
            }
            String[] userNamesArray = new String[userList.size()];
            it = userList.iterator();
            int loc = 0;
            while (it.hasNext()) {
                userNamesArray[loc] = (String)it.next();
                ++loc;
            }
            String[] sortedUserNamesArray = StaticQuickSorter.quickStringSort((String[])userNamesArray);
            String[] groupNamesArray = new String[groupList.size()];
            it = groupList.iterator();
            loc = 0;
            while (it.hasNext()) {
                groupNamesArray[loc] = (String)it.next();
                ++loc;
            }
            String[] sortedGroupNamesArray = StaticQuickSorter.quickStringSort((String[])groupNamesArray);
            AddByPrincipalTypeDialog dialog = new AddByPrincipalTypeDialog("Add User and Group Members to Group \"" + this.thisEntity.getName() + "\":", sortedUserNamesArray, sortedGroupNamesArray);
            dialog.show();
            Collection checkedUsers = this.namesOf(dialog.getCheckedUsers());
            if (checkedUsers.size() > 0) {
                this.manager.addUserMembersToGroup(checkedUsers, this.thisEntity.getName());
            }
            if ((checkedGroups = this.namesOf(dialog.getCheckedGroups())).size() > 0) {
                this.manager.addGroupMembersToGroup(checkedGroups, this.thisEntity.getName());
            }
            if (checkedUsers.size() > 0 || checkedGroups.size() > 0) {
                String name;
                this.setPrincipalFromEntity();
                this.containsMembers.getListPanel().repopulatePanel(this.principal);
                ArrayList<Entity> checkedUsersAsEntities = new ArrayList<Entity>();
                ArrayList<Entity> checkedGroupsAsEntities = new ArrayList<Entity>();
                it = checkedUsers.iterator();
                while (it.hasNext()) {
                    name = (String)it.next();
                    checkedUsersAsEntities.add(new Entity(name, 1));
                }
                it = checkedGroups.iterator();
                while (it.hasNext()) {
                    name = (String)it.next();
                    checkedGroupsAsEntities.add(new Entity(name, 0));
                }
                this.hasMembersDisplayController.membersAdded(this.thisEntity.getName(), checkedUsersAsEntities);
                this.hasMembersDisplayController.membersAdded(this.thisEntity.getName(), checkedGroupsAsEntities);
            }
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Add Members to Group", (Throwable)e);
        }
        finally {
            StaticUtilities.endWait((Component)((Object)this));
        }
    }

    private Collection namesOf(Collection mmpn) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = mmpn.iterator();
        while (it.hasNext()) {
            MetaMatrixPrincipalName m = (MetaMatrixPrincipalName)it.next();
            names.add(m.getName());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAddRolesToPrincipal() {
        try {
            RoleDisplay[] explicitRoles = this.manager.getRolesForPrincipal(this.principal, false);
            Map allRoles = this.manager.getRoles();
            ArrayList<String> rolesToDisplay = new ArrayList<String>();
            ArrayList<String> roleNames = new ArrayList<String>();
            Iterator it = allRoles.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String roleName = (String)me.getKey();
                RoleDisplay roleDisplay = (RoleDisplay)me.getValue();
                if (StaticPrincipalUtilities.roleDisplayArrayContainsRole((RoleDisplay[])explicitRoles, (String)roleName)) continue;
                String displayString = roleDisplay.getDisplayName() + " - " + roleDisplay.getDescription();
                roleNames.add(roleName);
                rolesToDisplay.add(displayString);
            }
            String[] rolesArray = new String[rolesToDisplay.size()];
            String[] rolesToDisplayArray = new String[rolesArray.length];
            for (int i = 0; i < rolesArray.length; ++i) {
                rolesArray[i] = (String)roleNames.get(i);
                rolesToDisplayArray[i] = (String)rolesToDisplay.get(i);
            }
            boolean done = false;
            while (!done) {
                done = true;
                for (int i = 0; i < rolesToDisplayArray.length - 1; ++i) {
                    int compVal = rolesToDisplayArray[i].compareToIgnoreCase(rolesToDisplayArray[i + 1]);
                    if (compVal <= 0) continue;
                    done = false;
                    String temp = rolesToDisplayArray[i];
                    rolesToDisplayArray[i] = rolesToDisplayArray[i + 1];
                    rolesToDisplayArray[i + 1] = temp;
                    temp = rolesArray[i];
                    rolesArray[i] = rolesArray[i + 1];
                    rolesArray[i + 1] = temp;
                }
            }
            String title = "Add Roles to " + this.thisEntity.entityTypeToDisplayString() + " \"" + this.thisEntity.getName() + "\":";
            AddDialog dialog = new AddDialog(title, rolesToDisplayArray);
            dialog.show();
            StaticUtilities.startWait((Component)ConsoleMainFrame.getInstance());
            Collection checkedItems = dialog.getCheckedItems();
            if (checkedItems.size() > 0) {
                it = checkedItems.iterator();
                ArrayList<MetaMatrixPrincipalName> principalCollection = new ArrayList<MetaMatrixPrincipalName>();
                MetaMatrixPrincipalName mmName = this.thisEntity.getType() == 0 ? new MetaMatrixPrincipalName(this.thisEntity.getName(), 1) : new MetaMatrixPrincipalName(this.thisEntity.getName(), 0);
                principalCollection.add(mmName);
                while (it.hasNext()) {
                    String roleDesc = (String)((Object)it.next());
                    int index = StaticQuickSorter.stringArrayIndex((String[])rolesToDisplayArray, (String)roleDesc);
                    this.manager.addPrincipalsToRole(principalCollection, rolesArray[index]);
                }
                this.setPrincipalFromEntity();
                this.hasRoles.getListPanel().repopulatePanel(this.principal);
                this.hasRoles.enableAddButton(!StaticPrincipalUtilities.hasAllRoles((MetaMatrixPrincipalName)this.thisEntity.toPrincipalName(), (ConnectionInfo)this.connection));
            }
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Add Roles to Principal", (Throwable)e);
        }
        finally {
            StaticUtilities.endWait((Component)ConsoleMainFrame.getInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeThisPrincipalFromGroups(PairedEntities[] removalItems) {
        try {
            StaticUtilities.startWait((Component)((Object)this));
            ArrayList<String> groups = new ArrayList<String>();
            for (int i = 0; i < removalItems.length; ++i) {
                groups.add(removalItems[i].getSecond().getName());
            }
            if (this.thisEntity.getType() == 1) {
                this.manager.removeUserMemberFromGroups(this.thisEntity.getName(), groups);
            } else {
                this.manager.removeGroupMemberFromGroups(this.thisEntity.getName(), groups);
            }
            this.setPrincipalFromEntity();
            this.isMemberOf.getListPanel().repopulatePanel(this.principal);
            this.hasRoles.getListPanel().repopulatePanel(this.principal);
            this.isMemberOfDisplayController.removedAsMemberOf(this.thisEntity, groups);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Remove Principal from Groups", (Throwable)e);
        }
        finally {
            StaticUtilities.endWait((Component)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePrincipalsFromThisGroup(PairedEntities[] removalItems) {
        try {
            StaticUtilities.startWait((Component)((Object)this));
            ArrayList<String> userMembers = new ArrayList<String>();
            ArrayList<String> groupMembers = new ArrayList<String>();
            ArrayList<Entity> userMembersAsEntities = new ArrayList<Entity>();
            ArrayList<Entity> groupMembersAsEntities = new ArrayList<Entity>();
            for (int i = 0; i < removalItems.length; ++i) {
                String name = removalItems[i].getFirst().getName();
                int type = removalItems[i].getFirst().getType();
                if (type == 1) {
                    userMembers.add(name);
                    userMembersAsEntities.add(new Entity(name, 1));
                    continue;
                }
                groupMembers.add(name);
                groupMembersAsEntities.add(new Entity(name, 0));
            }
            if (userMembers.size() > 0) {
                this.manager.removeUserMembersFromGroup(userMembers, this.thisEntity.getName());
            }
            if (groupMembers.size() > 0) {
                this.manager.removeGroupMembersFromGroup(groupMembers, this.thisEntity.getName());
            }
            this.setPrincipalFromEntity();
            this.containsMembers.getListPanel().repopulatePanel(this.principal);
            this.hasMembersDisplayController.membersRemoved(this.thisEntity.getName(), userMembersAsEntities);
            this.hasMembersDisplayController.membersRemoved(this.thisEntity.getName(), groupMembersAsEntities);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Remove Members from Group", (Throwable)e);
        }
        finally {
            StaticUtilities.endWait((Component)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRolesFromThisPrincipal(PairedEntities[] removalItems) {
        try {
            StaticUtilities.startWait((Component)((Object)this));
            String[] roles = new String[removalItems.length];
            Map mapOfRoles = this.manager.getRoles();
            HashMap<String, String> holderMap = new HashMap<String, String>();
            Iterator it = mapOfRoles.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                RoleDisplay display = (RoleDisplay)entry.getValue();
                holderMap.put(display.getDisplayName(), display.getName());
            }
            for (int i = 0; i < roles.length; ++i) {
                String displayKey = removalItems[i].getFirst().getName();
                roles[i] = (String)holderMap.get(displayKey);
            }
            MetaMatrixPrincipalName mmName = this.thisEntity.getType() == 1 ? new MetaMatrixPrincipalName(this.thisEntity.getName(), 0) : new MetaMatrixPrincipalName(this.thisEntity.getName(), 1);
            this.manager.removeRolesFromPrincipal(roles, mmName);
            this.setPrincipalFromEntity();
            this.hasRoles.getListPanel().repopulatePanel(this.principal);
            this.hasRoles.enableAddButton(!StaticPrincipalUtilities.hasAllRoles((MetaMatrixPrincipalName)this.thisEntity.toPrincipalName(), (ConnectionInfo)this.connection));
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Remove Roles from Principal", (Throwable)e);
        }
        finally {
            StaticUtilities.endWait((Component)((Object)this));
        }
    }

    public PrincipalDetail() {
    }

    public static void main(String[] args) {
        PrincipalPropertyInfo[] initPropValues = new PrincipalPropertyInfo[10];
        for (int i = 0; i < 10; ++i) {
            initPropValues[i] = new PrincipalPropertyInfo("test name", "test name1", "test value");
        }
        JFrame frame = new JFrame("test");
        frame.getContentPane().add(new PrincipalDetail().buildPropsPanel(initPropValues));
        frame.setSize(400, 500);
        frame.setVisible(true);
    }

    static /* synthetic */ void access$000(PrincipalDetail x0) {
        x0.resetPasswordButtonPressed();
    }

    static /* synthetic */ Entity access$100(PrincipalDetail x0) {
        return x0.thisEntity;
    }

    static /* synthetic */ JSplitPane access$200(PrincipalDetail x0) {
        return x0.splitter;
    }

    static /* synthetic */ void access$300(PrincipalDetail x0) {
        x0.editButtonPressed();
    }
}

