/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.layout;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.console.connections.ConnectionAndPanel;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ExtensionSourceManager;
import com.metamatrix.console.models.MetadataEntManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.PoolManager;
import com.metamatrix.console.models.ServerLogManager;
import com.metamatrix.console.models.UserManager;
import com.metamatrix.console.notification.RuntimeUpdateNotification;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.NotifyOnExitConsole;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.ConsoleMenuBar;
import com.metamatrix.console.ui.layout.MenuEntry;
import com.metamatrix.console.ui.layout.PanelsTree;
import com.metamatrix.console.ui.layout.PendingPanel;
import com.metamatrix.console.ui.layout.Workspace;
import com.metamatrix.console.ui.layout.WorkspaceControllerWorkItem;
import com.metamatrix.console.ui.layout.WorkspaceControllerWorkerFactory;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.ui.views.connector.ConnectorPanel;
import com.metamatrix.console.ui.views.connectorbinding.ConnectorBindingPanel;
import com.metamatrix.console.ui.views.deploy.DeployMainPanel;
import com.metamatrix.console.ui.views.entitlements.EntitlementsDataInterface;
import com.metamatrix.console.ui.views.entitlements.EntitlementsPanel;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourcesPanel;
import com.metamatrix.console.ui.views.logsetup.SystemLogSetUpPanel;
import com.metamatrix.console.ui.views.metadataent.MetEntsPanel;
import com.metamatrix.console.ui.views.pools.PoolsConfigurationPanel;
import com.metamatrix.console.ui.views.pools.PoolsPanel;
import com.metamatrix.console.ui.views.properties.PropertiesMasterPanel;
import com.metamatrix.console.ui.views.queries.QueryPanel;
import com.metamatrix.console.ui.views.resources.ResourcesMainPanel;
import com.metamatrix.console.ui.views.runtime.RuntimeMgmtPanel;
import com.metamatrix.console.ui.views.sessions.SessionPanel;
import com.metamatrix.console.ui.views.summary.SummaryPanel;
import com.metamatrix.console.ui.views.syslog.SysLogPanel;
import com.metamatrix.console.ui.views.users.GroupsMain;
import com.metamatrix.console.ui.views.users.RolesMain;
import com.metamatrix.console.ui.views.users.UsersMain;
import com.metamatrix.console.ui.views.vdb.VdbMainPanel;
import com.metamatrix.console.util.AutoRefreshable;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.Refreshable;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.console.util.StaticUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;

public class WorkspaceController
implements NotifyOnExitConsole {
    private static WorkspaceController theController = null;
    private List panels = new ArrayList(50);
    private HashMap hmAutoRefreshables = null;
    private Workspace workspace;
    private ConnectionAndPanel currentlyDisplayedPanel = null;
    private boolean programmaticConnectionSelectionChange = false;
    private boolean changingConnections = false;
    private WorkerPool workerPool;
    static /* synthetic */ Class class$com$metamatrix$console$ui$layout$PanelsTreeModel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$sessions$SessionPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$summary$SummaryPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$queries$QueryPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$users$UsersMain;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$users$GroupsMain;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$users$RolesMain;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$vdb$VdbMainPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$properties$PropertiesMasterPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$connector$ConnectorPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$connectorbinding$ConnectorBindingPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$entitlements$EntitlementsPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$metadataent$MetEntsPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$extensionsource$ExtensionSourcesPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$deploy$DeployMainPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$syslog$SysLogPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$runtime$RuntimeMgmtPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$logsetup$SystemLogSetUpPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$pools$PoolsPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$pools$PoolsConfigurationPanel;
    static /* synthetic */ Class class$com$metamatrix$console$ui$views$resources$ResourcesMainPanel;
    static /* synthetic */ Class class$java$lang$ClassNotFoundException;

    private WorkspaceController(Workspace ws) {
        this.workspace = ws;
        this.workerPool = new WorkerPool("WorkspaceControllerQueue", (QueueWorkerFactory)new WorkspaceControllerWorkerFactory(), 1, 1000L);
    }

    public static void createInstance(Workspace workspace) {
        if (theController != null) {
            String message = "Attempt to create duplicate WorkspaceController";
            LogManager.logError((String)"INITIALIZATION", (String)message);
            throw new RuntimeException(message);
        }
        theController = new WorkspaceController(workspace);
    }

    public static WorkspaceController getInstance() {
        return theController;
    }

    public void connectionSelectionChanged(final ConnectionInfo connection) {
        if (!this.programmaticConnectionSelectionChange) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        WorkspaceController.this.changingConnections = true;
                        int loc = WorkspaceController.this.panels.size() - 1;
                        ConnectionAndPanel cp = null;
                        while (cp == null && loc >= 0) {
                            ConnectionAndPanel thisCP = (ConnectionAndPanel)WorkspaceController.this.panels.get(loc);
                            if (connection.equals((Object)thisCP.getConnection())) {
                                cp = new ConnectionAndPanel(connection, thisCP.getPanelClass(), thisCP.getPanel());
                                continue;
                            }
                            --loc;
                        }
                        if (cp == null) {
                            Class panelClass = ConsoleMainFrame.INITIAL_PANEL_CLASS;
                            WorkspacePanel panel = WorkspaceController.this.createPanelOfClass(panelClass, connection);
                            cp = new ConnectionAndPanel(connection, panelClass, panel);
                        }
                        PanelsTree tree = PanelsTree.getInstance((ConnectionInfo)connection);
                        ConsoleMainFrame.getInstance().displayTreeForConnection(connection);
                        tree.selectNodeForPanel(cp);
                        WorkspaceController.this.treeSelectionChangedToClass(cp.getPanelClass(), true, connection);
                        WorkspaceController.this.changingConnections = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        }
    }

    public boolean isChangingConnections() {
        return this.changingConnections;
    }

    public void treeSelectionChangedToClass(Class clazz, boolean showThePanel, ConnectionInfo connection) {
        try {
            WorkspaceControllerWorkItem item = new WorkspaceControllerWorkItem(clazz, showThePanel, connection);
            this.workerPool.addWork((Object)item);
        }
        catch (QueueSuspendedException e) {
            LogManager.logError((String)"GENERAL", (Throwable)e, (String)"WorkspaceControllerWorkerPool is suspended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doChangePanel(WorkspaceControllerWorkItem item) {
        Class clazz = item.clazz;
        boolean showThePanel = item.showThePanel;
        ConnectionInfo connection = item.connection;
        if (clazz != null) {
            try {
                ConnectionAndPanel cp;
                ConsoleMenuBar.getInstance().emptyTheActionsMenu();
                WorkspacePanel panel = this.getPanelOfClass(clazz, connection);
                boolean panelAdded = false;
                if (panel == null) {
                    panel = this.createPanelOfClass(clazz, connection);
                    cp = new ConnectionAndPanel(connection, panel.getClass(), panel);
                    this.panels.add(cp);
                    panelAdded = true;
                }
                if (panel != null) {
                    block18: {
                        int index;
                        cp = new ConnectionAndPanel(connection, panel.getClass(), panel);
                        if (!panelAdded && (index = this.panelsIndex(cp)) >= 0) {
                            this.panels.remove(index);
                        }
                        if (panel instanceof GroupsMain) {
                            ((GroupsMain)panel).refreshGroupTree();
                        }
                        if (panel instanceof UsersMain) {
                            boolean alreadyWaiting = StaticUtilities.isShowingWaitCursor();
                            try {
                                if (!alreadyWaiting) {
                                    ConsoleMainFrame.getInstance().getMainTree().setCursor(Cursor.getPredefinedCursor(3));
                                    StaticUtilities.startWait((Component)ConsoleMainFrame.getInstance());
                                }
                                ((UsersMain)panel).refreshUserTree();
                                Object var10_10 = null;
                                if (alreadyWaiting) break block18;
                                ConsoleMainFrame.getInstance().getMainTree().setCursor(Cursor.getDefaultCursor());
                            }
                            catch (Throwable throwable) {
                                Object var10_11 = null;
                                if (!alreadyWaiting) {
                                    ConsoleMainFrame.getInstance().getMainTree().setCursor(Cursor.getDefaultCursor());
                                    StaticUtilities.endWait((Component)ConsoleMainFrame.getInstance());
                                }
                                throw throwable;
                            }
                            StaticUtilities.endWait((Component)ConsoleMainFrame.getInstance());
                            {
                            }
                        }
                    }
                    if (panel instanceof RolesMain) {
                        ((RolesMain)panel).refreshData();
                    }
                    if (!panelAdded) {
                        this.panels.add(cp);
                        panelAdded = true;
                    }
                    this.updateActions(panel);
                    if (showThePanel) {
                        this.workspace.showPanel(panel);
                    }
                } else if (this.currentlyDisplayedPanel != null) {
                    PanelsTree.getInstance((ConnectionInfo)connection).selectNodeForPanel(this.currentlyDisplayedPanel);
                }
                if (panel != null) {
                    this.currentlyDisplayedPanel = new ConnectionAndPanel(connection, clazz, panel);
                }
            }
            catch (Exception theException) {
                ExceptionUtility.showMessage((String)("Problem occurred changing to panel " + clazz), (Throwable)theException);
                LogManager.logError((String)"GENERAL", (Throwable)theException, (String)("Changing tree selection to " + clazz));
            }
        }
    }

    public void handleUpdateNotification(ConnectionInfo connection, RuntimeUpdateNotification notification) {
        int numPanels = this.panels.size();
        for (int i = numPanels - 1; i >= 0; --i) {
            ConnectionAndPanel cp = (ConnectionAndPanel)this.panels.get(i);
            ConnectionInfo thisConnection = cp.getConnection();
            if (thisConnection != connection) continue;
            WorkspacePanel panel = cp.getPanel();
            panel.receiveUpdateNotification(notification);
        }
    }

    private int panelsIndex(ConnectionAndPanel cp) {
        int matchIndex = -1;
        int index = 0;
        int panelsSize = this.panels.size();
        while (matchIndex < 0 && index < panelsSize) {
            ConnectionAndPanel curCP = (ConnectionAndPanel)this.panels.get(index);
            if (cp.getConnection().equals((Object)curCP.getConnection()) && cp.getPanelClass().getName().equals(curCP.getPanelClass().getName())) {
                matchIndex = index;
                continue;
            }
            ++index;
        }
        return matchIndex;
    }

    public void updateActions(WorkspacePanel panel) {
        ArrayList actions = panel.resume();
        if (actions == null) {
            actions = new ArrayList(1);
        }
        if (actions.size() > 0) {
            Object oTemp = actions.get(0);
            if (oTemp instanceof Action) {
                ConsoleMenuBar.getInstance().setActions(actions);
            } else if (oTemp instanceof MenuEntry) {
                ConsoleMenuBar.getInstance().addActionsFromMenuEntryObjects(actions);
            }
        } else {
            ConsoleMenuBar.getInstance().addActionsFromMenuEntryObjects(actions);
        }
        boolean refreshable = panel instanceof Refreshable;
        ConsoleMenuBar.getInstance().setDefaultRefreshEnabled(refreshable);
    }

    public WorkspacePanel getPanelOfClass(Class cls, ConnectionInfo connection) {
        String className = cls.getName();
        WorkspacePanel panel = null;
        int i = this.panels.size() - 1;
        while (panel == null && i >= 0) {
            ConnectionAndPanel cp = (ConnectionAndPanel)this.panels.get(i);
            if (connection.equals((Object)cp.getConnection())) {
                WorkspacePanel current = cp.getPanel();
                String currentClassName = current.getClass().getName();
                if (className.equals(currentClassName)) {
                    panel = current;
                    continue;
                }
                --i;
                continue;
            }
            --i;
        }
        return panel;
    }

    public WorkspacePanel createPanelOfClass(Class cls, ConnectionInfo connection) {
        PendingPanel panel = null;
        if (cls == (class$com$metamatrix$console$ui$layout$PanelsTreeModel == null ? (class$com$metamatrix$console$ui$layout$PanelsTreeModel = WorkspaceController.class$("com.metamatrix.console.ui.layout.PanelsTreeModel")) : class$com$metamatrix$console$ui$layout$PanelsTreeModel)) {
            panel = new PendingPanel();
        } else if (cls == (class$com$metamatrix$console$ui$views$sessions$SessionPanel == null ? (class$com$metamatrix$console$ui$views$sessions$SessionPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.sessions.SessionPanel")) : class$com$metamatrix$console$ui$views$sessions$SessionPanel)) {
            panel = this.createSessionsPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$summary$SummaryPanel == null ? (class$com$metamatrix$console$ui$views$summary$SummaryPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.summary.SummaryPanel")) : class$com$metamatrix$console$ui$views$summary$SummaryPanel)) {
            panel = this.createSummaryPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$queries$QueryPanel == null ? (class$com$metamatrix$console$ui$views$queries$QueryPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.queries.QueryPanel")) : class$com$metamatrix$console$ui$views$queries$QueryPanel)) {
            panel = this.createQueriesPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$users$UsersMain == null ? (class$com$metamatrix$console$ui$views$users$UsersMain = WorkspaceController.class$("com.metamatrix.console.ui.views.users.UsersMain")) : class$com$metamatrix$console$ui$views$users$UsersMain)) {
            panel = this.createUsersPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$users$GroupsMain == null ? (class$com$metamatrix$console$ui$views$users$GroupsMain = WorkspaceController.class$("com.metamatrix.console.ui.views.users.GroupsMain")) : class$com$metamatrix$console$ui$views$users$GroupsMain)) {
            panel = this.createGroupsPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$users$RolesMain == null ? (class$com$metamatrix$console$ui$views$users$RolesMain = WorkspaceController.class$("com.metamatrix.console.ui.views.users.RolesMain")) : class$com$metamatrix$console$ui$views$users$RolesMain)) {
            panel = this.createRolesPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$vdb$VdbMainPanel == null ? (class$com$metamatrix$console$ui$views$vdb$VdbMainPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.vdb.VdbMainPanel")) : class$com$metamatrix$console$ui$views$vdb$VdbMainPanel)) {
            panel = this.createVDBPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$properties$PropertiesMasterPanel == null ? (class$com$metamatrix$console$ui$views$properties$PropertiesMasterPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.properties.PropertiesMasterPanel")) : class$com$metamatrix$console$ui$views$properties$PropertiesMasterPanel)) {
            panel = this.createSystemPropertiesPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$connector$ConnectorPanel == null ? (class$com$metamatrix$console$ui$views$connector$ConnectorPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.connector.ConnectorPanel")) : class$com$metamatrix$console$ui$views$connector$ConnectorPanel)) {
            panel = this.createConnectorDefsPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$connectorbinding$ConnectorBindingPanel == null ? (class$com$metamatrix$console$ui$views$connectorbinding$ConnectorBindingPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.connectorbinding.ConnectorBindingPanel")) : class$com$metamatrix$console$ui$views$connectorbinding$ConnectorBindingPanel)) {
            panel = this.createConnectorBindingsPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$entitlements$EntitlementsPanel == null ? (class$com$metamatrix$console$ui$views$entitlements$EntitlementsPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.entitlements.EntitlementsPanel")) : class$com$metamatrix$console$ui$views$entitlements$EntitlementsPanel)) {
            panel = this.createEntitlementsViewPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$metadataent$MetEntsPanel == null ? (class$com$metamatrix$console$ui$views$metadataent$MetEntsPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.metadataent.MetEntsPanel")) : class$com$metamatrix$console$ui$views$metadataent$MetEntsPanel)) {
            panel = this.createMDEntPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$extensionsource$ExtensionSourcesPanel == null ? (class$com$metamatrix$console$ui$views$extensionsource$ExtensionSourcesPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.extensionsource.ExtensionSourcesPanel")) : class$com$metamatrix$console$ui$views$extensionsource$ExtensionSourcesPanel)) {
            panel = this.createExtensionSourcesPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$deploy$DeployMainPanel == null ? (class$com$metamatrix$console$ui$views$deploy$DeployMainPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.deploy.DeployMainPanel")) : class$com$metamatrix$console$ui$views$deploy$DeployMainPanel)) {
            panel = this.createDeployMainPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$syslog$SysLogPanel == null ? (class$com$metamatrix$console$ui$views$syslog$SysLogPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.syslog.SysLogPanel")) : class$com$metamatrix$console$ui$views$syslog$SysLogPanel)) {
            panel = this.createLogPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$runtime$RuntimeMgmtPanel == null ? (class$com$metamatrix$console$ui$views$runtime$RuntimeMgmtPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.runtime.RuntimeMgmtPanel")) : class$com$metamatrix$console$ui$views$runtime$RuntimeMgmtPanel)) {
            panel = this.createRuntimeMgmtPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$logsetup$SystemLogSetUpPanel == null ? (class$com$metamatrix$console$ui$views$logsetup$SystemLogSetUpPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.logsetup.SystemLogSetUpPanel")) : class$com$metamatrix$console$ui$views$logsetup$SystemLogSetUpPanel)) {
            panel = this.createSystemLogSetupPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$pools$PoolsPanel == null ? (class$com$metamatrix$console$ui$views$pools$PoolsPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.pools.PoolsPanel")) : class$com$metamatrix$console$ui$views$pools$PoolsPanel)) {
            panel = this.createPoolsPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$pools$PoolsConfigurationPanel == null ? (class$com$metamatrix$console$ui$views$pools$PoolsConfigurationPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.pools.PoolsConfigurationPanel")) : class$com$metamatrix$console$ui$views$pools$PoolsConfigurationPanel)) {
            panel = this.createPoolsConfigurationPanel(connection);
        } else if (cls == (class$com$metamatrix$console$ui$views$resources$ResourcesMainPanel == null ? (class$com$metamatrix$console$ui$views$resources$ResourcesMainPanel = WorkspaceController.class$("com.metamatrix.console.ui.views.resources.ResourcesMainPanel")) : class$com$metamatrix$console$ui$views$resources$ResourcesMainPanel)) {
            panel = this.createResourcesPanel(connection);
        }
        if (panel instanceof AutoRefreshable) {
            this.addToAutoRefreshableXref(panel);
        }
        return panel;
    }

    public void deletePanelsForConnection(ConnectionInfo connection) {
        ConnectionInfo currentConnection = this.currentlyDisplayedPanel.getConnection();
        boolean replaceCurrentPanel = currentConnection.equals((Object)connection) && this.panels.size() > 0;
        int listSize = this.panels.size();
        for (int i = listSize - 1; i >= 0; --i) {
            ConnectionAndPanel panel = (ConnectionAndPanel)this.panels.get(i);
            if (!panel.getConnection().equals((Object)connection)) continue;
            this.panels.remove(i);
        }
        if (replaceCurrentPanel) {
            ConnectionAndPanel lastPanel = (ConnectionAndPanel)this.panels.get(this.panels.size() - 1);
            PanelsTree.getInstance((ConnectionInfo)lastPanel.getConnection()).selectNodeForPanel(lastPanel);
            this.programmaticConnectionSelectionChange = true;
            ConsoleMainFrame.getInstance().selectConnection(connection);
            this.programmaticConnectionSelectionChange = false;
        }
    }

    private WorkspacePanel createSummaryPanel(ConnectionInfo connection) {
        SummaryPanel panel = new SummaryPanel(connection);
        return panel;
    }

    private WorkspacePanel createSessionsPanel(ConnectionInfo connection) {
        SessionPanel panel = null;
        try {
            panel = new SessionPanel(connection);
            panel.createComponent();
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage((String)"Create Sessions Panel", (Throwable)ex);
        }
        return panel;
    }

    private DeployMainPanel createDeployMainPanel(ConnectionInfo connection) {
        DeployMainPanel pnl = null;
        try {
            pnl = new DeployMainPanel(connection);
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage((String)"Create DeployMainPanel", (Throwable)theException);
        }
        return pnl;
    }

    private RuntimeMgmtPanel createRuntimeMgmtPanel(ConnectionInfo connection) {
        RuntimeMgmtPanel pnl = null;
        try {
            pnl = new RuntimeMgmtPanel(connection);
        }
        catch (Exception theException) {
            ExceptionUtility.showMessage((String)"Create RuntimeMgmtPanel", (Throwable)theException);
        }
        return pnl;
    }

    private WorkspacePanel createQueriesPanel(ConnectionInfo connection) {
        QueryPanel panel = null;
        try {
            panel = new QueryPanel(connection);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage((String)"Create Queries Panel", (Throwable)ex);
        }
        return panel;
    }

    private WorkspacePanel createSystemPropertiesPanel(ConnectionInfo connection) {
        PropertiesMasterPanel pPanel = new PropertiesMasterPanel(connection);
        pPanel.createComponent();
        return pPanel;
    }

    private WorkspacePanel createConnectorDefsPanel(ConnectionInfo connection) {
        ConnectorPanel panel = new ConnectorPanel(connection);
        return panel;
    }

    private WorkspacePanel createConnectorBindingsPanel(ConnectionInfo connection) {
        ConnectorBindingPanel panel = new ConnectorBindingPanel(connection);
        return panel;
    }

    private WorkspacePanel createUsersPanel(ConnectionInfo connection) {
        UsersMain panel = null;
        try {
            UserCapabilities cap = UserCapabilities.getInstance();
            UserManager userManager = ModelManager.getUserManager((ConnectionInfo)connection);
            panel = new UsersMain(userManager, true, cap.canViewPrincipalInfo(connection), cap.canModifyPrincipalInfo(connection), cap.canViewRoleInfo(connection), cap.canModifyRoleInfo(connection), cap.canResetPassword(connection), true, false, false);
            panel.createComponent();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Create Users panel", (Throwable)e);
        }
        return panel;
    }

    private WorkspacePanel createGroupsPanel(ConnectionInfo connection) {
        GroupsMain panel = null;
        try {
            UserCapabilities cap = UserCapabilities.getInstance();
            UserManager userManager = ModelManager.getUserManager((ConnectionInfo)connection);
            panel = new GroupsMain(userManager, true, cap.canViewPrincipalInfo(connection), cap.canModifyPrincipalInfo(connection), cap.canViewRoleInfo(connection), cap.canModifyRoleInfo(connection), cap.canResetPassword(connection), false, true, false);
            panel.createComponent();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Create Groups panel", (Throwable)e);
        }
        return panel;
    }

    private WorkspacePanel createRolesPanel(ConnectionInfo connection) {
        RolesMain panel = null;
        try {
            UserCapabilities cap = UserCapabilities.getInstance();
            UserManager userManager = ModelManager.getUserManager((ConnectionInfo)connection);
            panel = new RolesMain(userManager, true, cap.canViewPrincipalInfo(connection), cap.canModifyPrincipalInfo(connection), cap.canViewRoleInfo(connection), cap.canModifyRoleInfo(connection), cap.canResetPassword(connection));
            panel.createComponent();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage((String)"Create Roles panel", (Throwable)e);
        }
        return panel;
    }

    private WorkspacePanel createEntitlementsViewPanel(ConnectionInfo connection) {
        EntitlementsPanel entPanel = null;
        try {
            entPanel = new EntitlementsPanel((EntitlementsDataInterface)ModelManager.getEntitlementManager((ConnectionInfo)connection), true, true, connection);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage((String)"Create Data Node Entitlements panel", (Throwable)ex);
        }
        return entPanel;
    }

    private WorkspacePanel createMDEntPanel(ConnectionInfo connection) {
        MetEntsPanel mdPanel = null;
        try {
            UserCapabilities cap = UserCapabilities.getInstance();
            boolean canModify = cap.canModifyEntitlements(connection);
            MetadataEntManager mgr = ModelManager.getMetadataEntManager((ConnectionInfo)connection);
            mdPanel = new MetEntsPanel(mgr, canModify, connection);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage((String)"Create MetaBase Entitlements panel", (Throwable)ex);
        }
        return mdPanel;
    }

    private WorkspacePanel createPoolsPanel(ConnectionInfo connection) {
        PoolsPanel poolsPanel = null;
        try {
            UserCapabilities cap = UserCapabilities.getInstance();
            boolean canModify = cap.canModifyPools(connection);
            PoolManager mgr = ModelManager.getPoolManager((ConnectionInfo)connection);
            poolsPanel = new PoolsPanel(mgr, canModify, connection);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage((String)"Create Pools panel", (Throwable)ex);
        }
        return poolsPanel;
    }

    private WorkspacePanel createPoolsConfigurationPanel(ConnectionInfo connection) {
        PoolsConfigurationPanel pcp = null;
        try {
            UserCapabilities cap = UserCapabilities.getInstance();
            boolean canModify = cap.canModifyPools(connection);
            PoolManager mgr = ModelManager.getPoolManager((ConnectionInfo)connection);
            pcp = new PoolsConfigurationPanel(mgr, canModify, connection);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage((String)"Create Pools Configuration panel", (Throwable)ex);
        }
        return pcp;
    }

    private WorkspacePanel createResourcesPanel(ConnectionInfo connection) {
        ResourcesMainPanel rp = null;
        try {
            UserCapabilities cap = UserCapabilities.getInstance();
            boolean canModify = cap.canModifyResources(connection);
            PoolManager mgr = ModelManager.getPoolManager((ConnectionInfo)connection);
            rp = new ResourcesMainPanel(mgr, canModify, connection);
        }
        catch (Exception ex) {
            ExceptionUtility.showMessage((String)"Create Resources panel", (Throwable)ex);
        }
        return rp;
    }

    private WorkspacePanel createExtensionSourcesPanel(ConnectionInfo connection) {
        ExtensionSourceManager manager = ModelManager.getExtensionSourceManager((ConnectionInfo)connection);
        UserCapabilities cap = null;
        try {
            cap = UserCapabilities.getInstance();
        }
        catch (Exception ex) {
            // empty catch block
        }
        ExtensionSourcesPanel extPanel = new ExtensionSourcesPanel(manager, cap.canModifyExtensionSources(connection), connection);
        return extPanel;
    }

    private WorkspacePanel createVDBPanel(ConnectionInfo connection) {
        VdbMainPanel panel = new VdbMainPanel(connection);
        return panel;
    }

    private WorkspacePanel createLogPanel(ConnectionInfo connection) {
        SysLogPanel panel = null;
        try {
            panel = new SysLogPanel(connection);
        }
        catch (Exception ex) {
            panel = null;
            String msg = ExceptionUtility.containsExceptionOfType((Throwable)ex, (Class)(class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = WorkspaceController.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException)) ? "Unable to create Log Viewer.  Please ensure that JDBC driver is correctly installed." : "Unable to create Log Viewer panel.";
            ExceptionUtility.showMessage((String)"Error creating Log Viewer Panel", (String)msg, (Throwable)ex);
            LogManager.logError((String)"SYSTEMLOGGING", (Throwable)ex, (String)"Error creating SysLogPanel");
        }
        return panel;
    }

    private WorkspacePanel createSystemLogSetupPanel(ConnectionInfo connection) {
        ServerLogManager manager = ModelManager.getServerLogManager((ConnectionInfo)connection);
        boolean canModify = false;
        try {
            canModify = UserCapabilities.getInstance().canModifyLoggingConfig(connection);
        }
        catch (Exception ex) {
            // empty catch block
        }
        SystemLogSetUpPanel panel = new SystemLogSetUpPanel(manager, canModify, connection);
        return panel;
    }

    public boolean havePendingChanges(ConnectionInfo connection) {
        boolean pending = false;
        for (int i = this.panels.size() - 1; i >= 0 && !pending; --i) {
            WorkspacePanel panel;
            ConnectionAndPanel cp = (ConnectionAndPanel)this.panels.get(i);
            if (connection != null && !connection.equals((Object)cp.getConnection()) || !((panel = cp.getPanel()) instanceof NotifyOnExitConsole)) continue;
            pending = ((NotifyOnExitConsole)panel).havePendingChanges();
        }
        return pending;
    }

    public boolean havePendingChanges() {
        return this.havePendingChanges(null);
    }

    public boolean finishUp(ConnectionInfo connection) {
        boolean exiting = true;
        ArrayList panelsBeforeReordering = new ArrayList(this.panels.size());
        Iterator it = this.panels.iterator();
        while (it.hasNext()) {
            panelsBeforeReordering.add(it.next());
        }
        for (int i = panelsBeforeReordering.size() - 1; i >= 0 && exiting; --i) {
            NotifyOnExitConsole notifyee;
            WorkspacePanel panel;
            ConnectionAndPanel cp = (ConnectionAndPanel)panelsBeforeReordering.get(i);
            if (connection != null && !connection.equals((Object)cp.getConnection()) || !((panel = cp.getPanel()) instanceof NotifyOnExitConsole) || !(notifyee = (NotifyOnExitConsole)panel).havePendingChanges()) continue;
            ConnectionInfo conn = panel.getConnection();
            cp = new ConnectionAndPanel(conn, notifyee.getClass(), panel);
            this.programmaticConnectionSelectionChange = true;
            ConsoleMainFrame.getInstance().selectConnection(conn);
            ConsoleMainFrame.getInstance().displayTreeForConnection(conn);
            ConsoleMainFrame.getInstance().selectPanel(cp);
            this.workspace.showPanel(cp.getPanel());
            this.programmaticConnectionSelectionChange = false;
            exiting = notifyee.finishUp();
        }
        return exiting;
    }

    public boolean finishUp() {
        return this.finishUp(null);
    }

    private HashMap getAutoRefreshableXref() {
        if (this.hmAutoRefreshables == null) {
            this.hmAutoRefreshables = new HashMap();
        }
        return this.hmAutoRefreshables;
    }

    private void addToAutoRefreshableXref(WorkspacePanel wsp) {
        if (wsp instanceof AutoRefreshable) {
            this.getAutoRefreshableXref().put(((AutoRefreshable)wsp).getName(), wsp);
            this.applyAutoRefreshParmsToWorkspacePanel(wsp);
        }
    }

    public void applyAutoRefreshParmsToAll() {
        Collection colAutoRefreshableWorkspacePanels = this.getAutoRefreshableXref().values();
        Iterator itWSPs = colAutoRefreshableWorkspacePanels.iterator();
        while (itWSPs.hasNext()) {
            WorkspacePanel wsp = (WorkspacePanel)itWSPs.next();
            this.applyAutoRefreshParmsToWorkspacePanel(wsp);
        }
    }

    public void applyAutoRefreshParmsToWorkspacePanel(WorkspacePanel wsp) {
        if (!(wsp instanceof AutoRefreshable)) {
            return;
        }
        if (wsp instanceof SummaryPanel) {
            this.applyAutoRefreshParms((AutoRefreshable)wsp, StaticProperties.getSummaryRefreshEnabled(), StaticProperties.getSummaryRefreshRate());
        }
        if (wsp instanceof QueryPanel) {
            this.applyAutoRefreshParms((AutoRefreshable)wsp, StaticProperties.getQueryRefreshEnabled(), StaticProperties.getQueryRefreshRate());
        }
        if (wsp instanceof SessionPanel) {
            this.applyAutoRefreshParms((AutoRefreshable)wsp, StaticProperties.getSessionRefreshEnabled(), StaticProperties.getSessionRefreshRate());
        }
        if (wsp instanceof SysLogPanel) {
            this.applyAutoRefreshParms((AutoRefreshable)wsp, StaticProperties.getSysLogRefreshEnabled(), StaticProperties.getSysLogRefreshRate());
        }
        if (wsp instanceof PoolsPanel) {
            boolean enabled = StaticProperties.getResourcePoolsRefreshEnabled();
            int rate = StaticProperties.getResourcePoolsRefreshRate();
            this.applyAutoRefreshParms((AutoRefreshable)wsp, enabled, rate);
        }
    }

    public void applyAutoRefreshParms(AutoRefreshable refAutoRefreshablePanel, boolean bEnabled, int iRate) {
        refAutoRefreshablePanel.setAutoRefreshEnabled(bEnabled);
        refAutoRefreshablePanel.setRefreshRate(iRate);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

