/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.util.CenteredOptionPane;
import com.metamatrix.console.ui.util.ConsoleConstants;
import com.metamatrix.console.ui.views.entitlements.PrincipalChangeListener;
import com.metamatrix.console.ui.views.users.Entity;
import com.metamatrix.console.ui.views.users.EntityDeletedListener;
import com.metamatrix.console.ui.views.users.InheritedRole;
import com.metamatrix.console.ui.views.users.RoleDisplay;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticPrincipalUtilities;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.admin.api.AuthorizationAdminAPI;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalNames;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.platform.security.api.PasswordCredentials;
import com.metamatrix.platform.security.api.service.MembershipObjectEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class UserManager
extends Manager {
    public static final String[][] PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_USERS = new String[][]{{"commonName", "Common Name"}, {"givenName", "First Name"}, {"surName", "Last Name"}, {"location", "Location"}, {"telephoneNumber", "Telephone #"}};
    public static final String[][] PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_GROUPS = new String[][]{{"description", "Description"}};
    private Map roles = null;
    private List entityDeletedListeners = new ArrayList();
    private HashMap principalCache = new HashMap();
    private HashMap userChildrenCache = new HashMap();
    private HashMap groupChildrenCache = new HashMap();
    private List principalChangeListeners = new ArrayList(1);

    public UserManager(ConnectionInfo connection) {
        super(connection);
    }

    public void init() {
        super.init();
    }

    public Map getRoles() throws ExternalException, AuthorizationException {
        if (this.roles == null) {
            try {
                AuthorizationAdminAPI authAPI = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection());
                this.roles = authAPI.getRoleDescriptions();
                Iterator it = this.roles.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    boolean skipping = this.isSkippedRole(key);
                    if (!skipping) {
                        RoleDisplay roleDisplay = new RoleDisplay(key, val);
                        this.roles.put(key, roleDisplay);
                        continue;
                    }
                    this.roles.remove(key);
                }
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExternalException(e);
            }
        }
        return this.roles;
    }

    public RoleDisplay getRoleDisplay(String roleName) throws ExternalException, AuthorizationException {
        RoleDisplay rd = (RoleDisplay)this.roles.get(roleName);
        return rd;
    }

    public String getRoleDescription(String roleName) throws ExternalException, AuthorizationException {
        String desc = null;
        Map roles = this.getRoles();
        RoleDisplay rd = (RoleDisplay)roles.get(roleName);
        if (rd != null) {
            desc = rd.getDescription();
        }
        return desc;
    }

    public String getRoleDisplayName(String roleName) throws ExternalException, AuthorizationException {
        String displayName = null;
        Map roles = this.getRoles();
        RoleDisplay rd = (RoleDisplay)roles.get(roleName);
        if (rd != null) {
            displayName = rd.getDisplayName();
        }
        return displayName;
    }

    public Collection getPrincipalsForRole(String roleName) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        Collection principals;
        try {
            principals = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).getPrincipalsForRole(roleName);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return principals;
    }

    public RoleDisplay[] getRolesForPrincipal(MetaMatrixPrincipalName principalName, boolean includeImplicit) throws ComponentNotFoundException, AuthorizationException, ExternalException, MetaMatrixSecurityException {
        Collection roles;
        try {
            roles = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).getRoleNamesForPrincipal(principalName, true);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        ArrayList<RoleDisplay> rds = new ArrayList<RoleDisplay>();
        Iterator it = roles.iterator();
        while (it.hasNext()) {
            String roleName = (String)it.next();
            RoleDisplay rd = (RoleDisplay)this.getRoles().get(roleName);
            rds.add(rd);
        }
        if (includeImplicit) {
            InheritedRole[] implicitRoles = this.getImplicitRoles(principalName);
            for (int i = 0; i < implicitRoles.length; ++i) {
                RoleDisplay rd = implicitRoles[i].getRoleDisplay();
                if (rds.contains(rd)) continue;
                rds.add(rd);
            }
        }
        RoleDisplay[] rdArray = new RoleDisplay[rds.size()];
        it = rds.iterator();
        int i = 0;
        while (it.hasNext()) {
            rdArray[i] = (RoleDisplay)it.next();
            ++i;
        }
        return rdArray;
    }

    public RoleDisplay[] getRolesForPrincipal(MetaMatrixPrincipal principal, boolean includeImplicit) throws ComponentNotFoundException, AuthorizationException, ExternalException, MetaMatrixSecurityException {
        return this.getRolesForPrincipal(principal.getMetaMatrixPrincipalName(), includeImplicit);
    }

    public void addPrincipalsToRole(Collection principals, String role) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        try {
            ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).addPrincipalsToRole(new HashSet(principals), role);
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void removePrincipalsFromRole(Collection principals, String role) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        try {
            ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).removePrincipalsFromRole(new HashSet(principals), role);
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void removeRolesFromPrincipal(String[] roles, MetaMatrixPrincipalName principal) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        ArrayList<MetaMatrixPrincipalName> princ = new ArrayList<MetaMatrixPrincipalName>();
        princ.add(principal);
        for (int i = 0; i < roles.length; ++i) {
            this.removePrincipalsFromRole(princ, roles[i]);
        }
    }

    public Collection getRootGroupNames() throws ExternalException, AuthorizationException {
        Collection rootGroupNames;
        try {
            rootGroupNames = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getRootGroupPrincipalNames();
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return rootGroupNames;
    }

    public Collection getMetaMatrixRootGroupNames() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            Collection allRootGroupNames = this.getRootGroupNames();
            Collection allMetaMatrixGroupNames = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getEditablePrincipalNames().getGroupPrincipalNames();
            ArrayList<Collection> coll = new ArrayList<Collection>();
            coll.add(allRootGroupNames);
            coll.add(allMetaMatrixGroupNames);
            Collection allMetaMatrixRootGroupNames = StaticUtilities.intersectionOf(coll);
            return allMetaMatrixRootGroupNames;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public Collection getEnterpriseRootGroupNames() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            Collection allRootGroupNames = this.getRootGroupNames();
            Collection allEnterpriseGroupNames = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getReadonlyPrincipalNames().getGroupPrincipalNames();
            ArrayList<Collection> coll = new ArrayList<Collection>();
            coll.add(allRootGroupNames);
            coll.add(allEnterpriseGroupNames);
            Collection allEnterpriseRootGroupNames = StaticUtilities.intersectionOf(coll);
            return allEnterpriseRootGroupNames;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public Collection getUserMembersOfGroup(String groupID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        Collection members = (Collection)this.userChildrenCache.get(groupID);
        if (members == null) {
            try {
                MetaMatrixPrincipalNames allMembers = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembersOfGroup(groupID);
                members = allMembers.getUserPrincipalNames();
                this.userChildrenCache.put(groupID, members);
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (ComponentNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExternalException(e);
            }
        }
        return members;
    }

    public Collection getGroupMembersOfGroup(String groupID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        String ourGroupID = groupID;
        Collection members = (Collection)this.groupChildrenCache.get(ourGroupID);
        if (members == null) {
            try {
                MetaMatrixPrincipalNames allMembers = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembersOfGroup(ourGroupID);
                members = allMembers.getGroupPrincipalNames();
                this.groupChildrenCache.put(ourGroupID, members);
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (ComponentNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExternalException(e);
            }
        }
        return members;
    }

    public MetaMatrixPrincipal getUserPrincipal(String userID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        MetaMatrixPrincipal principal = (MetaMatrixPrincipal)this.principalCache.get(userID);
        if (principal != null) {
            if (principal.getType() != 0) {
                principal = null;
            }
        } else {
            try {
                principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getUserPrincipal(userID);
                if (principal.getType() != 0) {
                    principal = null;
                } else {
                    this.principalCache.put(userID, principal);
                }
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (ComponentNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExternalException(e);
            }
        }
        return principal;
    }

    public MetaMatrixPrincipal refreshPrincipalCache(String userID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        this.principalCache.clear();
        return this.getUserPrincipal(userID);
    }

    public MetaMatrixPrincipal refreshGroupPrincipalCache(String userID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        this.principalCache.clear();
        return this.getGroupPrincipal(userID);
    }

    public MetaMatrixPrincipal getGroupPrincipal(String groupID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        MetaMatrixPrincipal principal = (MetaMatrixPrincipal)this.principalCache.get(groupID);
        if (principal != null) {
            if (principal.getType() != 1) {
                principal = null;
            }
        } else {
            try {
                principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getGroupPrincipal(groupID);
                if (principal.getType() != 1) {
                    principal = null;
                } else {
                    this.principalCache.put(groupID, principal);
                }
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (ComponentNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExternalException(e);
            }
        }
        return principal;
    }

    public Collection getAllUserNames() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            MetaMatrixPrincipalNames enterprisePrincipals = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getReadonlyPrincipalNames();
            Collection users = enterprisePrincipals.getUserPrincipalNames();
            MetaMatrixPrincipalNames metaMatrixPrincipals = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getEditablePrincipalNames();
            Collection metaMatrixUsers = metaMatrixPrincipals.getUserPrincipalNames();
            users.addAll(metaMatrixUsers);
            this.removeBlockedUsers(users);
            return users;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public Collection getAllGroupNames() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            MetaMatrixPrincipalNames enterprisePrincipals = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getReadonlyPrincipalNames();
            Collection groups = enterprisePrincipals.getGroupPrincipalNames();
            MetaMatrixPrincipalNames metaMatrixPrincipals = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getEditablePrincipalNames();
            Collection metaMatrixGroups = metaMatrixPrincipals.getGroupPrincipalNames();
            groups.addAll(metaMatrixGroups);
            return groups;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public List getAllMetaMatrixUserNames() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        List<Object> users;
        try {
            MetaMatrixPrincipalNames metaMatrixPrincipals = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getEditablePrincipalNames();
            users = Arrays.asList(metaMatrixPrincipals.getUserPrincipalNames().toArray());
            this.removeBlockedUsers(users);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return users;
    }

    public Collection getAllMetaMatrixGroupNames() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        Collection groups;
        try {
            MetaMatrixPrincipalNames metaMatrixPrincipals = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getEditablePrincipalNames();
            groups = metaMatrixPrincipals.getGroupPrincipalNames();
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return groups;
    }

    public List getAllEnterpriseUserNames() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        List<Object> users;
        try {
            MetaMatrixPrincipalNames enterprisePrincipals = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getReadonlyPrincipalNames();
            users = Arrays.asList(enterprisePrincipals.getUserPrincipalNames().toArray());
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return users;
    }

    public Collection getAllEnterpriseGroupNames() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        Collection groups;
        try {
            MetaMatrixPrincipalNames enterprisePrincipals = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getReadonlyPrincipalNames();
            groups = enterprisePrincipals.getGroupPrincipalNames();
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return groups;
    }

    public boolean isEnterprise(MetaMatrixPrincipalName pn) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        Collection allEnterprise = pn.getType() == 0 ? this.getAllEnterpriseUserNames() : this.getAllEnterpriseGroupNames();
        boolean enterprise = allEnterprise.contains(pn.getName());
        return enterprise;
    }

    public String[][] getImplicitGroupMemberships(MetaMatrixPrincipal principal) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        return StaticPrincipalUtilities.implicitGroups((MetaMatrixPrincipal)principal, (boolean)false, (ConnectionInfo)this.getConnection());
    }

    public InheritedRole[] getImplicitRoles(MetaMatrixPrincipalName principalName) throws ExternalException, AuthorizationException, ComponentNotFoundException, MetaMatrixSecurityException {
        return StaticPrincipalUtilities.implicitRoles((MetaMatrixPrincipalName)principalName, (boolean)false, (ConnectionInfo)this.getConnection());
    }

    public boolean userHasActiveConnection(String userID) {
        ConnectionInfo[] connections = ModelManager.getConnections();
        boolean found = false;
        int i = 0;
        while (i < connections.length && !found) {
            String curUser = connections[i].getUser();
            found = userID.equals(curUser);
            if (found) continue;
            ++i;
        }
        return found;
    }

    public boolean userHasSessionRunning(String userID) throws ExternalException {
        Collection cllOfSessions = null;
        try {
            cllOfSessions = ModelManager.getSessionAPI((ConnectionInfo)this.getConnection()).getActiveSessions();
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        Iterator activeSessions = cllOfSessions.iterator();
        while (activeSessions.hasNext()) {
            MetaMatrixSessionInfo sessInfo = (MetaMatrixSessionInfo)activeSessions.next();
            String name = sessInfo.getUserName();
            if (!name.equals(userID)) continue;
            return true;
        }
        return false;
    }

    public boolean canDeleteUserWithRunningSession(String userID) {
        String message = "User \"" + userID + "\" is logged in.  Do you really want to delete user \"" + userID + "\"?";
        int resp = CenteredOptionPane.showConfirmDialog((Component)ViewManager.getMainFrame(), (Object)message, (String)"Confirm Deletion", (int)0);
        return resp != 1;
    }

    public void deleteUser(String userID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            MetaMatrixPrincipal principal = (MetaMatrixPrincipal)this.principalCache.get(userID);
            if (principal == null) {
                principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getUserPrincipal(userID);
            }
            ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).removePrincipalFromAllPolicies(principal.getMetaMatrixPrincipalName());
            moe.remove(principal);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(userID);
            this.removeIDsFromCache(ids);
            this.entityDeleted(new Entity(userID, 1));
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void deleteGroup(String groupID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            MetaMatrixPrincipal principal = (MetaMatrixPrincipal)this.principalCache.get(groupID);
            if (principal == null) {
                principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getGroupPrincipal(groupID);
            }
            ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).removePrincipalFromAllPolicies(principal.getMetaMatrixPrincipalName());
            moe.remove(principal);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(groupID);
            this.removeIDsFromCache(ids);
            this.entityDeleted(new Entity(groupID, 0));
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void addUserMembersToGroup(Collection userIDs, String groupID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            Iterator it = userIDs.iterator();
            ArrayList<MetaMatrixPrincipal> principalsToAdd = new ArrayList<MetaMatrixPrincipal>();
            ArrayList<String> idsToRemoveFromCache = new ArrayList<String>();
            idsToRemoveFromCache.add(groupID);
            while (it.hasNext()) {
                String id = (String)it.next();
                MetaMatrixPrincipal principal = (MetaMatrixPrincipal)this.principalCache.get(id);
                if (principal == null) {
                    principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getUserPrincipal(id);
                }
                principalsToAdd.add(principal);
                idsToRemoveFromCache.add(id);
            }
            moe.addPrincipalsToGroup(principalsToAdd, groupID);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            this.removeIDsFromCache(idsToRemoveFromCache);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void addUserMemberToGroups(String userID, Collection groupIDs) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            MetaMatrixPrincipal userPrincipal = (MetaMatrixPrincipal)this.principalCache.get(userID);
            if (userPrincipal == null) {
                userPrincipal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getUserPrincipal(userID);
            }
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            moe.addPrincipalToGroups(userPrincipal, groupIDs);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            ArrayList<String> idsToRemoveFromCache = new ArrayList<String>();
            idsToRemoveFromCache.add(userID);
            Iterator it = groupIDs.iterator();
            while (it.hasNext()) {
                idsToRemoveFromCache.add((String)it.next());
            }
            this.removeIDsFromCache(idsToRemoveFromCache);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void removeUserMembersFromGroup(Collection userIDs, String groupID) throws AuthorizationException, ComponentNotFoundException, ExternalException {
        try {
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            ArrayList<MetaMatrixPrincipal> principalsToRemove = new ArrayList<MetaMatrixPrincipal>();
            ArrayList<String> idsToRemoveFromCache = new ArrayList<String>();
            idsToRemoveFromCache.add(groupID);
            Iterator it = userIDs.iterator();
            while (it.hasNext()) {
                String id = (String)it.next();
                MetaMatrixPrincipal prin = (MetaMatrixPrincipal)this.principalCache.get(id);
                if (prin == null) {
                    prin = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getUserPrincipal(id);
                }
                principalsToRemove.add(prin);
                idsToRemoveFromCache.add(id);
            }
            moe.removePrincipalsFromGroup(principalsToRemove, groupID);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            this.removeIDsFromCache(idsToRemoveFromCache);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void removeUserMemberFromGroups(String userID, Collection groupIDs) throws AuthorizationException, ComponentNotFoundException, ExternalException {
        try {
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            moe.removePrincipalFromGroups(this.getUserPrincipal(userID), groupIDs);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            ArrayList<String> idsToRemoveFromCache = new ArrayList<String>();
            idsToRemoveFromCache.add(userID);
            Iterator it = groupIDs.iterator();
            while (it.hasNext()) {
                idsToRemoveFromCache.add((String)it.next());
            }
            this.removeIDsFromCache(idsToRemoveFromCache);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void addGroupMembersToGroup(Collection groupIDs, String groupID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            Iterator it = groupIDs.iterator();
            ArrayList<MetaMatrixPrincipal> principalsToAdd = new ArrayList<MetaMatrixPrincipal>();
            ArrayList<String> idsToRemoveFromCache = new ArrayList<String>();
            idsToRemoveFromCache.add(groupID);
            while (it.hasNext()) {
                String id = (String)it.next();
                MetaMatrixPrincipal principal = (MetaMatrixPrincipal)this.principalCache.get(id);
                if (principal == null) {
                    principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getGroupPrincipal(id);
                }
                principalsToAdd.add(principal);
                idsToRemoveFromCache.add(id);
            }
            moe.addPrincipalsToGroup(principalsToAdd, groupID);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            this.removeIDsFromCache(idsToRemoveFromCache);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void addGroupMemberToGroups(String groupID, Collection groupIDs) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            MetaMatrixPrincipal groupPrincipal = (MetaMatrixPrincipal)this.principalCache.get(groupID);
            if (groupPrincipal == null) {
                groupPrincipal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getGroupPrincipal(groupID);
            }
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            moe.addPrincipalToGroups(groupPrincipal, groupIDs);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            ArrayList<String> idsToRemoveFromCache = new ArrayList<String>();
            idsToRemoveFromCache.add(groupID);
            Iterator it = groupIDs.iterator();
            while (it.hasNext()) {
                idsToRemoveFromCache.add((String)it.next());
            }
            this.removeIDsFromCache(idsToRemoveFromCache);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void removeGroupMembersFromGroup(Collection groupIDs, String groupID) throws AuthorizationException, ComponentNotFoundException, ExternalException {
        try {
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            ArrayList<MetaMatrixPrincipal> principalsToRemove = new ArrayList<MetaMatrixPrincipal>();
            ArrayList<String> idsToRemoveFromCache = new ArrayList<String>();
            idsToRemoveFromCache.add(groupID);
            Iterator it = groupIDs.iterator();
            while (it.hasNext()) {
                String id = (String)it.next();
                MetaMatrixPrincipal prin = (MetaMatrixPrincipal)this.principalCache.get(id);
                if (prin == null) {
                    prin = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getGroupPrincipal(id);
                }
                principalsToRemove.add(prin);
                idsToRemoveFromCache.add(id);
            }
            moe.removePrincipalsFromGroup(principalsToRemove, groupID);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            this.removeIDsFromCache(idsToRemoveFromCache);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void removeGroupMemberFromGroups(String groupID, Collection groupIDs) throws AuthorizationException, ComponentNotFoundException, ExternalException {
        try {
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            moe.removePrincipalFromGroups(this.getGroupPrincipal(groupID), groupIDs);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            ArrayList<String> idsToRemoveFromCache = new ArrayList<String>();
            idsToRemoveFromCache.add(groupID);
            Iterator it = groupIDs.iterator();
            while (it.hasNext()) {
                idsToRemoveFromCache.add((String)it.next());
            }
            this.removeIDsFromCache(idsToRemoveFromCache);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public MetaMatrixPrincipal createUser(String userName, String password, String[][] propertyNamesAndValues, List roles) throws ExternalException, AuthorizationException {
        try {
            MetaMatrixPrincipal principal = null;
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            principal = moe.createUser(userName);
            Credentials credentials = this.createEncryptedCredentials(password.toCharArray());
            MetaMatrixSessionID us = this.getConnection().getSessionID();
            moe.setCredentials(us, principal, credentials);
            for (int i = 0; i < propertyNamesAndValues.length; ++i) {
                String name = propertyNamesAndValues[i][0];
                String value = propertyNamesAndValues[i][1];
                moe.addProperty(principal, name, value);
            }
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getUserPrincipal(userName);
            if (!roles.isEmpty()) {
                AuthorizationAdminAPI authAPI = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection());
                MetaMatrixPrincipalName principalName = principal.getMetaMatrixPrincipalName();
                List fullRoleNames = this.convertDisplayRoleNamesToFull(roles);
                authAPI.addPrincipalToRoles(principalName, (Collection)fullRoleNames);
            }
            this.principalCache.put(userName, principal);
            this.entityCreated(new Entity(userName, 1));
            return principal;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public MetaMatrixPrincipal updateUser(String userName, Properties changedProperties) throws ExternalException, ComponentNotFoundException, AuthorizationException {
        MetaMatrixPrincipal principal;
        try {
            principal = this.getUserPrincipal(userName);
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            Iterator<Map.Entry<Object, Object>> it = changedProperties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> me = it.next();
                moe.setProperty(principal, (String)me.getKey(), (String)me.getValue());
            }
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getUserPrincipal(userName);
            this.principalCache.put(userName, principal);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return principal;
    }

    public MetaMatrixPrincipal createGroup(String groupName, String[][] propertyNamesAndValues, List roles) throws ExternalException, AuthorizationException {
        try {
            MetaMatrixPrincipal principal = null;
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            principal = moe.createGroup(groupName);
            for (int i = 0; i < propertyNamesAndValues.length; ++i) {
                String name = propertyNamesAndValues[i][0];
                String value = propertyNamesAndValues[i][1];
                moe.addProperty(principal, name, value);
            }
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getGroupPrincipal(groupName);
            this.principalCache.put(groupName, principal);
            if (!roles.isEmpty()) {
                AuthorizationAdminAPI authAPI = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection());
                MetaMatrixPrincipalName principalName = principal.getMetaMatrixPrincipalName();
                List fullRoleNames = this.convertDisplayRoleNamesToFull(roles);
                authAPI.addPrincipalToRoles(principalName, (Collection)fullRoleNames);
            }
            this.entityCreated(new Entity(groupName, 0));
            return principal;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public MetaMatrixPrincipal updateGroup(String groupName, Properties changedProperties) throws AuthorizationException, ComponentNotFoundException, ExternalException {
        MetaMatrixPrincipal principal;
        try {
            principal = this.getGroupPrincipal(groupName);
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            Iterator<Object> it = changedProperties.keySet().iterator();
            while (it.hasNext()) {
                String sKey = (String)it.next();
                String sValue = (String)changedProperties.get(sKey);
                moe.setProperty(principal, sKey, sValue);
            }
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
            principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getGroupPrincipal(groupName);
            this.principalCache.put(groupName, principal);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return principal;
    }

    public void resetPassword(String userName, char[] newPassword) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        try {
            MetaMatrixPrincipal principal = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getUserPrincipal(userName);
            MembershipObjectEditor moe = ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).getMembershipObjectEditor();
            Credentials credentials = this.createEncryptedCredentials(newPassword);
            MetaMatrixSessionID us = this.getConnection().getSessionID();
            moe.setCredentials(us, principal, credentials);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getMembershipAPI((ConnectionInfo)this.getConnection()).executeMembershipTransaction(actions);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public Map getMetaMatrixPropNamesForUsers() {
        Hashtable<String, String> htPropNamesAndDisplayNames = new Hashtable<String, String>();
        int iOuterLength = PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_USERS.length;
        for (int x = 0; x < iOuterLength; ++x) {
            String[] aryTemp = PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_USERS[x];
            htPropNamesAndDisplayNames.put(aryTemp[0], aryTemp[1]);
        }
        return htPropNamesAndDisplayNames;
    }

    public Map getMetaMatrixPropNamesForGroups() {
        Hashtable<String, String> htPropNamesAndDisplayNames = new Hashtable<String, String>();
        int iOuterLength = PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_GROUPS.length;
        for (int x = 0; x < iOuterLength; ++x) {
            String[] aryTemp = PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_GROUPS[x];
            htPropNamesAndDisplayNames.put(aryTemp[0], aryTemp[1]);
        }
        return htPropNamesAndDisplayNames;
    }

    public void addEntityDeletedListener(EntityDeletedListener listener) {
        int loc = this.entityDeletedListeners.indexOf(listener);
        if (loc < 0) {
            this.entityDeletedListeners.add(listener);
        }
    }

    public void removeEntityDeletedListener(EntityDeletedListener removee) {
        int len = this.entityDeletedListeners.size();
        for (int i = len - 1; i >= 0; --i) {
            EntityDeletedListener listener = (EntityDeletedListener)this.entityDeletedListeners.get(i);
            if (listener != removee) continue;
            this.entityDeletedListeners.remove(i);
        }
    }

    public void addPrincipalChangeListener(PrincipalChangeListener listener) {
        int loc = this.principalChangeListeners.indexOf(listener);
        if (loc < 0) {
            this.principalChangeListeners.add(listener);
        }
    }

    public boolean isSkippedRole(String roleName) {
        boolean skipped = false;
        int i = 0;
        while (!skipped && i < ConsoleConstants.ROLES_NOT_DISPLAYED.length) {
            if (roleName.equals(ConsoleConstants.ROLES_NOT_DISPLAYED[i])) {
                skipped = true;
                continue;
            }
            ++i;
        }
        return skipped;
    }

    private void removeIDsFromCache(Collection IDs) {
        ArrayList idsToRemove = new ArrayList();
        Iterator it = IDs.iterator();
        while (it.hasNext()) {
            idsToRemove.add(it.next());
        }
        for (int nextLocToRemove = 0; nextLocToRemove < idsToRemove.size(); ++nextLocToRemove) {
            String curID = (String)idsToRemove.get(nextLocToRemove);
            this.principalCache.remove(curID);
            this.userChildrenCache.remove(curID);
            this.groupChildrenCache.remove(curID);
            Collection isChildOf = this.childOfParents(curID);
            it = isChildOf.iterator();
            while (it.hasNext()) {
                String parent = (String)it.next();
                if (idsToRemove.contains(parent)) continue;
                idsToRemove.add(parent);
            }
        }
    }

    private Collection childOfParents(String id) {
        Collection ch;
        Map.Entry me;
        ArrayList c = new ArrayList();
        Iterator it = this.userChildrenCache.entrySet().iterator();
        while (it.hasNext()) {
            me = it.next();
            ch = (Collection)me.getValue();
            if (!ch.contains(id)) continue;
            c.add(me.getKey());
        }
        it = this.groupChildrenCache.entrySet().iterator();
        while (it.hasNext()) {
            me = it.next();
            ch = (Collection)me.getValue();
            if (!ch.contains(id)) continue;
            c.add(me.getKey());
        }
        return c;
    }

    private void entityDeleted(Entity entity) {
        EntityDeletedListener listener;
        int i;
        int len = this.entityDeletedListeners.size();
        for (i = len - 1; i >= 0; --i) {
            listener = (EntityDeletedListener)this.entityDeletedListeners.get(i);
            listener.entityDeleted(entity);
        }
        len = this.principalChangeListeners.size();
        for (i = len - 1; i >= 0; --i) {
            listener = (PrincipalChangeListener)this.principalChangeListeners.get(i);
            int type = -1;
            type = entity.getType() == 1 ? 0 : 1;
            listener.principalDeleted(new MetaMatrixPrincipalName(entity.getName(), type));
        }
    }

    private void entityCreated(Entity entity) {
        int len = this.principalChangeListeners.size();
        for (int i = len - 1; i >= 0; --i) {
            PrincipalChangeListener listener = (PrincipalChangeListener)this.principalChangeListeners.get(i);
            int type = -1;
            type = entity.getType() == 1 ? 0 : 1;
            listener.principalCreated(new MetaMatrixPrincipalName(entity.getName(), type));
        }
    }

    private void removeBlockedUsers(Collection users) {
    }

    private List convertDisplayRoleNamesToFull(List roles) {
        ArrayList<String> newList = new ArrayList<String>(roles.size());
        Iterator it = roles.iterator();
        while (it.hasNext()) {
            newList.add(this.convertDisplayRoleNameToFull((String)it.next()));
        }
        return newList;
    }

    private String convertDisplayRoleNameToFull(String displayRoleName) {
        Iterator it = null;
        try {
            it = this.getRoles().entrySet().iterator();
        }
        catch (Exception ex) {
            // empty catch block
        }
        String fullName = null;
        while (it.hasNext() && fullName == null) {
            Map.Entry me = it.next();
            RoleDisplay rd = (RoleDisplay)me.getValue();
            if (!rd.getDisplayName().equals(displayRoleName)) continue;
            fullName = (String)me.getKey();
        }
        return fullName;
    }

    private Credentials createEncryptedCredentials(char[] password) throws CryptoException {
        char[] encryptedPassword = CryptoUtil.stringEncrypt((Encryptor)this.getEncryptor(), (char[])password);
        return new PasswordCredentials(encryptedPassword, true);
    }
}

