/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.EntitlementManager;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.UserManager;
import com.metamatrix.console.ui.views.entitlements.DataNodesTreeModel;
import com.metamatrix.console.ui.views.metadataent.MetEntDetail;
import com.metamatrix.console.ui.views.metadataent.MetEntModificationDetail;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticQuickSorter;
import com.metamatrix.platform.admin.api.AuthorizationAdminAPI;
import com.metamatrix.platform.admin.api.PermissionMetaBaseNode;
import com.metamatrix.platform.admin.api.PermissionMetaBaseTreeView;
import com.metamatrix.platform.admin.api.PermissionNode;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.platform.admin.apiimpl.PermissionMetaBaseTreeViewImpl;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.MetaBaseAuthorizationObjectEditor;
import com.metamatrix.platform.security.api.MetaBasePermissionFactory;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;

public class MetadataEntManager
extends Manager {
    public MetadataEntManager(ConnectionInfo connection) {
        super(connection);
    }

    public MetEntDetail getDetailForEntitlement(String name, boolean canModify) throws AuthorizationException, ComponentNotFoundException, ExternalException {
        MetEntDetail detail = null;
        AuthorizationPolicyID policyID = new AuthorizationPolicyID(name, null, MetaBasePermissionFactory.getRealm());
        AuthorizationPolicy policy = this.getPolicy(policyID);
        String description = policy.getDescription();
        Set allPrincipals = policy.getPrincipals();
        ArrayList metaMatrixUsers = new ArrayList();
        ArrayList metaMatrixGroups = new ArrayList();
        ArrayList enterpriseUsers = new ArrayList();
        ArrayList enterpriseGroups = new ArrayList();
        this.separatePrincipals(allPrincipals, metaMatrixUsers, metaMatrixGroups, enterpriseUsers, enterpriseGroups);
        PermissionMetaBaseTreeViewImpl treeView = null;
        DataNodesTreeModel treeModel = null;
        try {
            PermissionMetaBaseNode root = this.getAPI().getMetaBaseEntitlementTree(policyID);
            treeView = new PermissionMetaBaseTreeViewImpl((PermissionNode)root);
            treeModel = this.convertTreeViewToTreeModel((PermissionMetaBaseTreeView)treeView, canModify);
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (ComponentNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
        detail = new MetEntDetail(name, description, metaMatrixUsers, metaMatrixGroups, enterpriseUsers, enterpriseGroups, (DefaultTreeModel)treeModel, (PermissionTreeView)treeView);
        return detail;
    }

    public void deleteEntitlement(String name) throws AuthorizationException, ExternalException {
        try {
            AuthorizationPolicyID policyID = new AuthorizationPolicyID(name, null, MetaBasePermissionFactory.getRealm());
            MetaBaseAuthorizationObjectEditor moe = this.getAPI().createMetaBaseEditor();
            moe.remove(policyID);
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            this.getAPI().executeTransaction(actions);
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    public void createEntitlement(String name, String description, String copyAuthsFromEntitlement, String copyPrincipalsFromEntitlement) throws AuthorizationException, ExternalException {
        try {
            MetaBaseAuthorizationObjectEditor moe = this.getAPI().createMetaBaseEditor();
            AuthorizationPolicyID policyID = new AuthorizationPolicyID(name, null, MetaBasePermissionFactory.getRealm());
            AuthorizationPolicy policy = moe.createAuthorizationPolicy(policyID);
            String desc = description;
            if (desc == null) {
                desc = "";
            }
            moe.setDescription(policy, desc);
            if (copyAuthsFromEntitlement != null) {
                AuthorizationPolicyID aPolicyID = new AuthorizationPolicyID(copyAuthsFromEntitlement, null, MetaBasePermissionFactory.getRealm());
                AuthorizationPolicy aPolicy = this.getPolicy(aPolicyID);
                policy = moe.clonePolicyPermissions(aPolicy, policy);
            }
            if (copyPrincipalsFromEntitlement != null) {
                AuthorizationPolicyID pPolicyID = new AuthorizationPolicyID(copyPrincipalsFromEntitlement, null, MetaBasePermissionFactory.getRealm());
                AuthorizationPolicy pPolicy = this.getPolicy(pPolicyID);
                policy = moe.clonePolicyPrincipals(pPolicy, policy);
            }
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).executeTransaction(actions);
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    public void modifyEntitlement(MetEntModificationDetail detail, PermissionMetaBaseTreeView treeView) throws AuthorizationException, ExternalException {
        String name = detail.getName();
        AuthorizationPolicyID policyID = new AuthorizationPolicyID(name, null, MetaBasePermissionFactory.getRealm());
        try {
            Collection changedPermissions;
            MetaMatrixPrincipalName prin;
            MetaMatrixPrincipalName prin2;
            AuthorizationPolicy policy = this.getPolicy(policyID);
            MetaBaseAuthorizationObjectEditor moe = this.getAPI().createMetaBaseEditor();
            String newDescription = detail.getDescription();
            String oldDescription = policy.getDescription();
            if (!oldDescription.equals(newDescription)) {
                policy = moe.setDescription(policy, newDescription);
            }
            HashSet<MetaMatrixPrincipalName> removees = new HashSet<MetaMatrixPrincipalName>();
            Iterator it = detail.getRemovedMetaMatrixUsers().iterator();
            while (it.hasNext()) {
                prin2 = new MetaMatrixPrincipalName((String)it.next(), 0);
                removees.add(prin2);
            }
            it = detail.getRemovedEnterpriseUsers().iterator();
            while (it.hasNext()) {
                prin2 = new MetaMatrixPrincipalName((String)it.next(), 0);
                removees.add(prin2);
            }
            it = detail.getRemovedMetaMatrixGroups().iterator();
            while (it.hasNext()) {
                prin2 = new MetaMatrixPrincipalName((String)it.next(), 1);
                removees.add(prin2);
            }
            it = detail.getRemovedEnterpriseGroups().iterator();
            while (it.hasNext()) {
                prin2 = new MetaMatrixPrincipalName((String)it.next(), 1);
                removees.add(prin2);
            }
            if (removees.size() > 0) {
                policy = moe.removePrincipals(policy, removees);
            }
            HashSet<MetaMatrixPrincipalName> addees = new HashSet<MetaMatrixPrincipalName>();
            it = detail.getAddedMetaMatrixUsers().iterator();
            while (it.hasNext()) {
                prin = new MetaMatrixPrincipalName((String)it.next(), 0);
                addees.add(prin);
            }
            it = detail.getAddedEnterpriseUsers().iterator();
            while (it.hasNext()) {
                prin = new MetaMatrixPrincipalName((String)it.next(), 1);
                addees.add(prin);
            }
            it = detail.getAddedMetaMatrixGroups().iterator();
            while (it.hasNext()) {
                prin = new MetaMatrixPrincipalName((String)it.next(), 0);
                addees.add(prin);
            }
            it = detail.getAddedEnterpriseGroups().iterator();
            while (it.hasNext()) {
                prin = new MetaMatrixPrincipalName((String)it.next(), 1);
                addees.add(prin);
            }
            if (addees.size() > 0) {
                policy = moe.addAllPrincipals(policy, addees);
            }
            if ((changedPermissions = detail.getChangedPermissions()) != null) {
                ModelManager.getEntitlementManager((ConnectionInfo)this.getConnection()).setPermissionNodeAuths(changedPermissions);
                moe.modifyPermissions((PermissionTreeView)treeView, policy);
            }
            ModificationActionQueue maq = moe.getDestination();
            List actions = maq.popActions();
            this.getAPI().executeTransaction(actions);
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    public String[] getEntitlements() throws AuthorizationException, ExternalException {
        String[] sortedResult = null;
        try {
            Collection ids = this.getAPI().getMetaBasePolicyIDs();
            ArrayList<String> result = new ArrayList<String>(ids.size());
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                AuthorizationPolicyID id = (AuthorizationPolicyID)it.next();
                String name = id.getName();
                result.add(name);
            }
            String[] unsortedResult = new String[result.size()];
            it = result.iterator();
            int i = 0;
            while (it.hasNext()) {
                unsortedResult[i] = (String)it.next();
                ++i;
            }
            sortedResult = StaticQuickSorter.quickStringSort((String[])unsortedResult);
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
        return sortedResult;
    }

    public Collection getAllEnterpriseUserNames() throws AuthorizationException, ExternalException, ComponentNotFoundException {
        UserManager um = ModelManager.getUserManager((ConnectionInfo)this.getConnection());
        return um.getAllEnterpriseUserNames();
    }

    public Collection getAllEnterpriseGroupNames() throws AuthorizationException, ExternalException, ComponentNotFoundException {
        UserManager um = ModelManager.getUserManager((ConnectionInfo)this.getConnection());
        return um.getAllEnterpriseGroupNames();
    }

    public Collection getAllMetaMatrixUserNames() throws AuthorizationException, ExternalException, ComponentNotFoundException {
        UserManager um = ModelManager.getUserManager((ConnectionInfo)this.getConnection());
        return um.getAllMetaMatrixUserNames();
    }

    public Collection getAllMetaMatrixGroupNames() throws AuthorizationException, ExternalException, ComponentNotFoundException {
        UserManager um = ModelManager.getUserManager((ConnectionInfo)this.getConnection());
        return um.getAllMetaMatrixGroupNames();
    }

    public boolean doesEntitlementExist(String name) throws AuthorizationException, ExternalException {
        Collection ids = null;
        try {
            ids = this.getAPI().getMetaBasePolicyIDs();
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
        Iterator it = ids.iterator();
        boolean found = false;
        while (!found && it.hasNext()) {
            AuthorizationPolicyID id = (AuthorizationPolicyID)it.next();
            if (!id.getName().equals(name)) continue;
            found = true;
        }
        return found;
    }

    private AuthorizationPolicy getPolicy(AuthorizationPolicyID id) throws AuthorizationException, ComponentNotFoundException, ExternalException {
        EntitlementManager em = ModelManager.getEntitlementManager((ConnectionInfo)this.getConnection());
        return em.getPolicy(id);
    }

    private void separatePrincipals(Set allPrincipals, Collection metaMatrixUsers, Collection metaMatrixGroups, Collection enterpriseUsers, Collection enterpriseGroups) throws AuthorizationException, ComponentNotFoundException, ExternalException {
        UserManager um = ModelManager.getUserManager((ConnectionInfo)this.getConnection());
        List metaMatrixUserNames = um.getAllMetaMatrixUserNames();
        Collection metaMatrixGroupNames = um.getAllMetaMatrixGroupNames();
        List enterpriseUserNames = um.getAllEnterpriseUserNames();
        Collection enterpriseGroupNames = um.getAllEnterpriseGroupNames();
        Iterator it = allPrincipals.iterator();
        while (it.hasNext()) {
            MetaMatrixPrincipalName prinName = (MetaMatrixPrincipalName)it.next();
            String name = prinName.getName();
            if (metaMatrixUserNames.contains(name)) {
                metaMatrixUsers.add(name);
                continue;
            }
            if (metaMatrixGroupNames.contains(name)) {
                metaMatrixGroups.add(name);
                continue;
            }
            if (enterpriseUserNames.contains(name)) {
                enterpriseUsers.add(name);
                continue;
            }
            if (!enterpriseGroupNames.contains(name)) continue;
            enterpriseGroups.add(name);
        }
    }

    private AuthorizationAdminAPI getAPI() {
        return ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection());
    }

    private DataNodesTreeModel convertTreeViewToTreeModel(PermissionMetaBaseTreeView treeView, boolean canModify) throws Exception {
        return DataNodesTreeModel.createDefaultTreeModelFromTreeView((PermissionTreeView)treeView, (boolean)canModify, (boolean)true);
    }
}

