/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.UserManager;
import com.metamatrix.console.ui.views.entitlements.DataNodePermissions;
import com.metamatrix.console.ui.views.entitlements.DataNodePermissionsWithNodeName;
import com.metamatrix.console.ui.views.entitlements.EntitlementInfo;
import com.metamatrix.console.ui.views.entitlements.EntitlementsDataInterface;
import com.metamatrix.console.ui.views.entitlements.EntitlementsTableRowData;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticPrincipalUtilities;
import com.metamatrix.console.util.StaticQuickSorter;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.platform.admin.api.AuthorizationAdminAPI;
import com.metamatrix.platform.admin.api.PermissionDataNode;
import com.metamatrix.platform.admin.api.PermissionDataNodeTreeView;
import com.metamatrix.platform.admin.api.PermissionNode;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.platform.admin.api.exception.PermissionNodeNotActionableException;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeTreeViewImpl;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationObjectEditor;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.server.admin.api.RuntimeMetadataAdminAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class EntitlementManager
extends Manager
implements EntitlementsDataInterface {
    public EntitlementManager(ConnectionInfo connection) {
        super(connection);
    }

    public void init() {
        super.init();
    }

    public void deleteEntitlement(AuthorizationPolicyID id) throws ExternalException, ComponentNotFoundException, AuthorizationException {
        try {
            AuthorizationObjectEditor aoe = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).createEditor();
            aoe.remove(id);
            ModificationActionQueue maq = aoe.getDestination();
            List actions = maq.popActions();
            ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).executeTransaction(actions);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        this.fireModelChangedEvent("Managed model changed.");
    }

    public Collection getPrincipalsForEntitlement(AuthorizationPolicyID policyID) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        Set princ = null;
        AuthorizationPolicy policy = this.getPolicy(policyID);
        if (policy != null) {
            princ = policy.getPrincipals();
        }
        return princ;
    }

    public AuthorizationPolicy getPolicy(AuthorizationPolicyID policyID) throws AuthorizationException, ComponentNotFoundException, ExternalException {
        AuthorizationPolicy result = null;
        if (policyID != null) {
            try {
                result = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).getPolicy(policyID);
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (ComponentNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExternalException(e);
            }
        }
        return result;
    }

    public Collection getAllEntitlements() throws ExternalException, AuthorizationException {
        TreeSet result;
        try {
            result = new TreeSet(ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).findAllPolicyIDs());
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return result;
    }

    public EntitlementsTableRowData[] getEntitlements() throws AuthorizationException, ExternalException {
        Collection ids = this.getAllEntitlements();
        Iterator it = ids.iterator();
        ArrayList<EntitlementsTableRowData> ent = new ArrayList<EntitlementsTableRowData>(ids.size());
        while (it.hasNext()) {
            EntitlementsTableRowData row;
            AuthorizationPolicyID id = (AuthorizationPolicyID)it.next();
            String name = id.getName();
            String displayName = id.getDisplayName();
            String vdbName = id.getVDBName();
            int vdbVersion = id.getVDBVersion();
            if (displayName == null && name.indexOf(33) >= 0) {
                int firstDelimiterLoc = name.indexOf(33);
                int secondDelimiterLoc = name.lastIndexOf(33);
                displayName = name.substring(0, firstDelimiterLoc);
                vdbName = name.substring(firstDelimiterLoc + 1, secondDelimiterLoc);
                String vdbVersionString = name.substring(secondDelimiterLoc + 1);
                int underscoreLoc = vdbVersionString.indexOf(95);
                if (underscoreLoc >= 0) {
                    vdbVersionString = vdbVersionString.substring(0, underscoreLoc);
                }
                vdbVersion = new Integer(vdbVersionString);
            }
            if ((row = new EntitlementsTableRowData(displayName, vdbName, vdbVersion)) == null || row.getEntitlementName() == null || row.getVDBName() == null) continue;
            ent.add(row);
        }
        EntitlementsTableRowData[] rows = new EntitlementsTableRowData[ent.size()];
        it = ent.iterator();
        int i = 0;
        while (it.hasNext()) {
            rows[i] = (EntitlementsTableRowData)it.next();
            ++i;
        }
        return rows;
    }

    public List getPolicyIDs() throws AuthorizationException, ExternalException {
        Collection ids = this.getAllEntitlements();
        Vector<AuthorizationPolicyID> v = new Vector<AuthorizationPolicyID>(ids.size());
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            AuthorizationPolicyID id = (AuthorizationPolicyID)it.next();
            v.add(id);
        }
        return v;
    }

    public Collection getAllVDBs() throws AuthorizationException, ExternalException, ComponentNotFoundException {
        try {
            Collection coll = ModelManager.getVdbManager((ConnectionInfo)this.getConnection()).getVDBs();
            return coll;
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (ComponentNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    public int[] getVersionsForVDB(String vdbName) throws AuthorizationException, ExternalException, ComponentNotFoundException {
        Collection coll = this.getAllVDBs();
        ArrayList<Integer> versionsList = new ArrayList<Integer>(coll.size());
        Iterator it = coll.iterator();
        int i = 0;
        while (it.hasNext()) {
            VirtualDatabase vdb = (VirtualDatabase)it.next();
            VirtualDatabaseID id = (VirtualDatabaseID)vdb.getID();
            String name = id.getName();
            if (name.equals(vdbName)) {
                String versionStr = id.getVersion();
                float version = new Float(versionStr).floatValue();
                int versInt = Math.round(version);
                versionsList.add(new Integer(versInt));
            }
            ++i;
        }
        int[] versions = new int[versionsList.size()];
        it = versionsList.iterator();
        int i2 = 0;
        while (it.hasNext()) {
            Integer temp = (Integer)it.next();
            versions[i2] = temp;
            ++i2;
        }
        boolean done = false;
        while (!done) {
            done = true;
            for (int i3 = 0; i3 < versions.length - 1; ++i3) {
                if (versions[i3] <= versions[i3 + 1]) continue;
                done = false;
                int temp = versions[i3];
                versions[i3] = versions[i3 + 1];
                versions[i3 + 1] = temp;
            }
        }
        return versions;
    }

    public void createNewEntitlement(String entitlementName, String entitlementDescription, String vdbName, int vdbVersion, EntitlementsTableRowData dataNodesSameAsEntitlement, EntitlementsTableRowData principalsSameAsEntitlement) throws AuthorizationException, ExternalException {
        try {
            AuthorizationObjectEditor aoe = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).createEditor();
            AuthorizationPolicyID policyID = new AuthorizationPolicyID(entitlementName, vdbName, vdbVersion);
            AuthorizationPolicy policy = aoe.createAuthorizationPolicy(policyID);
            String desc = entitlementDescription;
            if (desc == null) {
                desc = "";
            }
            aoe.setDescription(policy, desc);
            if (dataNodesSameAsEntitlement != null) {
                AuthorizationPolicyID dPolicyID = new AuthorizationPolicyID(dataNodesSameAsEntitlement.getEntitlementName(), dataNodesSameAsEntitlement.getVDBName(), dataNodesSameAsEntitlement.getVDBVersion());
                AuthorizationPolicy dPolicy = this.getPolicy(dPolicyID);
                RuntimeMetadataAdminAPI api = ModelManager.getRuntimeMetadataAPI((ConnectionInfo)this.getConnection());
                Set allPaths = api.getAllDataNodeNames(vdbName, new Integer(vdbVersion).toString());
                policy = aoe.clonePolicyPermissions(dPolicy, policy, new AuthorizationRealm(vdbName, new Integer(vdbVersion).toString()), allPaths);
            }
            if (principalsSameAsEntitlement != null) {
                AuthorizationPolicyID pPolicyID = new AuthorizationPolicyID(principalsSameAsEntitlement.getEntitlementName(), principalsSameAsEntitlement.getVDBName(), principalsSameAsEntitlement.getVDBVersion());
                AuthorizationPolicy pPolicy = this.getPolicy(pPolicyID);
                policy = aoe.clonePolicyPrincipals(pPolicy, policy);
            }
            ModificationActionQueue maq = aoe.getDestination();
            List actions = maq.popActions();
            ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).executeTransaction(actions);
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    public boolean doesEntitlementExist(String entName, String vdbName, int vdbVersion) throws AuthorizationException, ExternalException, ComponentNotFoundException {
        boolean result = false;
        AuthorizationAdminAPI api = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection());
        try {
            AuthorizationPolicyID id = new AuthorizationPolicyID(entName, vdbName, vdbVersion);
            Boolean exists = api.containsPolicy(id);
            result = exists;
        }
        catch (ComponentNotFoundException ex) {
            throw ex;
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
        return result;
    }

    public EntitlementInfo getEntitlementInfo(String entName, String vdbName, int vdbVersion) throws AuthorizationException, ExternalException, ComponentNotFoundException {
        try {
            AuthorizationPolicyID policyID = new AuthorizationPolicyID(entName, vdbName, vdbVersion);
            AuthorizationPolicy policy = this.getPolicy(policyID);
            Collection coll = this.getPrincipalsForEntitlement(policyID);
            Map princMap = StaticPrincipalUtilities.classifyPrincipals((Collection)coll, (ConnectionInfo)this.getConnection());
            List<String> metaMatrixUsers = Arrays.asList((String[])princMap.get(new Integer(0)));
            List<String> metaMatrixGroups = Arrays.asList((String[])princMap.get(new Integer(2)));
            List<String> enterpriseUsers = Arrays.asList((String[])princMap.get(new Integer(1)));
            List<String> enterpriseGroups = Arrays.asList((String[])princMap.get(new Integer(3)));
            PermissionDataNodeTreeView tv = this.getTreeViewForData(vdbName, vdbVersion, policyID);
            EntitlementInfo entInfo = new EntitlementInfo((PermissionTreeView)tv, policyID, policy, entName, policy.getDescription(), vdbName, vdbVersion, metaMatrixUsers, enterpriseUsers, metaMatrixGroups, enterpriseGroups);
            return entInfo;
        }
        catch (ComponentNotFoundException ex) {
            throw ex;
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    public void changeAPolicy(PermissionDataNodeTreeView treeView, AuthorizationPolicy policy, String newDescription, Collection addedUserPrincipals, Collection addedGroupPrincipals, Collection removedUserPrincipals, Collection removedGroupPrincipals, List changedPermissions) throws AuthorizationException, ExternalException {
        try {
            MetaMatrixPrincipalName prin;
            MetaMatrixPrincipalName prin2;
            AuthorizationObjectEditor aoe = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection()).createEditor();
            String oldDescription = policy.getDescription();
            if (!oldDescription.equals(newDescription)) {
                policy = aoe.setDescription(policy, newDescription);
            }
            HashSet<MetaMatrixPrincipalName> removees = new HashSet<MetaMatrixPrincipalName>();
            Iterator it = removedUserPrincipals.iterator();
            while (it.hasNext()) {
                prin2 = new MetaMatrixPrincipalName((String)it.next(), 0);
                removees.add(prin2);
            }
            it = removedGroupPrincipals.iterator();
            while (it.hasNext()) {
                prin2 = new MetaMatrixPrincipalName((String)it.next(), 1);
                removees.add(prin2);
            }
            if (removees.size() > 0) {
                policy = aoe.removePrincipals(policy, removees);
            }
            HashSet<MetaMatrixPrincipalName> addees = new HashSet<MetaMatrixPrincipalName>();
            it = addedUserPrincipals.iterator();
            while (it.hasNext()) {
                prin = new MetaMatrixPrincipalName((String)it.next(), 0);
                addees.add(prin);
            }
            it = addedGroupPrincipals.iterator();
            while (it.hasNext()) {
                prin = new MetaMatrixPrincipalName((String)it.next(), 1);
                addees.add(prin);
            }
            if (addees.size() > 0) {
                policy = aoe.addAllPrincipals(policy, addees);
            }
            if (changedPermissions.size() > 0) {
                this.setPermissionNodeAuths(changedPermissions);
                aoe.modifyPermissions((PermissionTreeView)treeView, policy);
            }
            ModificationActionQueue maq = aoe.getDestination();
            List actions = maq.popActions();
            AuthorizationAdminAPI api = ModelManager.getAuthorizationAPI((ConnectionInfo)this.getConnection());
            api.executeTransaction(actions);
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    public Collection getAllMetaMatrixUserNames() throws AuthorizationException, ExternalException, ComponentNotFoundException {
        UserManager um = ModelManager.getUserManager((ConnectionInfo)this.getConnection());
        return um.getAllMetaMatrixUserNames();
    }

    public Collection getAllEnterpriseUserNames() throws AuthorizationException, ExternalException, ComponentNotFoundException {
        UserManager um = ModelManager.getUserManager((ConnectionInfo)this.getConnection());
        return um.getAllEnterpriseUserNames();
    }

    public Collection getAllMetaMatrixGroupNames() throws AuthorizationException, ExternalException, ComponentNotFoundException {
        UserManager um = ModelManager.getUserManager((ConnectionInfo)this.getConnection());
        return um.getAllMetaMatrixGroupNames();
    }

    public Collection getAllEnterpriseGroupNames() throws AuthorizationException, ExternalException, ComponentNotFoundException {
        UserManager um = ModelManager.getUserManager((ConnectionInfo)this.getConnection());
        return um.getAllEnterpriseGroupNames();
    }

    public PermissionDataNodeTreeView getTreeViewForData(String vdbName, int vdbVersion, AuthorizationPolicyID policyID) throws AuthorizationException, ExternalException {
        try {
            RuntimeMetadataAdminAPI api = ModelManager.getRuntimeMetadataAPI((ConnectionInfo)this.getConnection());
            String versString = new Integer(vdbVersion).toString();
            PermissionDataNode root = api.getEntitlementTree(vdbName, versString, policyID);
            PermissionDataNodeTreeViewImpl view = new PermissionDataNodeTreeViewImpl((PermissionNode)root);
            return view;
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    public List getEntitlementsForVDB(String vdbName, int vdbVersion) throws AuthorizationException, ExternalException {
        ArrayList<String> matches = new ArrayList<String>();
        List ids = this.getPolicyIDs();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            AuthorizationPolicyID id = (AuthorizationPolicyID)it.next();
            if (!this.policyIsForVDB(id, vdbName, vdbVersion)) continue;
            String entName = this.getEntitlementName(id);
            matches.add(entName);
        }
        Collection sorted = StaticQuickSorter.quickStringCollectionSort(matches);
        matches = new ArrayList(sorted);
        return matches;
    }

    public void setPermissionNodeAuths(Collection changedPermissions) {
        Iterator it = changedPermissions.iterator();
        while (it.hasNext()) {
            DataNodePermissionsWithNodeName perms = (DataNodePermissionsWithNodeName)it.next();
            DataNodePermissions newPerms = perms.getNewPermissions();
            int flag = 0;
            if (newPerms.hasCreate()) {
                flag |= 1;
            }
            if (newPerms.hasRead()) {
                flag |= 2;
            }
            if (newPerms.hasUpdate()) {
                flag |= 4;
            }
            if (newPerms.hasDelete()) {
                flag |= 8;
            }
            AuthorizationActions actions = StandardAuthorizationActions.getAuthorizationActions((int)flag);
            try {
                PermissionNode pNode = perms.getCorrespondingNode();
                pNode.setActions(actions);
            }
            catch (PermissionNodeNotActionableException ex) {
                LogManager.logError((String)"ENTITLEMENTS", (Throwable)ex, (String)"On modifying entitlement recvd PermissionNodeNotActionableException.  Should never happen.");
            }
        }
    }

    private boolean policyIsForVDB(AuthorizationPolicyID id, String vdbName, int vdbVersion) {
        String policyVDB = id.getVDBName();
        int policyVDBVersion = id.getVDBVersion();
        boolean matches = policyVDBVersion == vdbVersion && policyVDB.equals(vdbName);
        return matches;
    }

    private String getEntitlementName(AuthorizationPolicyID id) {
        String name = id.getName();
        int delimiterLoc = name.indexOf(33);
        if (delimiterLoc < 0) {
            delimiterLoc = name.length();
        }
        String entName = name.substring(0, delimiterLoc);
        return entName;
    }
}

