/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.registry.MetaMatrixRegistryImpl;
import com.metamatrix.platform.registry.VMRegistryBinding;
import com.metamatrix.platform.registry.exception.RegistryCommunicationException;
import com.metamatrix.platform.vm.api.controller.VMControllerInterface;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;

public class VMPollingThread
extends Thread {
    private static final int POLLING_INITIAL_DELAY = 120000;
    private static final int POLLING_INTERVAL_DEFAULT = 15000;
    private static int POLLING_INTERVAL = 15000;
    private MetaMatrixRegistryImpl registry;
    private boolean stopped = false;

    public VMPollingThread(MetaMatrixRegistryImpl registry) {
        this.registry = registry;
        String interval = System.getProperty("vm.polling.interval");
        if (interval != null && interval.length() > 0) {
            try {
                POLLING_INTERVAL = Integer.parseInt(interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stopThread() {
        this.stopped = true;
    }

    private void synchUp() {
        Collection processes = null;
        try {
            processes = CurrentConfiguration.getStartupConfiguration().getVMComponentDefns();
        }
        catch (ConfigurationException e) {
            return;
        }
        int runningProcs = 0;
        Iterator procIter = processes.iterator();
        while (procIter.hasNext()) {
            VMComponentDefn process = (VMComponentDefn)procIter.next();
            if (!process.isEnabled()) continue;
            ++runningProcs;
        }
        if (runningProcs != this.registry.getVMControllerBindings().size()) {
            LogManager.logTrace((String)"REGISTRY", (String)"Registry is out of sync, sending REGISTRY_PING_EVENT");
            this.registry.sendPing();
            try {
                CurrentConfiguration.refresh();
                CurrentConfiguration.getConfiguration();
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
        }
    }

    public void run() {
        LogManager.logTrace((String)"REGISTRY", (String)"Starting VMPollingThread");
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        int loopCounter = 0;
        while (!this.stopped) {
            Iterator iter = this.registry.getVMControllerBindings().iterator();
            while (iter.hasNext()) {
                VMRegistryBinding binding = (VMRegistryBinding)iter.next();
                try {
                    VMControllerInterface vm = binding.getVMController();
                    vm.ping();
                }
                catch (RegistryCommunicationException rce) {
                    LogManager.logTrace((String)"REGISTRY", (String)("RegistryCommunicationException: removing " + binding.getVMControllerID()));
                    this.registry.removeVMController(binding.getVMControllerID());
                }
                catch (RemoteException e) {
                    LogManager.logTrace((String)"REGISTRY", (String)("RemoteException: removing " + binding.getVMControllerID()));
                    this.registry.removeVMController(binding.getVMControllerID());
                }
                catch (Throwable t) {
                    LogManager.logTrace((String)"REGISTRY", (Throwable)t, (String)("Throwable caught while pinging " + binding.getVMName()));
                    t.printStackTrace();
                }
            }
            try {
                Thread.sleep(POLLING_INTERVAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (loopCounter++ % 2 != 0) continue;
            this.synchUp();
        }
    }
}

