/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;

public class MMRMISocketFactory
extends RMISocketFactory {
    private final int DEFAULT_SOCKET_READ_TIMEOUT = 6000;
    private int SOCKET_READ_TIMEOUT = 6000;
    public final String SOCKET_READ_TIMEOUT_PROPERTY = "metamatrix.rmi.read.timeout";
    private final int DEFAULT_SOCKET_CONNECT_TIMEOUT = 15000;
    private int SOCKET_CONNECT_TIMEOUT = 15000;
    public final String SOCKET_CONNECT_TIMEOUT_PROPERTY = "metamatrix.rmi.connect.timeout";

    public MMRMISocketFactory() {
        String propString = System.getProperty("metamatrix.rmi.read.timeout");
        if (propString != null && propString.length() > 0) {
            try {
                this.SOCKET_READ_TIMEOUT = Integer.parseInt(propString);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((propString = System.getProperty("metamatrix.rmi.connect.timeout")) != null && propString.length() > 0) {
            try {
                this.SOCKET_CONNECT_TIMEOUT = Integer.parseInt(propString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(this.SOCKET_READ_TIMEOUT);
        socket.connect(new InetSocketAddress(host, port), this.SOCKET_CONNECT_TIMEOUT);
        return socket;
    }
}

