/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import org.jgroups.util.Util;

public class socktest {
    public static void main(String[] args) throws Exception {
        System.out.println("trying to determine first IPv6 address");
        InetAddress bind_addr = socktest.getFirstNonLoopbackIPv6Address();
        ServerSocket s = new ServerSocket(7500, 50, bind_addr);
        System.out.println("socket: " + s + ", local address is " + s.getLocalSocketAddress());
        while (true) {
            Socket client_sock = s.accept();
            System.out.println("accepted connection from " + client_sock);
            Util.sleep(5000L);
        }
    }

    public static InetAddress getByName(String interfaceName) throws Exception {
        NetworkInterface intf = NetworkInterface.getByName(interfaceName);
        if (intf == null) {
            return null;
        }
        Enumeration<InetAddress> en = intf.getInetAddresses();
        if (en.hasMoreElements()) {
            InetAddress addr = en.nextElement();
            return addr;
        }
        return null;
    }

    public static InetAddress getFirstNonLoopbackIPv6Address() throws SocketException {
        System.out.println("fetching the network interfaces");
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        boolean preferIpv4 = false;
        boolean preferIPv6 = true;
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            System.out.println("-- looking at: " + i);
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                System.out.println("-- addr: " + addr);
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return null;
    }
}

