/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.List;
import org.jgroups.util.Util;

public class Router {
    final Hashtable groups = new Hashtable();
    int port = 8080;
    ServerSocket srv_sock = null;
    InetAddress bind_address;
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final int GET = -10;
    public static final int REGISTER = -11;
    public static final int DUMP = -21;

    public Router(int port) throws Exception {
        this.port = port;
        this.srv_sock = new ServerSocket(port, 50);
    }

    public Router(int port, InetAddress bind_address) throws Exception {
        this.port = port;
        this.bind_address = bind_address;
        this.srv_sock = new ServerSocket(port, 50, bind_address);
    }

    public void start() {
        if (this.bind_address == null) {
            this.bind_address = this.srv_sock.getInetAddress();
        }
        Date d = new Date();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Router started at " + d));
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Listening on port " + this.port + " bound on address " + this.bind_address + '\n'));
        }
        d = null;
        block7: while (true) {
            try {
                while (true) {
                    Socket sock = this.srv_sock.accept();
                    sock.setSoLinger(true, 500);
                    IpAddress peer_addr = new IpAddress(sock.getInetAddress(), sock.getPort());
                    DataOutputStream output = new DataOutputStream(sock.getOutputStream());
                    byte[] buf = Util.objectToByteBuffer(peer_addr);
                    output.writeInt(buf.length);
                    output.write(buf, 0, buf.length);
                    DataInputStream input = new DataInputStream(sock.getInputStream());
                    int type = input.readInt();
                    String gname = input.readUTF();
                    switch (type) {
                        case -10: {
                            this.processGetRequest(sock, output, gname);
                            continue block7;
                        }
                        case -21: {
                            this.processDumpRequest(peer_addr, sock, output);
                            continue block7;
                        }
                        case -11: {
                            int len = input.readInt();
                            buf = new byte[len];
                            input.readFully(buf, 0, buf.length);
                            Address addr = (Address)Util.objectFromByteBuffer(buf);
                            this.addEntry(gname, new AddressEntry(addr, sock, output));
                            new SocketThread(sock, input).start();
                            continue block7;
                        }
                    }
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error((Object)("request of type " + type + " not recognized"));
                }
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exception=" + e));
                continue;
            }
            break;
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processGetRequest(Socket sock, DataOutputStream output, String groupname) {
        List grpmbrs = (List)this.groups.get(groupname);
        List ret = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("groupname=" + groupname + ", result=" + grpmbrs));
        }
        if (grpmbrs != null && grpmbrs.size() > 0) {
            ret = new List();
            Enumeration e = grpmbrs.elements();
            while (e.hasMoreElements()) {
                AddressEntry entry = (AddressEntry)e.nextElement();
                ret.add(entry.addr);
            }
        }
        try {
            if (ret == null || ret.size() == 0) {
                output.writeInt(0);
            } else {
                byte[] buf = Util.objectToByteBuffer(ret);
                output.writeInt(buf.length);
                output.write(buf, 0, buf.length);
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception=" + e));
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                sock.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDumpRequest(Address peerAddress, Socket sock, DataOutputStream output) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("request from " + peerAddress));
        }
        StringBuffer sb = new StringBuffer();
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            if (this.groups.size() == 0) {
                sb.append("empty routing table");
            } else {
                Iterator i = this.groups.keySet().iterator();
                while (i.hasNext()) {
                    String gname = (String)i.next();
                    sb.append("GROUP: '" + gname + "'\n");
                    List l = (List)this.groups.get(gname);
                    if (l == null) {
                        sb.append("\tnull list of addresses\n");
                        continue;
                    }
                    if (l.size() == 0) {
                        sb.append("\tempty list of addresses\n");
                        continue;
                    }
                    Enumeration e = l.elements();
                    while (e.hasMoreElements()) {
                        AddressEntry ae = (AddressEntry)e.nextElement();
                        sb.append('\t');
                        sb.append(ae.toString());
                        sb.append('\n');
                    }
                }
            }
        }
        try {
            output.writeUTF(sb.toString());
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Error sending the answer back to the client: " + e));
            }
        }
        finally {
            block31: {
                block30: {
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception e) {
                        if (!this.log.isErrorEnabled()) break block30;
                        this.log.error((Object)("Error closing the output stream: " + e));
                    }
                }
                try {
                    sock.close();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block31;
                    this.log.error((Object)("Error closing the socket: " + e));
                }
            }
        }
    }

    synchronized void route(Address dest, String dest_group, byte[] msg) {
        if (dest == null) {
            if (dest_group == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"both dest address and group are null");
                }
                return;
            }
            this.sendToAllMembersInGroup(dest_group, msg);
        } else {
            DataOutputStream out = this.findSocket(dest);
            if (out != null) {
                this.sendToMember(out, msg);
            } else if (this.log.isErrorEnabled()) {
                this.log.error((Object)("routing of message to " + dest + " failed; outstream is null !"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntry(String groupname, AddressEntry e) {
        if (groupname == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"groupname was null, not added !");
            }
            return;
        }
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            AddressEntry old_entry;
            List val = (List)this.groups.get(groupname);
            if (val == null) {
                val = new List();
                this.groups.put(groupname, val);
            }
            if (val.contains(e) && (old_entry = (AddressEntry)val.removeElement(e)) != null) {
                old_entry.destroy();
            }
            val.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(Socket sock) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            Enumeration e = this.groups.keys();
            while (e.hasMoreElements()) {
                List val = (List)this.groups.get(e.nextElement());
                Enumeration e2 = val.elements();
                while (e2.hasMoreElements()) {
                    AddressEntry entry = (AddressEntry)e2.nextElement();
                    if (entry.sock != sock) continue;
                    try {
                        entry.sock.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    val.removeElement(entry);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(OutputStream out) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            Enumeration e = this.groups.keys();
            while (e.hasMoreElements()) {
                List val = (List)this.groups.get(e.nextElement());
                Enumeration e2 = val.elements();
                while (e2.hasMoreElements()) {
                    AddressEntry entry = (AddressEntry)e2.nextElement();
                    if (entry.output != out) continue;
                    try {
                        if (entry.sock != null) {
                            entry.sock.close();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    val.removeElement(entry);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(String groupname, Address addr) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            List val = (List)this.groups.get(groupname);
            if (val == null || val.size() == 0) {
                return;
            }
            Enumeration e2 = val.elements();
            while (e2.hasMoreElements()) {
                AddressEntry entry = (AddressEntry)e2.nextElement();
                if (!entry.addr.equals(addr)) continue;
                try {
                    if (entry.sock != null) {
                        entry.sock.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                val.removeElement(entry);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataOutputStream findSocket(Address addr) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            Enumeration e = this.groups.keys();
            while (e.hasMoreElements()) {
                List val = (List)this.groups.get(e.nextElement());
                Enumeration e2 = val.elements();
                while (e2.hasMoreElements()) {
                    AddressEntry entry = (AddressEntry)e2.nextElement();
                    if (!addr.equals(entry.addr)) continue;
                    return entry.output;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendToAllMembersInGroup(String groupname, byte[] msg) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            List val = (List)this.groups.get(groupname);
            if (val == null || val.size() == 0) {
                return;
            }
            Enumeration e = val.elements();
            while (e.hasMoreElements()) {
                this.sendToMember(((AddressEntry)e.nextElement()).output, msg);
            }
        }
    }

    void sendToMember(DataOutputStream out, byte[] msg) {
        try {
            if (out != null) {
                out.writeInt(msg.length);
                out.write(msg, 0, msg.length);
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception=" + e));
            }
            this.removeEntry(out);
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 8080;
        Router router = null;
        InetAddress address = null;
        System.out.println("Router is starting...");
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-help".equals(arg)) {
                System.out.println("Router [-port <port>] [-bindaddress <address>]");
                return;
            }
            if ("-port".equals(arg)) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (!"-bindaddress".equals(arg)) continue;
            address = InetAddress.getByName(args[++i]);
        }
        try {
            router = address == null ? new Router(port) : new Router(port, address);
            router.start();
            System.out.println("Router was created at " + new Date());
            System.out.println("Listening on port " + port + " and bound to address " + address);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    class SocketThread
    extends Thread {
        Socket sock;
        DataInputStream input;

        public SocketThread(Socket sock, DataInputStream ois) {
            super(Util.getGlobalThreadGroup(), "SocketThread");
            this.sock = null;
            this.input = null;
            this.sock = sock;
            this.input = ois;
        }

        void closeSocket() {
            try {
                if (this.input != null) {
                    this.input.close();
                }
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            Address dst_addr = null;
            try {
                while (true) {
                    byte[] buf;
                    String gname = this.input.readUTF();
                    int len = this.input.readInt();
                    if (len == 0) {
                        dst_addr = null;
                    } else {
                        buf = new byte[len];
                        this.input.readFully(buf, 0, buf.length);
                        dst_addr = (Address)Util.objectFromByteBuffer(buf);
                    }
                    len = this.input.readInt();
                    if (len == 0) {
                        if (!Router.this.log.isWarnEnabled()) continue;
                        Router.this.log.warn((Object)"received null message");
                        continue;
                    }
                    buf = new byte[len];
                    this.input.readFully(buf, 0, buf.length);
                    Router.this.route(dst_addr, gname, buf);
                }
            }
            catch (IOException io_ex) {
                if (Router.this.log.isInfoEnabled()) {
                    Router.this.log.info((Object)("client " + this.sock.getInetAddress().getHostName() + ':' + this.sock.getPort() + " closed connection; removing it from routing table"));
                }
                Router.this.removeEntry(this.sock);
                return;
            }
            catch (Exception e) {
                if (Router.this.log.isErrorEnabled()) {
                    Router.this.log.error((Object)("exception=" + e));
                }
                this.closeSocket();
                return;
            }
        }
    }

    class AddressEntry {
        Address addr = null;
        Socket sock = null;
        DataOutputStream output = null;

        public AddressEntry(Address addr, Socket sock, DataOutputStream output) {
            this.addr = addr;
            this.sock = sock;
            this.output = output;
        }

        void destroy() {
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.output = null;
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sock = null;
            }
        }

        public boolean equals(Object other) {
            return this.addr.equals(((AddressEntry)other).addr);
        }

        public String toString() {
            return "addr=" + this.addr + ", sock=" + this.sock;
        }
    }
}

