/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.jmx;

import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.JChannelFactory;
import org.jgroups.jmx.JChannel;
import org.jgroups.jmx.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

public class JmxConfigurator {
    static final Log log = LogFactory.getLog((Class)JmxConfigurator.class);

    public static JChannel registerChannel(org.jgroups.JChannel channel, MBeanServer server, String domain, String cluster_name, boolean register_protocols) throws Exception {
        JChannel retval = new JChannel(channel);
        if (cluster_name == null) {
            String string = cluster_name = channel != null ? channel.getChannelName() : null;
        }
        if (cluster_name == null) {
            cluster_name = "null";
        }
        server.registerMBean(retval, new ObjectName(domain + ":type=channel,cluster=" + cluster_name));
        if (register_protocols) {
            String tmp = domain + ":type=protocol,cluster=" + cluster_name;
            JmxConfigurator.registerProtocols(server, channel, tmp);
        }
        return retval;
    }

    public static void unregisterChannel(MBeanServer server, ObjectName name) throws Exception {
        if (server != null) {
            server.unregisterMBean(name);
        }
    }

    public static void unregisterChannel(MBeanServer server, String name) throws Exception {
        if (server != null) {
            server.unregisterMBean(new ObjectName(name));
        }
    }

    public static org.jgroups.jmx.JChannelFactory registerChannelFactory(JChannelFactory factory, MBeanServer server, String name) throws Exception {
        org.jgroups.jmx.JChannelFactory retval = new org.jgroups.jmx.JChannelFactory(factory);
        server.registerMBean(retval, new ObjectName(name));
        return retval;
    }

    public static void registerProtocols(MBeanServer server, org.jgroups.JChannel channel, String prefix) throws Exception {
        ProtocolStack stack = channel.getProtocolStack();
        Vector protocols = stack.getProtocols();
        Protocol p = null;
        for (int i = 0; i < protocols.size(); ++i) {
            org.jgroups.stack.Protocol prot = (org.jgroups.stack.Protocol)protocols.get(i);
            try {
                p = JmxConfigurator.findProtocol(prot);
            }
            catch (ClassNotFoundException e) {
                p = null;
            }
            catch (Throwable e) {
                log.error((Object)("failed creating a JMX wrapper instance for " + prot), e);
                p = null;
            }
            if (p == null) {
                p = new Protocol(prot);
            }
            ObjectName prot_name = new ObjectName(prefix + ",protocol=" + prot.getName());
            server.registerMBean(p, prot_name);
        }
    }

    public static void unregisterProtocols(MBeanServer server, org.jgroups.JChannel channel, String channel_name) {
        ProtocolStack stack = channel.getProtocolStack();
        Vector protocols = stack.getProtocols();
        ObjectName prot_name = null;
        for (int i = 0; i < protocols.size(); ++i) {
            org.jgroups.stack.Protocol prot = (org.jgroups.stack.Protocol)protocols.get(i);
            try {
                prot_name = new ObjectName(channel_name + ",protocol=" + prot.getName());
                server.unregisterMBean(prot_name);
                continue;
            }
            catch (Throwable e) {
                log.error((Object)("failed to unregister " + prot_name), e);
            }
        }
    }

    public static void unregister(MBeanServer server, String object_name) throws Exception {
        Set<ObjectName> mbeans = server.queryNames(new ObjectName(object_name), null);
        if (mbeans != null) {
            Iterator<ObjectName> it = mbeans.iterator();
            while (it.hasNext()) {
                ObjectName name = it.next();
                server.unregisterMBean(name);
            }
        }
    }

    protected static Protocol findProtocol(org.jgroups.stack.Protocol prot) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        String prot_name = prot.getClass().getName();
        String clname = prot_name.replaceFirst("org.jgroups.", "org.jgroups.jmx.");
        Class cl = Util.loadClass(clname, JmxConfigurator.class);
        if (cl != null) {
            Protocol p = (Protocol)cl.newInstance();
            p.attachProtocol(prot);
            return p;
        }
        return null;
    }
}

