/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.Version;

public class ResolverExport
implements VersionSupplier {
    private ResolverBundle exporter;
    private ExportPackageDescription exportPackageDescription;
    private boolean reprovide = false;
    private boolean dropped = false;

    ResolverExport(ResolverBundle bundle, ExportPackageDescription export) {
        this.exporter = bundle;
        this.exportPackageDescription = export;
    }

    ResolverExport(ResolverBundle bundle, ExportPackageDescription export, boolean reprovide) {
        this(bundle, export);
        this.reprovide = reprovide;
    }

    public String getName() {
        return this.exportPackageDescription.getName();
    }

    public Version getVersion() {
        return this.exportPackageDescription.getVersion();
    }

    public BundleDescription getBundle() {
        return this.exportPackageDescription.getExporter();
    }

    ResolverBundle getExporter() {
        return this.exporter;
    }

    ExportPackageDescription getExportPackageDescription() {
        return this.exportPackageDescription;
    }

    ResolverExport getRoot() {
        ResolverExport re = this;
        while (re != null && !re.getExportPackageDescription().isRoot()) {
            ResolverExport root = null;
            ResolverBundle reExporter = re.getExporter();
            ResolverImport ri = reExporter.getImport(re.getName());
            root = ri != null ? ri.getMatchingExport() : ResolverExport.getRootRequires(re, reExporter);
            if (root == null || root == re || root == this) {
                return null;
            }
            re = root;
        }
        return re;
    }

    static ResolverExport getRootRequires(ResolverExport re, ResolverBundle reExporter) {
        BundleConstraint[] requires = reExporter.getRequires();
        for (int i = 0; i < requires.length; ++i) {
            if (requires[i].getMatchingBundle() == null) continue;
            ResolverExport[] exports = requires[i].getMatchingBundle().getExportPackages();
            for (int j = 0; j < exports.length; ++j) {
                if (!re.getName().equals(exports[j].getName())) continue;
                return exports[j];
            }
            if (!(re = ResolverExport.getRootRequires(re, requires[i].getMatchingBundle())).getExportPackageDescription().isRoot()) continue;
            return re;
        }
        return re;
    }

    static boolean isOnRootPath(ResolverBundle rb, ResolverExport re) {
        if (re.getExporter() == rb) {
            return true;
        }
        while (re != null && !re.getExportPackageDescription().isRoot()) {
            ResolverBundle reExporter = re.getExporter();
            ResolverImport ri = reExporter.getImport(re.getName());
            if (!(ri != null ? (re = ri.getMatchingExport()).getExporter() == rb : (re = ResolverExport.getRootRequires(re, reExporter)).getExporter() == rb)) continue;
            return true;
        }
        return false;
    }

    boolean isReprovide() {
        return this.reprovide;
    }

    public String toString() {
        return this.exportPackageDescription.toString();
    }

    boolean isDropped() {
        return this.dropped;
    }

    void setDropped(boolean dropped) {
        this.dropped = dropped;
    }
}

