/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.query.service;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.server.InvalidRequestIDException;
import com.metamatrix.common.comm.ServerListenerRegistrant;
import com.metamatrix.common.comm.ServerListenerRegistry;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.platform.server.ClientConnectionManager;
import com.metamatrix.common.comm.service.SocketService;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.dqp.application.DQP;
import com.metamatrix.dqp.config.DQPConfigSource;
import com.metamatrix.dqp.config.DQPLauncher;
import com.metamatrix.dqp.internal.application.DQPComponent;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.platform.admin.api.IServerLogonSource;
import com.metamatrix.platform.resource.MessageReceiver;
import com.metamatrix.platform.resource.RemoteResource;
import com.metamatrix.platform.security.api.IServerLogon;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.SessionServiceProxy;
import com.metamatrix.platform.service.api.CacheAdmin;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.platform.service.controller.AbstractService;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.function.FunctionMetadataSource;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.dqp.config.PlatformConfigSource;
import com.metamatrix.server.function.ExtensionFunctionMetadataSource;
import com.metamatrix.server.query.service.BaseQueryServiceInterface;
import com.metamatrix.server.query.service.QueryServiceEngine;
import com.metamatrix.server.query.service.QueryServiceInterface;
import com.metamatrix.server.util.ServerProxyHelper;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class QueryService
extends AbstractService
implements ServerListenerRegistrant,
QueryServiceInterface,
RemoteResource,
SocketService,
IServerLogonSource {
    private SessionServiceProxy sessionService;
    private QueryServiceEngine engine = new QueryServiceEngine();
    private BaseQueryServiceInterface queryService = this.engine;
    private CacheAdmin cacheAdmin = this.engine;

    protected void initService(Properties props) throws Exception {
        ClientConnectionManager clientConnMgr = new ClientConnectionManager();
        String udfSource = null;
        try {
            udfSource = props.getProperty("UDFSource", "FunctionDefinitions.xmi");
            if (udfSource != null) {
                this.registerUDFSource(udfSource);
            }
        }
        catch (Throwable t) {
            LogManager.logError("QUERY_SERVICE", t, ServerPlugin.Util.getString("QueryService.Unable_to_register_user-defined_function_source__{0}_1", udfSource));
        }
        props.setProperty("metamatrix.server.metadata.systemURL", CurrentConfiguration.getProperty((String)"metamatrix.server.metadata.systemURL"));
        PlatformConfigSource configSource = new PlatformConfigSource(props, clientConnMgr, this.getBufferManager(), (Object)new Long(this.getID().getID()));
        DQPComponent dqp = new DQPLauncher((DQPConfigSource)configSource).createDqp();
        this.sessionService = ServerProxyHelper.getSessionServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
        this.sessionService.connect();
        this.engine.initialize((DQP)dqp, this);
    }

    public IServerLogon getIServerLogon() {
        return this.getSessionServiceProxy();
    }

    private SessionServiceProxy getSessionServiceProxy() {
        if (!this.sessionService.isConnected()) {
            this.sessionService.connect();
        }
        return this.sessionService;
    }

    private void registerUDFSource(String udfSource) {
        FunctionLibraryManager.registerSource((FunctionMetadataSource)new ExtensionFunctionMetadataSource(udfSource));
    }

    protected void closeService() throws Exception {
        this.engine.closeService();
    }

    protected void waitForServiceToClear() throws Exception {
        this.engine.waitForServiceToClear();
    }

    protected void killService() {
        this.engine.killService();
    }

    public void clearCache(SessionToken sessionToken) throws ComponentNotFoundException, ServiceStateException, RemoteException {
        this.queryService.clearCache(sessionToken);
    }

    public Collection getAllQueries() throws ServiceStateException, RemoteException {
        return this.queryService.getAllQueries();
    }

    public void cancelQueries(SessionToken sessionToken, boolean shouldRollback) throws ServiceStateException, InvalidRequestIDException, MetaMatrixComponentException, RemoteException {
        this.queryService.cancelQueries(sessionToken, shouldRollback);
    }

    public Collection getQueriesForSession(SessionToken userToken) throws ServiceStateException, RemoteException {
        return this.queryService.getQueriesForSession(userToken);
    }

    public void cancelQuery(RequestID requestID, boolean shouldRollback) throws InvalidRequestIDException, MetaMatrixComponentException, ServiceStateException, RemoteException {
        this.queryService.cancelQuery(requestID, shouldRollback);
    }

    public void cancelQuery(RequestID requestID, int nodeID) throws InvalidRequestIDException, MetaMatrixComponentException, ServiceStateException, RemoteException {
        this.queryService.cancelQuery(requestID, nodeID);
    }

    public void send(Message message, String messageKey, Object clientIdentifier) throws RemoteException {
        this.engine.send(message, messageKey, clientIdentifier);
    }

    public Message send(Message message, Object clientIdentifier) throws ApplicationException, RemoteException {
        return this.engine.send(message, clientIdentifier);
    }

    public void setMessageReceiver(MessageReceiver receiver, Properties props, Object clientIdentifier) throws RemoteException {
        this.engine.setMessageReceiver(receiver, props, clientIdentifier);
    }

    public Collection getQueueStatistics() {
        return this.engine.getQueueStatistics();
    }

    public WorkerPoolStats getQueueStatistics(String name) {
        return this.engine.getQueueStatistics(name);
    }

    public Map getCaches() throws MetaMatrixComponentException, RemoteException {
        return this.cacheAdmin.getCaches();
    }

    public void clearCache(String name, Properties props) throws MetaMatrixComponentException, RemoteException {
        this.cacheAdmin.clearCache(name, props);
    }

    public void clientShutdown(Object clientIdentifier) throws RemoteException {
        this.engine.clientShutdown(clientIdentifier);
    }

    public String getHost() throws RemoteException {
        return this.engine.getHost();
    }

    public int getPort() throws RemoteException {
        return this.engine.getPort();
    }

    public InetAddress getInetAddress() throws RemoteException {
        return this.engine.getInetAddress();
    }

    public void setServerListenerRegistry(ServerListenerRegistry registry) {
        this.engine.setServerListenerRegistry(registry);
    }
}

