/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.navigator.DeepPostOrderNavigator;
import com.metamatrix.query.sql.navigator.PostOrderNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.EvaluatableVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EvaluateExpressionVisitor
extends LanguageVisitor {
    private boolean elementReplacement = false;
    private MetaMatrixException error;
    private CommandContext context;

    public void setElementReplacement(boolean replacement) {
        this.elementReplacement = replacement;
    }

    public void setContext(CommandContext context) {
        this.context = context;
    }

    public void visit(BetweenCriteria obj) {
        Expression exp = obj.getExpression();
        obj.setExpression(this.evaluateExpression(exp));
        Expression lowerExp = obj.getLowerExpression();
        obj.setLowerExpression(this.evaluateExpression(lowerExp));
        Expression upperExp = obj.getUpperExpression();
        obj.setUpperExpression(this.evaluateExpression(upperExp));
    }

    public void visit(CaseExpression obj) {
        obj.setExpression(this.evaluateExpression(obj.getExpression()));
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(this.evaluateExpression(obj.getWhenExpression(i)));
            thens.add(this.evaluateExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(whens, thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.evaluateExpression(obj.getElseExpression()));
        }
    }

    public void visit(CompareCriteria obj) {
        Expression leftExp = obj.getLeftExpression();
        obj.setLeftExpression(this.evaluateExpression(leftExp));
        Expression rightExp = obj.getRightExpression();
        obj.setRightExpression(this.evaluateExpression(rightExp));
    }

    public void visit(IsNullCriteria obj) {
        Expression expr = obj.getExpression();
        obj.setExpression(this.evaluateExpression(expr));
    }

    public void visit(MatchCriteria obj) {
        Expression leftExp = obj.getLeftExpression();
        obj.setLeftExpression(this.evaluateExpression(leftExp));
        Expression rightExp = obj.getRightExpression();
        obj.setRightExpression(this.evaluateExpression(rightExp));
    }

    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(this.evaluateExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(obj.getWhen(), thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.evaluateExpression(obj.getElseExpression()));
        }
    }

    public void visit(SetCriteria obj) {
        Expression expr = obj.getExpression();
        obj.setExpression(this.evaluateExpression(expr));
        ArrayList<Expression> valuesList = new ArrayList<Expression>(obj.getNumberOfValues());
        Iterator valuesIter = obj.getValues().iterator();
        while (valuesIter.hasNext()) {
            Expression exp = (Expression)valuesIter.next();
            valuesList.add(this.evaluateExpression(exp));
        }
        obj.setValues(valuesList);
    }

    public void visit(SubqueryCompareCriteria obj) {
        Expression leftExp = obj.getLeftExpression();
        obj.setLeftExpression(this.evaluateExpression(leftExp));
    }

    public void visit(SubquerySetCriteria obj) {
        Expression expr = obj.getExpression();
        obj.setExpression(this.evaluateExpression(expr));
    }

    public void visit(Insert obj) {
        Iterator valuesIter = obj.getValues().iterator();
        ArrayList<Expression> valuesList = new ArrayList<Expression>(obj.getValues().size());
        while (valuesIter.hasNext()) {
            Expression exp = (Expression)valuesIter.next();
            valuesList.add(this.evaluateExpression(exp));
        }
        obj.setValues(valuesList);
    }

    public void visit(Update obj) {
        Iterator changeIter = obj.getChangeList().iterator();
        ArrayList<CompareCriteria> changeList = new ArrayList<CompareCriteria>(obj.getChangeList().size());
        while (changeIter.hasNext()) {
            CompareCriteria crit = (CompareCriteria)changeIter.next();
            this.visit(crit);
            changeList.add(crit);
        }
        obj.setChangeList(changeList);
    }

    public void visit(Select obj) {
        Iterator sybIter = obj.getSymbols().iterator();
        ArrayList<Expression> symbolsList = new ArrayList<Expression>(obj.getSymbols().size());
        while (sybIter.hasNext()) {
            Expression exp = (Expression)sybIter.next();
            Expression evaluatedExp = null;
            if (exp instanceof AliasSymbol) {
                AliasSymbol alias = (AliasSymbol)exp;
                evaluatedExp = new AliasSymbol(alias.getName(), (SingleElementSymbol)this.evaluateExpression(alias.getSymbol()));
            } else {
                evaluatedExp = this.evaluateExpression(exp);
            }
            symbolsList.add(evaluatedExp);
        }
        obj.setSymbols(symbolsList);
    }

    public void visit(AggregateSymbol obj) {
        Expression expr = obj.getExpression();
        if (expr != null) {
            obj.setExpression(this.evaluateExpression(expr));
        }
    }

    public void visit(ExpressionSymbol obj) {
        Expression expr = obj.getExpression();
        obj.setExpression(this.evaluateExpression(expr));
    }

    public void visit(Function obj) {
        int argLength = obj.getArgs().length;
        Expression[] args = new Expression[argLength];
        for (int i = 0; i < argLength; ++i) {
            Expression exp = obj.getArg(i);
            args[i] = this.evaluateExpression(exp);
        }
        obj.setArgs(args);
    }

    public void visit(StoredProcedure proc) {
        List params = proc.getParameters();
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Expression paramExp;
            SPParameter param = (SPParameter)iter.next();
            if (param.getParameterType() != 1 && param.getParameterType() != 3 || (paramExp = param.getExpression()) instanceof Reference) continue;
            param.setExpression(this.evaluateExpression(paramExp));
        }
    }

    private Expression evaluateExpression(Expression expr) {
        if (this.elementReplacement) {
            if (expr instanceof Reference) {
                Reference ref = (Reference)expr;
                Map elements = ref.getDataElements();
                if (elements == null) {
                    return ref.getExpression();
                }
            } else if (!ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr).isEmpty()) {
                return expr;
            }
        }
        if (!EvaluateExpressionVisitor.isFullyEvaluatable(expr, false)) {
            return expr;
        }
        try {
            Object value = ExpressionEvaluator.evaluate((Expression)expr, (Map)Collections.EMPTY_MAP, (List)Collections.EMPTY_LIST, null, (CommandContext)this.context);
            return new Constant(value, expr.getType());
        }
        catch (MetaMatrixException e) {
            this.handleError(e);
            return null;
        }
    }

    private void handleError(MetaMatrixException e) {
        this.error = e;
        this.setAbort(true);
    }

    public boolean hasException() {
        return this.error != null;
    }

    public MetaMatrixException getException() {
        return this.error;
    }

    public static final boolean isRuntimeEvaluatable(LanguageObject obj, boolean deep) {
        return EvaluatableVisitor.isEvaluatable(obj, deep, false, false);
    }

    public static final boolean isFullyEvaluatable(LanguageObject obj, boolean duringPlanning) {
        return EvaluatableVisitor.isEvaluatable(obj, true, duringPlanning, true);
    }

    public static final void replaceExpressions(LanguageObject obj, boolean deep, boolean elementReplacement, CommandContext context) throws ExpressionEvaluationException, MetaMatrixComponentException {
        EvaluateExpressionVisitor visitor = new EvaluateExpressionVisitor();
        visitor.setContext(context);
        visitor.setElementReplacement(elementReplacement);
        if (deep) {
            DeepPostOrderNavigator.doVisit(obj, visitor);
        } else {
            PostOrderNavigator.doVisit(obj, visitor);
        }
        if (visitor.hasException()) {
            MetaMatrixException e = visitor.getException();
            if (e instanceof ExpressionEvaluationException) {
                throw (ExpressionEvaluationException)e;
            }
            if (e instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)e;
            }
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
    }
}

