/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.navigator;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BatchedUpdateCommand;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.SQLQuery;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.lang.XQuery;
import com.metamatrix.query.sql.navigator.AbstractNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.BreakStatement;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.ContinueStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.CriteriaSelector;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.proc.HasCriteria;
import com.metamatrix.query.sql.proc.IfStatement;
import com.metamatrix.query.sql.proc.LoopStatement;
import com.metamatrix.query.sql.proc.RaiseErrorStatement;
import com.metamatrix.query.sql.proc.TranslateCriteria;
import com.metamatrix.query.sql.proc.WhileStatement;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;

public class PreOrPostOrderNavigator
extends AbstractNavigator {
    public static final boolean PRE_ORDER = true;
    public static final boolean POST_ORDER = false;
    private boolean order;

    public PreOrPostOrderNavigator(LanguageVisitor visitor, boolean order) {
        super(visitor);
        this.order = order;
    }

    protected void preVisitVisitor(LanguageObject obj) {
        if (this.order) {
            this.visitVisitor(obj);
        }
    }

    protected void postVisitVisitor(LanguageObject obj) {
        if (!this.order) {
            this.visitVisitor(obj);
        }
    }

    public void visit(AggregateSymbol obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(AliasSymbol obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getSymbol());
        this.postVisitVisitor(obj);
    }

    public void visit(AllInGroupSymbol obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(AllSymbol obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(AssignmentStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getVariable());
        if (obj.hasCommand()) {
            this.visitNode(obj.getCommand());
        }
        if (obj.hasExpression()) {
            this.visitNode(obj.getExpression());
        }
        this.postVisitVisitor(obj);
    }

    public void visit(BatchedUpdateCommand obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getUpdateCommands());
        this.postVisitVisitor(obj);
    }

    public void visit(BetweenCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.visitNode(obj.getLowerExpression());
        this.visitNode(obj.getUpperExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(Block obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getStatements());
        this.postVisitVisitor(obj);
    }

    public void visit(BreakStatement obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(CaseExpression obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            this.visitNode(obj.getWhenExpression(i));
            this.visitNode(obj.getThenExpression(i));
        }
        this.visitNode(obj.getElseExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(CommandStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getCommand());
        this.postVisitVisitor(obj);
    }

    public void visit(CompareCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getLeftExpression());
        this.visitNode(obj.getRightExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(CompoundCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getCriteria());
        this.postVisitVisitor(obj);
    }

    public void visit(Constant obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(ContinueStatement obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(CreateUpdateProcedureCommand obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getBlock());
        this.postVisitVisitor(obj);
    }

    public void visit(CriteriaSelector obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getElements());
        this.postVisitVisitor(obj);
    }

    public void visit(DeclareStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getVariable());
        this.postVisitVisitor(obj);
    }

    public void visit(Delete obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroup());
        this.visitNode(obj.getCriteria());
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    public void visit(ElementSymbol obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(ExistsCriteria obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(ExpressionSymbol obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(From obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getClauses());
        this.postVisitVisitor(obj);
    }

    public void visit(Function obj) {
        this.preVisitVisitor(obj);
        Expression[] args = obj.getArgs();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                this.visitNode(args[i]);
            }
        }
        this.postVisitVisitor(obj);
    }

    public void visit(GroupBy obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getSymbols());
        this.postVisitVisitor(obj);
    }

    public void visit(GroupSymbol obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(HasCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getSelector());
        this.postVisitVisitor(obj);
    }

    public void visit(IfStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getCondition());
        this.visitNode(obj.getIfBlock());
        this.visitNode(obj.getElseBlock());
        this.postVisitVisitor(obj);
    }

    public void visit(Insert obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroup());
        this.visitNodes(obj.getVariables());
        this.visitNodes(obj.getValues());
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    public void visit(Into obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroup());
        this.postVisitVisitor(obj);
    }

    public void visit(IsNullCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(JoinPredicate obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getLeftClause());
        this.visitNode(obj.getJoinType());
        this.visitNode(obj.getRightClause());
        this.visitNodes(obj.getJoinCriteria());
        this.postVisitVisitor(obj);
    }

    public void visit(JoinType obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(LoopStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getCommand());
        this.visitNode(obj.getBlock());
        this.postVisitVisitor(obj);
    }

    public void visit(MatchCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getLeftExpression());
        this.visitNode(obj.getRightExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(NotCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getCriteria());
        this.postVisitVisitor(obj);
    }

    public void visit(Option obj) {
        this.preVisitVisitor(obj);
    }

    public void visit(OrderBy obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getVariables());
        this.postVisitVisitor(obj);
    }

    public void visit(Query obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getSelect());
        this.visitNode(obj.getInto());
        this.visitNode(obj.getFrom());
        this.visitNode(obj.getCriteria());
        this.visitNode(obj.getGroupBy());
        this.visitNode(obj.getHaving());
        this.visitNode(obj.getOrderBy());
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    public void visit(RaiseErrorStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(Reference obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(ScalarSubquery obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(SearchedCaseExpression obj) {
        this.preVisitVisitor(obj);
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            this.visitNode(obj.getWhenCriteria(i));
            this.visitNode(obj.getThenExpression(i));
        }
        this.visitNode(obj.getElseExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(Select obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getSymbols());
        this.postVisitVisitor(obj);
    }

    public void visit(SetCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.visitNodes(obj.getValues());
        this.postVisitVisitor(obj);
    }

    public void visit(SetQuery obj) {
        this.preVisitVisitor(obj);
        this.visitNodes(obj.getQueries());
        this.visitNode(obj.getOrderBy());
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    public void visit(SQLQuery obj) {
        this.preVisitVisitor(obj);
        this.postVisitVisitor(obj);
    }

    public void visit(StoredProcedure obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    public void visit(SubqueryCompareCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getLeftExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(SubqueryFromClause obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroupSymbol());
        this.postVisitVisitor(obj);
    }

    public void visit(SubquerySetCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getExpression());
        this.postVisitVisitor(obj);
    }

    public void visit(TranslateCriteria obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getSelector());
        this.visitNodes(obj.getTranslations());
        this.postVisitVisitor(obj);
    }

    public void visit(UnaryFromClause obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroup());
        this.postVisitVisitor(obj);
    }

    public void visit(Update obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getGroup());
        this.visitNodes(obj.getChangeList());
        this.visitNode(obj.getCriteria());
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    public void visit(WhileStatement obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getCondition());
        this.visitNode(obj.getBlock());
        this.postVisitVisitor(obj);
    }

    public void visit(XQuery obj) {
        this.preVisitVisitor(obj);
        this.visitNode(obj.getOption());
        this.postVisitVisitor(obj);
    }

    public static void doVisit(LanguageObject object, LanguageVisitor visitor, boolean order) {
        PreOrPostOrderNavigator nav = new PreOrPostOrderNavigator(visitor, order);
        object.acceptVisitor(nav);
    }
}

