/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class From
implements LanguageObject {
    private List clauses;

    public From() {
        this.clauses = new ArrayList();
    }

    public From(List parameters) {
        this.clauses = new ArrayList(parameters);
    }

    public void addClause(FromClause clause) {
        this.clauses.add(clause);
    }

    public void addClauses(Collection clauses) {
        this.clauses.addAll(clauses);
    }

    public List getClauses() {
        return this.clauses;
    }

    public void setClauses(List clauses) {
        this.clauses = clauses;
    }

    public void addGroup(GroupSymbol group) {
        if (group != null) {
            this.clauses.add(new UnaryFromClause(group));
        }
    }

    public void addGroups(Collection groups) {
        if (groups != null) {
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                this.clauses.add(new UnaryFromClause((GroupSymbol)iter.next()));
            }
        }
    }

    public List getGroups() {
        ArrayList groups = new ArrayList();
        if (this.clauses != null) {
            for (int i = 0; i < this.clauses.size(); ++i) {
                FromClause clause = (FromClause)this.clauses.get(i);
                clause.collectGroups(groups);
            }
        }
        return groups;
    }

    public boolean containsGroup(GroupSymbol group) {
        return this.getGroups().contains(group);
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean isGroupOnInnerSideOfOuterJoin(GroupSymbol groupSymbol) {
        return this.getOuterJoinPredicateForInnerSideGroupSymbol(groupSymbol) != null;
    }

    public JoinPredicate getOuterJoinPredicateForInnerSideGroupSymbol(GroupSymbol groupSymbol) {
        Iterator clauses = this.getClauses().iterator();
        while (clauses.hasNext()) {
            FromClause clause = (FromClause)clauses.next();
            JoinPredicate result = From.getOuterJoinPredicateForInnerSide(clause, groupSymbol);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static JoinPredicate getOuterJoinPredicateForInnerSide(FromClause clause, GroupSymbol groupSymbol) {
        if (clause instanceof JoinPredicate) {
            JoinPredicate result;
            JoinPredicate predicate = (JoinPredicate)clause;
            JoinType jtype = predicate.getJoinType();
            if (jtype.isOuter()) {
                if (jtype.equals(JoinType.JOIN_LEFT_OUTER)) {
                    if (GroupCollectorVisitor.getGroups((LanguageObject)predicate.getRightClause(), true).contains(groupSymbol)) {
                        return predicate;
                    }
                } else if (jtype.equals(JoinType.JOIN_RIGHT_OUTER)) {
                    if (GroupCollectorVisitor.getGroups((LanguageObject)predicate.getLeftClause(), true).contains(groupSymbol)) {
                        return predicate;
                    }
                } else {
                    return predicate;
                }
            }
            if ((result = From.getOuterJoinPredicateForInnerSide(predicate.getLeftClause(), groupSymbol)) != null) {
                return result;
            }
            result = From.getOuterJoinPredicateForInnerSide(predicate.getRightClause(), groupSymbol);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public Object clone() {
        ArrayList<Object> copyClauses = new ArrayList<Object>(this.clauses.size());
        if (this.clauses.size() > 0) {
            Iterator iter = this.clauses.iterator();
            while (iter.hasNext()) {
                FromClause c = (FromClause)iter.next();
                copyClauses.add(c.clone());
            }
        }
        return new From(copyClauses);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return EquivalenceUtil.areEqual(this.getClauses(), ((From)obj).getClauses());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(0, this.getGroups());
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

