/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api.service;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.InvalidMetaMatrixPrincipalException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.api.exception.security.MetaMatrixAuthenticationException;
import com.metamatrix.api.exception.security.SessionServiceException;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.util.RemoteUtil;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.FindResourcesRequest;
import com.metamatrix.platform.security.api.FindResourcesResult;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.IServerLogon;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.platform.security.api.SessionToken;
import com.metamatrix.platform.security.api.service.ISessionServiceProxy;
import com.metamatrix.platform.security.api.service.SessionServiceInterface;
import com.metamatrix.platform.security.session.service.LogonHelper;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotInitializedException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.platform.service.proxy.ServiceProxy;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class SessionServiceProxy
extends ServiceProxy
implements ILogon,
IServerLogon,
ISessionServiceProxy {
    private LogonHelper logonHelper;
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$service$SessionServiceInterface;

    public SessionServiceProxy() {
        this.setLoggingContext("SESSION");
        this.logonHelper = new LogonHelper(this);
    }

    public String getServiceType() {
        return "SessionService";
    }

    protected String getServiceNameForProxy() {
        return "SessionService";
    }

    protected SessionServiceInterface getCurrentService() throws ServiceException {
        return (SessionServiceInterface)RemoteUtil.narrow(this.getNextInstance(), class$com$metamatrix$platform$security$api$service$SessionServiceInterface == null ? (class$com$metamatrix$platform$security$api$service$SessionServiceInterface = SessionServiceProxy.class$("com.metamatrix.platform.security.api.service.SessionServiceInterface")) : class$com$metamatrix$platform$security$api$service$SessionServiceInterface);
    }

    public MetaMatrixSessionInfo createSession(String userName, Credentials credentials, Serializable trustedToken, String applicationName, String productName, String[] productInfo) throws MetaMatrixAuthenticationException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.createSession(userName, credentials, trustedToken, applicationName, productName, productInfo);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public void closeSession(MetaMatrixSessionID sessionID) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            service.closeSession(sessionID);
                            return;
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
    }

    public boolean terminateSession(MetaMatrixSessionID terminatedSessionID, MetaMatrixSessionID adminSessionID) throws InvalidSessionException, AuthorizationException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.terminateSession(terminatedSessionID, adminSessionID);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public boolean terminateSessions(Collection terminatedSessionIDs, MetaMatrixSessionID adminSessionID) throws InvalidSessionException, AuthorizationException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.terminateSessions(terminatedSessionIDs, adminSessionID);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public boolean removeSessions(Collection removedSessionIDs, MetaMatrixSessionID adminSessionID) throws InvalidSessionException, AuthorizationException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.removeSessions(removedSessionIDs, adminSessionID);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public boolean isSessionValid(MetaMatrixSessionID sessionID) throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.isSessionValid(sessionID);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return false;
    }

    public MetaMatrixSessionInfo getSessionInfo(MetaMatrixSessionID sessionID) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getSessionInfo(sessionID);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public String getLastSessionTime() throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getLastSessionTime();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getActiveSessions() throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getActiveSessions();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Collection getAllSessions() throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getAllSessions();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public int getActiveSessionsCount() throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getActiveSessionsCount();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return 0;
    }

    public int getAllSessionsCount() throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getAllSessionsCount();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return 0;
    }

    public int getActiveConnectionsCountForProduct(String product) throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getActiveConnectionsCountForProduct(product);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return 0;
    }

    public int getAllConnectionsCountForProduct(String product) throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getAllConnectionsCountForProduct(product);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return 0;
    }

    public Collection getActiveSessionsForUser(String userName) throws InvalidMetaMatrixPrincipalException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getActiveSessionsForUser(userName);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public List getSessionsForUser(String userName) throws InvalidMetaMatrixPrincipalException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getSessionsForUser(userName);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public Set getLoggedOnPrincipals() throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getLoggedOnPrincipals();
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public MetaMatrixPrincipal getPrincipal(MetaMatrixSessionID sessionID) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getPrincipal(sessionID);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public SessionToken validateSession(MetaMatrixSessionID sessionID) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.validateSession(sessionID);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public void updateSession(MetaMatrixSessionID sessionID) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            service.updateSession(sessionID);
                            return;
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
    }

    public void updateSession(MetaMatrixSessionID sessionID, int sessionState) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            service.updateSession(sessionID, sessionState);
                            return;
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
    }

    public void unbindProductFromSession(MetaMatrixSessionID sessionID, String product) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            service.unbindProductFromSession(sessionID, product);
                            return;
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
    }

    public Collection getSessionsLoggedInToVDB(String VDBName, String VDBVersion) throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            return service.getSessionsLoggedInToVDB(VDBName, VDBVersion);
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
        return null;
    }

    public void setIsSubscriber(MetaMatrixSessionID sessionID, boolean isSubscriber) throws InvalidSessionException, SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            service.setIsSubscriber(sessionID, isSubscriber);
                            return;
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
    }

    public void reinitializeSessionCleanup(Properties props) throws SessionServiceException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            service.reinitializeSessionCleanup(props);
                            return;
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
    }

    public void pingServer(MetaMatrixSessionID sessionID) throws ServiceStateException, ServiceException, ComponentNotFoundException {
        super.checkConnection();
        SessionServiceInterface service = null;
        RemoteException re = null;
        try {
            while ((service = this.getCurrentService()) != null) {
                String msg;
                try {
                    for (int i = 0; i != this.getRetryLimit(); ++i) {
                        try {
                            service.pingServer(sessionID);
                            return;
                        }
                        catch (RemoteException e) {
                            re = e;
                            if (!(e instanceof ConnectException) && !(e instanceof ConnectIOException)) break;
                            try {
                                Thread.sleep(250L);
                            }
                            catch (InterruptedException ie) {
                            }
                        }
                    }
                    if (re != null) {
                        String msg2 = PlatformPlugin.Util.getString("ERR.014.107.0085");
                        I18nLogManager.logCritical("PROXY", "ERR.014.107.0085", (Throwable)re, msg2);
                    }
                    this.markInstanceAsBad(service);
                }
                catch (ServiceNotInitializedException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0086");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0086", (Throwable)e, msg);
                }
                catch (ServiceException e) {
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0087");
                    I18nLogManager.logError("PROXY", "ERR.014.107.0087", (Throwable)e, msg);
                    this.markInstanceAsBad(service);
                }
            }
        }
        catch (ServiceException e) {
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0088");
            I18nLogManager.logError("PROXY", "ERR.014.107.0088", (Throwable)e, msg);
            throw new ComponentNotFoundException((Throwable)e, msg);
        }
    }

    public FindResourcesResult findResources(FindResourcesRequest request) throws ComponentNotFoundException {
        return this.logonHelper.findResources(request);
    }

    public Encryptor getEncryptor() throws CryptoException {
        return this.logonHelper.getEncryptor();
    }

    public SessionServiceProxy getSessionServiceProxy() {
        return this.logonHelper.getSessionServiceProxy();
    }

    public LogonResult logon(String userName, Credentials password, Serializable trustedToken, String applicationName, String productName, String[] productInfo, FindResourcesRequest findResourcesRequest) throws LogonException, ComponentNotFoundException {
        return this.logonHelper.logon(userName, password, trustedToken, applicationName, productName, productInfo, findResourcesRequest);
    }

    public void ping(MetaMatrixSessionID sessionID) throws InvalidSessionException, ComponentNotFoundException {
        this.logonHelper.ping(sessionID);
    }

    public SessionToken validateSessionHighLevel(MetaMatrixSessionID sessionID) throws InvalidSessionException, ComponentNotFoundException {
        return this.logonHelper.validateSessionHighLevel(sessionID);
    }

    public void setClientEncryption(boolean clientEncryption) {
        this.logonHelper.setClientEncryption(clientEncryption);
    }

    public void logoff(MetaMatrixSessionID sessionID) throws InvalidSessionException, ComponentNotFoundException, RemoteException {
        this.logonHelper.logoff(sessionID);
    }

    public String getAppServerType() {
        return this.logonHelper.getAppServerType();
    }

    public MetaMatrixSessionID getSessionID() {
        return this.logonHelper.getSessionID();
    }

    public boolean isOpen() {
        return this.logonHelper.isOpen();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

