/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaBasePermissionFactory;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import java.io.Serializable;

public class AuthorizationPolicyID
implements Comparable,
Serializable {
    public static final char DELIMITER = '!';
    public static final int DESCRIPTION_LEN = 250;
    private String name;
    private String description;
    private String displayName;
    private AuthorizationRealm realm;

    public AuthorizationRealm getRealm() {
        return this.realm;
    }

    public AuthorizationPolicyID(String name, String description) {
        this.parseAndSetName(name);
        this.setDescription(description);
    }

    public AuthorizationPolicyID(String theDisplayName, String description, AuthorizationRealm theRealm) {
        if (theDisplayName == null || theDisplayName.trim().length() == 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0024"));
        }
        if (theDisplayName.indexOf(33) >= 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0025", '!'));
        }
        if (theRealm == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0026"));
        }
        this.name = theRealm.equals(MetaBasePermissionFactory.getRealm()) ? theDisplayName : AuthorizationPolicyID.formName(theDisplayName, theRealm.getSuperRealmName(), theRealm.getSubRealmName());
        this.realm = theRealm;
        this.displayName = theDisplayName;
        this.setDescription(description);
    }

    public AuthorizationPolicyID(String theDisplayName, String vdbName, int vdbVersion) {
        this(theDisplayName, vdbName, Integer.toString(vdbVersion));
    }

    public AuthorizationPolicyID(String theDisplayName, String vdbName, String vdbVersion) {
        if (theDisplayName == null || theDisplayName.trim().length() == 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0024"));
        }
        if (vdbName == null || vdbName.trim().length() == 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0027"));
        }
        this.displayName = theDisplayName;
        this.realm = new AuthorizationRealm(vdbName, vdbVersion);
        this.name = AuthorizationPolicyID.formName(theDisplayName, vdbName, vdbVersion);
        this.description = "";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVDBName() {
        return this.realm.getSuperRealmName();
    }

    public int getVDBVersion() {
        String vdbVersion = this.realm.getSubRealmName();
        return vdbVersion == null ? -1 : Integer.parseInt(vdbVersion);
    }

    public String getVDBVersionString() {
        String vdbVersion = this.realm.getSubRealmName();
        return vdbVersion == null ? "-1" : vdbVersion;
    }

    public void setDescription(String desc) {
        if (desc != null) {
            if (desc.length() > 250) {
                throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0028", 250));
            }
            this.description = desc;
        } else {
            this.description = "";
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("Name=<" + this.name);
        buf.append("> Realm=<" + this.realm + '>');
        buf.append("> Desc=<" + this.description);
        return buf.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AuthorizationPolicyID) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return AuthorizationPolicyID.compare(this, (AuthorizationPolicyID)obj) == 0;
        }
        return false;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0029"));
        }
        if (!(o instanceof AuthorizationPolicyID)) {
            throw new ClassCastException(PlatformPlugin.Util.getString("ERR.014.107.0030", o.getClass()));
        }
        return AuthorizationPolicyID.compare(this, (AuthorizationPolicyID)o);
    }

    static int compare(AuthorizationPolicyID obj1, AuthorizationPolicyID obj2) {
        return obj1.hashCode() == obj2.hashCode() ? 0 : obj1.name.compareTo(obj2.name);
    }

    public static String parseRealm(AuthorizationRealm aRealm) {
        String superRealmName = aRealm.getSuperRealmName();
        String subRealmName = aRealm.getSubRealmName();
        if (subRealmName == null) {
            return superRealmName;
        }
        return AuthorizationPolicyID.formName("", superRealmName, subRealmName);
    }

    public static String formName(String displayName, String vdbName, String vdbVersion) {
        String delimiterString = new String(new char[]{'!'});
        StringBuffer name = new StringBuffer();
        if (displayName != null && displayName.trim().length() > 0) {
            name.append(displayName);
        }
        if (displayName.indexOf(46) < 0) {
            if (vdbName != null && vdbName.trim().length() > 0) {
                name.append(delimiterString);
                name.append(vdbName);
            }
            if (vdbVersion != null && vdbVersion.trim().length() > 0) {
                String versionString = vdbVersion;
                while (versionString.length() < 3) {
                    versionString = "0" + versionString;
                }
                name.append(delimiterString);
                name.append(versionString);
            }
        }
        return name.toString();
    }

    private void parseAndSetName(String idName) {
        this.name = idName;
        int firstDelimiterLoc = idName.indexOf(33);
        String superRealmName = "";
        String subRealmName = "";
        if (firstDelimiterLoc > 0) {
            this.displayName = idName.substring(0, firstDelimiterLoc);
            int secondDelimiterLoc = idName.lastIndexOf(33);
            if (secondDelimiterLoc > firstDelimiterLoc + 1) {
                superRealmName = idName.substring(firstDelimiterLoc + 1, secondDelimiterLoc);
                if (secondDelimiterLoc < idName.length()) {
                    subRealmName = idName.substring(secondDelimiterLoc + 1);
                }
            }
            this.realm = new AuthorizationRealm(superRealmName, subRealmName);
        } else {
            this.displayName = idName;
            this.realm = this.displayName.indexOf(46) > 0 ? RolePermissionFactory.getRealm() : MetaBasePermissionFactory.getRealm();
        }
    }
}

