/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeImpl;
import com.metamatrix.platform.security.api.AbstractAuthorizationObjectEditor;
import com.metamatrix.platform.security.api.AuthorizationActions;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissions;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.BasicAuthorizationPermission;
import com.metamatrix.platform.security.api.BasicAuthorizationPermissionFactory;
import com.metamatrix.platform.security.api.DataAccessResource;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AuthorizationObjectEditor
extends AbstractAuthorizationObjectEditor {
    public static final long serialVersionUID = 5799168432068176908L;
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$AuthorizationPolicyID;
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$AuthorizationPolicy;
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$AuthorizationRealm;

    public AuthorizationObjectEditor(boolean createActions) {
        super(createActions);
    }

    public AuthorizationObjectEditor() {
        super(true);
    }

    public AuthorizationPolicy cloneAuthorizationPolicy(AuthorizationPolicy sourcePolicy, AuthorizationPolicyID policyID, AuthorizationRealm targetRealm, Set allPaths) {
        if (policyID == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0001"));
        }
        if (sourcePolicy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (targetRealm == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0004"));
        }
        AuthorizationPolicyID targetID = (AuthorizationPolicyID)this.verifyTargetClass(policyID, class$com$metamatrix$platform$security$api$AuthorizationPolicyID == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicyID = AuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicyID")) : class$com$metamatrix$platform$security$api$AuthorizationPolicyID);
        AuthorizationPolicy newPolicy = new AuthorizationPolicy(targetID);
        AuthorizationPolicy theSourcePolicy = (AuthorizationPolicy)this.verifyTargetClass(sourcePolicy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationRealm newRealm = (AuthorizationRealm)this.verifyTargetClass(targetRealm, class$com$metamatrix$platform$security$api$AuthorizationRealm == null ? (class$com$metamatrix$platform$security$api$AuthorizationRealm = AuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationRealm")) : class$com$metamatrix$platform$security$api$AuthorizationRealm);
        this.createCreationAction(targetID, newPolicy);
        newPolicy = this.clonePolicyPrincipals(theSourcePolicy, newPolicy);
        newPolicy = this.clonePolicyPermissions(theSourcePolicy, newPolicy, newRealm, allPaths);
        return newPolicy;
    }

    public AuthorizationPolicy clonePolicyPermissions(AuthorizationPolicy sourcePolicy, AuthorizationPolicy targetPolicy, AuthorizationRealm targetRealm, Set allPaths) {
        if (targetPolicy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (sourcePolicy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0006"));
        }
        if (targetRealm == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0004"));
        }
        AuthorizationPolicy theSourcePolicy = (AuthorizationPolicy)this.verifyTargetClass(sourcePolicy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationPolicy theTargetPolicy = (AuthorizationPolicy)this.verifyTargetClass(targetPolicy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationRealm newRealm = (AuthorizationRealm)this.verifyTargetClass(targetRealm, class$com$metamatrix$platform$security$api$AuthorizationRealm == null ? (class$com$metamatrix$platform$security$api$AuthorizationRealm = AuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationRealm")) : class$com$metamatrix$platform$security$api$AuthorizationRealm);
        ArrayList srcPathList = null;
        HashSet<AuthorizationPermission> permissions = new HashSet<AuthorizationPermission>();
        Iterator permItr = theSourcePolicy.iterator();
        while (permItr.hasNext()) {
            AuthorizationPermission newPerm = null;
            AuthorizationPermission originalPerm = (AuthorizationPermission)permItr.next();
            if (originalPerm != null) {
                String msg;
                Object[] params;
                String msg2;
                Object[] params2;
                String resourcePath = originalPerm.getResourceName();
                if (BasicAuthorizationPermission.isRecursiveResource(resourcePath)) {
                    resourcePath = BasicAuthorizationPermission.removeRecursion(resourcePath);
                }
                if (allPaths.contains(resourcePath)) {
                    try {
                        newPerm = (AuthorizationPermission)originalPerm.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        params2 = new Object[]{originalPerm};
                        msg2 = PlatformPlugin.Util.getString("ERR.014.107.0005", params2);
                        LogManager.logError("AUTHORIZATION", (Throwable)e, msg2);
                    }
                } else if (originalPerm.getActions().getValue() == 8) {
                    if (srcPathList == null) {
                        srcPathList = new ArrayList(allPaths);
                    }
                    if (!AuthorizationObjectEditor.resourceIsElement(srcPathList, resourcePath)) {
                        try {
                            newPerm = (AuthorizationPermission)originalPerm.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            params2 = new Object[]{originalPerm};
                            msg2 = PlatformPlugin.Util.getString("ERR.014.107.0005", params2);
                            LogManager.logError("AUTHORIZATION", (Throwable)e, msg2);
                        }
                    } else {
                        params = new Object[]{originalPerm};
                        msg = PlatformPlugin.Util.getString("ERR.014.107.0010", params);
                        LogManager.logError("AUTHORIZATION", msg);
                    }
                } else {
                    params = new Object[]{originalPerm};
                    msg = PlatformPlugin.Util.getString("ERR.014.107.0011", params);
                    LogManager.logError("AUTHORIZATION", msg);
                }
            }
            if (newPerm == null) continue;
            newPerm.setRealm(newRealm);
            permissions.add(newPerm);
        }
        theTargetPolicy = this.addAllPermissions(theTargetPolicy, permissions);
        return theTargetPolicy;
    }

    public Collection modifyPermissions(PermissionTreeView treeView, AuthorizationPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0012"));
        }
        AuthorizationPolicyID thePolicyID = policy.getAuthorizationPolicyID();
        AuthorizationRealm realm = new AuthorizationRealm(thePolicyID.getVDBName(), thePolicyID.getVDBVersionString());
        HashSet<AuthorizationPermission> permissionsToAdd = new HashSet<AuthorizationPermission>();
        HashSet<AuthorizationPermission> permissionsToRemove = new HashSet<AuthorizationPermission>();
        List modifiedNodes = treeView.getModified();
        HashSet<AuthorizationPermission> effectedNodes = new HashSet<AuthorizationPermission>();
        AuthorizationPermissions currentPerms = policy.getAuthorizationPermissions();
        BasicAuthorizationPermissionFactory permFactory = new BasicAuthorizationPermissionFactory();
        LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Starting...");
        Iterator nodeItr = modifiedNodes.iterator();
        while (nodeItr.hasNext()) {
            PermissionDataNodeImpl aNode = (PermissionDataNodeImpl)nodeItr.next();
            LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Effected node: " + aNode);
            AuthorizationActions theActions = aNode.getActions();
            String resourceName = aNode.getResourceName();
            AuthorizationPermission newPerm = null;
            AuthorizationPermission oldPerm = null;
            boolean isGroupNode = aNode.isGroupNode();
            if (aNode.isLeafNode() || isGroupNode) {
                LogManager.logTrace("AUTHORIZATION", "modifyPermissions: LEAF or GROUP - actions <" + theActions + ">");
                oldPerm = this.getExistingPermission(aNode, policy);
                if (oldPerm != null) {
                    LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Removing permission: " + oldPerm);
                    currentPerms.remove(oldPerm);
                    permissionsToRemove.add(oldPerm);
                    effectedNodes.add(oldPerm);
                }
                if (!((Object)theActions).equals(StandardAuthorizationActions.NONE)) {
                    if (aNode.isLeafNode()) {
                        LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Creating LEAF permission.");
                        newPerm = permFactory.create(resourceName, realm, theActions);
                        LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Adding new ELEMENT perm: <" + newPerm.getResourceName() + " - " + newPerm.getActions() + ">");
                        permissionsToAdd.add(newPerm);
                    } else if (isGroupNode) {
                        LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Creating GROUP " + theActions + " permission.");
                        newPerm = permFactory.create(resourceName, realm, theActions);
                        LogManager.logTrace("AUTHORIZATION", "modifyPermissions: Adding new GROUP perm: <" + newPerm.getResourceName() + " - " + newPerm.getActions() + ">");
                        permissionsToAdd.add(newPerm);
                    }
                }
            }
            aNode.setModified(false, false);
        }
        this.removePermissions(policy, permissionsToRemove);
        this.addAllPermissions(policy, permissionsToAdd);
        return effectedNodes;
    }

    private AuthorizationPermission getExistingPermission(PermissionDataNodeImpl aNode, AuthorizationPolicy policy) {
        AuthorizationPermission permToRemove = null;
        String resourceName = aNode.getResourceName();
        DataAccessResource resource = new DataAccessResource(resourceName);
        permToRemove = policy.findPermissionWithResource(resource);
        return permToRemove;
    }

    private static final boolean resourceIsElement(List paths, String path) {
        boolean isElement = true;
        Iterator eleItr = paths.iterator();
        while (eleItr.hasNext()) {
            String anElement = (String)eleItr.next();
            if (!anElement.startsWith(path) || anElement.equals(path)) continue;
            isElement = false;
            break;
        }
        return isElement;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

