/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.message;

import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.message.RequestMessage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AtomicRequestMessage
extends RequestMessage {
    static final long serialVersionUID = -4060941593023225562L;
    public static final int NEW = 1;
    public static final int MORE = 2;
    public static final int CANCEL = 3;
    public static final int LOB = 4;
    private int type = 1;
    private int nodeID;
    private String connectorBindingID;
    private ConnectorID connectorID;
    private TupleSourceID tupleID;
    private int nextRow = -1;
    private int execCount;

    public AtomicRequestMessage() {
    }

    public AtomicRequestMessage(RequestMessage parent) {
        this.setRequestID(parent.getRequestID());
        this.setFetchSize(parent.getFetchSize());
        this.setPartialResults(parent.supportsPartialResults());
        this.setCallableStatement(parent.isCallableStatement());
        this.setPreparedStatement(parent.isPreparedStatement());
        this.setVdbName(parent.getVdbName());
        this.setVdbVersion(parent.getVdbVersion());
        this.setConnectionID(parent.getConnectionID());
        this.setTrustedPayload(parent.getTrustedPayload());
        this.setExecutionPayload(parent.getExecutionPayload());
        this.setUserName(parent.getUserName());
        this.setTransactionContext(parent.getTransactionContext());
        this.setProfileID(parent.getProfileID());
        this.setUseResultSetCache(parent.useResultSetCache());
    }

    public String getConnectorBindingID() {
        return this.connectorBindingID;
    }

    public ConnectorID getConnectorID() {
        return this.connectorID;
    }

    public int getNextRow() {
        return this.nextRow;
    }

    public TupleSourceID getTupleSourceID() {
        return this.tupleID;
    }

    public int getType() {
        return this.type;
    }

    public void setConnectorBindingID(String string) {
        this.connectorBindingID = string;
    }

    public void setConnectorID(ConnectorID connectorID) {
        this.connectorID = connectorID;
    }

    public void setNextRow(int i) {
        this.nextRow = i;
    }

    public void setTupleSourceID(TupleSourceID sourceID) {
        this.tupleID = sourceID;
    }

    public void setType(int i) {
        this.type = i;
    }

    public int getMessageType() {
        return 1;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(int nodeID) {
        this.nodeID = nodeID;
    }

    public String getMessageKey() {
        if (super.getMessageKey() == null) {
            super.setMessageKey(super.getRequestID().toString() + this.getNodeID());
        }
        return super.getMessageKey();
    }

    public void setExecCount(int execCount) {
        this.execCount = execCount;
    }

    public int getExecCount() {
        return this.execCount;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.type = in.readInt();
        this.nodeID = in.readInt();
        this.connectorBindingID = (String)in.readObject();
        this.connectorID = (ConnectorID)in.readObject();
        this.tupleID = (TupleSourceID)in.readObject();
        this.nextRow = in.readInt();
        this.execCount = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.type);
        out.writeInt(this.nodeID);
        out.writeObject(this.connectorBindingID);
        out.writeObject(this.connectorID);
        out.writeObject(this.tupleID);
        out.writeInt(this.nextRow);
        out.writeInt(this.execCount);
    }
}

