/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto.cipher;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Encryptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class SerializableEncryptor
implements Encryptor,
Externalizable {
    private static final String DEFAULT_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private String cipherAlgorithm = "RSA/ECB/PKCS1Padding";
    private Key encryptKey = null;
    private transient Cipher encryptCipher = null;
    private String providerName = null;

    public SerializableEncryptor() {
    }

    public SerializableEncryptor(Key encryptKey) throws CryptoException {
        this.encryptKey = encryptKey;
        this.initCipher();
    }

    public SerializableEncryptor(Key encryptKey, String providerName) throws CryptoException {
        this.encryptKey = encryptKey;
        this.providerName = providerName;
        this.initCipher();
    }

    public synchronized byte[] encrypt(byte[] cleartext) throws CryptoException {
        try {
            return this.encryptCipher.doFinal(cleartext);
        }
        catch (Exception e) {
            throw new CryptoException("ERR.003.030.0081", CommonPlugin.Util.getString("ERR.003.030.0081", e.getMessage()));
        }
    }

    public char[] encrypt(char[] cleartext) throws CryptoException {
        if (cleartext == null) {
            throw new CryptoException("ERR.003.030.0072", CommonPlugin.Util.getString("ERR.003.030.0072"));
        }
        String clearString = new String(cleartext);
        if (clearString.trim().length() == 0 && clearString.length() == 0) {
            throw new CryptoException("ERR.003.030.0073", CommonPlugin.Util.getString("ERR.003.030.0073"));
        }
        byte[] clearBytes = clearString.getBytes();
        byte[] cipherBytes = this.encrypt(clearBytes);
        return CryptoFactory.encodeBytes(cipherBytes);
    }

    private void initCipher() throws CryptoException {
        try {
            this.encryptCipher = this.providerName != null ? Cipher.getInstance(this.cipherAlgorithm, this.providerName) : Cipher.getInstance(this.cipherAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0076", CommonPlugin.Util.getString("ERR.003.030.0076", this.cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException("ERR.003.030.0072", CommonPlugin.Util.getString("ERR.003.030.0077", this.cipherAlgorithm, e.getMessage()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CryptoException("ERR.003.030.0082", CommonPlugin.Util.getString("ERR.003.030.0082", e.getClass().getName(), this.cipherAlgorithm));
        }
        try {
            this.encryptCipher.init(1, this.encryptKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException((Throwable)e, "ERR.003.030.0078", CommonPlugin.Util.getString("ERR.003.030.0078", e.getMessage()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CryptoException("ERR.003.030.0083", CommonPlugin.Util.getString("ERR.003.030.0083", new Object[]{e.getClass().getName(), this.encryptCipher, new Integer(1), this.encryptKey}));
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.cipherAlgorithm == DEFAULT_ALGORITHM) {
            out.writeObject(null);
        }
        out.writeObject(this.encryptKey);
        out.writeObject(this.providerName);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cipherAlgorithm = (String)in.readObject();
        if (this.cipherAlgorithm == null) {
            this.cipherAlgorithm = DEFAULT_ALGORITHM;
        }
        this.encryptKey = (Key)in.readObject();
        this.providerName = (String)in.readObject();
        try {
            this.initCipher();
        }
        catch (CryptoException e) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.030.0084", e.getMessage()));
        }
        catch (Throwable e) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.030.0085", e.getClass().getName(), e.getMessage()));
        }
    }

    static {
        CryptoUtil.initJCEProvider();
    }
}

