/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types;

import com.metamatrix.common.types.DataTypeManager;

public final class MMJDBCSQLTypeInfo {
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String TIME = "time";
    public static final String DATE = "date";
    public static final String TIMESTAMP = "timestamp";
    public static final String INTEGER = "integer";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String BIGDECIMAL = "bigdecimal";
    public static final String BIGINTEGER = "biginteger";
    public static final String BYTE = "byte";
    public static final String SHORT = "short";
    public static final String LONG = "long";
    public static final String CHAR = "char";
    public static final String OBJECT = "object";
    public static final String CLOB = "clob";
    public static final String BLOB = "blob";
    public static final String XML = "xml";
    public static final String STRING_CLASS = DataTypeManager.DefaultDataClasses.STRING.getName();
    public static final String BOOLEAN_CLASS = DataTypeManager.DefaultDataClasses.BOOLEAN.getName();
    public static final String TIME_CLASS = DataTypeManager.DefaultDataClasses.TIME.getName();
    public static final String DATE_CLASS = DataTypeManager.DefaultDataClasses.DATE.getName();
    public static final String TIMESTAMP_CLASS = DataTypeManager.DefaultDataClasses.TIMESTAMP.getName();
    public static final String INTEGER_CLASS = DataTypeManager.DefaultDataClasses.INTEGER.getName();
    public static final String FLOAT_CLASS = DataTypeManager.DefaultDataClasses.FLOAT.getName();
    public static final String DOUBLE_CLASS = DataTypeManager.DefaultDataClasses.DOUBLE.getName();
    public static final String BIGDECIMAL_CLASS = DataTypeManager.DefaultDataClasses.BIG_DECIMAL.getName();
    public static final String BYTE_CLASS = DataTypeManager.DefaultDataClasses.BYTE.getName();
    public static final String SHORT_CLASS = DataTypeManager.DefaultDataClasses.SHORT.getName();
    public static final String LONG_CLASS = DataTypeManager.DefaultDataClasses.LONG.getName();
    public static final String CHAR_CLASS = DataTypeManager.DefaultDataClasses.CHAR.getName();
    public static final String BIGINTEGER_CLASS = DataTypeManager.DefaultDataClasses.BIG_INTEGER.getName();
    public static final String OBJECT_CLASS = DataTypeManager.DefaultDataClasses.OBJECT.getName();
    public static final String CLOB_CLASS = "java.sql.Clob";
    public static final String BLOB_CLASS = "java.sql.Blob";

    private MMJDBCSQLTypeInfo() {
    }

    public static final int getSQLType(String typeName) {
        int sqlType = typeName.equalsIgnoreCase(STRING) ? 12 : (typeName.equalsIgnoreCase(BOOLEAN) ? -7 : (typeName.equalsIgnoreCase(CHAR) ? 1 : (typeName.equalsIgnoreCase(TIME) ? 92 : (typeName.equalsIgnoreCase(DATE) ? 91 : (typeName.equalsIgnoreCase(TIMESTAMP) ? 93 : (typeName.equalsIgnoreCase(INTEGER) ? 4 : (typeName.equalsIgnoreCase(FLOAT) ? 7 : (typeName.equalsIgnoreCase(DOUBLE) ? 8 : (typeName.equalsIgnoreCase(BIGDECIMAL) ? 2 : (typeName.equalsIgnoreCase(BYTE) ? -6 : (typeName.equalsIgnoreCase(SHORT) ? 5 : (typeName.equalsIgnoreCase(LONG) ? -5 : (typeName.equalsIgnoreCase(BIGINTEGER) ? 2 : (typeName.equalsIgnoreCase(CLOB) ? 2005 : (typeName.equalsIgnoreCase(BLOB) ? 2004 : (typeName.equalsIgnoreCase(XML) ? 12 : 2000))))))))))))))));
        return sqlType;
    }

    public static final int getSQLTypeFromClass(String typeName) {
        int sqlType = typeName.equalsIgnoreCase(STRING_CLASS) ? 12 : (typeName.equalsIgnoreCase(BOOLEAN_CLASS) ? -7 : (typeName.equalsIgnoreCase(CHAR_CLASS) ? 1 : (typeName.equalsIgnoreCase(TIME_CLASS) ? 92 : (typeName.equalsIgnoreCase(DATE_CLASS) ? 91 : (typeName.equalsIgnoreCase(TIMESTAMP_CLASS) ? 93 : (typeName.equalsIgnoreCase(INTEGER_CLASS) ? 4 : (typeName.equalsIgnoreCase(FLOAT_CLASS) ? 7 : (typeName.equalsIgnoreCase(DOUBLE_CLASS) ? 8 : (typeName.equalsIgnoreCase(BIGDECIMAL_CLASS) ? 2 : (typeName.equalsIgnoreCase(BYTE_CLASS) ? -6 : (typeName.equalsIgnoreCase(SHORT_CLASS) ? 5 : (typeName.equalsIgnoreCase(LONG_CLASS) ? -5 : (typeName.equalsIgnoreCase(BIGINTEGER_CLASS) ? 2 : (typeName.equalsIgnoreCase(CLOB_CLASS) ? 2005 : (typeName.equalsIgnoreCase(BLOB_CLASS) ? 2004 : 2000)))))))))))))));
        return sqlType;
    }

    public static final String getJavaClassName(int jdbcSQLType) {
        String javaClassName;
        switch (jdbcSQLType) {
            case 12: {
                javaClassName = STRING_CLASS;
                break;
            }
            case -1: {
                javaClassName = STRING_CLASS;
                break;
            }
            case 1: {
                javaClassName = CHAR_CLASS;
                break;
            }
            case -7: {
                javaClassName = BOOLEAN_CLASS;
                break;
            }
            case 91: {
                javaClassName = DATE_CLASS;
                break;
            }
            case 92: {
                javaClassName = TIME_CLASS;
                break;
            }
            case 93: {
                javaClassName = TIMESTAMP_CLASS;
                break;
            }
            case 4: {
                javaClassName = INTEGER_CLASS;
                break;
            }
            case 7: {
                javaClassName = FLOAT_CLASS;
                break;
            }
            case 6: {
                javaClassName = DOUBLE_CLASS;
                break;
            }
            case 8: {
                javaClassName = DOUBLE_CLASS;
                break;
            }
            case 2: {
                javaClassName = BIGDECIMAL_CLASS;
                break;
            }
            case 3: {
                javaClassName = BIGDECIMAL_CLASS;
                break;
            }
            case -5: {
                javaClassName = LONG_CLASS;
                break;
            }
            case -6: {
                javaClassName = BYTE_CLASS;
                break;
            }
            case 5: {
                javaClassName = SHORT_CLASS;
                break;
            }
            case 2000: {
                javaClassName = OBJECT_CLASS;
                break;
            }
            case 2005: {
                javaClassName = CLOB_CLASS;
                break;
            }
            case 2004: {
                javaClassName = BLOB_CLASS;
                break;
            }
            default: {
                javaClassName = null;
            }
        }
        return javaClassName;
    }

    public static String[] getMMTypeNames() {
        return new String[]{STRING, BOOLEAN, TIME, DATE, TIMESTAMP, INTEGER, FLOAT, DOUBLE, BIGDECIMAL, BIGINTEGER, BYTE, SHORT, LONG, CHAR, OBJECT, CLOB, BLOB, XML};
    }
}

